/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.ILog;
import org.fusesource.ide.commons.logging.RiderLogFacade;
import org.fusesource.ide.commons.ui.ImagesActivatorSupport;
import org.fusesource.ide.jmx.activemq.ActiveMQConverter;
import org.fusesource.ide.jmx.activemq.navigator.ActiveMQNodeProvider;
import org.fusesource.ide.jmx.activemq.navigator.ActiveMQPreferenceInitializer;
import org.osgi.framework.BundleContext;

public class ActiveMQJMXPlugin
extends ImagesActivatorSupport {
    public static final String PLUGIN_ID = "org.fusesource.ide.jmx.activemq";
    private static ActiveMQJMXPlugin plugin;
    private static ActiveMQNodeProvider nodeProvider;
    private static ActiveMQConverter converter;
    private static AtomicBoolean started;

    static {
        started = new AtomicBoolean(false);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public static void registerNodeProviders() {
        if (started.compareAndSet(false, true)) {
            new ActiveMQPreferenceInitializer().initializeDefaultPreferences();
            nodeProvider = new ActiveMQNodeProvider();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ActiveMQJMXPlugin getDefault() {
        return plugin;
    }

    public static RiderLogFacade getLogger() {
        return RiderLogFacade.getLog((ILog)ActiveMQJMXPlugin.getDefault().getLog());
    }

    public static ActiveMQConverter getConverter() {
        if (converter == null) {
            converter = new ActiveMQConverter();
        }
        return converter;
    }

    public static void setConverter(ActiveMQConverter converter) {
        ActiveMQJMXPlugin.converter = converter;
    }

    public static void showUserError(String title, String message, Exception e) {
        ActiveMQJMXPlugin.showUserError((String)PLUGIN_ID, (RiderLogFacade)ActiveMQJMXPlugin.getLogger(), (String)title, (String)message, (Exception)e);
    }
}

