/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr;

import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.Utils;

public class ValidationStatus
implements Comparable<ValidationStatus> {
    public static final int OK_CODE = 0;
    public static final ValidationStatus OK_STATUS = ValidationStatus.createOkMessage(0, Messages.okValidationMsg);
    protected int code;
    protected String message;
    protected Severity severity;

    public static ValidationStatus createErrorMessage(int code, String message) {
        return new ValidationStatus(Severity.ERROR, code, message);
    }

    public static ValidationStatus createInfoMessage(int code, String message) {
        return new ValidationStatus(Severity.INFO, code, message);
    }

    public static ValidationStatus createOkMessage(int code, String message) {
        return new ValidationStatus(Severity.OK, code, message);
    }

    public static ValidationStatus createWarningMessage(int code, String message) {
        return new ValidationStatus(Severity.WARNING, code, message);
    }

    protected ValidationStatus(Severity severity, int code, String message) {
        assert (severity != null) : "severity is null";
        Utils.verifyIsNotEmpty(message, "message");
        this.code = code;
        this.severity = severity;
        this.message = message;
    }

    @Override
    public int compareTo(ValidationStatus that) {
        if (this == that || this.severity == that.severity) {
            return this.getMessage().compareTo(that.getMessage());
        }
        if (this.isError()) {
            if (that.isWarning()) {
                return -10;
            }
            if (that.isInfo()) {
                return -100;
            }
            return -1000;
        }
        if (this.isWarning()) {
            if (that.isError()) {
                return 10;
            }
            if (that.isInfo()) {
                return -10;
            }
            return -100;
        }
        if (this.isInfo()) {
            if (that.isError()) {
                return 100;
            }
            if (that.isWarning()) {
                return 10;
            }
            return -10;
        }
        if (that.isError()) {
            return 1000;
        }
        if (that.isWarning()) {
            return 100;
        }
        return 10;
    }

    public boolean containsCode(int code) {
        return this.getCode() == code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ValidationStatus that = (ValidationStatus)obj;
        return this.severity.equals((Object)that.severity) && this.message.equals(that.message);
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public int hashCode() {
        return Utils.hashCode(new Object[]{this.severity, this.message});
    }

    public boolean isError() {
        return Severity.ERROR == this.severity;
    }

    public boolean isInfo() {
        return Severity.INFO == this.severity;
    }

    public boolean isOk() {
        return Severity.OK == this.severity;
    }

    public boolean isWarning() {
        return Severity.WARNING == this.severity;
    }

    public static enum Severity {
        ERROR,
        INFO,
        OK,
        WARNING;


        public boolean isMoreSevere(Severity that) {
            Utils.verifyIsNotNull((Object)that, "that");
            if (this == that || this == WARNING) {
                return false;
            }
            if (this == ERROR) {
                return true;
            }
            if (this == INFO) {
                return that == OK;
            }
            return that == WARNING;
        }
    }
}

