/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.models.switchyard1_0.spring;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LoggingLevel implements Enumerator
{
    DEBUG(0, "DEBUG", "DEBUG"),
    ERROR(1, "ERROR", "ERROR"),
    INFO(2, "INFO", "INFO"),
    TRACE(3, "TRACE", "TRACE"),
    WARN(4, "WARN", "WARN"),
    OFF(5, "OFF", "OFF");

    public static final int DEBUG_VALUE = 0;
    public static final int ERROR_VALUE = 1;
    public static final int INFO_VALUE = 2;
    public static final int TRACE_VALUE = 3;
    public static final int WARN_VALUE = 4;
    public static final int OFF_VALUE = 5;
    private static final LoggingLevel[] VALUES_ARRAY;
    public static final List<LoggingLevel> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LoggingLevel[]{DEBUG, ERROR, INFO, TRACE, WARN, OFF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LoggingLevel get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LoggingLevel result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LoggingLevel getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LoggingLevel result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LoggingLevel get(int value) {
        switch (value) {
            case 0: {
                return DEBUG;
            }
            case 1: {
                return ERROR;
            }
            case 2: {
                return INFO;
            }
            case 3: {
                return TRACE;
            }
            case 4: {
                return WARN;
            }
            case 5: {
                return OFF;
            }
        }
        return null;
    }

    private LoggingLevel(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

