/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

public class ItemFilter {
    boolean like = false;
    boolean startsWith = false;
    boolean contains = false;
    boolean endsWith = false;
    String searchText;

    public ItemFilter(String filterStr) {
        String fText = "";
        if (filterStr.toUpperCase().startsWith("LIKE")) {
            this.like = true;
            fText = filterStr.substring("LIKE".length()).trim();
        } else {
            this.like = false;
            fText = filterStr.substring("NOT LIKE".length()).trim();
        }
        String rText = this.removeLeadingTrailingTicks(fText);
        this.searchText = this.setLeadingTrailingFlags(rText);
    }

    private String removeLeadingTrailingTicks(String str) {
        String result = null;
        if (str.startsWith("'")) {
            result = str.substring(1);
        }
        if (result.endsWith("'")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private String setLeadingTrailingFlags(String str) {
        boolean trailingPct;
        boolean leadingPct = str.startsWith("%");
        if (leadingPct) {
            str = str.substring(1);
        }
        if (trailingPct = str.endsWith("%")) {
            str = str.substring(0, str.length() - 1);
        }
        if (leadingPct && trailingPct) {
            this.contains = true;
        } else if (leadingPct) {
            this.endsWith = true;
        } else if (trailingPct) {
            this.startsWith = true;
        }
        return str;
    }

    public boolean isMatch(String itemName) {
        if (this.startsWith) {
            if (this.like && itemName.startsWith(this.searchText)) {
                return true;
            }
            if (!this.like && !itemName.startsWith(this.searchText)) {
                return true;
            }
        } else if (this.endsWith) {
            if (this.like && itemName.endsWith(this.searchText)) {
                return true;
            }
            if (!this.like && !itemName.endsWith(this.searchText)) {
                return true;
            }
        } else if (this.contains) {
            if (this.like && itemName.contains(this.searchText)) {
                return true;
            }
            if (!this.like && !itemName.startsWith(this.searchText)) {
                return true;
            }
        }
        return false;
    }

    public String getFilterDescription() {
        String description = null;
        if (this.startsWith) {
            description = this.like ? "[Starts with '" + this.searchText + "']" : "[Does not start with '" + this.searchText + "']";
        } else if (this.endsWith) {
            description = this.like ? "[Ends with '" + this.searchText + "']" : "[Does not end with '" + this.searchText + "']";
        } else if (this.contains) {
            description = this.like ? "[Contains '" + this.searchText + "']" : "[Does not contain '" + this.searchText + "']";
        }
        return description;
    }
}

