/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.wizards;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.domain.ModeShapeServer;
import org.jboss.tools.modeshape.rest.wizards.ServerPage;
import org.modeshape.web.jcr.rest.client.Status;

public final class ServerWizard
extends Wizard {
    private ModeShapeServer existingServer;
    private final ServerPage page;
    private final ServerManager serverManager;

    public ServerWizard(ServerManager serverManager) {
        this.page = new ServerPage();
        this.serverManager = serverManager;
        this.setDefaultPageImageDescriptor(Activator.getDefault().getImageDescriptor("icons/wizards/wizard_banner.png"));
        this.setWindowTitle(RestClientI18n.serverWizardNewServerTitle);
    }

    public ServerWizard(ServerManager serverManager, ModeShapeServer server) {
        this.page = new ServerPage(server);
        this.serverManager = serverManager;
        this.existingServer = server;
        this.setDefaultPageImageDescriptor(Activator.getDefault().getImageDescriptor("icons/wizards/wizard_banner.png"));
        this.setWindowTitle(RestClientI18n.serverWizardEditServerTitle);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    protected ServerManager getServerManager() {
        return this.serverManager;
    }

    public boolean performFinish() {
        Status status = Status.OK_STATUS;
        ModeShapeServer server = this.page.getServer();
        if (this.existingServer == null) {
            status = this.serverManager.addServer(server);
            if (status.isError()) {
                MessageDialog.openError((Shell)this.getShell(), (String)RestClientI18n.errorDialogTitle, (String)RestClientI18n.serverWizardEditServerErrorMsg);
            }
        } else if (!this.existingServer.equals(server) && (status = this.serverManager.updateServer(this.existingServer, server)).isError()) {
            MessageDialog.openError((Shell)this.getShell(), (String)RestClientI18n.errorDialogTitle, (String)RestClientI18n.serverWizardNewServerErrorMsg);
        }
        if (!status.isOk()) {
            Activator.getDefault().log(status);
        }
        return !status.isError();
    }
}

