/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.views;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.web.jcr.rest.client.Status;

public final class ModeShapeMessageConsole
extends IOConsole {
    private static final String EMPHASIS_START_TAG = "<em>";
    private static final String EMPHASIS_END_TAG = "</em>";
    private static final String ID = "org.jboss.tools.modeshape.rest.views.ModeShapeMessageConsole";
    private static final String NAME = RestClientI18n.publishingConsoleName;

    private static ModeShapeMessageConsole getMessageConsole() {
        ModeShapeMessageConsole console = null;
        IConsoleManager consoleMgr = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = consoleMgr.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            if (NAME.equals(consoles[i].getName())) {
                console = (ModeShapeMessageConsole)consoles[i];
                break;
            }
            ++i;
        }
        if (console == null) {
            console = new ModeShapeMessageConsole();
            consoleMgr.addConsoles(new IConsole[]{console});
        }
        return console;
    }

    public static void writeln(String message) {
        CheckArg.isNotNull((Object)message, (String)"message");
        ModeShapeMessageConsole.writeln(message, null);
    }

    public static void writeln(String message, IFile file) {
        CheckArg.isNotNull((Object)message, (String)"message");
        ModeShapeMessageConsole console = ModeShapeMessageConsole.getMessageConsole();
        console.print(message, true, file);
    }

    private ModeShapeMessageConsole() {
        super(NAME, Activator.getDefault().getImageDescriptor("icons/views/modeShape_icon_16x.png"));
    }

    void addDocumentListener(String message, IFile file) {
        this.getDocument().addDocumentListener((IDocumentListener)new HyperlinkCreator(message, this, file));
    }

    public String getType() {
        return ID;
    }

    private void print(String message, boolean doLineFeedAtEnd, IFile file) {
        assert (message != null);
        final Display display = Display.getDefault();
        ModeShapeMessageConsole console = this;
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable((AbstractConsole)console, file, message, doLineFeedAtEnd){
                private final /* synthetic */ AbstractConsole val$console;
                private final /* synthetic */ IFile val$file;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ boolean val$doLineFeedAtEnd;
                {
                    this.val$console = abstractConsole;
                    this.val$file = iFile;
                    this.val$message = string;
                    this.val$doLineFeedAtEnd = bl;
                }

                @Override
                public void run() {
                    block20: {
                        if (!display.isDisposed()) {
                            this.val$console.activate();
                            if (this.val$file != null) {
                                ModeShapeMessageConsole.this.addDocumentListener(this.val$message, this.val$file);
                            }
                            IOConsoleOutputStream stream = ModeShapeMessageConsole.this.newOutputStream();
                            try {
                                try {
                                    int beginIndex = 0;
                                    int endIndex = 0;
                                    int msgLength = this.val$message.length();
                                    while (endIndex < msgLength) {
                                        boolean emphasize;
                                        int endTagIndex;
                                        int startTagIndex = this.val$message.indexOf(ModeShapeMessageConsole.EMPHASIS_START_TAG, beginIndex);
                                        int n = endTagIndex = startTagIndex < 0 ? -1 : this.val$message.indexOf(ModeShapeMessageConsole.EMPHASIS_END_TAG, startTagIndex + ModeShapeMessageConsole.EMPHASIS_START_TAG.length());
                                        if (endTagIndex < 0 && startTagIndex >= 0) {
                                            startTagIndex = -1;
                                        }
                                        boolean bl = emphasize = beginIndex == startTagIndex;
                                        if (emphasize) {
                                            beginIndex += ModeShapeMessageConsole.EMPHASIS_START_TAG.length();
                                            stream.setFontStyle(1);
                                            endIndex = endTagIndex;
                                        } else {
                                            stream.setFontStyle(0);
                                            endIndex = startTagIndex < 0 ? msgLength : startTagIndex;
                                        }
                                        stream.write(this.val$message.substring(beginIndex, endIndex));
                                        stream.close();
                                        stream = ModeShapeMessageConsole.this.newOutputStream();
                                        if (emphasize) {
                                            endIndex += ModeShapeMessageConsole.EMPHASIS_END_TAG.length();
                                        }
                                        beginIndex = endIndex;
                                    }
                                    if (this.val$doLineFeedAtEnd) {
                                        stream.write("\n");
                                    }
                                }
                                catch (IOException e) {
                                    Activator.getDefault().log(new Status(Status.Severity.ERROR, RestClientI18n.publishingConsoleProblemMsg, (Throwable)e));
                                    if (stream == null || stream.isClosed()) break block20;
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException e2) {
                                        Activator.getDefault().log(new Status(Status.Severity.ERROR, RestClientI18n.publishingConsoleProblemMsg, (Throwable)e2));
                                    }
                                }
                            }
                            finally {
                                if (stream != null && !stream.isClosed()) {
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException e) {
                                        Activator.getDefault().log(new Status(Status.Severity.ERROR, RestClientI18n.publishingConsoleProblemMsg, (Throwable)e));
                                    }
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    class HyperlinkCreator
    implements IDocumentListener {
        private final ModeShapeMessageConsole console;
        private final IFile file;
        private final String message;

        public HyperlinkCreator(String message, ModeShapeMessageConsole console, IFile file) {
            this.message = message.replaceAll(ModeShapeMessageConsole.EMPHASIS_START_TAG, "").replaceAll("\\Q</em>\\E", "");
            this.console = console;
            this.file = file;
        }

        public void documentAboutToBeChanged(DocumentEvent arg0) {
        }

        public void documentChanged(DocumentEvent event) {
            IDocument document = event.getDocument();
            try {
                FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
                IRegion region = finder.find(document.getLength() - 1, this.message, false, true, false, false);
                if (region != null) {
                    String target = this.file.getFullPath().toString();
                    int index = this.message.indexOf(target);
                    if (index == -1) {
                        throw new BadLocationException(NLS.bind((String)RestClientI18n.publishingConsoleFilePathNotFoundMsg, (Object)target));
                    }
                    this.console.addHyperlink((IHyperlink)new FileLink(this.file, null, -1, -1, -1), region.getOffset() + index, target.length());
                    document.removeDocumentListener((IDocumentListener)this);
                }
            }
            catch (BadLocationException e) {
                Activator.getDefault().log(new Status(Status.Severity.ERROR, RestClientI18n.publishingConsoleProblemCreatingHyperlinkMsg, (Throwable)e));
                document.removeDocumentListener((IDocumentListener)this);
            }
        }
    }
}

