/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.runtime.integration;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.bean.KarafBeanProvider;
import org.fusesource.ide.server.karaf.core.util.IKarafToolingConstants;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBean;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;
import org.jboss.tools.runtime.core.model.AbstractRuntimeDetectorDelegate;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;

public class KarafRuntimeDetector
extends AbstractRuntimeDetectorDelegate {
    public RuntimeDefinition getRuntimeDefinition(File root, IProgressMonitor monitor) {
        if (monitor.isCanceled() || root == null) {
            return null;
        }
        ServerBeanLoader loader = new ServerBeanLoader(root);
        ServerBean serverBean = loader.getServerBean();
        ServerBeanType type = serverBean.getBeanType();
        if (((Object)((Object)KarafBeanProvider.KARAF_2x)).equals(type) || ((Object)((Object)KarafBeanProvider.KARAF_3x)).equals(type)) {
            RuntimeDefinition runtimeDefinition = new RuntimeDefinition(serverBean.getName(), serverBean.getVersion(), type.getId(), new File(serverBean.getLocation()));
            return runtimeDefinition;
        }
        return null;
    }

    public boolean exists(RuntimeDefinition runtimeDefinition) {
        File path = runtimeDefinition == null ? null : runtimeDefinition.getLocation();
        return this.runtimeExistsAtLocation(path);
    }

    public void initializeRuntimes(List<RuntimeDefinition> runtimeDefinitions) {
        this.createKarafServerFromDefinitions(runtimeDefinitions);
    }

    private void createKarafServerFromDefinitions(List<RuntimeDefinition> runtimeDefinitions) {
        for (RuntimeDefinition runtimeDefinition : runtimeDefinitions) {
            String wtpServerType;
            File asLocation;
            if (!runtimeDefinition.isEnabled() || (asLocation = runtimeDefinition.getLocation()) == null || !asLocation.isDirectory() || !this.isKarafServerType(wtpServerType = new ServerBeanLoader(asLocation).getServerAdapterId())) continue;
            String name = runtimeDefinition.getName();
            String runtimeName = String.valueOf(name) + " Runtime";
            KarafRuntimeDetector.createKarafServer(asLocation, wtpServerType, name, runtimeName);
        }
    }

    private boolean isKarafServerType(String type) {
        return Arrays.asList(IKarafToolingConstants.ALL_KARAF_SERVER_TYPES).contains(type);
    }

    private static void createKarafServer(File loc, String serverTypeId, String name, String runtimeName) {
        if (loc == null || !loc.isDirectory() || serverTypeId == null) {
            return;
        }
        IServerType serverType = ServerCore.findServerType((String)serverTypeId);
        if (serverType == null) {
            return;
        }
        IRuntimeType rtType = serverType.getRuntimeType();
        if (rtType == null) {
            return;
        }
        try {
            Path locPath = new Path(loc.getAbsolutePath());
            IRuntimeWorkingCopy rt = rtType.createRuntime(runtimeName, (IProgressMonitor)new NullProgressMonitor());
            rt.setLocation((IPath)locPath);
            rt.setName(runtimeName);
            rt.save(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            Activator.getLogger().error((Throwable)ce);
        }
    }

    public void computeIncludedRuntimeDefinition(RuntimeDefinition runtimeDefinition) {
    }

    private boolean runtimeExistsAtLocation(File path) {
        if (path != null) {
            IRuntime[] all = ServerCore.getRuntimes();
            int i = 0;
            while (i < all.length) {
                File f = all[i].getLocation().toFile();
                if (path.equals(f)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

