/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.poller;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.Messages;
import org.fusesource.ide.server.karaf.core.server.subsystems.IServerPortController;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller2;
import org.jboss.ide.eclipse.as.core.server.IServerStatePollerType;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;

public class BaseKarafPoller
implements IServerStatePoller2 {
    public static final String KEY_POLLER = "karafPoller";
    private IServer server;
    private IServerStatePollerType type;
    private String host;
    private int port;
    private boolean canceled;
    private boolean done;
    private boolean state;
    private boolean expectedState;

    public void beginPolling(IServer server, boolean expectedState) {
        this.server = server;
        this.done = false;
        this.canceled = false;
        this.expectedState = expectedState;
        this.state = !expectedState;
        this.determineServerInfo();
        this.launchThread();
    }

    public IServerStatePollerType getPollerType() {
        return this.type;
    }

    public void setPollerType(IServerStatePollerType type) {
        this.type = type;
    }

    public IServer getServer() {
        return this.server;
    }

    public boolean isComplete() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
        return this.done;
    }

    public boolean getState() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
        return this.state;
    }

    public void cleanup() {
    }

    public List<String> getRequiredProperties() {
        return new ArrayList<String>();
    }

    public void provideCredentials(Properties properties) {
    }

    public void cancel(int type) {
        this.canceled = true;
    }

    public int getTimeoutBehavior() {
        return 2;
    }

    public IStatus getCurrentStateSynchronous(IServer server) {
        URI serverURI = this.determineServerInfo(server);
        boolean b = this.onePing(serverURI.getHost(), serverURI.getPort());
        Status s = b ? new Status(0, "org.fusesource.ide.server.karaf.core", NLS.bind((String)Messages.KarafPollerServerFound, (Object)serverURI.getHost(), (Object)serverURI.getPort())) : new Status(1, "org.fusesource.ide.server.karaf.core", NLS.bind((String)Messages.KarafPollerServerNotFound, (Object)serverURI.getHost(), (Object)serverURI.getPort()));
        return s;
    }

    protected void launchThread() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                BaseKarafPoller.this.pollerRun();
            }
        }, "Karaf Poller");
        t.start();
    }

    private void pollerRun() {
        this.done = false;
        while (!this.canceled && !this.done) {
            boolean up = this.onePing(this.host, this.port);
            if (up == this.expectedState) {
                this.state = this.expectedState;
                this.done = true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void determineServerInfo() {
        this.host = this.getServer().getHost();
        this.port = this.getPort();
    }

    private URI determineServerInfo(IServer s) {
        String host = s.getHost();
        int port = this.getPort(s);
        try {
            return new URI(null, null, host, port, null, null, null);
        }
        catch (URISyntaxException ex) {
            Activator.getLogger().error((Throwable)ex);
            return null;
        }
    }

    private int getPort() {
        try {
            ControllableServerBehavior csb = (ControllableServerBehavior)this.getServer().loadAdapter(ControllableServerBehavior.class, null);
            if (csb != null) {
                IServerPortController ctrl = (IServerPortController)csb.getController("port");
                return ctrl.findPort(105, -1);
            }
        }
        catch (CoreException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1;
    }

    private int getPort(IServer s) {
        try {
            ControllableServerBehavior csb = (ControllableServerBehavior)s.loadAdapter(ControllableServerBehavior.class, null);
            if (csb != null) {
                IServerPortController ctrl = (IServerPortController)csb.getController("port");
                return ctrl.findPort(105, -1);
            }
        }
        catch (CoreException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return -1;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean onePing(String host, int port) {
        Socket s;
        block12: {
            s = null;
            s = new Socket(host, port);
            if (!s.isBound()) break block12;
            if (s == null) return true;
            try {
                s.close();
                return true;
            }
            catch (IOException iOException) {}
            return true;
        }
        if (s == null) return false;
        try {
            s.close();
            return false;
        }
        catch (IOException iOException) {}
        return false;
        catch (IOException iOException) {
            try {
                if (s == null) return false;
            }
            catch (Throwable throwable) {
                if (s == null) throw throwable;
                try {
                    s.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                s.close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }
}

