/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.panels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.teiidimporter.ui.Activator;
import org.teiid.designer.teiidimporter.ui.Messages;
import org.teiid.designer.teiidimporter.ui.UiConstants;
import org.teiid.designer.teiidimporter.ui.panels.DataSourceManager;
import org.teiid.designer.teiidimporter.ui.panels.DataSourcePanelListener;
import org.teiid.designer.teiidimporter.ui.panels.DataSourcePropertiesPanelListener;
import org.teiid.designer.teiidimporter.ui.panels.DataSourcePropertyEditingSupport;
import org.teiid.designer.teiidimporter.ui.panels.PropertyItem;
import org.teiid.designer.teiidimporter.ui.wizard.ITeiidImportServer;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;

public final class DataSourcePropertiesPanel
extends Composite
implements UiConstants,
DataSourcePanelListener {
    private static int GROUP_HEIGHT_100 = 100;
    private String dataSourceOrDriverName;
    private TableViewerBuilder propertiesViewer;
    private ITeiidImportServer teiidImportServer;
    private DataSourceManager dataSourceMgr;
    private List<PropertyItem> propertyItemList = new ArrayList<PropertyItem>();
    private boolean isCreateNew = false;
    private boolean isReadOnly = false;
    private PropertyLabelProvider namePropLabelProvider;
    private PropertyLabelProvider valuePropLabelProvider;
    private List<DataSourcePropertiesPanelListener> listeners = new ArrayList<DataSourcePropertiesPanelListener>();
    private Button resetButton;
    private Button applyButton;
    private Text propDescriptionText;

    public DataSourcePropertiesPanel(Composite parent, ITeiidImportServer teiidImportServer, boolean isReadOnly, boolean isCreateNew, String initialSelection) {
        super(parent, 0);
        this.teiidImportServer = teiidImportServer;
        this.isCreateNew = isCreateNew;
        this.isReadOnly = isReadOnly;
        this.dataSourceOrDriverName = initialSelection;
        this.dataSourceMgr = new DataSourceManager(this.teiidImportServer);
        Composite outerPanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808, (int)2);
        GridLayout bpGL = new GridLayout(2, false);
        bpGL.marginHeight = 1;
        outerPanel.setLayout((Layout)bpGL);
        if (!isReadOnly) {
            this.createButtonsPanel(outerPanel);
        }
        this.createTablePanel(outerPanel, isReadOnly);
    }

    private void createButtonsPanel(Composite parent) {
        Composite panel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)1);
        panel.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(0x1000000, 1, false, false);
        gData.heightHint = GROUP_HEIGHT_100;
        panel.setLayoutData((Object)gData);
        this.resetButton = new Button(panel, 8);
        this.resetButton.setText(Messages.dataSourcePropertiesPanel_resetButton);
        this.resetButton.setToolTipText(Messages.dataSourcePropertiesPanel_resetTooltip);
        this.resetButton.setLayoutData((Object)new GridData(768));
        this.resetButton.setEnabled(false);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSourcePropertiesPanel.this.handleResetProperty();
            }
        });
        this.applyButton = new Button(panel, 8);
        this.applyButton.setText(Messages.dataSourcePropertiesPanel_applyButton);
        this.applyButton.setToolTipText(Messages.dataSourcePropertiesPanel_applyTooltip);
        this.applyButton.setLayoutData((Object)new GridData(768));
        this.applyButton.setEnabled(false);
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSourcePropertiesPanel.this.applyButton.setEnabled(false);
                DataSourcePropertiesPanel.this.firePropertyChanged();
            }
        });
    }

    private void createTablePanel(Composite parent, boolean isReadOnly) {
        Composite panel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808);
        int tableStyle = 68096;
        this.propertiesViewer = new TableViewerBuilder(panel, tableStyle);
        ((GridData)this.propertiesViewer.getTableComposite().getLayoutData()).minimumHeight = 120;
        Label reqdLabel = new Label(panel, 0);
        reqdLabel.setText(Messages.dataSourcePropertiesPanel_requiredLabel);
        this.propDescriptionText = new Text(panel, 586);
        this.propDescriptionText.setBackground(parent.getBackground());
        this.propDescriptionText.setForeground(Display.getCurrent().getSystemColor(10));
        GridData descriptionLabelGridData = new GridData(768);
        descriptionLabelGridData.horizontalIndent = 20;
        descriptionLabelGridData.heightHint = 2 * this.propDescriptionText.getLineHeight();
        this.propDescriptionText.setLayoutData((Object)descriptionLabelGridData);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.propertiesViewer.getTableViewer());
        this.propertiesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return DataSourcePropertiesPanel.this.getProperties();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        Table table = this.propertiesViewer.getTable();
        table.setLayout((Layout)new TableLayout());
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * 5;
        TableViewerColumn column = this.propertiesViewer.createColumn(16384, 50, 40, true);
        column.getColumn().setText(Messages.dataSourcePropertiesPanel_nameColText);
        this.namePropLabelProvider = new PropertyLabelProvider(true, this.propertyItemList);
        column.setLabelProvider((CellLabelProvider)this.namePropLabelProvider);
        column = this.propertiesViewer.createColumn(16384, 50, 40, true);
        column.getColumn().setText(Messages.dataSourcePropertiesPanel_valueColText);
        this.valuePropLabelProvider = new PropertyLabelProvider(false, this.propertyItemList);
        column.setLabelProvider((CellLabelProvider)this.valuePropLabelProvider);
        if (!isReadOnly) {
            column.setEditingSupport((EditingSupport)new DataSourcePropertyEditingSupport((ColumnViewer)this.propertiesViewer.getTableViewer(), this));
            ColumnViewerEditorActivationStrategy activationSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.propertiesViewer.getTableViewer()){

                protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                    Object eventSource;
                    EventObject source;
                    if (event.eventType == 2 && (source = event.sourceEvent) instanceof MouseEvent && (eventSource = event.getSource()) instanceof ViewerCell && ((ViewerCell)eventSource).getColumnIndex() == 1) {
                        DataSourcePropertiesPanel.this.applyButton.setEnabled(true);
                        DataSourcePropertiesPanel.this.firePropertyChanged();
                        return true;
                    }
                    DataSourcePropertiesPanel.this.applyButton.setEnabled(false);
                    DataSourcePropertiesPanel.this.firePropertyChanged();
                    return false;
                }
            };
            TableViewerEditor.create((TableViewer)this.propertiesViewer.getTableViewer(), (ColumnViewerEditorActivationStrategy)activationSupport, (int)1);
        }
        this.propertiesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataSourcePropertiesPanel.this.handlePropertySelected(event);
            }
        });
        this.propertiesViewer.setInput((Object)this);
        this.updatePropertiesList();
        this.propertiesViewer.refresh();
        this.packTable();
    }

    public void addListener(DataSourcePropertiesPanelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(DataSourcePropertiesPanelListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void firePropertyChanged() {
        for (DataSourcePropertiesPanelListener listener : this.listeners) {
            listener.propertyChanged();
        }
    }

    private void handleResetProperty() {
        assert (!this.propertiesViewer.getSelection().isEmpty());
        PropertyItem prop = this.getSelectedProperty();
        prop.reset();
        this.propertiesViewer.refresh();
        this.resetButton.setEnabled(false);
        this.applyButton.setEnabled(false);
        this.firePropertyChanged();
    }

    public void setDataSourceOrDriverName(String sourceOrDriverName) {
        this.dataSourceOrDriverName = sourceOrDriverName;
        this.updatePropertiesList();
        this.propertiesViewer.refresh();
        this.packTable();
    }

    private void packTable() {
        TableColumn[] cols = this.propertiesViewer.getTable().getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].pack();
            ++i;
        }
    }

    private Object[] getProperties() {
        return this.propertyItemList.toArray();
    }

    public Properties getDataSourceProperties() {
        Properties resultProperties = new Properties();
        for (PropertyItem propObj : this.propertyItemList) {
            String propName = propObj.getName();
            String propValue = propObj.getValue();
            String defaultValue = propObj.getDefaultValue();
            boolean isModifiable = propObj.isModifiable();
            boolean isRequired = this.isPropertyRequired(propObj, this.propertyItemList);
            if (!isRequired && (!isModifiable || this.valuesSame(propValue, defaultValue))) continue;
            resultProperties.setProperty(propName, propValue);
        }
        return resultProperties;
    }

    private boolean isPropertyRequired(PropertyItem propItem, List<PropertyItem> propItems) {
        String propName;
        boolean isRequired = propItem.isRequired();
        if (isRequired && this.isGoogleSource(propItems) && (propName = propItem.getName()) != null) {
            String authValue;
            if (propName.equalsIgnoreCase("RefreshToken")) {
                String authValue2 = this.getPropertyValue("AuthMethod", this.propertyItemList);
                if (authValue2 != null && authValue2.equalsIgnoreCase("ClientLogin")) {
                    isRequired = false;
                }
            } else if ((propName.equalsIgnoreCase("Username") || propName.equalsIgnoreCase("Password")) && (authValue = this.getPropertyValue("AuthMethod", this.propertyItemList)) != null && authValue.equalsIgnoreCase("OAuth2")) {
                isRequired = false;
            }
        }
        return isRequired;
    }

    private boolean valuesSame(String value1, String value2) {
        if (CoreStringUtil.isEmpty((String)value1) && CoreStringUtil.isEmpty((String)value2)) {
            return true;
        }
        if (CoreStringUtil.isEmpty((String)value1) && !CoreStringUtil.isEmpty((String)value2)) {
            return false;
        }
        if (CoreStringUtil.isEmpty((String)value2) && !CoreStringUtil.isEmpty((String)value1)) {
            return false;
        }
        return value1.equalsIgnoreCase(value2);
    }

    public boolean hasPropertyChanges() {
        boolean hasChange = false;
        for (PropertyItem propItem : this.propertyItemList) {
            if (!propItem.hasChanged()) continue;
            hasChange = true;
            break;
        }
        return hasChange;
    }

    private void updatePropertiesList() {
        if (this.dataSourceOrDriverName != null) {
            this.propertyItemList = this.isCreateNew ? this.sortPropertyItems(this.dataSourceMgr.getDriverPropertyItems(this.dataSourceOrDriverName)) : this.sortPropertyItems(this.dataSourceMgr.getDataSourcePropertyItems(this.dataSourceOrDriverName));
            this.namePropLabelProvider.setPropertyItems(this.propertyItemList);
            this.valuePropLabelProvider.setPropertyItems(this.propertyItemList);
        }
    }

    private List<PropertyItem> sortPropertyItems(List<PropertyItem> propItems) {
        PropertyItem item;
        PropertyItem item22;
        CoreArgCheck.isNotNull(propItems);
        ArrayList<PropertyItem> resultList = new ArrayList<PropertyItem>(propItems.size());
        ArrayList<String> propDisplayNames = new ArrayList<String>(propItems.size());
        for (PropertyItem item22 : propItems) {
            propDisplayNames.add(item22.getDisplayName());
        }
        Collections.sort(propDisplayNames);
        if (propDisplayNames.contains("connection-url")) {
            item22 = this.getPropertyItem("connection-url", propItems);
            if (item22 != null) {
                resultList.add(item22);
            }
            propDisplayNames.remove("connection-url");
        }
        if (propDisplayNames.contains("user-name")) {
            item22 = this.getPropertyItem("user-name", propItems);
            if (item22 != null) {
                resultList.add(item22);
            }
            propDisplayNames.remove("user-name");
        }
        if (propDisplayNames.contains("password")) {
            item22 = this.getPropertyItem("password", propItems);
            if (item22 != null) {
                resultList.add(item22);
            }
            propDisplayNames.remove("password");
        }
        ArrayList<String> requiredDisplayNames = new ArrayList<String>(propDisplayNames.size());
        for (String propName : propDisplayNames) {
            item = this.getPropertyItem(propName, propItems);
            if (!item.isRequired()) continue;
            requiredDisplayNames.add(item.getDisplayName());
        }
        for (String propName : requiredDisplayNames) {
            item = this.getPropertyItem(propName, propItems);
            if (item == null) continue;
            resultList.add(item);
        }
        propDisplayNames.removeAll(requiredDisplayNames);
        for (String propName : propDisplayNames) {
            item = this.getPropertyItem(propName, propItems);
            resultList.add(item);
        }
        return resultList;
    }

    private PropertyItem getPropertyItem(String displayName, List<PropertyItem> propItems) {
        CoreArgCheck.isNotNull(propItems);
        CoreArgCheck.isNotNull((Object)displayName);
        PropertyItem resultItem = null;
        for (PropertyItem item : propItems) {
            if (!item.getDisplayName().equalsIgnoreCase(displayName)) continue;
            resultItem = item;
            break;
        }
        return resultItem;
    }

    private PropertyItem getSelectedProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.propertiesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (PropertyItem)selection.getFirstElement();
    }

    void handlePropertySelected(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.setPropertyDescriptionText(selection);
        if (this.isReadOnly) {
            return;
        }
        if (selection.isEmpty()) {
            if (this.resetButton.isEnabled()) {
                this.resetButton.setEnabled(false);
            }
        } else {
            PropertyItem prop = (PropertyItem)selection.getFirstElement();
            boolean enable = prop.hasChanged();
            if (this.resetButton.isEnabled() != enable) {
                this.resetButton.setEnabled(enable);
            }
        }
    }

    private void setPropertyDescriptionText(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            this.propDescriptionText.setText("");
        } else {
            PropertyItem prop = (PropertyItem)selection.getFirstElement();
            this.propDescriptionText.setText(prop.getDescription());
        }
    }

    void handleRestorePropertyDefaultValue() {
        assert (!this.propertiesViewer.getSelection().isEmpty());
        PropertyItem prop = this.getSelectedProperty();
        prop.setValue(null);
        this.propertiesViewer.refresh();
        this.resetButton.setEnabled(false);
    }

    public IStatus getStatus() {
        Status resultStatus = new Status(0, PLUGIN_ID, Messages.dataSourcePropertiesPanelOk);
        for (PropertyItem propObj : this.propertyItemList) {
            if (!this.isPropertyRequired(propObj, this.propertyItemList) || propObj.hasValidValue()) continue;
            resultStatus = new Status(4, PLUGIN_ID, Messages.dataSourcePropertiesPanel_invalidPropertyMsg);
            break;
        }
        if (this.applyButton.isEnabled()) {
            resultStatus = new Status(4, PLUGIN_ID, Messages.dataSourcePropertiesPanel_applyPropertyChangesMsg);
        }
        return resultStatus;
    }

    private boolean isGoogleSource(List<PropertyItem> propertyItems) {
        boolean isGoogle = false;
        String classNameValue = this.getPropertyValue("class-name", propertyItems);
        if (classNameValue != null && classNameValue.equalsIgnoreCase("org.teiid.resource.adapter.google.SpreadsheetManagedConnectionFactory")) {
            isGoogle = true;
        }
        return isGoogle;
    }

    private String getPropertyValue(String propKey, List<PropertyItem> propertyItems) {
        String propValue = null;
        for (PropertyItem propItem : propertyItems) {
            String propName = propItem.getName();
            if (propName == null || !propName.equalsIgnoreCase(propKey)) continue;
            propValue = propItem.getValue();
            break;
        }
        return propValue;
    }

    public void refresh() {
        this.propertiesViewer.setInput((Object)this);
        this.propertiesViewer.refresh();
    }

    @Override
    public void selectionChanged(String dataSourceOrDriverName) {
        this.setDataSourceOrDriverName(dataSourceOrDriverName);
    }

    class PropertyLabelProvider
    extends ColumnLabelProvider {
        private final boolean nameColumn;
        private List<PropertyItem> propertyItems;

        public PropertyLabelProvider(boolean nameColumn, List<PropertyItem> propertyItems) {
            this.nameColumn = nameColumn;
            this.propertyItems = propertyItems;
        }

        public void setPropertyItems(List<PropertyItem> propItems) {
            this.propertyItems = propItems;
        }

        public Image getImage(Object element) {
            PropertyItem property = (PropertyItem)element;
            Image image = null;
            Image changedImage = Activator.getDefault().getImage("icons/restore-default-value.png");
            Image errorImage = Activator.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            if (!this.nameColumn) {
                boolean hasChanged = property.hasChanged();
                if (hasChanged) {
                    image = changedImage;
                }
                boolean hasValidValue = property.hasValidValue();
                boolean isPropRqd = DataSourcePropertiesPanel.this.isPropertyRequired(property, this.propertyItems);
                if (isPropRqd && !hasValidValue) {
                    image = errorImage;
                }
            }
            return image;
        }

        public String getText(Object element) {
            PropertyItem property = (PropertyItem)element;
            if (this.nameColumn) {
                if (DataSourcePropertiesPanel.this.isPropertyRequired(property, this.propertyItems)) {
                    return "* " + property.getDisplayName();
                }
                return property.getDisplayName();
            }
            String value = property.getValue();
            if ((property.isMasked() || property.isPassword()) && !CoreStringUtil.isEmpty((String)value)) {
                return "*****";
            }
            return value;
        }

        public String getToolTipText(Object element) {
            PropertyItem propObj = (PropertyItem)element;
            if (this.nameColumn) {
                return propObj.getDescription();
            }
            if (propObj.hasValidValue()) {
                return NLS.bind((String)Messages.dataSourcePropertiesPanel_validPropertyTooltip, (Object)propObj.getDisplayName());
            }
            return NLS.bind((String)Messages.dataSourcePropertiesPanel_invalidPropertyTooltip, (Object)propObj.getDisplayName());
        }
    }
}

