/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.panels;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.TeiidPropertyDefinition;
import org.teiid.designer.teiidimporter.ui.Messages;
import org.teiid.designer.teiidimporter.ui.UiConstants;
import org.teiid.designer.teiidimporter.ui.panels.PropertyItem;
import org.teiid.designer.teiidimporter.ui.panels.TranslatorHelper;
import org.teiid.designer.teiidimporter.ui.wizard.ITeiidImportServer;

public class DataSourceManager
implements UiConstants {
    private static final String DRIVER_KEY = "driver-name";
    private static final String CLASSNAME_KEY = "class-name";
    private static final String CONN_FACTORY_CLASS_KEY = "managedconnectionfactory-class";
    private static final String DOT_RAR = ".rar";
    private ITeiidImportServer teiidImportServer;

    public DataSourceManager(ITeiidImportServer teiidImportServer) {
        this.teiidImportServer = teiidImportServer;
    }

    public IStatus createDataSource(final String dataSourceName, final String driverName, final Properties properties) {
        Status resultStatus = new Status(0, PLUGIN_ID, Messages.dataSourceManager_createOk);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        DataSourceManager.this.teiidImportServer.getOrCreateDataSource(dataSourceName, dataSourceName, driverName, properties);
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, op);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            resultStatus = new Status(4, UiConstants.PLUGIN_ID, 0, cause.getLocalizedMessage(), cause);
            UTIL.log((IStatus)resultStatus);
        }
        catch (InterruptedException interruptedException) {
            resultStatus = new Status(4, UiConstants.PLUGIN_ID, Messages.dataSourceManager_createInterruptedMsg);
            UTIL.log((IStatus)resultStatus);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        return resultStatus;
    }

    public IStatus deleteDataSource(final String dataSourceName) {
        Status resultStatus = new Status(0, PLUGIN_ID, Messages.dataSourceManager_deleteOk);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        DataSourceManager.this.teiidImportServer.deleteDataSource(dataSourceName);
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, op);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            resultStatus = new Status(4, UiConstants.PLUGIN_ID, 0, cause.getLocalizedMessage(), cause);
            UTIL.log((IStatus)resultStatus);
        }
        catch (InterruptedException interruptedException) {
            resultStatus = new Status(4, UiConstants.PLUGIN_ID, Messages.dataSourceManager_deleteInterruptedMsg);
            UTIL.log((IStatus)resultStatus);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        return resultStatus;
    }

    public IStatus deleteAndCreateDataSource(final String deleteSourceName, final String createSourceName, final String driverName, final Properties properties) {
        Status resultStatus = new Status(0, PLUGIN_ID, Messages.dataSourceManager_deleteCreateOk);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        DataSourceManager.this.teiidImportServer.deleteDataSource(deleteSourceName);
                        DataSourceManager.this.teiidImportServer.getOrCreateDataSource(createSourceName, createSourceName, driverName, properties);
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, op);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            resultStatus = new Status(4, UiConstants.PLUGIN_ID, 0, cause.getLocalizedMessage(), cause);
            UTIL.log((IStatus)resultStatus);
        }
        catch (InterruptedException interruptedException) {
            resultStatus = new Status(4, UiConstants.PLUGIN_ID, Messages.dataSourceManager_deleteCreateInterruptedMsg);
            UTIL.log((IStatus)resultStatus);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        return resultStatus;
    }

    public IStatus copyDataSource(final String dataSourceToCopyName, final String dataSourceToCopyDriver, final String newDataSourceName) {
        Status resultStatus = new Status(0, PLUGIN_ID, Messages.dataSourceManager_copyOk);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        Properties dsProps = DataSourceManager.this.teiidImportServer.getDataSourceProperties(dataSourceToCopyName);
                        dsProps.remove("jndi-name");
                        DataSourceManager.this.teiidImportServer.getOrCreateDataSource(newDataSourceName, newDataSourceName, dataSourceToCopyDriver, dsProps);
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, op);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            resultStatus = new Status(4, UiConstants.PLUGIN_ID, 0, cause.getLocalizedMessage(), cause);
            UTIL.log((IStatus)resultStatus);
        }
        catch (InterruptedException interruptedException) {
            resultStatus = new Status(4, UiConstants.PLUGIN_ID, Messages.dataSourceManager_copyInterruptedMsg);
            UTIL.log((IStatus)resultStatus);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        return resultStatus;
    }

    public List<PropertyItem> getDataSourcePropertyItems(String dsName) {
        String driverName = this.getDataSourceDriver(dsName, null);
        List<PropertyItem> propertyItems = this.getDriverPropertyItems(driverName);
        if (!propertyItems.isEmpty()) {
            Properties props = null;
            try {
                props = this.teiidImportServer.getDataSourceProperties(dsName);
            }
            catch (Exception ex) {
                props = new Properties();
                UTIL.log((Throwable)ex);
            }
            for (PropertyItem propItem : propertyItems) {
                String propName = propItem.getName();
                String propValue = props.getProperty(propName);
                if (!props.containsKey(propName) || (propValue = props.getProperty(propName)) == null) continue;
                propItem.setValue(propValue);
                propItem.setOriginalValue(propValue);
            }
        }
        return propertyItems;
    }

    public List<PropertyItem> getDriverPropertyItems(String driverName) {
        Collection<TeiidPropertyDefinition> propDefns;
        ArrayList<PropertyItem> propertyItemList = new ArrayList<PropertyItem>();
        if (driverName == null) {
            return propertyItemList;
        }
        try {
            propDefns = this.teiidImportServer.getTemplatePropertyDefns(driverName);
        }
        catch (Exception ex) {
            propDefns = new ArrayList<TeiidPropertyDefinition>();
            UTIL.log((Throwable)ex);
        }
        String rarConnFactoryValue = this.getManagedConnectionFactoryClassDefault(propDefns);
        for (TeiidPropertyDefinition propDefn : propDefns) {
            String urlTemplate;
            PropertyItem propItem = new PropertyItem();
            String name = propDefn.getName();
            propItem.setName(name);
            String displayName = propDefn.getDisplayName();
            propItem.setDisplayName(displayName);
            propItem.setDescription(propDefn.getDescription());
            boolean isModifiable = this.isModifiable(driverName, propDefn);
            propItem.setModifiable(isModifiable);
            boolean isRequired = propDefn.isRequired();
            propItem.setRequired(isRequired);
            boolean isMasked = propDefn.isMasked();
            propItem.setMasked(isMasked);
            Object defaultValue = propDefn.getDefaultValue();
            if (defaultValue != null) {
                propItem.setDefaultValue(defaultValue.toString());
            }
            if (defaultValue != null) {
                propItem.setValue(defaultValue.toString());
                propItem.setOriginalValue(defaultValue.toString());
            } else if (displayName.equalsIgnoreCase("connection-url") && !CoreStringUtil.isEmpty((String)(urlTemplate = TranslatorHelper.getUrlTemplate(driverName)))) {
                propItem.setValue(urlTemplate);
                propItem.setOriginalValue(urlTemplate);
            }
            if (name.equals(CLASSNAME_KEY)) {
                propItem.setDefaultValue(rarConnFactoryValue);
                propItem.setValue(rarConnFactoryValue);
                propItem.setOriginalValue(rarConnFactoryValue);
                propItem.setRequired(true);
            }
            propertyItemList.add(propItem);
        }
        return propertyItemList;
    }

    public Map<String, String> getClassNameDriverNameMap(Collection<ITeiidDataSource> teiidDataSources) {
        Set availableTemplateNames;
        HashMap<String, String> raClassToDriverNameMap = new HashMap<String, String>();
        HashSet<String> dsClassNames = new HashSet<String>();
        for (ITeiidDataSource ds : teiidDataSources) {
            String dsClass = ds.getPropertyValue(CLASSNAME_KEY);
            if (CoreStringUtil.isEmpty((String)dsClass)) continue;
            dsClassNames.add(dsClass);
        }
        try {
            availableTemplateNames = this.teiidImportServer.getDataSourceTemplateNames();
        }
        catch (Exception ex) {
            availableTemplateNames = Collections.EMPTY_SET;
            UTIL.log((Throwable)ex);
        }
        block5: for (String className : dsClassNames) {
            for (String templateName : availableTemplateNames) {
                try {
                    Collection<TeiidPropertyDefinition> propDefns = this.teiidImportServer.getTemplatePropertyDefns(templateName);
                    String mcfDefault = this.getManagedConnectionFactoryClassDefault(propDefns);
                    if (!className.equals(mcfDefault)) continue;
                    raClassToDriverNameMap.put(className, templateName);
                    continue block5;
                }
                catch (Exception ex) {
                    UTIL.log((Throwable)ex);
                }
            }
        }
        return raClassToDriverNameMap;
    }

    public String getDataSourceDriver(String dsName, Map<String, String> raClassNameDriverNameMap) {
        String driverName = null;
        Properties props = new Properties();
        try {
            props = this.teiidImportServer.getDataSourceProperties(dsName);
        }
        catch (Exception ex) {
            UTIL.log((Throwable)ex);
            return null;
        }
        driverName = props.getProperty(DRIVER_KEY);
        if (CoreStringUtil.isEmpty((String)driverName)) {
            String className = props.getProperty(CLASSNAME_KEY);
            if (raClassNameDriverNameMap != null) {
                driverName = raClassNameDriverNameMap.get(className);
            } else {
                String dsTemplateName = this.findDSTemplateWithMatchingClass(className);
                if (!CoreStringUtil.isEmpty((String)dsTemplateName)) {
                    driverName = dsTemplateName;
                }
            }
        }
        return driverName;
    }

    private String findDSTemplateWithMatchingClass(String className) {
        Set availableTemplateNames;
        if (CoreStringUtil.isEmpty((String)className)) {
            return null;
        }
        String dsTemplateName = null;
        try {
            availableTemplateNames = this.teiidImportServer.getDataSourceTemplateNames();
        }
        catch (Exception ex) {
            availableTemplateNames = Collections.EMPTY_SET;
            UTIL.log((Throwable)ex);
        }
        for (String templateName : availableTemplateNames) {
            try {
                Collection<TeiidPropertyDefinition> propDefns = this.teiidImportServer.getTemplatePropertyDefns(templateName);
                String mcfDefault = this.getManagedConnectionFactoryClassDefault(propDefns);
                if (!className.equals(mcfDefault)) continue;
                dsTemplateName = templateName;
                break;
            }
            catch (Exception ex) {
                UTIL.log((Throwable)ex);
            }
        }
        return dsTemplateName;
    }

    private boolean isModifiable(String driverName, TeiidPropertyDefinition propDefn) {
        boolean isModifiable = propDefn.isModifiable();
        if (driverName != null && driverName.endsWith(DOT_RAR)) {
            isModifiable = !isModifiable;
        }
        return isModifiable;
    }

    private String getManagedConnectionFactoryClassDefault(Collection<TeiidPropertyDefinition> propDefns) {
        String resultValue = null;
        for (TeiidPropertyDefinition pDefn : propDefns) {
            if (!pDefn.getName().equalsIgnoreCase(CONN_FACTORY_CLASS_KEY)) continue;
            resultValue = (String)pDefn.getDefaultValue();
            break;
        }
        return resultValue;
    }
}

