/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.part;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.jbpm.gd.common.figure.EdgeFigure;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.notation.BendPoint;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Label;
import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.policy.BendpointEditPolicy;
import org.jbpm.gd.common.policy.ConnectionEditPolicy;
import org.jbpm.gd.common.policy.ConnectionEndpointsEditPolicy;

public abstract class EdgeGraphicalEditPart
extends AbstractConnectionEditPart
implements NotationElementGraphicalEditPart {
    public EdgeGraphicalEditPart(NotationElement notationElement) {
        this.setModel(notationElement);
    }

    private Edge getEdge() {
        return (Edge)this.getModel();
    }

    protected IFigure createFigure() {
        EdgeFigure result = new EdgeFigure();
        result.setRoutingConstraint(this.constructFigureBendpointList(result));
        return result;
    }

    private List constructFigureBendpointList(EdgeFigure f) {
        ArrayList<RelativeBendpoint> result = new ArrayList<RelativeBendpoint>();
        List modelBendpoints = this.getEdge().getBendPoints();
        int i = 0;
        while (i < modelBendpoints.size()) {
            BendPoint bendpoint = (BendPoint)modelBendpoints.get(i);
            RelativeBendpoint figureBendpoint = new RelativeBendpoint((Connection)f);
            figureBendpoint.setRelativeDimensions(bendpoint.getFirstRelativeDimension(), bendpoint.getSecondRelativeDimension());
            figureBendpoint.setWeight((float)((i + 1) / (modelBendpoints.size() + 1)));
            result.add(figureBendpoint);
            ++i;
        }
        return result;
    }

    private void refreshBendpoints() {
        EdgeFigure f = (EdgeFigure)this.getFigure();
        f.setRoutingConstraint(this.constructFigureBendpointList(f));
    }

    protected abstract ConnectionEditPolicy getConnectionEditPolicy();

    protected void createEditPolicies() {
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)this.getConnectionEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointsEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new BendpointEditPolicy());
    }

    public void activate() {
        if (!this.isActive()) {
            this.getEdge().addPropertyChangeListener(this);
            super.activate();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getEdge().removePropertyChangeListener(this);
            super.deactivate();
        }
    }

    protected List getModelChildren() {
        ArrayList<Label> result = new ArrayList<Label>();
        Label label = this.getEdge().getLabel();
        if (label != null) {
            result.add(label);
        }
        return result;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("bendPointAdd".equals(propertyName) || "bendPointSet".equals(propertyName) || "bendPointRemove".equals(propertyName)) {
            this.refreshBendpoints();
        } else if ("target".equals(propertyName)) {
            this.setTarget((EditPart)this.getViewer().getEditPartRegistry().get(evt.getNewValue()));
            this.refresh();
        }
    }

    public AbstractNotationElement getNotationElement() {
        return (AbstractNotationElement)this.getModel();
    }

    public boolean testAttribute(Object target, String name, String value) {
        return false;
    }
}

