/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.common.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.common.ui.AddEditDialog;
import org.apache.directory.studio.common.ui.widgets.AbstractWidget;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TableWidget<E>
extends AbstractWidget {
    private List<E> elements = new ArrayList();
    private AddEditDialog<E> elementDialog;
    private LabelProvider labelProvider;
    private boolean hasEdit;
    private Composite composite;
    private Table elementTable;
    private TableViewer elementTableViewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private ISelectionChangedListener tableViewerSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection selection = (StructuredSelection)TableWidget.this.elementTableViewer.getSelection();
            if (TableWidget.this.hasEdit) {
                TableWidget.this.editButton.setEnabled(!selection.isEmpty());
            }
            TableWidget.this.deleteButton.setEnabled(!selection.isEmpty());
        }
    };
    private IDoubleClickListener tableViewerDoubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            TableWidget.this.editElement();
        }
    };
    private SelectionListener addButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableWidget.this.addElement();
        }
    };
    private SelectionListener editButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableWidget.this.editElement();
        }
    };
    private SelectionListener deleteButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableWidget.this.deleteElement();
        }
    };

    public void createWidgetWithEdit(Composite parent, FormToolkit toolkit) {
        this.createWidget(parent, toolkit, true);
    }

    public void createWidgetNoEdit(Composite parent, FormToolkit toolkit) {
        this.createWidget(parent, toolkit, false);
    }

    private void createWidget(Composite parent, FormToolkit toolkit, boolean hasEdit) {
        this.hasEdit = hasEdit;
        this.composite = toolkit != null ? toolkit.createComposite(parent) : new Composite(parent, 0);
        GridLayout compositeGridLayout = new GridLayout(2, false);
        compositeGridLayout.marginWidth = 0;
        compositeGridLayout.marginHeight = 0;
        this.composite.setLayout((Layout)compositeGridLayout);
        this.elementTable = toolkit != null ? toolkit.createTable(this.composite, 0) : new Table(this.composite, 0);
        GridData gd = new GridData(4, 4, true, true, 1, 3);
        gd.heightHint = 20;
        gd.widthHint = 100;
        this.elementTable.setLayoutData((Object)gd);
        this.elementTableViewer = new TableViewer(this.elementTable);
        this.elementTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.elementTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.elementTableViewer.addSelectionChangedListener(this.tableViewerSelectionChangedListener);
        if (hasEdit) {
            this.elementTableViewer.addDoubleClickListener(this.tableViewerDoubleClickListener);
        }
        this.elementTableViewer.setInput(this.elements);
        this.addButton = toolkit != null ? toolkit.createButton(this.composite, "Add...", 8) : BaseWidgetUtils.createButton(this.composite, "Add...", 1);
        this.addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.addButton.addSelectionListener(this.addButtonListener);
        if (hasEdit) {
            this.editButton = toolkit != null ? toolkit.createButton(this.composite, "Edit...", 8) : BaseWidgetUtils.createButton(this.composite, "Edit...", 8);
            this.editButton.setEnabled(false);
            this.editButton.setLayoutData((Object)new GridData(4, 1, false, false));
            this.editButton.addSelectionListener(this.editButtonListener);
        }
        this.deleteButton = toolkit != null ? toolkit.createButton(this.composite, "Delete", 8) : BaseWidgetUtils.createButton(this.composite, "Delete", 8);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.deleteButton.addSelectionListener(this.deleteButtonListener);
    }

    public Control getControl() {
        return this.composite;
    }

    public void setElements(List<E> elements) {
        if (elements != null && elements.size() > 0) {
            this.elements.addAll(elements);
        }
        this.elementTableViewer.refresh();
    }

    public List<E> getElements() {
        if (this.elements != null) {
            ArrayList copy = new ArrayList(this.elements.size());
            System.arraycopy(this.elements, 0, copy, 0, this.elements.size());
            return copy;
        }
        return null;
    }

    private void addElement() {
        this.elementDialog.addNewElement();
        this.elementDialog.setElements(this.elements);
        if (this.elementDialog.open() == 0) {
            E newElement = this.elementDialog.getEditedElement();
            if (!this.elements.contains(newElement)) {
                String elementStr = newElement.toString();
                this.elements.add(newElement);
                this.elementTableViewer.refresh();
                this.elementTableViewer.setSelection((ISelection)new StructuredSelection((Object)elementStr));
            }
            this.notifyListeners();
        }
    }

    private void editElement() {
        StructuredSelection selection = (StructuredSelection)this.elementTableViewer.getSelection();
        if (!selection.isEmpty()) {
            Object selectedElement = selection.getFirstElement();
            this.elementDialog.setEditedElement(selectedElement);
            if (this.elementDialog.open() == 0) {
                E newElement = this.elementDialog.getEditedElement();
                if (this.elements.contains(newElement)) {
                    this.elements.remove(selectedElement);
                    this.elements.remove(newElement);
                    this.elements.add(newElement);
                } else {
                    this.elements.remove(selectedElement);
                    this.elements.add(newElement);
                }
                this.elementTableViewer.refresh();
                this.elementTableViewer.setSelection((ISelection)new StructuredSelection((Object)newElement.toString()));
                this.notifyListeners();
            }
        }
    }

    private void deleteElement() {
        StructuredSelection selection = (StructuredSelection)this.elementTableViewer.getSelection();
        if (!selection.isEmpty()) {
            Object selectedElement = selection.getFirstElement();
            this.elements.remove(selectedElement);
            this.elementTableViewer.refresh();
            this.notifyListeners();
        }
    }

    public void setElementDialog(AddEditDialog<E> elementDialog) {
        this.elementDialog = elementDialog;
    }

    public void setLabelProvider(LabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }
}

