/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.common.ui.widgets;

import org.apache.directory.studio.common.ui.CommonUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BaseWidgetUtils {
    public static Group createGroup(Composite parent, String label, int span) {
        Group group = new Group(parent, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = span;
        group.setLayoutData((Object)gridData);
        group.setText(label);
        group.setLayout((Layout)new GridLayout());
        return group;
    }

    public static Composite createColumnContainer(Composite parent, int columnCount, int span) {
        return BaseWidgetUtils.createColumnContainer(parent, columnCount, false, span);
    }

    public static Composite createColumnContainer(Composite parent, int columnCount, boolean makeColumnsEqualWidth, int span) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(columnCount, makeColumnsEqualWidth);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        container.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = span;
        container.setLayoutData((Object)gridData);
        return container;
    }

    public static Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        return label;
    }

    public static Label createWrappedLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = span;
        gridData.widthHint = 100;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        return label;
    }

    public static Text createText(Composite parent, String text, int span) {
        Text textWidget = new Text(parent, 2048);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = span;
        textWidget.setLayoutData((Object)gridData);
        textWidget.setText(text);
        return textWidget;
    }

    public static Text createText(Composite parent, String text, int textWidth, int span) {
        Text textWidget = new Text(parent, 2048);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        gridData.widthHint = 9 * textWidth;
        textWidget.setLayoutData((Object)gridData);
        textWidget.setText(text);
        textWidget.setTextLimit(textWidth);
        return textWidget;
    }

    public static Text createPasswordText(Composite parent, String text, int span) {
        Text textWidget = new Text(parent, 0x400800);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = span;
        textWidget.setLayoutData((Object)gridData);
        textWidget.setText(text);
        return textWidget;
    }

    public static Text createReadonlyPasswordText(Composite parent, String text, int span) {
        Text textWidget = new Text(parent, 0x400808);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = span;
        textWidget.setLayoutData((Object)gridData);
        textWidget.setEditable(false);
        textWidget.setBackground(parent.getBackground());
        textWidget.setText(text);
        return textWidget;
    }

    public static Text createLabeledText(Composite parent, String text, int span) {
        Text textWidget = new Text(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = span;
        textWidget.setLayoutData((Object)gridData);
        textWidget.setEditable(false);
        textWidget.setBackground(parent.getBackground());
        textWidget.setText(text);
        return textWidget;
    }

    public static Text createLabeledText(Composite parent, String text, int span, int widthHint) {
        Text textWidget = new Text(parent, 0);
        GridData gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = span;
        gridData.widthHint = widthHint;
        textWidget.setLayoutData((Object)gridData);
        textWidget.setEditable(false);
        textWidget.setBackground(parent.getBackground());
        textWidget.setText(text);
        return textWidget;
    }

    public static Text createWrappedLabeledText(Composite parent, String text, int span) {
        Text textWidget = new Text(parent, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = span;
        gridData.widthHint = 10;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        textWidget.setLayoutData((Object)gridData);
        textWidget.setEditable(false);
        textWidget.setBackground(parent.getBackground());
        textWidget.setText(text);
        return textWidget;
    }

    public static Text createWrappedLabeledText(Composite parent, String text, int span, int widthHint) {
        Text textWidget = new Text(parent, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = span;
        gridData.widthHint = widthHint;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        textWidget.setLayoutData((Object)gridData);
        textWidget.setEditable(false);
        textWidget.setBackground(parent.getBackground());
        textWidget.setText(text);
        return textWidget;
    }

    public static Text createReadonlyText(Composite parent, String text, int span) {
        Text textWidget = new Text(parent, 2056);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = span;
        textWidget.setLayoutData((Object)gridData);
        textWidget.setEditable(false);
        textWidget.setBackground(parent.getBackground());
        textWidget.setText(text);
        return textWidget;
    }

    public static Combo createCombo(Composite parent, String[] items, int selectedIndex, int span) {
        Combo combo = new Combo(parent, 2052);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = span;
        combo.setLayoutData((Object)gridData);
        combo.setItems(items);
        combo.select(selectedIndex);
        combo.setVisibleItemCount(20);
        return combo;
    }

    public static Combo createReadonlyCombo(Composite parent, String[] items, int selectedIndex, int span) {
        Combo combo = new Combo(parent, 2060);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = span;
        combo.setLayoutData((Object)gridData);
        combo.setItems(items);
        combo.select(selectedIndex);
        combo.setVisibleItemCount(20);
        return combo;
    }

    public static Button createCheckbox(Composite parent, String text, int span) {
        Button checkbox = new Button(parent, 32);
        checkbox.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        checkbox.setLayoutData((Object)gridData);
        return checkbox;
    }

    public static Button createRadiobutton(Composite parent, String text, int span) {
        Button radio = new Button(parent, 16);
        radio.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        radio.setLayoutData((Object)gridData);
        return radio;
    }

    public static Button createButton(Composite parent, String text, int span) {
        GC gc = new GC((Drawable)parent);
        try {
            gc.setFont(JFaceResources.getDialogFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            Button button = new Button(parent, 8);
            GridData gridData = new GridData();
            gridData.widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
            gridData.horizontalSpan = span;
            button.setLayoutData((Object)gridData);
            button.setText(text);
            Button button2 = button;
            return button2;
        }
        finally {
            gc.dispose();
        }
    }

    public static Label createRadioIndent(Composite parent, int span) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        gridData.horizontalIndent = 22;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static Label createSpacer(Composite parent, int span) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        gridData.heightHint = 1;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static Label createSeparator(Composite parent, int span) {
        Label label = new Label(parent, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = span;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static Link createLink(Composite parent, String text, int span) {
        Link link = new Link(parent, 0);
        link.setText(text);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = span;
        gridData.widthHint = 150;
        link.setLayoutData((Object)gridData);
        return link;
    }

    public static Text createIntegerText(FormToolkit toolkit, Composite parent) {
        return BaseWidgetUtils.createIntegerText(toolkit, parent, null, -1);
    }

    public static Text createIntegerText(FormToolkit toolkit, Composite parent, int width) {
        return BaseWidgetUtils.createIntegerText(toolkit, parent, null, width);
    }

    public static Text createIntegerText(FormToolkit toolkit, Composite parent, String description) {
        return BaseWidgetUtils.createIntegerText(toolkit, parent, description, -1);
    }

    public static Text createIntegerText(FormToolkit toolkit, Composite parent, String description, int width) {
        Text integerText = toolkit.createText(parent, "");
        integerText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int i = 0;
                while (i < e.text.length()) {
                    if (!Character.isDigit(e.text.charAt(i))) {
                        e.doit = false;
                        break;
                    }
                    ++i;
                }
            }
        });
        if (description != null && description.length() > 0) {
            ControlDecoration monitoringCheckboxDecoration = new ControlDecoration((Control)integerText, 0x1020000);
            monitoringCheckboxDecoration.setImage(CommonUIPlugin.getDefault().getImageDescriptor("resources/icons/information.gif").createImage());
            monitoringCheckboxDecoration.setMarginWidth(4);
            monitoringCheckboxDecoration.setDescriptionText(description);
        }
        if (width >= 0) {
            GridData gridData = new GridData();
            gridData.widthHint = width;
            integerText.setLayoutData((Object)gridData);
        }
        return integerText;
    }
}

