/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelStatus;
import org.teiid.designer.core.workspace.ModelStatusConstants;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceItemImpl;
import org.teiid.designer.core.workspace.ModelWorkspaceItemInfo;

public class ModelStatusImpl
extends Status
implements ModelStatus,
ModelStatusConstants,
IResourceStatus {
    private static final String DEFAULT_STATUS_NAME = "ModelStatus";
    protected ModelWorkspaceItem[] fElements = new ModelWorkspaceItem[0];
    protected IPath fPath;
    protected String fString;
    protected static final IStatus[] fgEmptyChildren = new IStatus[0];
    protected IStatus[] fChildren = fgEmptyChildren;
    public static final ModelStatus VERIFIED_OK = new ModelStatusImpl(0, 0, ModelerCore.Util.getString("status.OK", new Object[0]));

    public ModelStatusImpl() {
        super(4, "org.teiid.designer.core", 0, DEFAULT_STATUS_NAME, null);
    }

    public ModelStatusImpl(int code) {
        super(4, "org.teiid.designer.core", code, DEFAULT_STATUS_NAME, null);
        this.fElements = ModelWorkspaceItemInfo.fgEmptyChildren;
    }

    public ModelStatusImpl(int code, ModelWorkspaceItem[] elements) {
        super(4, "org.teiid.designer.core", code, DEFAULT_STATUS_NAME, null);
        this.fElements = elements;
        this.fPath = null;
    }

    public ModelStatusImpl(int code, String string) {
        this(4, code, string);
    }

    public ModelStatusImpl(int severity, int code, String string) {
        super(severity, "org.teiid.designer.core", code, DEFAULT_STATUS_NAME, null);
        this.fElements = ModelWorkspaceItemInfo.fgEmptyChildren;
        this.fPath = null;
        this.fString = string;
    }

    public ModelStatusImpl(int code, Throwable throwable) {
        super(4, "org.teiid.designer.core", code, DEFAULT_STATUS_NAME, throwable);
        this.fElements = ModelWorkspaceItemInfo.fgEmptyChildren;
    }

    public ModelStatusImpl(int code, Throwable throwable, String msg) {
        super(4, "org.teiid.designer.core", code, DEFAULT_STATUS_NAME, throwable);
        this.fElements = ModelWorkspaceItemInfo.fgEmptyChildren;
        this.fString = msg;
    }

    public ModelStatusImpl(int code, IPath path) {
        super(4, "org.teiid.designer.core", code, DEFAULT_STATUS_NAME, null);
        this.fElements = ModelWorkspaceItemInfo.fgEmptyChildren;
        this.fPath = path;
    }

    public ModelStatusImpl(int code, ModelWorkspaceItem element) {
        this(code, new ModelWorkspaceItem[]{element});
    }

    public ModelStatusImpl(int code, ModelWorkspaceItem element, String string) {
        this(code, new ModelWorkspaceItem[]{element});
        this.fString = string;
    }

    public ModelStatusImpl(int code, ModelWorkspaceItem element, IPath path) {
        this(code, new ModelWorkspaceItem[]{element});
        this.fPath = path;
    }

    public ModelStatusImpl(CoreException coreException) {
        super(4, "org.teiid.designer.core", 966, DEFAULT_STATUS_NAME, (Throwable)coreException);
        this.fElements = ModelWorkspaceItemInfo.fgEmptyChildren;
    }

    protected int getBits() {
        int severity = 1 << this.getCode() % 100 / 33;
        int category = 1 << this.getCode() / 100 + 3;
        return severity | category;
    }

    public IStatus[] getChildren() {
        return this.fChildren;
    }

    @Override
    public ModelWorkspaceItem[] getModelWorkspaceItems() {
        return this.fElements;
    }

    public String getMessage() {
        Throwable exception = this.getException();
        if (exception == null) {
            switch (this.getCode()) {
                case 966: {
                    return ModelerCore.Util.getString("status.coreException", new Object[0]);
                }
                case 969: {
                    return ModelerCore.Util.getString("element.doesNotExist", (Object)((ModelWorkspaceItemImpl)this.fElements[0]).toStringWithAncestors());
                }
                case 980: {
                    return ModelerCore.Util.getString("status.indexOutOfBounds", new Object[0]);
                }
                case 984: {
                    return ModelerCore.Util.getString("status.invalidContents", new Object[0]);
                }
                case 978: {
                    return ModelerCore.Util.getString("status.invalidDestination", (Object)((ModelWorkspaceItemImpl)this.fElements[0]).toStringWithAncestors());
                }
                case 967: {
                    StringBuffer buff = new StringBuffer(ModelerCore.Util.getString("operation.notSupported", new Object[0]));
                    int i = 0;
                    while (i < this.fElements.length) {
                        if (i > 0) {
                            buff.append(", ");
                        }
                        buff.append(((ModelWorkspaceItemImpl)this.fElements[i]).toStringWithAncestors());
                        ++i;
                    }
                    return buff.toString();
                }
                case 983: {
                    return ModelerCore.Util.getString("status.invalidName", (Object)this.fString);
                }
                case 979: {
                    if (this.fString != null) {
                        return this.fString;
                    }
                    return ModelerCore.Util.getString("status.invalidPath", (Object)(this.getPath() == null ? "null" : this.getPath().toString()));
                }
                case 997: {
                    return ModelerCore.Util.getString("status.invalidProject", (Object)this.fString);
                }
                case 995: {
                    return ModelerCore.Util.getString("status.invalidResource", (Object)this.fString);
                }
                case 996: {
                    return ModelerCore.Util.getString("status.invalidResourceType", (Object)this.fString);
                }
                case 993: {
                    if (this.fString != null) {
                        return ModelerCore.Util.getString("status.invalidSibling", (Object)this.fString);
                    }
                    return ModelerCore.Util.getString("status.invalidSibling", (Object)((ModelWorkspaceItemImpl)this.fElements[0]).toStringWithAncestors());
                }
                case 985: {
                    return ModelerCore.Util.getString("status.IOException", new Object[0]);
                }
                case 977: {
                    if (this.fString != null) {
                        return this.fString;
                    }
                    return ModelerCore.Util.getString("status.nameCollision", (Object)"");
                }
                case 968: {
                    return ModelerCore.Util.getString("operation.needElements", new Object[0]);
                }
                case 982: {
                    return ModelerCore.Util.getString("operation.needName", new Object[0]);
                }
                case 970: {
                    return ModelerCore.Util.getString("operation.needPath", new Object[0]);
                }
                case 974: {
                    return ModelerCore.Util.getString("operation.needString", new Object[0]);
                }
                case 971: {
                    return ModelerCore.Util.getString("operation.pathOutsideProject", new Object[]{this.fString, ((ModelWorkspaceItemImpl)this.fElements[0]).toStringWithAncestors()});
                }
                case 976: {
                    ModelWorkspaceItem element = this.fElements[0];
                    String name = element.getItemName();
                    return ModelerCore.Util.getString("status.readOnly", (Object)name);
                }
                case 972: {
                    return ModelerCore.Util.getString("operation.needAbsolutePath", (Object)this.getPath().toString());
                }
                case 987: {
                    return ModelerCore.Util.getString("status.targetException", new Object[0]);
                }
                case 981: {
                    return ModelerCore.Util.getString("status.updateConflict", new Object[0]);
                }
                case 999: {
                    return ModelerCore.Util.getString("status.noLocalContents", (Object)this.getPath().toString());
                }
            }
            if (this.fString != null) {
                return this.fString;
            }
            return "";
        }
        String message = exception.getMessage();
        if (message != null) {
            return message;
        }
        return exception.toString();
    }

    @Override
    public IPath getPath() {
        return this.fPath;
    }

    public int getSeverity() {
        if (this.fChildren == fgEmptyChildren) {
            return super.getSeverity();
        }
        int severity = -1;
        int i = 0;
        int max = this.fChildren.length;
        while (i < max) {
            int childrenSeverity = this.fChildren[i].getSeverity();
            if (childrenSeverity > severity) {
                severity = childrenSeverity;
            }
            ++i;
        }
        return severity;
    }

    @Override
    public boolean isDoesNotExist() {
        return this.getCode() == 969;
    }

    public boolean isMultiStatus() {
        return this.fChildren != fgEmptyChildren;
    }

    public boolean isOK() {
        return this.getCode() == 0;
    }

    public boolean matches(int mask) {
        if (!this.isMultiStatus()) {
            return this.matches(this, mask);
        }
        int i = 0;
        int max = this.fChildren.length;
        while (i < max) {
            if (this.matches((ModelStatusImpl)this.fChildren[i], mask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matches(ModelStatusImpl status, int mask) {
        int severityMask = mask & 7;
        int categoryMask = mask & 0xFFFFFFF8;
        int bits = status.getBits();
        return !(severityMask != 0 && (bits & severityMask) == 0 || categoryMask != 0 && (bits & categoryMask) == 0);
    }

    public void add(IStatus status) {
        CoreArgCheck.isNotNull((Object)status);
        IStatus[] result = new IStatus[this.fChildren.length + 1];
        System.arraycopy(this.fChildren, 0, result, 0, this.fChildren.length);
        result[result.length - 1] = status;
        this.fChildren = result;
        int newSev = status.getSeverity();
        if (newSev > this.getSeverity()) {
            this.setSeverity(newSev);
        }
    }

    public void addAll(IStatus status) {
        CoreArgCheck.isNotNull((Object)status);
        IStatus[] statuses = status.getChildren();
        int i = 0;
        while (i < statuses.length) {
            this.add(statuses[i]);
            ++i;
        }
    }

    public static ModelStatus newMultiStatus(ModelStatus[] children) {
        ModelStatusImpl result = new ModelStatusImpl();
        result.fChildren = children;
        return result;
    }

    public String toString() {
        if (this == VERIFIED_OK) {
            return "ModelStatusImpl[OK]";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Model Status [");
        buffer.append(this.getMessage());
        buffer.append("]");
        return buffer.toString();
    }
}

