/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.validation.rules;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ResourceValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.validation.rules.CoreValidationRulesUtil;
import org.teiid.designer.core.workspace.ModelStatusImpl;

public class ModelFileExtensionRule
implements ResourceValidationRule,
StringConstants {
    @Override
    public void validate(Resource resource, ValidationContext context) {
        CoreArgCheck.isNotNull((Object)resource);
        CoreArgCheck.isNotNull((Object)context);
        URI uri = resource.getURI();
        if (uri != null && uri.isFile()) {
            IStatus status;
            String name = ModelerCore.getModelEditor().getModelName(resource);
            String decodedName = URI.decode((String)name);
            ValidationResultImpl vresult = new ValidationResultImpl(decodedName);
            if (!ModelFileExtensionRule.isReservedInvalidModelName(decodedName)) {
                CoreValidationRulesUtil.validateStringNameChars(vresult, decodedName, null);
            }
            if (!vresult.hasProblems()) {
                if (!name.equals(decodedName) && !ModelFileExtensionRule.isReservedInvalidModelName(name)) {
                    CoreValidationRulesUtil.validateStringNameChars(vresult, name, null);
                    if (vresult.hasProblems()) {
                        context.addResult(vresult);
                    }
                }
            } else {
                context.addResult(vresult);
            }
            if (!(status = ModelFileExtensionRule.validate(uri.lastSegment())).isOK()) {
                ValidationResultImpl result = new ValidationResultImpl(resource);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, status.getMessage());
                result.addProblem(problem);
                context.addResult(result);
            }
        }
    }

    public static IStatus validate(String fileNameWithExtension) {
        String expectedExtension;
        CoreArgCheck.isNotNull((Object)fileNameWithExtension);
        CoreArgCheck.isNotZeroLength((String)fileNameWithExtension);
        String actualExtension = null;
        int beginIndex = fileNameWithExtension.lastIndexOf(46) + 1;
        if (beginIndex > 0 && beginIndex < fileNameWithExtension.length()) {
            actualExtension = fileNameWithExtension.substring(beginIndex);
        }
        if ((expectedExtension = ModelFileExtensionRule.getMatchingKnownExtension(actualExtension)) == null) {
            return ModelStatusImpl.VERIFIED_OK;
        }
        if (expectedExtension.equals(actualExtension)) {
            return ModelStatusImpl.VERIFIED_OK;
        }
        if (expectedExtension.equalsIgnoreCase(actualExtension)) {
            int endIndex = fileNameWithExtension.length() - actualExtension.length();
            String expectedFileName = String.valueOf(fileNameWithExtension.substring(0, endIndex)) + expectedExtension;
            Object[] params = new Object[]{fileNameWithExtension, expectedFileName};
            String msg = ModelerCore.Util.getString("ModelerCore.file_extension_not_correct_case_please_rename_file", params);
            return new Status(2, "org.teiid.designer.core", -1, msg, null);
        }
        return ModelStatusImpl.VERIFIED_OK;
    }

    private static boolean isReservedInvalidModelName(String name) {
        boolean isReservedInvalid = false;
        if ("XMLSchema-instance".equals(name) || "SimpleDatatypes-instance".equals(name)) {
            isReservedInvalid = true;
        }
        return isReservedInvalid;
    }

    private static String getMatchingKnownExtension(String extension) {
        if ("xml".equalsIgnoreCase(extension)) {
            return "xml";
        }
        if ("xmi".equalsIgnoreCase(extension)) {
            return "xmi";
        }
        if ("xsd".equalsIgnoreCase(extension)) {
            return "xsd";
        }
        if ("vdb".equalsIgnoreCase(extension)) {
            return "vdb";
        }
        return null;
    }
}

