/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.validation.rules;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ResourceValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;

public final class CircularDependenciesRule
implements ResourceValidationRule {
    @Override
    public void validate(Resource resource, ValidationContext context) {
        CoreArgCheck.isNotNull((Object)resource);
        CoreArgCheck.isNotNull((Object)context);
        try {
            IFile circularDependency;
            IResource model;
            ModelResource modelResource = ModelUtil.getModel(resource);
            if (modelResource != null && (model = modelResource.getResource()) != null && (circularDependency = WorkspaceResourceFinderUtil.getFirstResourceHavingCircularDependency(model)) != null) {
                ValidationResultImpl result = new ValidationResultImpl(resource, resource);
                String msg = ModelerCore.Util.getString("CircularDependenciesRule.errorMsg", new Object[]{model.getName(), circularDependency.getName()});
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                result.addProblem(problem);
                context.addResult(result);
            }
        }
        catch (Exception e) {
            ValidationResultImpl result = new ValidationResultImpl(resource, resource);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, e.getLocalizedMessage());
            result.addProblem(problem);
            context.addResult(result);
        }
    }
}

