/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.IOperation;
import org.teiid.core.designer.util.IReturningOperation;
import org.teiid.core.designer.util.ISafeOperation;
import org.teiid.core.designer.util.ISafeReturningOperation;
import org.teiid.designer.core.ModelerCore;

public class TransactionUtil
implements CoreStringUtil.Constants {
    public static void execute(IOperation operation, Object source, String description) throws Exception {
        TransactionUtil.execute(operation, source, true, description, true);
    }

    public static void execute(ISafeOperation operation, Object source, String description) {
        TransactionUtil.execute(operation, source, true, description, true);
    }

    public static Object execute(IReturningOperation operation, Object source, String description) throws Exception {
        return TransactionUtil.execute(operation, source, true, description, true);
    }

    public static Object execute(ISafeReturningOperation operation, Object source, String description) {
        return TransactionUtil.execute(operation, source, true, description, true);
    }

    private static void execute(IOperation operation, Object source, boolean undoable, String description, boolean significant) throws Exception {
        boolean started = ModelerCore.startTxn(undoable, significant, description, source);
        boolean succeeded = false;
        try {
            operation.execute();
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private static void execute(ISafeOperation operation, Object source, boolean undoable, String description, boolean significant) {
        boolean started = ModelerCore.startTxn(undoable, significant, description, source);
        boolean succeeded = false;
        try {
            operation.execute();
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private static Object execute(IReturningOperation operation, Object source, boolean undoable, String description, boolean significant) throws Exception {
        boolean started = ModelerCore.startTxn(undoable, significant, description, source);
        boolean succeeded = false;
        try {
            Object result = operation.execute();
            succeeded = true;
            Object object = result;
            return object;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private static Object execute(ISafeReturningOperation operation, Object source, boolean undoable, String description, boolean significant) {
        boolean started = ModelerCore.startTxn(undoable, significant, description, source);
        boolean succeeded = false;
        try {
            Object result = operation.execute();
            succeeded = true;
            Object object = result;
            return object;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public static void executeInsignificant(IOperation operation, Object source) throws Exception {
        TransactionUtil.execute(operation, source, true, "", false);
    }

    public static void executeInsignificant(ISafeOperation operation, Object source) {
        TransactionUtil.execute(operation, source, true, "", false);
    }

    public static Object executeInsignificant(IReturningOperation operation, Object source) throws Exception {
        return TransactionUtil.execute(operation, source, true, "", false);
    }

    public static Object executeInsignificant(ISafeReturningOperation operation, Object source) {
        return TransactionUtil.execute(operation, source, true, "", false);
    }

    public static void executeNonUndoable(IOperation operation, Object source) throws Exception {
        TransactionUtil.execute(operation, source, false, "", false);
    }

    public static void executeNonUndoable(ISafeOperation operation, Object source) {
        TransactionUtil.execute(operation, source, false, "", false);
    }

    public static Object executeNonUndoable(IReturningOperation operation, Object source) throws Exception {
        return TransactionUtil.execute(operation, source, false, "", false);
    }

    public static Object executeNonUndoable(ISafeReturningOperation operation, Object source) {
        return TransactionUtil.execute(operation, source, false, "", false);
    }

    private TransactionUtil() {
    }
}

