/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.search.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.IEntryResult;
import org.teiid.designer.core.index.IndexConstants;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.index.ModelWorkspaceSearchIndexSelector;
import org.teiid.designer.core.search.commands.FindRelationshipTypesCommand;
import org.teiid.designer.core.search.runtime.RelationshipTypeRecord;
import org.teiid.designer.core.search.runtime.SearchRuntimeAdapter;

public class FindRelationshipTypesCommandImpl
implements FindRelationshipTypesCommand {
    private String typeNamePattern = null;
    private boolean includeSubtypes = false;
    private Collection relationTypeInfo = Collections.EMPTY_LIST;
    private IndexSelector selector;

    @Override
    public boolean canExecute() {
        return true;
    }

    public IndexSelector getIndexSelector() {
        this.selector = this.selector != null ? this.selector : new ModelWorkspaceSearchIndexSelector();
        return this.selector;
    }

    @Override
    public void setIndexSelector(IndexSelector selector) {
        this.selector = selector;
    }

    @Override
    public IStatus execute() {
        if (!this.canExecute()) {
            return null;
        }
        try {
            Collection types = this.getRelationshipTypes(this.typeNamePattern);
            if (!CoreStringUtil.isEmpty((String)this.typeNamePattern) && this.includeSubtypes) {
                Iterator typeIter = types.iterator();
                ArrayList children = new ArrayList();
                while (typeIter.hasNext()) {
                    RelationshipTypeRecord record = (RelationshipTypeRecord)typeIter.next();
                    String typeUUID = record.getUUID();
                    children.addAll(this.getChildTypes(typeUUID));
                }
                types.addAll(children);
            }
            this.relationTypeInfo = types;
        }
        catch (Exception e) {
            ModelerCore.Util.log((Throwable)e);
            return new Status(4, "org.teiid.designer.core", 0, ModelerCore.Util.getString("FindRelationshipTypesCommandImpl.Error_trying_to_execute_command,_problem_trying_to_query_relationship_search_indexes._1", new Object[0]), (Throwable)e);
        }
        return new Status(0, "org.teiid.designer.core", 0, "", null);
    }

    private Collection getRelationshipTypes(String namePattern) throws Exception {
        String searchPrefix = IndexUtil.getPrefixPattern('G', this.typeNamePattern);
        IEntryResult[] results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), searchPrefix.toCharArray(), true, false);
        ArrayList<RelationshipTypeRecord> relationTypes = new ArrayList<RelationshipTypeRecord>(results.length);
        int i = 0;
        while (i < results.length) {
            IEntryResult result = results[i];
            relationTypes.add(SearchRuntimeAdapter.createRelationshipTypeRecord(result.getWord()));
            ++i;
        }
        return relationTypes;
    }

    private Collection getChildTypes(String typeUUID) throws Exception {
        String searchPrefix = "G\u00a0" + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + typeUUID + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
        IEntryResult[] results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), searchPrefix.toCharArray(), false, false);
        ArrayList<RelationshipTypeRecord> relationTypes = new ArrayList<RelationshipTypeRecord>(results.length);
        int i = 0;
        while (i < results.length) {
            IEntryResult result = results[i];
            relationTypes.add(SearchRuntimeAdapter.createRelationshipTypeRecord(result.getWord()));
            ++i;
        }
        return relationTypes;
    }

    @Override
    public Collection getRelationShipTypeInfo() {
        return this.relationTypeInfo;
    }

    @Override
    public void setIncludeSubTypes(boolean includeSubTypes) {
        this.includeSubtypes = includeSubTypes;
    }

    @Override
    public void setRelationshipTypeName(String namePattern) {
        this.typeNamePattern = namePattern;
    }
}

