/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.IPathComparator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.IndexSelectorFactory;
import org.teiid.designer.core.index.ModelWorkspaceSearchIndexSelector;
import org.teiid.designer.core.search.MetadataSearch;
import org.teiid.designer.core.search.commands.FindObjectCommandImpl;
import org.teiid.designer.core.search.commands.FindTypedObjectCommandImpl;
import org.teiid.designer.core.search.runtime.AnnotatedObjectRecord;
import org.teiid.designer.core.search.runtime.ResourceObjectRecord;
import org.teiid.designer.core.search.runtime.SearchRecord;
import org.teiid.designer.core.search.runtime.TypedObjectRecord;
import org.teiid.designer.core.types.DatatypeConstants;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.metamodels.core.CorePackage;
import org.teiid.designer.metamodels.diagram.DiagramPackage;

public class MetadataSearchImpl
implements MetadataSearch {
    private static final EObject[] EMPTY_EOBJECT_ARRAY = new EObject[0];
    private static final String[] RUNTIME_TYPE_NAMES;
    private static final Set TYPED_META_CLASS_NAMES;
    private static final Map EXCLUDED_OBJECT_NS_URIS;
    private EClass metaClass;
    private EObject datatype;
    private boolean includeSubtypes;
    private String runtimeType;
    private String featureName;
    private String textPattern;
    private boolean containsPattern;
    private final List modelScope;
    private final List readOnlyModelScope;
    private final List results;
    private final List readOnlyResults;
    private final ModelWorkspace workspace;

    static {
        TYPED_META_CLASS_NAMES = new HashSet(11);
        EXCLUDED_OBJECT_NS_URIS = new HashMap(3);
        RUNTIME_TYPE_NAMES = MetadataSearchImpl.getRuntimeTypeNames();
        TYPED_META_CLASS_NAMES.add("org.teiid.designer.metamodels.relational.Column");
        TYPED_META_CLASS_NAMES.add("org.teiid.designer.metamodels.relational.ProcedureParameter");
        TYPED_META_CLASS_NAMES.add("org.teiid.designer.metamodels.sdt.SimpleDatatype");
        TYPED_META_CLASS_NAMES.add("org.eclipse.xsd.XSDSimpleTypeDefinition");
        TYPED_META_CLASS_NAMES.add("org.teiid.designer.metamodels.transformation.InputParameter");
        TYPED_META_CLASS_NAMES.add("org.teiid.designer.metamodels.transformation.MappingClassColumn");
        TYPED_META_CLASS_NAMES.add("org.teiid.designer.metamodels.dataaccess.Element");
        TYPED_META_CLASS_NAMES.add("org.teiid.designer.metamodels.dataaccess.ProcedureParameter");
        EXCLUDED_OBJECT_NS_URIS.put("http://www.metamatrix.com/metamodels/Core", new String[]{ModelerCore.getModelEditor().getUri((EObject)CorePackage.eINSTANCE.getModelAnnotation()).toString()});
        EXCLUDED_OBJECT_NS_URIS.put("http://www.metamatrix.com/metamodels/Transformation", null);
        EXCLUDED_OBJECT_NS_URIS.put("http://www.metamatrix.com/metamodels/Diagram", new String[]{ModelerCore.getModelEditor().getUri((EObject)DiagramPackage.eINSTANCE.getDiagram()).toString()});
        EXCLUDED_OBJECT_NS_URIS.put("http://www.eclipse.org/emf/2002/Ecore", null);
    }

    public MetadataSearchImpl(ModelWorkspace workspace, IndexSelectorFactory selector) {
        CoreArgCheck.isNotNull((Object)workspace);
        CoreArgCheck.isNotNull((Object)selector);
        this.workspace = workspace;
        this.results = new LinkedList();
        this.readOnlyResults = Collections.unmodifiableList(this.results);
        this.modelScope = new LinkedList();
        this.readOnlyModelScope = Collections.unmodifiableList(this.modelScope);
        this.includeSubtypes = false;
        this.containsPattern = true;
    }

    @Override
    public ModelWorkspace getModelWorkspace() {
        return this.workspace;
    }

    @Override
    public EClass getMetaClass() {
        return null;
    }

    @Override
    public void setMetaClass(EClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public EObject getDatatype() {
        return this.datatype;
    }

    @Override
    public EObject[] getDatatypes() {
        try {
            return ModelerCore.getWorkspaceDatatypeManager().getAllDatatypes();
        }
        catch (Throwable t) {
            String msg = ModelerCore.Util.getString("MetadataSearchImpl.Error_retrieving_types_from_DatatypeManager", new Object[0]);
            ModelerCore.Util.log(4, t, msg);
            return EMPTY_EOBJECT_ARRAY;
        }
    }

    @Override
    public List getModelScope() {
        return this.readOnlyModelScope;
    }

    @Override
    public String getFeatureCriteria() {
        return this.textPattern;
    }

    @Override
    public String getRuntimeType() {
        return this.runtimeType;
    }

    @Override
    public String[] getRuntimeTypes() {
        return RUNTIME_TYPE_NAMES;
    }

    @Override
    public String[] getFeaturesNames() {
        return MetadataSearch.ALLOWABLE_SEARCH_FEATURES;
    }

    @Override
    public String getSelectedFeatureName() {
        return null;
    }

    @Override
    public boolean isIncludeSubtypes() {
        return this.includeSubtypes;
    }

    @Override
    public boolean isTypedMetaClass(EClass metaClass) {
        if (metaClass == null) {
            return true;
        }
        return TYPED_META_CLASS_NAMES.contains(metaClass.getInstanceClassName());
    }

    @Override
    public void setDatatype(EObject datatype, boolean includeSubtypes) {
        this.datatype = datatype;
        this.includeSubtypes = includeSubtypes;
    }

    @Override
    public void setModelScope(List modelWorkspaceItems) {
        CoreArgCheck.isNotNull((Object)modelWorkspaceItems);
        HashSet hsSet = new HashSet();
        this.modelScope.clear();
        int numItems = modelWorkspaceItems.size();
        int i = 0;
        while (i < numItems) {
            Object item = modelWorkspaceItems.get(i);
            if (item instanceof ModelWorkspaceItem) {
                int type = ((ModelWorkspaceItem)item).getItemType();
                switch (type) {
                    case 5: {
                        hsSet.add(item);
                        break;
                    }
                    case 2: {
                        LinkedList resourceList = new LinkedList();
                        this.getChildResources((ModelWorkspaceItem)item, resourceList);
                        hsSet.addAll(resourceList);
                        break;
                    }
                    case 1: {
                        LinkedList resourceList = new LinkedList();
                        this.getChildResources((ModelWorkspaceItem)item, resourceList);
                        hsSet.addAll(resourceList);
                        break;
                    }
                    case 4: {
                        LinkedList resourceList = new LinkedList();
                        this.getChildResources((ModelWorkspaceItem)item, resourceList);
                        hsSet.addAll(resourceList);
                        break;
                    }
                }
            }
            ++i;
        }
        this.modelScope.addAll(hsSet);
    }

    @Override
    public void setFeatureCriteria(String featureName, String textPattern, boolean containsPattern) {
        this.featureName = featureName;
        this.textPattern = textPattern;
        this.containsPattern = containsPattern;
    }

    @Override
    public void setRuntimeType(String runtimeType) {
        this.runtimeType = runtimeType;
    }

    @Override
    public IStatus canExecute() {
        boolean invalidFeatureSearch;
        boolean invalidMetaclassSearch = this.metaClass == null;
        boolean invalidDatatypeSearch = this.datatype == null && this.runtimeType == null;
        boolean bl = invalidFeatureSearch = this.featureName == null || this.textPattern == null || this.textPattern.length() == 0;
        if (invalidMetaclassSearch && invalidDatatypeSearch && invalidFeatureSearch) {
            String msg = ModelerCore.Util.getString("MetadataSearchImpl.Missing_search_criteria", new Object[0]);
            return new Status(4, "org.teiid.designer.core", 0, msg, null);
        }
        if (this.featureName != null && (this.textPattern == null || this.textPattern.length() == 0)) {
            String msg = ModelerCore.Util.getString("MetadataSearchImpl.Missing_search_criteria", new Object[0]);
            return new Status(4, "org.teiid.designer.core", 0, msg, null);
        }
        String msg = ModelerCore.Util.getString("MetadataSearchImpl.Search_may_be_executed", new Object[0]);
        return new Status(0, "org.teiid.designer.core", 0, msg, null);
    }

    @Override
    public String getSearchCriteria() {
        if (this.canExecute().isOK()) {
            String prefix = I18nUtil.getPropertyPrefix(MetadataSearchImpl.class);
            StringBuilder txt = new StringBuilder();
            if (this.metaClass != null) {
                txt.append(ModelerCore.Util.getString(String.valueOf(prefix) + "classCriteria", (Object)this.metaClass.getName()));
            }
            if (this.datatype != null) {
                if (txt.length() > 0) {
                    txt.append(", ");
                }
                txt.append(ModelerCore.Util.getString(String.valueOf(prefix) + "datatypeCriteria", new Object[]{((XSDSimpleTypeDefinition)this.datatype).getName(), this.includeSubtypes}));
            }
            if (this.runtimeType != null) {
                if (txt.length() > 0) {
                    txt.append(", ");
                }
                txt.append(ModelerCore.Util.getString(String.valueOf(prefix) + "runtimeTypeCriteria", (Object)this.runtimeType));
            }
            if (this.featureName != null) {
                if (txt.length() > 0) {
                    txt.append(", ");
                }
                txt.append(ModelerCore.Util.getString(String.valueOf(prefix) + "featureCriteria", (Object)this.featureName));
            }
            if (this.textPattern != null) {
                if (txt.length() > 0) {
                    txt.append(", ");
                }
                txt.append(ModelerCore.Util.getString(String.valueOf(prefix) + "textPatternCriteria", (Object)this.textPattern));
            }
            return txt.toString();
        }
        return null;
    }

    @Override
    public IStatus execute(IProgressMonitor progressMonitor) {
        IStatus canStatus = this.canExecute();
        if (!canStatus.isOK()) {
            return canStatus;
        }
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        this.results.clear();
        IStatus status = null;
        try {
            ModelWorkspaceSearchIndexSelector scopeSelector = new ModelWorkspaceSearchIndexSelector(this.readOnlyModelScope);
            if (this.datatype != null || this.runtimeType != null) {
                EObject[] otherTypes = this.includeSubtypes ? MetadataSearchImpl.getSubtypes(this.datatype) : EMPTY_EOBJECT_ARRAY;
                status = this.doExecute((IndexSelector)scopeSelector, monitor, this.metaClass, this.datatype, otherTypes, this.runtimeType, this.results);
                if (status.isOK() && (this.metaClass != null || this.textPattern != null)) {
                    ArrayList featureSearchResults = new ArrayList();
                    status = this.doExecute((IndexSelector)scopeSelector, monitor, this.metaClass, this.featureName, this.textPattern, this.containsPattern, featureSearchResults);
                    this.intersetResultLists(featureSearchResults, this.results);
                    this.results.clear();
                    this.results.addAll(featureSearchResults);
                }
            } else if (this.metaClass != null || this.textPattern != null) {
                status = this.doExecute((IndexSelector)scopeSelector, monitor, this.metaClass, this.featureName, this.textPattern, this.containsPattern, this.results);
            }
            this.filterRecords(this.results);
        }
        catch (Throwable e) {
            String msg = e.getLocalizedMessage();
            return new Status(0, "org.teiid.designer.core", 0, msg, e);
        }
        if (status == null) {
            String msg = ModelerCore.Util.getString("MetadataSearchImpl.Search_completed_successfully", new Object[0]);
            status = new Status(0, "org.teiid.designer.core", 0, msg, null);
        }
        return status;
    }

    protected void intersetResultLists(List firstResult, List secondResult) {
        String id;
        HashSet<String> ids = new HashSet<String>(secondResult.size());
        for (SearchRecord record : secondResult) {
            id = this.getIdentifier(record);
            if (id == null) continue;
            ids.add(id);
        }
        Iterator iter = firstResult.iterator();
        while (iter.hasNext()) {
            SearchRecord record;
            record = (SearchRecord)iter.next();
            id = this.getIdentifier(record);
            if (id != null && ids.contains(id)) continue;
            iter.remove();
        }
    }

    protected IStatus doExecute(IndexSelector scopeSelector, IProgressMonitor monitor, EClass metaClass, String featureName, String textPattern, boolean containsPattern, List results) {
        FindObjectCommandImpl command = new FindObjectCommandImpl();
        command.setIndexSelector(scopeSelector);
        command.setMetaClass(metaClass);
        command.setFeatureCriteria(featureName, textPattern, containsPattern);
        if (!command.canExecute()) {
            return null;
        }
        IStatus status = command.execute();
        Collection recordInfo = command.getRecordInfo();
        results.addAll(recordInfo);
        return status;
    }

    protected IStatus doExecute(IndexSelector scopeSelector, IProgressMonitor monitor, EClass metaClass, EObject datatype, EObject[] subtypes, String runtimeType, List results) {
        FindTypedObjectCommandImpl command = new FindTypedObjectCommandImpl();
        command.setIndexSelector(scopeSelector);
        command.setMetaClass(metaClass);
        command.setDatatype(datatype);
        command.setSubTypes(subtypes);
        command.setRuntimeType(runtimeType);
        if (!command.canExecute()) {
            return null;
        }
        IStatus status = command.execute();
        Collection recordInfo = command.getRecordInfo();
        results.addAll(recordInfo);
        return status;
    }

    protected List getPaths(List modelWorkspaceItems) {
        LinkedList<IPath> paths = new LinkedList<IPath>();
        for (ModelWorkspaceItem item : modelWorkspaceItems) {
            IPath path = item.getPath();
            paths.add(path);
        }
        if (paths.isEmpty()) {
            return paths;
        }
        IPathComparator comparator = new IPathComparator();
        Collections.sort(paths, comparator);
        LinkedList<IPath> validPaths = new LinkedList<IPath>();
        Object next = (IPath)paths.removeFirst();
        while (next != null) {
            boolean skip = false;
            ListIterator existingPathIter = validPaths.listIterator(validPaths.size());
            while (existingPathIter.hasPrevious()) {
                IPath existingPath = (IPath)existingPathIter.previous();
                if (!existingPath.isPrefixOf(next)) continue;
                skip = true;
                break;
            }
            if (!skip) {
                validPaths.add((IPath)next);
            }
            next = paths.size() == 0 ? null : (IPath)paths.removeFirst();
        }
        return validPaths;
    }

    public List getResults() {
        return this.readOnlyResults;
    }

    private String getIdentifier(SearchRecord record) {
        if (record != null) {
            String id = record.getUUID();
            if (id != null) {
                return id;
            }
            if (record instanceof ResourceObjectRecord) {
                id = ((ResourceObjectRecord)record).getObjectURI();
                return id;
            }
            if (record instanceof TypedObjectRecord) {
                id = ((TypedObjectRecord)record).getObjectURI();
                return id;
            }
            if (record instanceof AnnotatedObjectRecord) {
                id = ((AnnotatedObjectRecord)record).getObjectURI();
                return id;
            }
        }
        return null;
    }

    private static EObject[] getSubtypes(EObject startingDatatype) {
        EObject[] otherTypes = EMPTY_EOBJECT_ARRAY;
        if (startingDatatype != null) {
            HashSet tmp = new HashSet();
            MetadataSearchImpl.addSubtypesToCollection(startingDatatype, tmp);
            otherTypes = tmp.toArray(new EObject[tmp.size()]);
        }
        return otherTypes;
    }

    private static void addSubtypesToCollection(EObject datatype, Collection subTypes) {
        DatatypeManager mgr = ModelerCore.getWorkspaceDatatypeManager();
        if (mgr.isSimpleDatatype(datatype)) {
            try {
                EObject[] eObjects = mgr.getSubtypes(datatype);
                int i = 0;
                while (i < eObjects.length) {
                    EObject eObject = eObjects[i];
                    if (eObject != null) {
                        subTypes.add(eObject);
                        MetadataSearchImpl.addSubtypesToCollection(eObject, subTypes);
                    }
                    ++i;
                }
            }
            catch (ModelerCoreException err) {
                ModelerCore.Util.log(4, (Throwable)err, err.getMessage());
            }
        }
    }

    private static String[] getRuntimeTypeNames() {
        Collection runtimeTypeNames = DatatypeConstants.getRuntimeTypeNames();
        return new ArrayList(runtimeTypeNames).toArray(new String[runtimeTypeNames.size()]);
    }

    private List getChildResources(ModelWorkspaceItem modelWorkspaceItem, List resourceList) {
        try {
            ModelWorkspaceItem[] childItems = modelWorkspaceItem.getChildren();
            int type = 0;
            int i = 0;
            while (i < childItems.length) {
                ModelWorkspaceItem item = childItems[i];
                type = item.getItemType();
                switch (type) {
                    case 5: {
                        resourceList.add(item);
                        break;
                    }
                    case 2: {
                        this.getChildResources(item, resourceList);
                        break;
                    }
                    case 4: {
                        this.getChildResources(item, resourceList);
                        break;
                    }
                }
                ++i;
            }
        }
        catch (ModelWorkspaceException e) {
            e.printStackTrace();
        }
        return resourceList;
    }

    private void filterRecords(List records) {
        Iterator it = records.iterator();
        while (it.hasNext()) {
            String metaclassURI;
            Object o = it.next();
            if (!(o instanceof ResourceObjectRecord) || !this.isMetaclassURIExcluded(metaclassURI = ((ResourceObjectRecord)o).getMetaclassURI())) continue;
            it.remove();
        }
    }

    private boolean isMetaclassURIExcluded(String metaclassURI) {
        boolean success = false;
        if (metaclassURI != null && metaclassURI.length() > 0) {
            block0: for (String excludedMetaclassURI : EXCLUDED_OBJECT_NS_URIS.keySet()) {
                if (!metaclassURI.startsWith(excludedMetaclassURI)) continue;
                success = true;
                String[] includedMetaObjects = (String[])EXCLUDED_OBJECT_NS_URIS.get(excludedMetaclassURI);
                if (includedMetaObjects == null || includedMetaObjects.length <= 0) continue;
                int i = 0;
                while (i < includedMetaObjects.length) {
                    String metaObjectName = includedMetaObjects[i];
                    if (metaclassURI.equals(metaObjectName)) {
                        success = false;
                        continue block0;
                    }
                    ++i;
                }
            }
        }
        return success;
    }
}

