/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.resource;

import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.ReflectionHelper;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.EResourceImpl;
import org.teiid.designer.core.resource.EResourceSetImpl;
import org.teiid.designer.core.util.DateUtil;
import org.teiid.designer.metamodels.core.CorePackage;
import org.teiid.designer.metamodels.core.ModelImport;
import org.xml.sax.Attributes;

public class EResourceXmiHandler
extends SAXXMIHandler {
    private static final DateFormat[] DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSSZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm"), new SimpleDateFormat("yyyy-MM-dd")};
    private final IDGenerator idGenerator;
    private final EResourceImpl eResource;
    private final Collection roots;
    private final Collection proxyResourceURIs;
    private final Collection modelImportsToConvert;
    private boolean isXsdResource;

    public EResourceXmiHandler(XMIResource xmiResource, XMLHelper helper, Map options) {
        super((XMLResource)xmiResource, helper, options);
        CoreArgCheck.isNotNull((Object)xmiResource);
        CoreArgCheck.isInstanceOf(EResourceImpl.class, (Object)xmiResource);
        this.eResource = (EResourceImpl)xmiResource;
        this.idGenerator = IDGenerator.getInstance();
        this.roots = new ArrayList();
        this.proxyResourceURIs = new HashSet();
        this.modelImportsToConvert = new HashSet();
        this.isXsdResource = false;
    }

    public void startElement(String uri, String localName, String name) {
        super.startElement(uri, localName, name);
    }

    protected void createTopObject(String prefix, String name) {
        if (this.isXsdPrefix(prefix)) {
            this.isXsdResource = true;
        }
        super.createTopObject(prefix, name);
    }

    protected void processTopObject(EObject object) {
        super.processObject(object);
        this.roots.add(object);
    }

    protected void handleObjectAttribs(EObject obj) {
        if (this.attribs != null) {
            InternalEObject internalEObject = (InternalEObject)obj;
            int i = 0;
            int size = this.attribs.getLength();
            while (i < size) {
                String qName = this.attribs.getQName(i);
                if (qName.equals("xmi:id")) {
                    this.xmlResource.setID((EObject)internalEObject, this.attribs.getValue(i));
                } else if (qName.equals("xmi:uuid")) {
                    ObjectID uuid = this.getObjectIDFromString(this.attribs.getValue(i));
                    CoreArgCheck.isNotNull((Object)uuid);
                    uuid = this.patch_defect14449(obj, uuid, i);
                    ModelerCore.setObjectId(obj, uuid);
                    this.eResource.addToEObjectCache(obj, false);
                } else if (qName.equals("href")) {
                    String value = this.attribs.getValue(i);
                    if (value.startsWith("#")) {
                        value = String.valueOf(this.resourceURI.toString()) + value;
                    }
                    this.handleProxy(internalEObject, value);
                } else if (!qName.startsWith("xmlns") && !this.notFeatures.contains(qName)) {
                    EStructuralFeature feature = obj.eClass().getEStructuralFeature(qName);
                    if (feature != null && feature.isChangeable()) {
                        this.setAttribValue(obj, qName, this.attribs.getValue(i));
                    }
                    if (obj instanceof EPackage && EcorePackage.eINSTANCE.getEPackage_NsURI().equals(feature)) {
                        EPackage.Registry.INSTANCE.put((Object)this.attribs.getValue(i), (Object)obj);
                    }
                }
                ++i;
            }
            this.patchA_modelImport(obj, this.attribs);
        }
    }

    protected void handleProxy(InternalEObject proxy, String uriLiteral) {
        EResourceSetImpl rs;
        super.handleProxy(proxy, uriLiteral);
        this.proxyResourceURIs.add(proxy.eProxyURI().trimFragment());
        URI physicalUri = null;
        if (this.eResource.getResourceSet() instanceof EResourceSetImpl && (rs = (EResourceSetImpl)this.eResource.getResourceSet()).getEObjectHrefConverter() != null) {
            physicalUri = rs.getEObjectHrefConverter().getPhysicalURI(proxy.eProxyURI());
        }
        if (physicalUri != null) {
            proxy.eSetProxyURI(physicalUri);
        }
    }

    protected void setFeatureValue(EObject object, EStructuralFeature feature, Object value, int position) {
        if (this.isXsdResource || this.isXsdPrefix(object.eClass().getEPackage().getNsPrefix())) {
            this.setValue(object, feature, value, position);
            return;
        }
        if (feature instanceof EAttribute && value instanceof String && Date.class.equals((Object)((EAttribute)feature).getEAttributeType().getInstanceClass())) {
            value = this.convertDateFormat((String)value);
        }
        super.setFeatureValue(object, feature, value, position);
    }

    protected EObject createObjectFromFactory(EFactory factory, String typeName) {
        EObject newObject = null;
        if (factory != null) {
            newObject = this.findEProxy();
            if (newObject == null) {
                newObject = this.helper.createObject(factory, this.helper.getType(factory, typeName));
            }
            if (newObject != null) {
                if (this.disableNotify) {
                    newObject.eSetDeliver(false);
                }
                this.handleObjectAttribs(newObject);
                newObject = this.patch_defect12764(newObject, this.attribs);
            }
        }
        return newObject;
    }

    public void endDocument() {
        if (this.isXsdResource) {
            EList topObjects = this.xmlResource.getContents();
            Iterator iter = topObjects.iterator();
            while (iter.hasNext()) {
                this.updateSchema((EObject)iter.next());
            }
        }
        this.eResource.getContents().addAll(this.roots);
        this.patchB_modelImport();
        super.endDocument();
    }

    protected EObject findEProxy() {
        int i = 0;
        int size = this.attribs.getLength();
        while (i < size) {
            String qName = this.attribs.getQName(i);
            if (qName.equals("xmi:uuid")) {
                ObjectID uuid = this.getObjectIDFromString(this.attribs.getValue(i));
                CoreArgCheck.isNotNull((Object)uuid);
                EObject eProxy = this.eResource.findInEProxyCache(uuid);
                if (eProxy != null) {
                    this.eResource.removeFromEProxyCache(uuid);
                    ((InternalEObject)eProxy).eSetProxyURI(null);
                }
                return eProxy;
            }
            ++i;
        }
        return null;
    }

    protected ObjectID getObjectIDFromString(String uuidString) {
        if (uuidString == null || uuidString.length() == 0) {
            return null;
        }
        try {
            return IDGenerator.getInstance().stringToObject(uuidString);
        }
        catch (InvalidIDException invalidIDException) {
            return null;
        }
    }

    protected EObject patch_defect12764(EObject obj, Attributes attribs) {
        if (attribs != null) {
            int i = 0;
            int size = attribs.getLength();
            while (i < size) {
                URI uri;
                String qName = attribs.getQName(i);
                String value = attribs.getValue(i);
                if (qName.equals("href") && "http://www.eclipse.org/emf/2002/Ecore".equals((uri = URI.createURI((String)value)).trimFragment().toString())) {
                    EcorePackageImpl.init();
                }
                ++i;
            }
        }
        return obj;
    }

    protected ObjectID patch_defect14449(EObject obj, ObjectID objUuid, int attribsIndex) {
        CoreArgCheck.isTrue((attribsIndex >= 0 && attribsIndex < this.attribs.getLength() ? 1 : 0) != 0, (String)("Attributes Index " + attribsIndex + " out of range"));
        CoreArgCheck.isTrue((boolean)this.attribs.getQName(attribsIndex).equals("xmi:uuid"), (String)("QName " + this.attribs.getQName(attribsIndex) + " does not match " + "xmi:uuid"));
        if (obj instanceof ModelImport) {
            ModelImport modelImport = (ModelImport)obj;
            String uuidString = this.attribs.getValue(attribsIndex);
            String uuidOfRefedModel = modelImport.getUuid();
            if (uuidOfRefedModel == null) {
                String uuidFeatureName = CorePackage.eINSTANCE.getModelImport_Uuid().getName();
                int k = attribsIndex + 1;
                while (k < this.attribs.getLength()) {
                    String qName = this.attribs.getQName(k);
                    if (qName.equals(uuidFeatureName)) {
                        uuidOfRefedModel = this.attribs.getValue(k);
                    }
                    ++k;
                }
            }
            if (uuidString.equals(uuidOfRefedModel)) {
                return this.idGenerator.create();
            }
        }
        return objUuid;
    }

    protected EObject patchA_modelImport(EObject obj, Attributes attribs) {
        if (obj instanceof ModelImport && attribs != null) {
            int i = 0;
            int size = attribs.getLength();
            while (i < size) {
                String qName = attribs.getQName(i);
                String value = attribs.getValue(i);
                if (qName.equals("path")) {
                    ((ModelImport)obj).setModelLocation(value);
                    this.modelImportsToConvert.add(obj);
                }
                ++i;
            }
        }
        return obj;
    }

    protected void patchB_modelImport() {
        URI deresolvedURI;
        boolean deresolve;
        String uriString;
        String modelLocation;
        if (this.modelImportsToConvert.isEmpty()) {
            return;
        }
        URI eResourceURI = this.eResource.getURI();
        this.removeBadProxyResourceUris(this.proxyResourceURIs);
        HashSet unconvertedImports = new HashSet(this.modelImportsToConvert);
        block0: for (ModelImport modelImport : this.modelImportsToConvert) {
            modelLocation = modelImport.getModelLocation().toLowerCase();
            for (URI importURI : this.proxyResourceURIs) {
                uriString = URI.decode((String)importURI.toString()).toLowerCase();
                if (uriString.startsWith("http") && !uriString.endsWith("xmi") || !uriString.endsWith(modelLocation)) continue;
                boolean bl = deresolve = eResourceURI != null && !eResourceURI.isRelative() && eResourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(eResourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                }
                modelImport.setModelLocation(URI.decode((String)importURI.toString()));
                unconvertedImports.remove(modelImport);
                continue block0;
            }
        }
        Iterator i = unconvertedImports.iterator();
        block2: while (i.hasNext()) {
            ModelImport modelImport;
            modelImport = (ModelImport)i.next();
            modelLocation = this.removeProjectNameFromLocation(modelImport.getModelLocation()).toLowerCase();
            for (URI importURI : this.proxyResourceURIs) {
                uriString = URI.decode((String)importURI.toString()).toLowerCase();
                if (uriString.startsWith("http") && !uriString.endsWith("xmi") || !uriString.endsWith(modelLocation)) continue;
                boolean bl = deresolve = eResourceURI != null && !eResourceURI.isRelative() && eResourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(eResourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                }
                modelImport.setModelLocation(URI.decode((String)importURI.toString()));
                i.remove();
                continue block2;
            }
        }
        for (ModelImport modelImport : unconvertedImports) {
            modelImport.setModel(null);
        }
    }

    protected String removeProjectNameFromLocation(String location) {
        String newLocation = location;
        URI uri = URI.createURI((String)location);
        if (uri.segmentCount() > 1) {
            StringBuffer sb = new StringBuffer(location.length());
            String[] segments = uri.segments();
            int i = 1;
            while (i != segments.length) {
                sb.append("/");
                sb.append(segments[i]);
                ++i;
            }
            newLocation = sb.toString();
        }
        return newLocation;
    }

    protected void removeBadProxyResourceUris(Collection proxyResourceUris) {
        String uriString;
        if (proxyResourceUris == null || proxyResourceUris.isEmpty()) {
            return;
        }
        ArrayList<URI> badUris = new ArrayList<URI>(proxyResourceUris.size());
        Iterator i = proxyResourceUris.iterator();
        while (i.hasNext()) {
            URI uri = (URI)i.next();
            uriString = uri.toString();
            if (uriString.charAt(0) != '/') continue;
            badUris.add(uri);
            i.remove();
        }
        if (badUris.isEmpty()) {
            return;
        }
        for (URI uri : proxyResourceUris) {
            uriString = URI.decode((String)uri.toString()).toLowerCase();
            Iterator j = badUris.iterator();
            while (j.hasNext()) {
                URI badUri = (URI)j.next();
                String badUriString = URI.decode((String)badUri.toString()).toLowerCase();
                if (!uriString.endsWith(badUriString)) continue;
                j.remove();
            }
        }
        if (!badUris.isEmpty()) {
            proxyResourceUris.addAll(badUris);
        }
    }

    protected void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        int kind = this.helper.getFeatureKind(feature);
        switch (kind) {
            case 1: 
            case 2: {
                EClassifier eMetaObject = feature.getEType();
                EDataType eDataType = (EDataType)eMetaObject;
                EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                if (kind == 2) {
                    BasicEList list = (BasicEList)object.eGet(feature);
                    if (position == -2) {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)value, " ");
                        while (stringTokenizer.hasMoreTokens()) {
                            String token = stringTokenizer.nextToken();
                            list.addUnique(eFactory.createFromString(eDataType, token));
                        }
                        if (!list.isEmpty()) break;
                        list.clear();
                        break;
                    }
                    if (value == null) {
                        list.addUnique(null);
                        break;
                    }
                    list.addUnique(eFactory.createFromString(eDataType, (String)value));
                    break;
                }
                if (value == null) {
                    object.eSet(feature, null);
                    break;
                }
                object.eSet(feature, eFactory.createFromString(eDataType, (String)value));
                break;
            }
            case 3: 
            case 4: {
                BasicEList list = (BasicEList)object.eGet(feature);
                if (position == -1) {
                    list.addUnique(value);
                    break;
                }
                if (position == -2) {
                    list.clear();
                    break;
                }
                if (kind == 3) {
                    list.addUnique(position, value);
                    break;
                }
                list.move(position, value);
                break;
            }
            default: {
                object.eSet(feature, value);
            }
        }
    }

    protected boolean isXsdPrefix(String prefix) {
        return prefix.equalsIgnoreCase("xsd");
    }

    protected String convertDateFormat(String value) {
        Date valueAsDate = null;
        int i = 0;
        while (i < DATE_FORMATS.length) {
            try {
                valueAsDate = DATE_FORMATS[i].parse(value);
                break;
            }
            catch (ParseException parseException) {
                ++i;
            }
        }
        if (valueAsDate == null) {
            String msg = ModelerCore.Util.getString("EResourceXmiHandler.Error_parsing_date_string", (Object)value);
            ModelerCore.Util.log(4, msg);
            return value;
        }
        return DateUtil.getDateAsString(valueAsDate);
    }

    protected void updateSchema(EObject topObject) {
        Object[] args = new Object[]{};
        Class<?> xmlSchemaClass = topObject.getClass();
        ReflectionHelper helper = new ReflectionHelper(xmlSchemaClass);
        Method updateSchemaMethod = null;
        try {
            updateSchemaMethod = helper.findBestMethodOnTarget("update", args);
        }
        catch (SecurityException e) {
            String msg = ModelerCore.Util.getString("EResourceXmiHandler.Error_executing_XSD_update_method", xmlSchemaClass);
            ModelerCore.Util.log(4, (Throwable)e, msg);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (updateSchemaMethod != null) {
            try {
                updateSchemaMethod.invoke((Object)topObject, args);
            }
            catch (Throwable throwable) {
                String msg = ModelerCore.Util.getString("EResourceXmiHandler.Error_executing_XSD_update_method", (Object)updateSchemaMethod);
                ModelerCore.Util.log(4, msg);
            }
        }
    }
}

