/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.refactor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDImport;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.metamodel.aspect.ImportsAspect;
import org.teiid.designer.core.refactor.OrganizeImportHandler;
import org.teiid.designer.core.refactor.PathPair;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.search.ModelWorkspaceSearch;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;

public class OrganizeImportCommandFinderHelper {
    private Resource resource;
    private Collection<PathPair> refactoredPaths = new ArrayList<PathPair>();

    protected OrganizeImportCommandFinderHelper() {
    }

    protected void setRefactoredPaths(Collection<PathPair> pathPairs) {
        this.refactoredPaths = pathPairs != null ? pathPairs : new ArrayList<PathPair>();
    }

    protected void setResource(Resource resource) {
        this.resource = resource;
    }

    protected URI findModelUri(URI uri, Resource resource) {
        CoreArgCheck.isNotNull((Object)uri);
        String path = URI.decode((String)uri.toString());
        if (resource != null) {
            return this.getModelUri(resource, path);
        }
        return this.getModelUri(uri);
    }

    private URI getModelUri(Resource resource, String path) {
        block6: {
            String resourcePath = WorkspaceResourceFinderUtil.getWorkspaceUri(resource);
            if (resourcePath != null) {
                path = resourcePath;
            } else if (resource instanceof EmfResource) {
                try {
                    ObjectID objectID = ((EmfResource)resource).getUuid();
                    resourcePath = this.findResourcePathByUUID(objectID);
                    if (resourcePath != null) {
                        path = resourcePath;
                        break block6;
                    }
                    return null;
                }
                catch (Exception e) {
                    ModelerCore.Util.log((Throwable)e);
                }
            }
        }
        return URI.createURI((String)path);
    }

    protected String findResourcePathByUUID(ObjectID objectID) throws CoreException {
        String path = null;
        if (objectID != null) {
            Resource systemModels = ModelerCore.getModelContainer().getResourceFinder().findByUUID(objectID, false);
            path = WorkspaceResourceFinderUtil.getWorkspaceUri(systemModels);
        }
        return path;
    }

    private URI getModelUri(URI uri) {
        String path = null;
        IResource iResource = WorkspaceResourceFinderUtil.findIResource(uri);
        if (iResource != null) {
            path = iResource.getFullPath().toString();
        } else {
            iResource = this.findResourceInProjectByName(uri.lastSegment());
            if (iResource == null) {
                return null;
            }
            path = iResource.getFullPath().toString();
        }
        return URI.createURI((String)path);
    }

    protected IResource findResourceInProjectByName(String name) {
        if (name == null) {
            return null;
        }
        IResource iResource = null;
        Collection<IFile> iResources = WorkspaceResourceFinderUtil.findIResourceByName(name);
        if (iResources.size() == 0) {
            return null;
        }
        if (iResources.size() == 1) {
            iResource = (IResource)iResources.iterator().next();
        } else {
            IResource iRes = WorkspaceResourceFinderUtil.findIResource(this.resource.getURI());
            IProject project = iRes.getProject();
            for (IFile fileResource : iResources) {
                if (!fileResource.getProject().equals((Object)project)) continue;
                iResource = fileResource;
                break;
            }
            if (iResource == null) {
                iResource = (IResource)iResources.iterator().next();
            }
        }
        return iResource;
    }

    protected Resource findResourceWithObject(Collection refs, List problems, OrganizeImportHandler handler) {
        ModelWorkspaceSearch search = new ModelWorkspaceSearch();
        ModelWorkspaceManager workspaceManager = ModelWorkspaceManager.getModelWorkspaceManager();
        LinkedList<ModelResource> modelReferences = new LinkedList<ModelResource>();
        HashSet<String> searchedFragments = new HashSet<String>();
        HashSet<ObjectID> searchedIDs = new HashSet<ObjectID>();
        if (refs.size() != 0) {
            for (EObject reference : refs) {
                IPath[] modelPaths;
                InternalEObject internalEObject = (InternalEObject)reference;
                URI proxyUri = internalEObject.eProxyURI();
                String fragment = proxyUri.fragment();
                if (fragment == null) continue;
                ObjectID id = null;
                try {
                    id = IDGenerator.getInstance().stringToObject(fragment);
                }
                catch (InvalidIDException invalidIDException) {}
                if (id == null && searchedFragments.contains(fragment) || searchedIDs.contains(id)) continue;
                IPath[] iPathArray = modelPaths = id == null ? search.getResourcesContainingObjectId(fragment) : search.getResourcesContainingObjectId(id);
                if (modelPaths != null && modelPaths.length > 0) {
                    int i = 0;
                    while (i < modelPaths.length) {
                        IPath resourcePath = modelPaths[i];
                        ModelResource mResource = (ModelResource)workspaceManager.findModelWorkspaceItem(resourcePath, 1);
                        if (mResource != null && !modelReferences.contains(mResource)) {
                            modelReferences.add(mResource);
                        }
                        ++i;
                    }
                }
                if (id != null) {
                    searchedIDs.add(id);
                    continue;
                }
                searchedFragments.add(fragment);
            }
        }
        Resource result = null;
        if (!modelReferences.isEmpty()) {
            ModelResource mResource = null;
            if (modelReferences.size() == 1) {
                mResource = (ModelResource)modelReferences.get(0);
            } else {
                OrganizeImportHandler theHandler = handler;
                if (theHandler != null) {
                    Object choice = handler.choose(modelReferences);
                    if (choice instanceof ModelResource) {
                        mResource = (ModelResource)choice;
                    } else if (choice != null) {
                        Object[] params = new Object[]{choice.getClass().getName(), ModelResource.class.getName()};
                        String msg = ModelerCore.Util.getString("OrganizeImportCommand.Unexpected_choice", params);
                        throw new AssertionError((Object)msg);
                    }
                }
            }
            if (mResource != null) {
                try {
                    result = mResource.getEmfResource();
                }
                catch (ModelWorkspaceException modelWorkspaceException) {
                    Object[] params = new Object[]{mResource};
                    String msg = ModelerCore.Util.getString("OrganizeImportCommand.error_getting_resource", params);
                    problems.add(new Status(4, "org.teiid.designer.core", 1010, msg, null));
                }
            }
        }
        return result;
    }

    protected Resource findRefactoredResource(Resource eResource, URI externalResourceURI, IProgressMonitor monitor, List problems) {
        Container cntr;
        ResourceSet eResourceSet = eResource.getResourceSet();
        Resource externalResource = eResourceSet.getResource(externalResourceURI, false);
        if (externalResource == null && (cntr = ModelerCore.getContainer(eResource)) != null) {
            Resource[] eResources = cntr.getResourceFinder().findByName(externalResourceURI.lastSegment(), false, true);
            if (eResources.length == 0) {
                return null;
            }
            if (eResources.length == 1) {
                return eResources[0];
            }
            ArrayList<Resource> matches = new ArrayList<Resource>(eResources.length);
            String parentUriString = eResource.getURI().trimSegments(1).toString();
            int i = 0;
            while (i != eResources.length) {
                Resource r = eResources[i];
                String uriString = r.getURI().trimSegments(1).toString();
                if (parentUriString.startsWith(uriString) || uriString.startsWith(parentUriString)) {
                    matches.add(r);
                }
                ++i;
            }
            externalResource = matches.size() == 0 ? eResources[0] : (matches.size() == 1 ? (Resource)matches.get(0) : eResources[0]);
        }
        return externalResource;
    }

    protected IPath findFromRefactoredPaths(String uriPath) {
        if (this.refactoredPaths != null) {
            for (PathPair pathPair : this.refactoredPaths) {
                String oldPath = pathPair.getSourcePath();
                if (!uriPath.endsWith(oldPath)) continue;
                return new Path(oldPath);
            }
        }
        return new Path(uriPath);
    }

    protected IPath findPath(EObject eobject, ImportsAspect importsAspect) {
        IPath importPath = importsAspect.getModelPath(eobject);
        if (importPath == null) {
            return this.createPath(eobject);
        }
        return importPath;
    }

    private IPath createPath(EObject eobject) {
        if (eobject instanceof XSDImport) {
            String schemaLocation = ((XSDImport)eobject).getSchemaLocation();
            return this.getNewPathInfo(schemaLocation);
        }
        return null;
    }

    private IPath getNewPathInfo(String schemaLocation) {
        if (schemaLocation == null) {
            return null;
        }
        Path currentPath = new Path(schemaLocation);
        for (PathPair pathPair : this.refactoredPaths) {
            Path oldPathRef = new Path(pathPair.getSourcePath());
            if (!oldPathRef.lastSegment().equals(currentPath.lastSegment())) continue;
            return new Path(pathPair.getTargetPath());
        }
        return null;
    }
}

