/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.metamodel.MetamodelRegistry;
import org.teiid.designer.core.reader.StreamReader;
import org.teiid.designer.core.util.DateUtil;

public class XmiStreamReader
implements StreamReader {
    @Override
    public Collection read(InputStream inputStream, Map options) throws IOException {
        if (inputStream == null) {
            String msg = ModelerCore.Util.getString("XmiStreamReader.The_InputStream_reference_may_not_be_null_1", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        if (options == null) {
            String msg = ModelerCore.Util.getString("XmiStreamReader.The_Map_reference_may_not_be_null_2", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        ArrayList result = Collections.EMPTY_LIST;
        try {
            String tmpCntrName = String.valueOf(DateUtil.getCurrentDateAsString()) + "TempContainer";
            Container container = ModelerCore.createContainer(tmpCntrName, ModelerCore.RegistryOption.NO_REGISTER);
            Resource temp = container.createResource(URI.createURI((String)"XmiStreamReader.xmi"));
            temp.load(inputStream, options);
            result = new ArrayList(temp.getContents());
            for (EObject eObject : result) {
                EcoreUtil.remove((EObject)eObject);
            }
            container.getResources().remove((Object)temp);
            temp = null;
            container = null;
        }
        catch (Exception e) {
            ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("XmiStreamReader.Error_loading_resource_into_a_temporary_container_1", new Object[0]));
            throw new IOException(e.getMessage());
        }
        return result;
    }

    @Override
    public Collection read(InputStream inputStream, Map options, Resource resource) {
        throw new UnsupportedOperationException(ModelerCore.Util.getString("XmiStreamReader.Can_not_perform_operation_6", new Object[0]));
    }

    @Override
    public Collection read(InputStream inputStream, Map options, EObject parent) {
        throw new UnsupportedOperationException(ModelerCore.Util.getString("XmiStreamReader.Can_not_perform_operation_7", new Object[0]));
    }

    class DelegatedResourceSet
    extends ResourceSetImpl {
        private MetamodelRegistry registry;

        public DelegatedResourceSet(MetamodelRegistry registry) {
            if (registry == null) {
                String msg = ModelerCore.Util.getString("XmiStreamReader.The_Map_reference_may_not_be_null_2", new Object[0]);
                throw new IllegalArgumentException(msg);
            }
            this.registry = registry;
        }

        protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
            if (this.registry != null && this.registry.containsURI(uri)) {
                Resource resource = this.registry.getResource(uri);
                return resource;
            }
            return super.delegatedGetResource(uri, loadOnDemand);
        }
    }
}

