/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.validation.rules.StringNameRule;
import org.teiid.designer.metamodels.core.extension.XEnumLiteral;

public class XEnumLiteralValueRule
extends StringNameRule {
    public XEnumLiteralValueRule() {
        super(2);
    }

    @Override
    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        CoreArgCheck.isInstanceOf(XEnumLiteral.class, (Object)eObject);
        if (eStructuralFeature.getFeatureID() != this.getFeatureID()) {
            return;
        }
        XEnumLiteral xenum = (XEnumLiteral)eObject;
        String name = xenum.getName();
        if (name == null || name.trim().length() == 0) {
            ValidationResultImpl result = new ValidationResultImpl(xenum);
            String msg = ModelerCore.Util.getString("XEnumNameRule.MissingName", new Object[0]);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem(problem);
            context.addResult(result);
            return;
        }
        List siblings = this.getSiblingsForUniquenessCheck(eObject);
        for (XEnumLiteral sibling : siblings) {
            if (sibling.getName().equalsIgnoreCase(name) || sibling.getValue() != xenum.getValue()) continue;
            String msg = ModelerCore.Util.getString("XEnumLiteralValueRule.DuplicateValue", new Object[0]);
            ValidationResultImpl result = new ValidationResultImpl(xenum);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem(problem);
            context.addResult(result);
            return;
        }
    }

    @Override
    protected List getSiblingsForUniquenessCheck(EObject eObject) {
        LinkedList siblings = new LinkedList(super.getSiblingsForUniquenessCheck(eObject));
        Iterator iter = siblings.iterator();
        while (iter.hasNext()) {
            EObject sibling = (EObject)iter.next();
            if (sibling instanceof XEnumLiteral) continue;
            iter.remove();
        }
        return siblings;
    }
}

