/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.metamodel.MetamodelAspectManager;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.metamodel.MetamodelDescriptorImpl;
import org.teiid.designer.core.metamodel.MetamodelRegistry;
import org.teiid.designer.core.metamodel.MetamodelRootClass;
import org.teiid.designer.core.metamodel.MetamodelRootClassDescriptor;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.core.extension.XClass;

public class MetamodelRegistryImpl
implements MetamodelRegistry {
    private static final Comparator METAMODEL_ROOT_CLASS_NAME_COMPARATOR = new MetamodelRootClassNameComparator();
    private static final EClass[] EMPTY_ECLASS_ARRAY = new EClass[0];
    private static final MetamodelRootClass[] EMPTY_METAMODEL_ROOT_CLASS_ARRAY = new MetamodelRootClass[0];
    private final Map descriptorByUriMap = new HashMap();
    private final Map uriByStringMap = new HashMap();
    private final Set uris = new HashSet();
    private MetamodelAspectManager aspectMgr;

    @Override
    public boolean containsURI(String nsUriString) {
        if (CoreStringUtil.isEmpty((String)nsUriString)) {
            return false;
        }
        URI nsUri = this.getURI(nsUriString);
        if (nsUri == null) {
            return false;
        }
        return this.containsURI(nsUri);
    }

    @Override
    public boolean containsURI(URI nsUri) {
        if (nsUri == null) {
            return false;
        }
        if (this.uris.contains(nsUri)) {
            return true;
        }
        return this.descriptorByUriMap.keySet().contains(nsUri);
    }

    @Override
    public MetamodelDescriptor getMetamodelDescriptor(String nsUriString) {
        CoreArgCheck.isNotNull((Object)nsUriString);
        CoreArgCheck.isNotZeroLength((String)nsUriString);
        URI nsUri = this.getURI(nsUriString);
        if (nsUri == null) {
            return null;
        }
        return this.getMetamodelDescriptor(nsUri);
    }

    @Override
    public MetamodelDescriptor getMetamodelDescriptor(URI nsUri) {
        CoreArgCheck.isNotNull((Object)nsUri);
        return (MetamodelDescriptor)this.descriptorByUriMap.get(nsUri);
    }

    @Override
    public MetamodelDescriptor[] getMetamodelDescriptors() {
        HashSet values = new HashSet(this.descriptorByUriMap.values());
        return values.toArray(new MetamodelDescriptor[values.size()]);
    }

    @Override
    public String getMetamodelName(String nsUriString) {
        MetamodelDescriptor descriptor = this.getMetamodelDescriptor(nsUriString);
        if (descriptor == null) {
            return null;
        }
        String name = descriptor.getDisplayName();
        if (CoreStringUtil.isEmpty((String)name)) {
            return descriptor.getName();
        }
        return name;
    }

    @Override
    public String getModelTypeName(String modelType) {
        CoreArgCheck.isNotEmpty((String)modelType, (String)"modelType is empty");
        MetamodelDescriptor[] metamodelDescriptorArray = this.getMetamodelDescriptors();
        int n = metamodelDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetamodelDescriptor descriptor = metamodelDescriptorArray[n2];
            ModelType[] modelTypeArray = descriptor.getAllowableModelTypes();
            int n3 = modelTypeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ModelType allowedModelType = modelTypeArray[n4];
                if (allowedModelType.getLiteral().equals(modelType)) {
                    return allowedModelType.getDisplayName();
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Set<String> getModelTypes(String nsUriString) {
        MetamodelDescriptor descriptor = this.getMetamodelDescriptor(nsUriString);
        if (descriptor == null) {
            return Collections.emptySet();
        }
        ModelType[] modelTypes = descriptor.getAllowableModelTypes();
        if (modelTypes.length != 0) {
            HashSet<String> result = new HashSet<String>(modelTypes.length);
            ModelType[] modelTypeArray = modelTypes;
            int n = modelTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ModelType modelType = modelTypeArray[n2];
                result.add(modelType.getLiteral());
                ++n2;
            }
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public EPackage getEPackage(URI nsUri) {
        CoreArgCheck.isNotNull((Object)nsUri);
        MetamodelDescriptor descriptor = (MetamodelDescriptor)this.descriptorByUriMap.get(nsUri);
        if (descriptor != null) {
            return descriptor.getEPackage();
        }
        return null;
    }

    @Override
    public Resource getResource(URI nsUri) {
        EPackage ePkg;
        CoreArgCheck.isNotNull((Object)nsUri);
        MetamodelDescriptor descriptor = (MetamodelDescriptor)this.descriptorByUriMap.get(nsUri);
        if (descriptor != null && (ePkg = descriptor.getEPackage()) != null) {
            return ePkg.eResource();
        }
        return null;
    }

    @Override
    public URI getURI(String nsUriString) {
        CoreArgCheck.isNotNull((Object)nsUriString);
        CoreArgCheck.isNotZeroLength((String)nsUriString);
        return (URI)this.uriByStringMap.get(nsUriString);
    }

    @Override
    public Collection getURIs() {
        return this.uris;
    }

    @Override
    public URI register(MetamodelDescriptor descriptor) {
        CoreArgCheck.isNotNull((Object)descriptor);
        this.addDescriptorMappings(descriptor);
        return this.getURI(descriptor.getNamespaceURI());
    }

    @Override
    public void unregister(URI nsUri) {
        CoreArgCheck.isNotNull((Object)nsUri);
        MetamodelDescriptor descriptor = this.getMetamodelDescriptor(nsUri);
        if (descriptor != null) {
            this.removeDescriptorMappings(descriptor);
        }
    }

    @Override
    public void dispose() {
        MetamodelDescriptor[] descriptors = this.getMetamodelDescriptors();
        int i = 0;
        while (i != descriptors.length) {
            MetamodelDescriptor d = descriptors[i];
            if (d instanceof MetamodelDescriptorImpl) {
                ((MetamodelDescriptorImpl)d).dispose();
            }
            ++i;
        }
        this.descriptorByUriMap.clear();
        this.uriByStringMap.clear();
        this.uris.clear();
    }

    @Override
    public AdapterFactory getAdapterFactory() {
        if (this.aspectMgr == null) {
            this.aspectMgr = new MetamodelAspectManager(this);
        }
        return this.aspectMgr.getAdapterFactory();
    }

    @Override
    public MetamodelAspect getMetamodelAspect(EObject eObject, Class type) {
        CoreArgCheck.isNotNull((Object)eObject);
        CoreArgCheck.isNotNull((Object)type);
        return this.getMetamodelAspect(this.getEClass(eObject), type);
    }

    @Override
    public MetamodelAspect getMetamodelAspect(EClass eClass, Class type) {
        CoreArgCheck.isNotNull((Object)eClass);
        CoreArgCheck.isNotNull((Object)type);
        if (this.aspectMgr == null) {
            this.aspectMgr = new MetamodelAspectManager(this);
        }
        return this.aspectMgr.getMetamodelAspect(eClass, type);
    }

    @Override
    public String getMetaClassLabel(EClass eClass) {
        CoreArgCheck.isNotNull((Object)eClass);
        AdapterFactory factory = this.getAdapterFactory();
        EFactory objectFactory = eClass.getEPackage().getEFactoryInstance();
        EObject instance = objectFactory.create(eClass);
        IItemLabelProvider provider = (IItemLabelProvider)factory.adapt((Notifier)instance, IItemLabelProvider.class);
        if (provider != null && provider instanceof ItemProviderAdapter) {
            ItemProviderAdapter adapter = (ItemProviderAdapter)provider;
            try {
                String name = adapter.getString("_UI_" + eClass.getName() + "_type");
                return name;
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return eClass.getName();
    }

    @Override
    public String getMetaClassURI(EClass eClass) {
        CoreArgCheck.isNotNull((Object)eClass);
        return EcoreUtil.getURI((EObject)eClass).toString();
    }

    @Override
    public EClass getMetaClass(String metaClassUriString) {
        EPackage ePackage;
        CoreArgCheck.isNotNull((Object)metaClassUriString);
        CoreArgCheck.isNotZeroLength((String)metaClassUriString);
        URI metaClassUri = URI.createURI((String)metaClassUriString);
        URI nsUri = metaClassUri.trimFragment();
        if (nsUri != null && (ePackage = this.getEPackage(nsUri)) != null) {
            return (EClass)ePackage.eResource().getEObject(metaClassUri.fragment());
        }
        return null;
    }

    @Override
    public EClass[] getRootMetaClasses(URI nsUri) {
        CoreArgCheck.isNotNull((Object)nsUri);
        MetamodelDescriptor d = this.getMetamodelDescriptor(nsUri);
        if (d != null) {
            List metamodelRootClasses = this.getRootMetaClasses(d);
            ArrayList<EClass> result = new ArrayList<EClass>(metamodelRootClasses.size());
            for (MetamodelRootClass mrc : metamodelRootClasses) {
                result.add(mrc.getEClass());
            }
            return result.toArray(new EClass[result.size()]);
        }
        return EMPTY_ECLASS_ARRAY;
    }

    @Override
    public MetamodelRootClass[] getMetamodelRootClasses(URI nsUri) {
        CoreArgCheck.isNotNull((Object)nsUri);
        MetamodelDescriptor d = this.getMetamodelDescriptor(nsUri);
        if (d != null) {
            List result = this.getRootMetaClasses(d);
            return result.toArray(new MetamodelRootClass[result.size()]);
        }
        return EMPTY_METAMODEL_ROOT_CLASS_ARRAY;
    }

    protected URI createUri(String uriString) {
        CoreArgCheck.isNotNull((Object)uriString);
        CoreArgCheck.isNotZeroLength((String)uriString);
        if (this.uriByStringMap.containsKey(uriString)) {
            return (URI)this.uriByStringMap.get(uriString);
        }
        URI uri = null;
        uri = new File(uriString).exists() ? URI.createFileURI((String)uriString) : URI.createURI((String)uriString);
        return uri;
    }

    protected EClass getEClass(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        if (!(eObject instanceof XClass) && eObject instanceof EClass) {
            return (EClass)eObject;
        }
        return eObject.eClass();
    }

    protected void addDescriptorMappings(MetamodelDescriptor descriptor) {
        CoreArgCheck.isNotNull((Object)descriptor);
        String nsUriString = descriptor.getNamespaceURI();
        URI nsUri = this.createUri(nsUriString);
        this.uriByStringMap.put(nsUriString, nsUri);
        this.descriptorByUriMap.put(nsUri, descriptor);
        this.uris.add(nsUri);
        String[] alternateUris = descriptor.getAlternateNamespaceURIs();
        if (alternateUris != null && alternateUris.length > 0) {
            int i = 0;
            while (i != alternateUris.length) {
                nsUriString = alternateUris[i];
                nsUri = this.createUri(nsUriString);
                this.uriByStringMap.put(nsUriString, nsUri);
                this.descriptorByUriMap.put(nsUri, descriptor);
                ++i;
            }
        }
    }

    protected void removeDescriptorMappings(MetamodelDescriptor descriptor) {
        CoreArgCheck.isNotNull((Object)descriptor);
        String nsUriString = descriptor.getNamespaceURI();
        URI nsUri = this.createUri(nsUriString);
        this.uris.remove(nsUri);
        this.uriByStringMap.remove(nsUriString);
        this.descriptorByUriMap.remove(nsUri);
        String[] alternateUris = descriptor.getAlternateNamespaceURIs();
        if (alternateUris != null && alternateUris.length > 0) {
            int i = 0;
            while (i != alternateUris.length) {
                nsUriString = alternateUris[i];
                nsUri = this.createUri(nsUriString);
                this.uriByStringMap.remove(nsUriString);
                this.descriptorByUriMap.remove(nsUri);
                ++i;
            }
        }
    }

    protected List getRootMetaClasses(MetamodelDescriptor descriptor) {
        CoreArgCheck.isNotNull((Object)descriptor);
        URI nsUri = this.getURI(descriptor.getNamespaceURI());
        MetamodelRootClassDescriptor[] rootClasses = descriptor.getRootClassDescriptors();
        if (rootClasses != null && rootClasses.length > 0) {
            ArrayList<EClass> allEClasses = new ArrayList<EClass>();
            EPackage ePackage = this.getEPackage(nsUri);
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || allEClasses.contains(eClass = (EClass)eClassifier) || eClass.isAbstract() || eClass.isInterface()) continue;
                allEClasses.add(eClass);
            }
            HashMap<EClass, MetamodelRootClass> result = new HashMap<EClass, MetamodelRootClass>(rootClasses.length);
            block1: for (EClass eClass : allEClasses) {
                int j = 0;
                while (j < rootClasses.length) {
                    Class<?> eClassClass = eClass.getClass();
                    Class eClassInstanceClass = eClass.getInstanceClass();
                    Class rootClass = rootClasses[j].getExtensionClass();
                    int maxOccurs = rootClasses[j].getMaxOccurs();
                    if (eClassClass.equals(rootClass) && !result.containsKey(eClass)) {
                        result.put(eClass, new MetamodelRootClass(eClass, maxOccurs));
                        continue block1;
                    }
                    if (eClassInstanceClass != null && eClassInstanceClass.equals(rootClass) && !result.containsKey(eClass)) {
                        result.put(eClass, new MetamodelRootClass(eClass, maxOccurs));
                        continue block1;
                    }
                    ++j;
                }
            }
            ArrayList listResult = new ArrayList(result.values());
            Collections.sort(listResult, METAMODEL_ROOT_CLASS_NAME_COMPARATOR);
            return listResult;
        }
        return Collections.EMPTY_LIST;
    }

    static class MetamodelRootClassNameComparator
    implements Comparator {
        MetamodelRootClassNameComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null && obj2 != null) {
                return -1;
            }
            if (obj1 != null && obj2 == null) {
                return 1;
            }
            MetamodelRootClass rootClass1 = (MetamodelRootClass)obj1;
            MetamodelRootClass rootClass2 = (MetamodelRootClass)obj2;
            EClass eClass1 = rootClass1.getEClass();
            EClass eClass2 = rootClass2.getEClass();
            String value1 = eClass1.getName();
            String value2 = eClass2.getName();
            return value1.compareToIgnoreCase(value2);
        }
    }
}

