/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.TransactionRunnable;
import org.teiid.designer.core.builder.ModelBuildUtil;
import org.teiid.designer.core.index.AbstractIndexSelector;
import org.teiid.designer.core.index.Index;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.util.Util;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;

public class ModelResourceIndexSelector
extends AbstractIndexSelector {
    private static final Index[] EMPTY_INDEX_ARRAY = new Index[0];
    private Resource resource;

    public ModelResourceIndexSelector(Resource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        this.resource = resource;
    }

    public Index[] getIndexes() {
        this.updateIndexes();
        List modelImports = this.getModelImports();
        File[] indexFiles = this.getIndexFiles(modelImports);
        return IndexUtil.getExistingIndexes(indexFiles);
    }

    public List getModelImports() {
        ModelAnnotation model = Util.getModelAnnotation(this.resource);
        if (model != null) {
            return model.getModelImports();
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getNonIndexedResources() {
        List imports = this.getModelImports();
        ArrayList<IResource> iResources = new ArrayList<IResource>(imports.size() + 1);
        for (ModelImport mdlImport : imports) {
            ModelResource importResource;
            String importedResourcePath = mdlImport.getPath();
            if (importedResourcePath == null || (importResource = ModelerCore.getModelWorkspace().findModelResource((IPath)new Path(importedResourcePath))) == null || importResource.getIndexType() == 3 || importResource.getIndexType() == 1) continue;
            iResources.add(importResource.getResource());
        }
        ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource(this.getResource());
        if (modelResource.getIndexType() != 3 && modelResource.getIndexType() != 1) {
            iResources.add(modelResource.getResource());
        }
        return iResources;
    }

    private boolean updateIndexes() {
        try {
            final Collection nonIndexedResources = this.getNonIndexedResources();
            if (nonIndexedResources != null && !nonIndexedResources.isEmpty()) {
                TransactionRunnable runnable = new TransactionRunnable(){

                    @Override
                    public Object run(UnitOfWork uow) {
                        ModelBuildUtil.createModelIndexes(null, nonIndexedResources);
                        return null;
                    }
                };
                ModelerCore.getModelEditor().executeAsTransaction(runnable, "Updating ModelIndexes", false, false, (Object)this);
                return true;
            }
        }
        catch (CoreException e) {
            ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("ModelResourceIndexSelector.0", new Object[0]));
        }
        return false;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ModelResourceIndexSelector [");
        Index[] indexes = EMPTY_INDEX_ARRAY;
        indexes = this.getIndexes();
        int i = 0;
        while (i < indexes.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(indexes[i].getIndexFile());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private File[] getIndexFiles(List modelImports) {
        CoreArgCheck.isNotNull((Object)modelImports);
        ArrayList<File> tmp = new ArrayList<File>();
        for (ModelImport modelImport : modelImports) {
            File indexFile;
            if (modelImport == null || (indexFile = this.getIndexFile(modelImport)) == null || !indexFile.exists()) continue;
            tmp.add(indexFile);
        }
        File rsrcIndexFile = new File(IndexUtil.INDEX_PATH, IndexUtil.getRuntimeIndexFileName(this.resource));
        if (rsrcIndexFile.exists()) {
            tmp.add(rsrcIndexFile);
        }
        File[] result = new File[tmp.size()];
        tmp.toArray(result);
        return result;
    }

    private File getIndexFile(ModelImport modelImport) {
        String indexFileName = null;
        try {
            indexFileName = IndexUtil.getRuntimeIndexFileName(modelImport.getPath());
        }
        catch (Exception exception) {}
        if (indexFileName != null) {
            return new File(IndexUtil.INDEX_PATH, indexFileName);
        }
        return null;
    }
}

