/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.extension;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.extension.ModelExtensionUtils;
import org.teiid.designer.core.util.ModelObjectClassNameVisitor;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.NamespaceProvider;
import org.teiid.designer.metamodels.core.Annotation;

public class EmfModelObjectExtensionAssistant
extends ModelObjectExtensionAssistant {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(EmfModelObjectExtensionAssistant.class);

    public void cleanupModelResourceMEDs(Object modelResource) throws Exception {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource is null");
        CoreArgCheck.isInstanceOf(ModelResource.class, (Object)modelResource);
        ModelResource theModelResource = (ModelResource)modelResource;
        Collection<String> supportedNamespaces = ModelExtensionUtils.getSupportedNamespaces(theModelResource);
        for (String namespacePrefix : supportedNamespaces) {
            ModelExtensionAssistant assistant = ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(namespacePrefix);
            ModelExtensionDefinition med = assistant.getModelExtensionDefinition();
            if (!(assistant instanceof ModelObjectExtensionAssistant)) continue;
            if (!med.extendsMetamodelUri(theModelResource.getModelAnnotation().getPrimaryMetamodelUri())) {
                ((ModelObjectExtensionAssistant)assistant).removeModelExtensionDefinition(modelResource);
                continue;
            }
            if (med.getSupportedModelTypes().contains(theModelResource.getModelType())) continue;
            ((ModelObjectExtensionAssistant)assistant).removeModelExtensionDefinition(modelResource);
        }
    }

    protected ModelResource getModelResource(Object modelObject) throws Exception {
        ModelResource modelResource = null;
        if (modelObject instanceof ModelResource) {
            modelResource = (ModelResource)modelObject;
        } else if (modelObject instanceof EObject) {
            modelResource = ModelerCore.getModelEditor().findModelResource((EObject)modelObject);
        } else if (modelObject instanceof IFile) {
            modelResource = ModelerCore.getModelEditor().findModelResource((IResource)((IFile)modelObject));
        }
        return modelResource;
    }

    public String getOverriddenValue(Object modelObject, String propId) throws Exception {
        CoreArgCheck.isInstanceOf(EObject.class, (Object)modelObject);
        Annotation annotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)modelObject, false);
        if (annotation != null) {
            EMap tags = annotation.getTags();
            return this.getOverriddenValue(modelObject, propId, (String)tags.get((Object)propId));
        }
        return null;
    }

    protected String getOverriddenValue(Object modelObject, String propId, String currentValue) throws Exception {
        ModelExtensionPropertyDefinition propDefn = this.getPropertyDefinition(modelObject, propId);
        if (propDefn == null) {
            return null;
        }
        String defaultValue = propDefn.getDefaultValue();
        if (CoreStringUtil.isEmpty((String)currentValue) && CoreStringUtil.isEmpty((String)defaultValue) || CoreStringUtil.equals((String)currentValue, (String)defaultValue)) {
            currentValue = null;
        }
        return currentValue;
    }

    public Properties getOverriddenValues(Object modelObject) throws Exception {
        Annotation annotation;
        CoreArgCheck.isInstanceOf(EObject.class, (Object)modelObject);
        Properties props = new Properties();
        if (this.supportsMyNamespace(modelObject) && (annotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)modelObject, false)) != null) {
            ModelExtensionDefinition med = this.getModelExtensionDefinition();
            EMap tags = annotation.getTags();
            for (String propId : tags.keySet()) {
                if (!ModelExtensionPropertyDefinition.Utils.isExtensionPropertyId((String)propId, (NamespaceProvider)med)) continue;
                try {
                    String overridenValue = this.getOverriddenValue(modelObject, propId, (String)tags.get((Object)propId));
                    if (CoreStringUtil.isEmpty((String)overridenValue)) continue;
                    props.put(propId, overridenValue);
                }
                catch (Exception e) {
                    ModelerCore.Util.log((Throwable)e);
                }
            }
        }
        return props;
    }

    protected ModelExtensionPropertyDefinition getPropertyDefinition(Object modelObject, String propId) throws Exception {
        CoreArgCheck.isInstanceOf(EObject.class, (Object)modelObject);
        if (ModelExtensionPropertyDefinition.Utils.isExtensionPropertyId((String)propId, (NamespaceProvider)this.getModelExtensionDefinition())) {
            Set modelTypes = this.getModelExtensionDefinition().getSupportedModelTypes();
            boolean modelTypeSupported = false;
            if (modelTypes.isEmpty()) {
                modelTypeSupported = true;
            } else {
                ModelResource modelResource = this.getModelResource(modelObject);
                if (modelResource != null) {
                    String modelTypeLiteral = modelResource.getModelType().getLiteral();
                    modelTypeSupported = modelTypes.contains(modelTypeLiteral);
                }
            }
            if (modelTypeSupported) {
                return this.getModelExtensionDefinition().getPropertyDefinition(modelObject.getClass().getName(), propId);
            }
        }
        return null;
    }

    public Collection<ModelExtensionPropertyDefinition> getPropertyDefinitions(Object modelObject) throws Exception {
        if (!(modelObject instanceof EObject) || !this.supportsMyNamespace(modelObject)) {
            return Collections.emptyList();
        }
        String metaclassName = modelObject.getClass().getName();
        ModelExtensionDefinition med = this.getModelExtensionDefinition();
        ArrayList<ModelExtensionPropertyDefinition> propDefinitions = new ArrayList<ModelExtensionPropertyDefinition>();
        for (ModelExtensionPropertyDefinition potentialPropDefn : med.getPropertyDefinitions(metaclassName)) {
            ModelExtensionPropertyDefinition propDefn = this.getPropertyDefinition(modelObject, potentialPropDefn.getId());
            if (propDefn == null) continue;
            propDefinitions.add(propDefn);
        }
        return propDefinitions;
    }

    public String getPropertyValue(Object modelObject, String propId) throws Exception {
        String value = this.getOverriddenValue(modelObject, propId);
        if (CoreStringUtil.isEmpty((String)value)) {
            ModelExtensionPropertyDefinition propDefn = this.getPropertyDefinition(modelObject, propId);
            return propDefn == null ? null : propDefn.getDefaultValue();
        }
        return value;
    }

    public Properties getPropertyValues(Object modelObject) throws Exception {
        CoreArgCheck.isInstanceOf(EObject.class, (Object)modelObject);
        Properties props = new Properties();
        if (this.supportsMyNamespace(modelObject)) {
            props = this.getOverriddenValues(modelObject);
            for (ModelExtensionPropertyDefinition propDefn : this.getModelExtensionDefinition().getPropertyDefinitions(modelObject.getClass().getName())) {
                String defaultValue;
                if (props.containsKey(propDefn.getId()) || CoreStringUtil.isEmpty((String)(defaultValue = propDefn.getDefaultValue()))) continue;
                props.put(propDefn.getId(), defaultValue);
            }
        }
        return props;
    }

    public Collection<String> getSupportedNamespaces(Object modelObject) throws Exception {
        ModelResource modelResource = this.getModelResource(modelObject);
        if (modelResource == null) {
            return Collections.emptyList();
        }
        return ModelExtensionUtils.getSupportedNamespaces(modelResource);
    }

    public boolean hasExtensionProperties(File file) throws Exception {
        ModelResource modelResource;
        IWorkspace workspace = ModelerCore.getWorkspace();
        IPath location = Path.fromOSString((String)file.getAbsolutePath());
        IFile modelFile = workspace.getRoot().getFileForLocation(location);
        if (modelFile != null && ModelUtil.isModelFile(modelFile.getFullPath()) && (modelResource = this.getModelResource(modelFile)) != null) {
            return ModelExtensionUtils.getSupportedNamespaces(modelResource).contains(this.getNamespacePrefix());
        }
        return false;
    }

    public boolean hasExtensionProperties(Object modelObject) throws Exception {
        return !this.getPropertyValues(modelObject).isEmpty();
    }

    public boolean isModelExtensionDefinitionRelated(Object modelObject) throws Exception {
        CoreArgCheck.isInstanceOf(EObject.class, (Object)modelObject);
        return ModelExtensionUtils.isModelExtensionDefinitionRelated((EObject)modelObject);
    }

    public ModelExtensionDefinition getModelExtensionDefinition(Object modelObject) throws Exception {
        ModelResource modelResource = this.getModelResource(modelObject);
        if (modelResource == null) {
            return null;
        }
        return ModelExtensionUtils.getModelExtensionDefinition((ModelExtensionAssistant)this, modelResource);
    }

    public void removeModelExtensionDefinition(Object modelObject) throws Exception {
        ModelResource modelResource = this.getModelResource(modelObject);
        if (modelResource != null) {
            ModelExtensionUtils.removeModelExtensionDefinition(modelResource, this.getNamespacePrefix());
            ModelExtensionDefinition definition = this.getModelExtensionDefinition();
            String[] metaclasses = definition.getExtendedMetaclasses();
            ModelObjectClassNameVisitor visitor = new ModelObjectClassNameVisitor(Arrays.asList(metaclasses));
            ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor, 1);
            processor.walk(modelResource, 2);
            for (EObject eObject : visitor.getResult()) {
                Annotation annotation = ModelExtensionUtils.getModelObjectAnnotation(eObject, false);
                if (annotation == null) continue;
                String metaclassName = eObject.getClass().getName();
                for (ModelExtensionPropertyDefinition propDefn : definition.getPropertyDefinitions(metaclassName)) {
                    this.removeProperty(eObject, propDefn.getId());
                }
            }
        }
    }

    public void removeProperty(Object modelObject, String propId) throws Exception {
        CoreArgCheck.isInstanceOf(EObject.class, (Object)modelObject);
        if (!ModelExtensionPropertyDefinition.Utils.isExtensionPropertyId((String)propId, (NamespaceProvider)this.getModelExtensionDefinition())) {
            throw new Exception(ModelerCore.Util.getString(String.valueOf(PREFIX) + "wrongNamespacePrefix", new Object[]{propId, this.getNamespacePrefix()}));
        }
        ModelExtensionUtils.removeProperty((EObject)modelObject, propId, true);
    }

    public void saveModelExtensionDefinition(Object modelObject) throws Exception {
        ModelResource modelResource = this.getModelResource(modelObject);
        assert (modelResource != null) : "Model resource should not be null";
        boolean update = this.supportsMyNamespace(modelObject);
        ModelExtensionUtils.updateModelExtensionDefinition(modelResource, this.getModelExtensionDefinition());
    }

    public void setPropertyValue(Object modelObject, String propId, String newValue) throws Exception {
        ModelExtensionPropertyDefinition propDefn = this.getPropertyDefinition(modelObject, propId);
        if (propDefn == null) {
            throw new Exception(ModelerCore.Util.getString(String.valueOf(PREFIX) + "propertyDefinitionNotFound", (Object)propId));
        }
        CoreArgCheck.isInstanceOf(EObject.class, (Object)modelObject);
        boolean valueIsDefault = CoreStringUtil.equals((String)propDefn.getDefaultValue(), (String)newValue);
        Annotation annotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)modelObject, true);
        if (valueIsDefault) {
            if (annotation != null) {
                annotation.getTags().removeKey((Object)propId);
                if (annotation.getTags().isEmpty() && annotation.getDescription() == null) {
                    ModelResourceContainerFactory.deleteAnnotation(annotation);
                }
            }
        } else {
            String oldValue;
            if (annotation == null) {
                annotation = ModelExtensionUtils.getModelObjectAnnotation((EObject)modelObject, true);
            }
            if (!CoreStringUtil.equals((String)(oldValue = (String)annotation.getTags().get((Object)propId)), (String)newValue)) {
                if (CoreStringUtil.isEmpty((String)newValue)) {
                    annotation.getTags().removeKey((Object)propId);
                } else {
                    annotation.getTags().put((Object)propId, (Object)newValue);
                }
            }
        }
    }

    public boolean supportsMedOperation(String proposedOperationName, Object context) {
        block7: {
            ModelResource modelResource;
            block10: {
                block11: {
                    String metamodelUri;
                    block12: {
                        block9: {
                            String modelTypeLiteral;
                            block8: {
                                CoreArgCheck.isNotEmpty((String)proposedOperationName, (String)"proposedOperationName is empty");
                                try {
                                    if (!(context instanceof IFile)) break block7;
                                    modelResource = this.getModelResource(context);
                                    if (modelResource != null) break block8;
                                    return false;
                                }
                                catch (Exception e) {
                                    ModelerCore.Util.log((Throwable)e);
                                    return false;
                                }
                            }
                            Set modelTypes = this.getModelExtensionDefinition().getSupportedModelTypes();
                            if (modelTypes.isEmpty() || modelTypes.contains(modelTypeLiteral = modelResource.getModelType().getLiteral())) break block9;
                            return false;
                        }
                        if (!"ADD_MED_TO_MODEL".equals(proposedOperationName)) break block10;
                        if (this.supportsMyNamespace(modelResource)) break block11;
                        metamodelUri = this.getModelExtensionDefinition().getMetamodelUri();
                        if (!CoreStringUtil.isEmpty((String)metamodelUri)) break block12;
                        return false;
                    }
                    return metamodelUri.equals(modelResource.getPrimaryMetamodelUri());
                }
                return false;
            }
            if ("DELETE_MED_FROM_MODEL".equals(proposedOperationName)) {
                return this.supportsMyNamespace(modelResource);
            }
        }
        return super.supportsMedOperation(proposedOperationName, context);
    }

    public boolean supportsMyNamespace(Object modelObject) throws Exception {
        ModelResource modelResource = this.getModelResource(modelObject);
        if (modelResource == null) {
            return false;
        }
        return ModelExtensionUtils.isSupportedNamespace(modelResource, this.getNamespacePrefix());
    }
}

