/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.container;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ObjectManager;
import org.teiid.designer.core.resource.XResource;
import org.teiid.designer.core.resource.xmi.MtkXmiResourceImpl;

public class ObjectManagerImpl
implements ObjectManager {
    private final Container container;

    public ObjectManagerImpl(Container container) {
        CoreArgCheck.isNotNull((Object)container);
        this.container = container;
    }

    public void addEObject(EObject eObject) {
    }

    public void clear() {
    }

    @Override
    public EObject findEObject(String id) {
        CoreArgCheck.isNotNull((Object)id);
        for (Resource resrc : this.container.getResources()) {
            EObject obj;
            if (!resrc.isLoaded() || (obj = this.findEObject(id, resrc)) == null) continue;
            return obj;
        }
        return null;
    }

    @Override
    public EObject findEObject(String id, Resource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        return resource.getEObject(id);
    }

    @Override
    public String getObjectId(EObject object) {
        String uuid;
        CoreArgCheck.isNotNull((Object)object);
        Resource resrc = object.eResource();
        if (resrc == null) {
            return MtkXmiResourceImpl.DETACHED_EOBJECT_TO_UUID_MAP.get(object);
        }
        String string = uuid = resrc instanceof XResource ? ((XResource)resrc).getUuid(object) : resrc.getURIFragment(object);
        if (uuid != null && uuid.startsWith("mmuuid")) {
            return uuid;
        }
        return null;
    }

    public void processMassAdd(Collection newObjects) {
    }

    public void processMassRemove(Collection objects) {
    }

    public void processResourceChange(Object eObject, Resource newResource, Resource oldResource) {
    }

    public void removeEObject(EObject eObject) {
    }

    @Override
    public void setObjectId(EObject object, String uuid) {
        Resource resrc = object.eResource();
        if (resrc instanceof XResource) {
            ((XResource)resrc).setUuid(object, uuid);
        } else {
            MtkXmiResourceImpl.DETACHED_EOBJECT_TO_UUID_MAP.put(object, uuid);
            MtkXmiResourceImpl.DETACHED_UUID_TO_EOBJECT_MAP.put(uuid, object);
        }
    }
}

