/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.ResourceValidator;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.core.workspace.ModelUtil;

public class ModelProjectResourceValidator
implements ResourceValidator {
    @Override
    public boolean isValidatorForObject(Object obj) {
        if (obj instanceof IProject) {
            return DotProjectUtils.isModelerProject((IProject)obj);
        }
        return false;
    }

    @Override
    public void validate(IProgressMonitor monitor, Object obj, ValidationContext context) throws ModelerCoreException {
        IProject project = (IProject)obj;
        try {
            IProjectDescription desc = project.getDescription();
            boolean foundVdbBuilder = false;
            ICommand[] iCommandArray = desc.getBuildSpec();
            int n = iCommandArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand com = iCommandArray[n2];
                foundVdbBuilder = com.getBuilderName().equalsIgnoreCase("org.teiid.designer.vdb.ui.vdbBuilder");
                if (foundVdbBuilder) break;
                ++n2;
            }
            if (!foundVdbBuilder) {
                ValidationProblemImpl problem = new ValidationProblemImpl(999, 4, "Model project definition for " + project.getName() + " is out of date. Perform Quick Fix to update the project");
                try {
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("severity", 2);
                    attributes.put("message", problem.getMessage());
                    attributes.put("missingVdbBuilder", true);
                    attributes.put("location", project.getName());
                    this.createMarker((IResource)project, attributes, "org.eclipse.core.resources.problemmarker");
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        Collection<IFile> allFiles = DotProjectUtils.getAllProjectResources((IProject)obj);
        ArrayList<IPath> fullFilePaths = new ArrayList<IPath>();
        ArrayList<IPath> fullFilePathsInner = new ArrayList<IPath>();
        for (IFile file : allFiles) {
            if (!ModelUtil.isModelFile((IResource)file) && !ModelUtil.isXsdFile((IResource)file)) continue;
            fullFilePaths.add(file.getFullPath());
            fullFilePathsInner.add(file.getFullPath());
        }
        HashSet<String> fileNamesWithMultiple = new HashSet<String>();
        HashSet<String> fileNamesWithMultipleUpperCase = new HashSet<String>();
        for (IPath path : fullFilePaths) {
            String fileNameNoExt = path.removeFileExtension().lastSegment();
            if (fileNamesWithMultipleUpperCase.contains(fileNameNoExt.toUpperCase())) continue;
            int nFiles = 0;
            for (IPath innerPath : fullFilePathsInner) {
                if (!innerPath.removeFileExtension().lastSegment().equalsIgnoreCase(fileNameNoExt)) continue;
                ++nFiles;
            }
            if (nFiles <= true) continue;
            fileNamesWithMultiple.add(fileNameNoExt);
            fileNamesWithMultipleUpperCase.add(fileNameNoExt.toUpperCase());
        }
        for (String fileName : fileNamesWithMultiple) {
            this.addNewProblemMarker((IProject)obj, fileName);
        }
    }

    @Override
    public void addMarkers(ValidationContext context, IResource iResource) throws ModelerCoreException {
    }

    @Override
    @Deprecated
    public boolean isValidatorForResource(IResource iResource) {
        return false;
    }

    @Override
    @Deprecated
    public void validate(IProgressMonitor monitor, Resource resource, IResource iResource, ValidationContext context) throws ModelerCoreException {
    }

    @Override
    public void validationStarted(Collection resources, ValidationContext context) {
    }

    @Override
    public void validationEnded(ValidationContext context) {
    }

    private void addNewProblemMarker(IProject project, String fileName) {
        ValidationProblemImpl problem = new ValidationProblemImpl(999, 2, ModelerCore.Util.getString("ModelProjectResourceValidator.duplicateFileNamesError", (Object)fileName));
        try {
            this.createProblemMarker(project.getName(), problem, (IResource)project);
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
    }

    private void createProblemMarker(String location, ValidationProblem problem, IResource resource) throws CoreException {
        IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
        if (location != null) {
            marker.setAttribute("location", (Object)location);
        }
        marker.setAttribute("message", (Object)problem.getMessage());
        this.setMarkerSeverity(marker, problem);
    }

    private void setMarkerSeverity(IMarker marker, ValidationProblem problem) throws CoreException {
        switch (problem.getSeverity()) {
            case 4: {
                marker.setAttribute("severity", 2);
                break;
            }
            case 2: {
                marker.setAttribute("severity", 1);
                break;
            }
            case 1: {
                marker.setAttribute("severity", 0);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void createMarker(final IResource resource, final Map attributes, final String markerType) throws CoreException {
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(markerType);
                marker.setAttributes(attributes);
            }
        };
        resource.getWorkspace().run(r, null, 1, null);
    }
}

