/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.plugin.PluginUtilities;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.Stopwatch;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.ResourceValidator;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.DuplicateResourceException;
import org.teiid.designer.core.index.ModelIndexer;
import org.teiid.designer.core.index.ModelSearchIndexer;
import org.teiid.designer.core.index.ResourceIndexer;
import org.teiid.designer.core.refactor.OrganizeImportCommand;
import org.teiid.designer.core.refactor.OrganizeImportHandler;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;

public class ModelBuildUtil {
    public static final int MONITOR_TASK_NAME_MAX_LENGTH = 200;
    public static final String TASK_NAME_TRUNCTATION_SUFFIX = ModelerCore.Util.getString("ModelBuildUtil.taskNameTruncationSuffix", new Object[0]);
    public static final String MONITOR_RESOURCE_VALIDATION_MSG = ModelerCore.Util.getString("ModelBuildUtil.Validating_Resource__1", new Object[0]);
    public static final String MONITOR_OBJECT_VALIDATION_MSG = ModelerCore.Util.getString("ModelBuildUtil.Validating__2", new Object[0]);
    private static Collection VALIDATORS;
    private static Collection INDEXERS;

    static {
        ModelBuildUtil.initValidators();
        ModelBuildUtil.initIndexers();
    }

    public static void buildResources(IProgressMonitor monitor, Collection iResources, Container container, boolean validateInContext) {
        List modifiedResources = ModelBuildUtil.getModifiedResources();
        Map<IProject, Collection<IResource>> projToResMap = ModelBuildUtil.getProjectToResourcesMap(iResources);
        HashSet indexedResources = new HashSet();
        for (IProject proj : projToResMap.keySet()) {
            Collection<IResource> projectIResources = projToResMap.get(proj);
            HashSet<IFile> dependentModels = new HashSet<IFile>();
            for (IResource resource : projectIResources) {
                Collection<IFile> collection = WorkspaceResourceFinderUtil.getResourcesThatUse(resource, 0);
                collection.removeAll(projectIResources);
                dependentModels.addAll(collection);
            }
            HashSet<IResource> unIndexedResources = new HashSet<IResource>();
            for (IResource theRes : projectIResources) {
                if (indexedResources.contains(theRes)) continue;
                unIndexedResources.add(theRes);
            }
            ModelBuildUtil.indexResources(monitor, unIndexedResources);
            indexedResources.addAll(unIndexedResources);
            unIndexedResources = new HashSet();
            for (IResource theRes : dependentModels) {
                if (indexedResources.contains(theRes)) continue;
                unIndexedResources.add(theRes);
            }
            ModelBuildUtil.indexResources(monitor, unIndexedResources);
            indexedResources.addAll(unIndexedResources);
        }
        ModelBuildUtil.setModifiedResources(modifiedResources);
        HashSet validatedResources = new HashSet();
        for (IProject proj : projToResMap.keySet()) {
            Collection<IResource> projectIResources = projToResMap.get(proj);
            HashSet<IFile> dependentModels = new HashSet<IFile>();
            for (IResource iResource : projectIResources) {
                Collection<IFile> models = WorkspaceResourceFinderUtil.getResourcesThatUse(iResource, 0);
                models.removeAll(projectIResources);
                dependentModels.addAll(models);
            }
            HashSet<IResource> unValidatedResources = new HashSet<IResource>();
            for (IResource iResource : projectIResources) {
                if (validatedResources.contains(iResource)) continue;
                unValidatedResources.add(iResource);
            }
            ModelBuildUtil.validateResources(monitor, unValidatedResources, container, validateInContext);
            validatedResources.addAll(unValidatedResources);
            unValidatedResources = new HashSet();
            for (IResource iResource : dependentModels) {
                if (validatedResources.contains(iResource)) continue;
                unValidatedResources.add(iResource);
            }
            ModelBuildUtil.validateResources(monitor, unValidatedResources, container, validateInContext);
            validatedResources.addAll(unValidatedResources);
        }
        ModelBuildUtil.setModifiedResources(modifiedResources);
    }

    public static void clearResourceMarkers(Collection iResources) {
        try {
            for (IResource iResource : iResources) {
                if (!iResource.exists()) continue;
                iResource.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            }
        }
        catch (CoreException e) {
            ModelerCore.Util.log((Throwable)e);
        }
    }

    public static void clearResourceMarkers(IResource iResource) {
        try {
            if (iResource.exists()) {
                iResource.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            }
        }
        catch (CoreException e) {
            ModelerCore.Util.log((Throwable)e);
        }
    }

    public static void createModelIndexes(IProgressMonitor monitor, Collection resources) {
        ModelIndexer modelIndexer = new ModelIndexer();
        ModelBuildUtil.indexResources(monitor, resources, modelIndexer);
    }

    public static void createSearchIndexes(IProgressMonitor monitor, Collection resources) {
        ModelSearchIndexer searchIndexer = new ModelSearchIndexer();
        ModelBuildUtil.indexResources(monitor, resources, searchIndexer);
    }

    public static ValidationContext createValidationContext() {
        ValidationContext context = null;
        Plugin corePlugin = ModelerCore.getPlugin();
        context = corePlugin != null && !ModelerCore.ignoreValidationPreferencesOnBuild() ? new ValidationContext("org.teiid.designer.core") : new ValidationContext();
        return context;
    }

    public static List getModifiedResources() {
        try {
            return ModelBuildUtil.getModifiedResources((List)ModelerCore.getModelContainer().getResources());
        }
        catch (CoreException coreException) {
            return Collections.EMPTY_LIST;
        }
    }

    public static List getModifiedResources(List eResources) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (eResources != null) {
            for (Resource resource : eResources) {
                if (!resource.isModified()) continue;
                result.add(resource);
            }
        }
        return result;
    }

    private static Resource[] getWorkspaceResourcesInScope(ModelWorkspace workspace) throws CoreException {
        Resource[] wsEmfResources = workspace.getEmfResources();
        ArrayList<Resource> resourcesInScope = new ArrayList<Resource>(Arrays.asList(wsEmfResources));
        ModelBuildUtil.updateResource(resourcesInScope);
        return resourcesInScope.toArray(new Resource[resourcesInScope.size()]);
    }

    public static void indexResource(IProgressMonitor monitor, IResource iResource, ResourceIndexer indexer) {
        Object object = monitor = monitor != null ? monitor : new NullProgressMonitor();
        if (monitor.isCanceled()) {
            return;
        }
        String sTask = ModelerCore.Util.getString("ModelBuildUtil.Creating_{0}_for_{1}_1", new Object[]{indexer.getIndexType(), iResource.getFullPath()});
        monitor.setTaskName(sTask);
        try {
            Stopwatch totalWatch = new Stopwatch();
            totalWatch.start();
            indexer.indexResource(iResource, false, true);
            totalWatch.stop();
        }
        catch (Throwable e) {
            ModelerCore.Util.log(4, e, ModelerCore.Util.getString("ModelBuilder.Error_indexing_model_resource_3", (Object)iResource.getFullPath()));
        }
    }

    public static void indexResources(IProgressMonitor monitor, Collection resources) {
        monitor = monitor != null ? monitor : new NullProgressMonitor();
        for (ResourceIndexer indexer : INDEXERS) {
            ModelBuildUtil.indexResources(monitor, resources, indexer);
        }
    }

    public static void indexResources(IProgressMonitor monitor, Collection resources, ResourceIndexer indexer) {
        for (IResource resource : resources) {
            ModelBuildUtil.indexResource(monitor, resource, indexer);
            if (monitor == null) continue;
            monitor.worked(1);
        }
    }

    private static void initIndexers() {
        IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.core.resourceIndexer");
        INDEXERS = new ArrayList(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            try {
                Object instance = PluginUtilities.createExecutableExtension((IExtension)extension, (String)"class", (String)"name");
                if (instance instanceof ResourceIndexer) {
                    INDEXERS.add(instance);
                } else {
                    String message = ModelerCore.Util.getString("ModelBuildUtil.Extension_class_not_instance_of_IIndexer_1", new Object[0]);
                    ModelerCore.Util.log((Object)message);
                }
            }
            catch (CoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
            ++i;
        }
    }

    private static void initValidators() {
        IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.core.resourceValidator");
        VALIDATORS = new ArrayList(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            try {
                Object instance = PluginUtilities.createExecutableExtension((IExtension)extension, (String)"class", (String)"name");
                if (instance instanceof ResourceValidator) {
                    VALIDATORS.add(instance);
                } else {
                    String message = ModelerCore.Util.getString("ModelBuildUtil.Extension_class_not_instance_of_ResourceValidator_1", new Object[0]);
                    ModelerCore.Util.log((Object)message);
                }
            }
            catch (CoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
            ++i;
        }
    }

    private static void internalValidateResource(IProgressMonitor monitor, IResource iResource, ResourceValidator validator, ValidationContext context, boolean clearMarkers) {
        IProgressMonitor progresssMonitor;
        Object object = progresssMonitor = monitor != null ? monitor : new NullProgressMonitor();
        if (progresssMonitor.isCanceled() || !validator.isValidatorForObject(iResource)) {
            return;
        }
        progresssMonitor.setTaskName(String.valueOf(MONITOR_RESOURCE_VALIDATION_MSG) + iResource.getFullPath());
        Object duplicateOfModel = null;
        try {
            duplicateOfModel = iResource.getSessionProperty(ModelerCore.DUPLICATE_MODEL_OF_IPATH_KEY);
        }
        catch (CoreException coreException) {}
        if (clearMarkers) {
            ModelBuildUtil.clearResourceMarkers(iResource);
        }
        if (duplicateOfModel == null) {
            try {
                ModelWorkspace workspace = ModelerCore.getModelWorkspace();
                ModelResource mResource = workspace.findModelResource(iResource);
                IResource resource = null;
                if (!ModelUtil.isVdbArchiveFile(iResource) && !(iResource instanceof IProject)) {
                    try {
                        if (mResource != null && mResource.getEmfResource() != null) {
                            resource = mResource.getEmfResource();
                        } else {
                            IPath location = ModelUtil.getLocation(iResource);
                            if (location != null) {
                                URI uri = URI.createFileURI((String)location.toString());
                                resource = ModelerCore.getModelContainer().getResource(uri, true);
                                if (resource != null) {
                                    resource.setModified(false);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                IResource objToValidate = resource != null ? resource : iResource;
                Stopwatch totalWatch = new Stopwatch();
                totalWatch.start();
                validator.validate(progresssMonitor, objToValidate, context);
                totalWatch.stop();
                validator.addMarkers(context, iResource);
                context.clearResults();
            }
            catch (ModelerCoreException e) {
                Throwable underlyingException = e.getException();
                if (underlyingException instanceof DuplicateResourceException) {
                    try {
                        duplicateOfModel = iResource.getSessionProperty(ModelerCore.DUPLICATE_MODEL_OF_IPATH_KEY);
                    }
                    catch (CoreException err) {
                        ModelerCore.Util.log((Throwable)err);
                    }
                }
                ModelerCore.Util.log((Throwable)e);
            }
        }
        if (duplicateOfModel != null) {
            try {
                Object[] params = new Object[]{duplicateOfModel};
                String msg = ModelerCore.Util.getString("ModelBuildUtil.ModelDuplicateOf_0", params);
                IMarker marker = iResource.createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("severity", 2);
                marker.setAttribute("location", duplicateOfModel);
                marker.setAttribute("org.teiid.designer.core.markerURI", null);
                marker.setAttribute("org.teiid.designer.core.targetMarkerURI", null);
                marker.setAttribute("message", (Object)msg);
            }
            catch (CoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
        }
    }

    private static void internalValidateProject(IProgressMonitor monitor, IProject project, ResourceValidator validator, boolean clearMarkers) {
        IProgressMonitor progresssMonitor;
        Object object = progresssMonitor = monitor != null ? monitor : new NullProgressMonitor();
        if (progresssMonitor.isCanceled() || !validator.isValidatorForObject(project)) {
            return;
        }
        IProject objToValidate = project != null ? project : project;
        Stopwatch totalWatch = new Stopwatch();
        totalWatch.start();
        try {
            validator.validate(progresssMonitor, objToValidate, null);
        }
        catch (ModelerCoreException ex) {
            ex.printStackTrace();
        }
        totalWatch.stop();
        progresssMonitor.setTaskName(String.valueOf(MONITOR_RESOURCE_VALIDATION_MSG) + project.getName());
    }

    public static boolean rebuildImports(Resource resource, boolean includeDiagramReferences) {
        ModelResource mr;
        if (resource != null && (mr = ModelerCore.getModelEditor().findModelResource(resource)) != null && !mr.isReadOnly()) {
            OrganizeImportHandler handler = new OrganizeImportHandler(){

                @Override
                public Object choose(List options) {
                    return null;
                }
            };
            OrganizeImportCommand importCommand = new OrganizeImportCommand();
            importCommand.setResource(resource);
            importCommand.setHandler(handler);
            importCommand.setIncludeDiagramReferences(includeDiagramReferences);
            IProgressMonitor monitor = null;
            IStatus status = importCommand.canExecute();
            if (status.isOK()) {
                IStatus runStatus = importCommand.execute(monitor);
                if (!runStatus.isOK()) {
                    ModelerCore.Util.log(runStatus);
                    return false;
                }
                return true;
            }
            ModelerCore.Util.log(status);
        }
        return false;
    }

    public static void setModifiedResources(List modifiedResources) {
        try {
            Container container = ModelerCore.getModelContainer();
            for (Object element : container.getResources()) {
                Resource resource = (Resource)element;
                if (modifiedResources != null && modifiedResources.contains(resource)) {
                    resource.setModified(true);
                    continue;
                }
                resource.setModified(false);
            }
        }
        catch (CoreException theException) {
            ModelerCore.Util.log(4, (Throwable)theException, theException.getMessage());
        }
    }

    private static void updateResource(Collection resourcesInScope) {
        Resource[] systemVdbResources;
        Resource[] resourceArray = systemVdbResources = ModelerCore.getSystemVdbResources();
        int n = systemVdbResources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource systemVdbResource = resourceArray[n2];
            if (systemVdbResource instanceof EmfResource) {
                ObjectID objectID = ((EmfResource)systemVdbResource).getUuid();
                try {
                    Resource resrc = ModelerCore.getModelContainer().getResourceFinder().findByUUID(objectID, false);
                    if (resrc != null && !resourcesInScope.contains(resrc)) {
                        resourcesInScope.add(systemVdbResource);
                    }
                }
                catch (CoreException err) {
                    ModelerCore.Util.log((Throwable)err);
                }
            } else {
                resourcesInScope.add(systemVdbResource);
            }
            ++n2;
        }
    }

    public static void validateResource(IProgressMonitor monitor, IResource iResource, ResourceValidator validator, ValidationContext context) {
        if (iResource instanceof IProject) {
            ModelBuildUtil.internalValidateProject(monitor, (IProject)iResource, validator, true);
        } else {
            ModelBuildUtil.internalValidateResource(monitor, iResource, validator, context, true);
        }
    }

    private static void validateResource(IProgressMonitor monitor, Resource eResource, ResourceValidator validator, ValidationContext context) {
        IProgressMonitor progresssMonitor;
        CoreArgCheck.isNotNull((Object)eResource);
        CoreArgCheck.isNotNull((Object)validator);
        CoreArgCheck.isNotNull((Object)context);
        Object object = progresssMonitor = monitor != null ? monitor : new NullProgressMonitor();
        if (monitor.isCanceled() || !validator.isValidatorForObject(eResource)) {
            return;
        }
        monitor.setTaskName(String.valueOf(MONITOR_RESOURCE_VALIDATION_MSG) + eResource.getURI().lastSegment());
        boolean isModified = eResource.isModified();
        try {
            try {
                Stopwatch totalWatch = new Stopwatch();
                totalWatch.start();
                validator.validate(progresssMonitor, eResource, context);
                totalWatch.stop();
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log((Throwable)e);
                eResource.setModified(isModified);
            }
        }
        finally {
            eResource.setModified(isModified);
        }
    }

    public static void validateResource(IProgressMonitor monitor, Resource eResource, ValidationContext context) {
        CoreArgCheck.isNotNull((Object)eResource);
        CoreArgCheck.isNotNull((Object)context);
        for (ResourceValidator validator : VALIDATORS) {
            ModelBuildUtil.validateResource(monitor, eResource, validator, context);
        }
    }

    public static void validateResources(IProgressMonitor monitor, Collection iResources, Container container, boolean validateInContext) {
        IProgressMonitor progresssMonitor = monitor != null ? monitor : new NullProgressMonitor();
        ValidationContext context = ModelBuildUtil.createValidationContext();
        ModelWorkspace workspace = ModelerCore.getModelWorkspace();
        try {
            Resource[] resourcesInScope = ModelBuildUtil.getWorkspaceResourcesInScope(workspace);
            context.setResourcesInScope(resourcesInScope);
        }
        catch (CoreException theException) {
            ModelerCore.Util.log((Throwable)theException);
        }
        if (validateInContext && iResources != null) {
            ArrayList<Resource> temp = new ArrayList<Resource>();
            for (IResource iResource : iResources) {
                if (!ModelUtil.isModelFile(iResource)) continue;
                try {
                    ModelResource modelResource = ModelerCore.getModelEditor().findModelResource(iResource);
                    if (modelResource == null) continue;
                    temp.add(modelResource.getEmfResource());
                }
                catch (ModelWorkspaceException theException) {
                    ModelerCore.Util.log((Throwable)((Object)theException));
                }
            }
            context.setResourcesToValidate(temp.toArray(new Resource[temp.size()]));
        }
        context.setResourceContainer(container);
        ModelBuildUtil.clearResourceMarkers(iResources);
        for (ResourceValidator validator : VALIDATORS) {
            validator.validationStarted(iResources, context);
            try {
                for (IResource resource : iResources) {
                    ModelBuildUtil.internalValidateResource(progresssMonitor, resource, validator, context, false);
                }
            }
            finally {
                validator.validationEnded(context);
            }
        }
        context.clearState();
    }

    public static void validateResources(IProgressMonitor monitor, Resource[] eResources, ValidationContext context) {
        CoreArgCheck.isNotNull((Object)eResources);
        CoreArgCheck.isNotNull((Object)context);
        IProgressMonitor progresssMonitor = monitor != null ? monitor : new NullProgressMonitor();
        context.setResourcesToValidate(eResources);
        int i = 0;
        while (i < eResources.length) {
            ModelBuildUtil.validateResource(progresssMonitor, eResources[i], context);
            ++i;
        }
    }

    private static Map<IProject, Collection<IResource>> getProjectToResourcesMap(Collection iResources) {
        HashMap<IProject, Collection<IResource>> map = new HashMap<IProject, Collection<IResource>>(10);
        for (Object res : iResources) {
            IResource iResource = (IResource)res;
            IProject proj = iResource.getProject();
            ArrayList<IResource> resList = (ArrayList<IResource>)map.get(proj);
            if (resList == null) {
                resList = new ArrayList<IResource>(10);
            }
            resList.add(iResource);
            map.put(proj, resList);
        }
        return map;
    }
}

