/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.swt.widgets.Event;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.aspects.DeclarativeTransactionManager;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.core.designer.util.Stopwatch;
import org.teiid.designer.ExtensionRegistryUtils;
import org.teiid.designer.IExtensionRegistryCallback;
import org.teiid.designer.WorkspaceUUIDService;
import org.teiid.designer.core.Configuration;
import org.teiid.designer.core.EclipseConfigurationBuilder;
import org.teiid.designer.core.ExtensionDescriptor;
import org.teiid.designer.core.ExternalResourceDescriptor;
import org.teiid.designer.core.ExternalResourceLoader;
import org.teiid.designer.core.ExternalResourceSet;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelEditorImpl;
import org.teiid.designer.core.Registry;
import org.teiid.designer.core.TransformationPreferences;
import org.teiid.designer.core.TransformationPreferencesImpl;
import org.teiid.designer.core.ValidationPreferences;
import org.teiid.designer.core.ValidationPreferencesImpl;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ContainerImpl;
import org.teiid.designer.core.container.ResourceDescriptor;
import org.teiid.designer.core.index.ModelWorkspaceIndexSelectorFactory;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.metamodel.MetamodelRegistry;
import org.teiid.designer.core.metamodel.MetamodelRegistryImpl;
import org.teiid.designer.core.metamodel.ResourceLoadOptionContributor;
import org.teiid.designer.core.refactor.IRefactorResourceListener;
import org.teiid.designer.core.refactor.RefactorResourceEvent;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.resource.EmfResourceSet;
import org.teiid.designer.core.resource.EmfResourceSetImpl;
import org.teiid.designer.core.search.MetadataSearch;
import org.teiid.designer.core.search.MetadataSearchImpl;
import org.teiid.designer.core.spi.RegistrySPI;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.types.DatatypeManagerLifecycle;
import org.teiid.designer.core.util.FlatRegistry;
import org.teiid.designer.core.util.InvocationFactoryHelper;
import org.teiid.designer.core.util.StartupLogger;
import org.teiid.designer.core.util.WorkspaceUriPathConverter;
import org.teiid.designer.core.validation.ValidationRuleManager;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.core.workspace.ModelProject;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelStatusImpl;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.ModelWorkspaceManagerSaveParticipant;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.runtime.registry.TeiidRuntimeRegistry;
import org.teiid.designer.runtime.spi.EventManager;
import org.teiid.designer.runtime.spi.IExecutionAdminFactory;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.spi.ITeiidServerVersionListener;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.type.IDataTypeManagerService;

public class ModelerCore
extends Plugin
implements DeclarativeTransactionManager {
    private static final String FEATURE_ID = "org.teiid.designer";
    public static final String WORKSPACE_UUID_FILE = "workspace.uuid";
    private static final String MINIMUM_JAVA_VERSION = "1.6";
    public static final String PLUGIN_ID = "org.teiid.designer.core";
    public static final String PACKAGE_ID = ModelerCore.class.getPackage().getName();
    public static final String BUILDER_ID = "org.teiid.designer.core.modelBuilder";
    public static final String VDB_BUILDER_ID = "org.teiid.designer.vdb.ui.vdbBuilder";
    public static final String NATURE_ID = "org.teiid.designer.core.modelNature";
    public static final String HIDDEN_PROJECT_NATURE_ID = "org.teiid.designer.core.hiddenProjectNature";
    public static final String[] NATURES = new String[]{"org.teiid.designer.core.modelNature"};
    private static final String USERFILES_FOLDERNAME = "user-files";
    public static final String UDF_MODEL_NAME = "FunctionDefinitions.xmi";
    public static final String UDF_PROJECT_NAME = "org.teiid.designer.udf";
    private static final String XML_EXTENSIONS_PROJECT_NAME = "XMLExtensionsProject";
    private static final String BUILTIN_MEDS_PROJECT_NAME = "BuiltInMedsProject";
    private static final String[] RESERVED_PROJECT_NAMES = new String[]{"user-files", "org.teiid.designer.udf", "XMLExtensionsProject", "BuiltInMedsProject"};
    public static final String MODEL_FILE_EXTENSION = ".xmi";
    public static final String DECLATIVE_TXN = "Declarative Transaction";
    public static final String XSD_FILE_EXTENSION = ".xsd";
    public static final String VDB_FILE_EXTENSION = ".vdb";
    public static final String MED_FILE_EXTENSION = ".mxd";
    public static final String DOT_PROJECT_EXTENSION = "project";
    public static final String MARKER_PROBLEM_DECORATOR_TEXT = "org.teiid.designer.core.problemDecoratorText";
    public static final String MARKER_URI_PROPERTY = "org.teiid.designer.core.markerURI";
    public static final String TARGET_MARKER_URI_PROPERTY = "org.teiid.designer.core.targetMarkerURI";
    public static final String XML_SCHEMA_GENERAL_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String XML_MAGIC_SCHEMA_GENERAL_URI = "http://www.w3.org/2001/MagicXMLSchema";
    public static final String XML_SCHEMA_INSTANCE_GENERAL_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XML_XSD_GENERAL_URI = "http://www.w3.org/2001/xml";
    public static String XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX = "platform:/plugin/org.eclipse.xsd_2.1.0/";
    public static final String XML_SCHEMA_ECLIPSE_PLATFORM_URI;
    public static final String XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI;
    public static final String XML_SCHEMA_INSTANCE_ECLIPSE_PLATFORM_URI;
    public static final QualifiedName DUPLICATE_MODEL_OF_IPATH_KEY;
    public static final String DELIMITER = ".";
    private static final String I18N_NAME;
    private static final String I18N_PREFIX;
    public static final PluginUtil Util;
    private static Plugin MODELER_CORE_PLUGIN;
    private static final Object CONTAINER_LOCK;
    public static final String DEFAULT_CONTAINER_KEY = "Modeler Container";
    public static final String EXTERNAL_RESOURCE_CONTAINER_KEY = "External Resource Container";
    public static final String EXTERNAL_RESOURCE_SETS_KEY = "External Resource Sets";
    public static final String INVOCATION_FACTORY_HELPERS_KEY = "Invocation Factory Helpers";
    public static final String CONFIGURATION_KEY = "Configuration";
    public static final String DEFAULT_DATATYPE_MANAGER_KEY = "Default DataType Manager";
    public static final String METAMODEL_REGISTRY_KEY = "Default Metamodel Registry";
    public static final String MODEL_EDITOR_KEY = "Model Editor";
    public static final String TRANSFORMATION_PREFERENCES_KEY = "Transformation Preferences";
    public static final String VALIDATION_PREFERENCES_KEY = "Validation Preferences";
    public static final String VALIDATION_RULE_MANAGER_KEY = "Validation Rule Manager";
    public static final String UUID_KEY = "Workspace UUID";
    public static final String WORKSPACE_KEY = "Workspace";
    private static RegistrySPI registry;
    private static final Object METAMODEL_REGISTRY_LOCK;
    public static boolean DEBUG;
    public static boolean DEBUG_MODELER_CORE_INIT;
    public static boolean DEBUG_METAMODEL;
    public static boolean DEBUG_VALIDATION;
    public static boolean DEBUG_TRANSACTION;
    public static boolean DEBUG_TRANSACTION_INVOCATIONS;
    public static boolean DEBUG_MODEL_WORKSPACE;
    public static boolean DEBUG_MODEL_WORKSPACE_EVENT;
    public static boolean DEBUG_MODEL_WORKSPACE_SAVE;
    public static boolean DEBUG_PROJECT_BUILDER;
    public static boolean DEBUG_NOTIFICATIONS;
    public static boolean DEBUG_TEAM;
    public static boolean DEBUG_BRIDGE;
    public static boolean DEBUG_XML;
    public static boolean DEBUG_GEMINI;
    public static boolean DEBUG_QUERY_RESOLUTION;
    public static boolean DEBUG_VDB_EDITING_CONTEXT;
    private static boolean IGNORE_VALIDATION_PREFERNCES_ON_BUILD;
    private static ITeiidServerManager teiidServerManager;
    private static Object mutexObject;
    private ISaveParticipant saveParticipant;
    private final CopyOnWriteArrayList<IRefactorResourceListener> refactorListeners;

    static {
        try {
            XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX = XSDPlugin.INSTANCE.getBaseURL().toString();
        }
        catch (Exception exception) {}
        XML_SCHEMA_ECLIPSE_PLATFORM_URI = String.valueOf(XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX) + "cache/www.w3.org/2001/XMLSchema.xsd";
        XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI = String.valueOf(XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX) + "cache/www.w3.org/2001/MagicXMLSchema.xsd";
        XML_SCHEMA_INSTANCE_ECLIPSE_PLATFORM_URI = String.valueOf(XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX) + "cache/www.w3.org/2001/XMLSchema-instance.xsd";
        DUPLICATE_MODEL_OF_IPATH_KEY = new QualifiedName(PLUGIN_ID, "pathToDuplicateModel");
        I18N_NAME = String.valueOf(PACKAGE_ID) + ".i18n";
        I18N_PREFIX = I18nUtil.getPropertyPrefix(ModelerCore.class);
        Util = new PluginUtilImpl(PLUGIN_ID, I18N_NAME, ResourceBundle.getBundle(I18N_NAME));
        MODELER_CORE_PLUGIN = null;
        CONTAINER_LOCK = new Object();
        registry = new FlatRegistry();
        METAMODEL_REGISTRY_LOCK = new Object();
        DEBUG = false;
        DEBUG_MODELER_CORE_INIT = false;
        DEBUG_METAMODEL = false;
        DEBUG_VALIDATION = false;
        DEBUG_TRANSACTION = false;
        DEBUG_TRANSACTION_INVOCATIONS = false;
        DEBUG_MODEL_WORKSPACE = false;
        DEBUG_MODEL_WORKSPACE_EVENT = false;
        DEBUG_MODEL_WORKSPACE_SAVE = false;
        DEBUG_PROJECT_BUILDER = false;
        DEBUG_NOTIFICATIONS = false;
        DEBUG_TEAM = false;
        DEBUG_BRIDGE = false;
        DEBUG_XML = false;
        DEBUG_GEMINI = false;
        DEBUG_QUERY_RESOLUTION = false;
        DEBUG_VDB_EDITING_CONTEXT = false;
        IGNORE_VALIDATION_PREFERNCES_ON_BUILD = false;
        teiidServerManager = null;
        mutexObject = new Object();
    }

    public static void addExternalResourceSets(Container container) {
        List<ResourceSet> extRsrcSets = ModelerCore.getExternalResourceSets();
        for (ResourceSet rsrcSet : extRsrcSets) {
            container.addExternalResourceSet(rsrcSet);
            if (!DEBUG) continue;
            Util.log(1, Util.getString("ModelerCore.DEBUG.Added_external_resource_set_to_the_container._1", (Object)rsrcSet));
        }
    }

    public static void commitTxn() {
        try {
            UnitOfWork uow = ModelerCore.getCurrentUoW();
            if (uow != null) {
                uow.commit();
            }
        }
        catch (ModelerCoreException e) {
            Util.log(4, (Throwable)e, e.getMessage());
        }
    }

    public static ModelResource create(IFile file) {
        return ModelWorkspaceManager.create(file, null);
    }

    public static ModelProject create(IProject project) {
        if (project == null || !ModelerCore.hasModelNature(project)) {
            return null;
        }
        ModelWorkspace modelWorkspace = ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace();
        return modelWorkspace.getModelProject((IResource)project);
    }

    public static ModelWorkspaceItem create(IResource resource) {
        return ModelWorkspaceManager.create(resource, null);
    }

    public static ModelWorkspace create(IWorkspaceRoot root) {
        if (root == null) {
            return null;
        }
        return ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace();
    }

    public static ModelWorkspaceItem create(String handleIdentifier) {
        if (handleIdentifier == null) {
            return null;
        }
        return ModelWorkspaceManager.getModelWorkspaceManager().getHandleFromMemento(handleIdentifier);
    }

    public static Container createContainer(String containerName) throws CoreException {
        return ModelerCore.createContainer(containerName, RegistryOption.REGISTER);
    }

    public static Container createContainer(String containerName, RegistryOption registryOption) throws CoreException {
        Container container = ModelerCore.createEmptyContainer(containerName);
        ModelerCore.addExternalResourceSets(container);
        if (MODELER_CORE_PLUGIN != null && container instanceof ContainerImpl) {
            ContainerImpl ci = (ContainerImpl)container;
            DatatypeManager datatypeManager = ModelerCore.createDatatypeManager();
            if (datatypeManager != null) {
                ci.setDatatypeManager(datatypeManager);
                if (datatypeManager instanceof DatatypeManagerLifecycle) {
                    ((DatatypeManagerLifecycle)((Object)datatypeManager)).initialize(ci);
                }
            }
        }
        container.setOptions(ModelerCore.getDefaultContainerOptions());
        return container;
    }

    protected static DatatypeManager createDatatypeManager() {
        ModelerCore.getMetamodelRegistry();
        List desc = ModelerCore.getConfiguration().getDatatypeManagerDescriptors();
        if (desc.isEmpty()) {
            Util.log(4, Util.getString("ModelerCore.Error,_no_DatatypeManager_extensions_were_found_in_the_plugin_registry_1", new Object[0]));
        }
        DatatypeManager dtMgr = null;
        Iterator iter = desc.iterator();
        if (iter.hasNext()) {
            ExtensionDescriptor descriptor = (ExtensionDescriptor)iter.next();
            dtMgr = (DatatypeManager)descriptor.getNewExtensionClassInstance();
        }
        if (dtMgr == null) {
            Util.log(4, Util.getString("ModelerCore.Error_creating_new_instance_of_a_DatatypeManager_2", new Object[0]));
            throw new ModelerCoreRuntimeException(Util.getString("ModelerCore.Error_creating_the_DatatypeManager_instance_1", new Object[0]));
        }
        if (DEBUG) {
            Util.log(1, Util.getString("ModelerCore.DEBUG.Created_new_instance_of_a_DatatypeManager_1", new Object[0]));
        }
        return dtMgr;
    }

    public static Container createEmptyContainer(String containerName) throws CoreException {
        return ModelerCore.createEmptyContainer(containerName, RegistryOption.REGISTER);
    }

    public static Container createEmptyContainer(String containerName, RegistryOption registryOption) throws CoreException {
        ContainerImpl container = null;
        try {
            if (DEBUG_MODEL_WORKSPACE) {
                Util.log(1, Util.getString("ModelWorkspaceManager.DEBUG.Creating_the_model_container", new Object[0]));
            }
            container = new ContainerImpl();
            container.setName(containerName);
            container.setMetamodelRegistry(ModelerCore.getMetamodelRegistry());
            String name = container.getName();
            if (name != null && name.length() != 0 && RegistryOption.REGISTER.equals((Object)registryOption)) {
                registry.register(name, container, "container name property");
            }
            container.start();
            ResourceSet resourceSet = container.getResourceSet();
            if (resourceSet instanceof EmfResourceSetImpl) {
                ((EmfResourceSetImpl)resourceSet).setUriPathConverter(new WorkspaceUriPathConverter());
            }
        }
        catch (ModelerCoreException e) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 1, Util.getString("ModelerCore.Error_adding_resource_descriptors_to_the_container", new Object[0]), (Throwable)e));
        }
        Iterator iter = ModelerCore.getConfiguration().getResourceDescriptors().iterator();
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        while (iter.hasNext()) {
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)iter.next();
            try {
                container.addResourceDescriptor(resourceDescriptor);
            }
            catch (ModelerCoreException e) {
                IStatus status = e.getStatus();
                errors.add(status);
            }
        }
        if (!errors.isEmpty()) {
            IStatus[] statuses = errors.toArray(new IStatus[errors.size()]);
            throw new CoreException((IStatus)new MultiStatus(PLUGIN_ID, 0, statuses, Util.getString("ModelerCore.Error_adding_resource_descriptors_to_the_container", new Object[0]), null));
        }
        return container;
    }

    public static MetadataSearch createMetadataSearch() {
        ModelWorkspaceIndexSelectorFactory factory = new ModelWorkspaceIndexSelectorFactory();
        ModelWorkspace workspace = ModelerCore.getModelWorkspace();
        return new MetadataSearchImpl(workspace, factory);
    }

    public static DatatypeManager getBuiltInTypesManager() {
        DatatypeManager builtInTypesManager = null;
        DatatypeManager wsDatatypeManager = ModelerCore.getWorkspaceDatatypeManager();
        if (wsDatatypeManager != null) {
            builtInTypesManager = wsDatatypeManager.getBuiltInTypeManager();
        }
        return builtInTypesManager;
    }

    public static Configuration getConfiguration() {
        Configuration configuration = registry.lookup(CONFIGURATION_KEY, Configuration.class);
        if (configuration == null) {
            configuration = registry.register(CONFIGURATION_KEY, new Configuration());
        }
        return configuration;
    }

    public static Container getContainer(EObject obj) {
        if (obj == null) {
            return null;
        }
        Resource objResource = obj.eResource();
        if (objResource != null) {
            ResourceSet resourceSet = objResource.getResourceSet();
            if (resourceSet instanceof EmfResourceSet) {
                EmfResourceSet emfResourceSet = (EmfResourceSet)resourceSet;
                Container container = emfResourceSet.getContainer();
                return container;
            }
            if (resourceSet instanceof Container) {
                return (Container)resourceSet;
            }
            if (resourceSet == XSDSchemaImpl.getGlobalResourceSet()) {
                return registry.lookup(DEFAULT_CONTAINER_KEY, Container.class);
            }
        }
        return null;
    }

    public static Container getContainer(Resource resource) {
        ResourceSet rs;
        CoreArgCheck.isNotNull((Object)resource);
        if (resource instanceof EmfResource) {
            return ((EmfResource)resource).getContainer();
        }
        if (resource instanceof XSDResourceImpl && (rs = resource.getResourceSet()) instanceof EmfResourceSet) {
            return ((EmfResourceSet)rs).getContainer();
        }
        return null;
    }

    public static UnitOfWork getCurrentUoW() {
        if (registry.lookup(DEFAULT_CONTAINER_KEY, Container.class) != null) {
            try {
                return ModelerCore.getModelContainer().getEmfTransactionProvider().getCurrent();
            }
            catch (CoreException e) {
                Util.log(4, (Throwable)e, e.getMessage());
                return null;
            }
        }
        return null;
    }

    public static DatatypeManager getDatatypeManager() {
        DatatypeManager manager = registry.lookup(DEFAULT_DATATYPE_MANAGER_KEY, DatatypeManager.class);
        if (manager == null) {
            manager = registry.register(DEFAULT_DATATYPE_MANAGER_KEY, ModelerCore.createDatatypeManager());
        }
        return manager;
    }

    public static DatatypeManager getDatatypeManager(EObject object) {
        return ModelerCore.getDatatypeManager(object, false);
    }

    public static DatatypeManager getDatatypeManager(EObject object, boolean defaultToWorkspaceMgr) {
        if (defaultToWorkspaceMgr && object == null) {
            return ModelerCore.getWorkspaceDatatypeManager();
        }
        CoreArgCheck.isNotNull((Object)object);
        DatatypeManager datatypeManager = registry.lookup(DEFAULT_DATATYPE_MANAGER_KEY, DatatypeManager.class);
        if (datatypeManager != null) {
            return datatypeManager;
        }
        DatatypeManager result = null;
        Container container = ModelerCore.getContainer(object);
        if (container != null) {
            result = container.getDatatypeManager();
        }
        if (defaultToWorkspaceMgr && result == null) {
            result = ModelerCore.getWorkspaceDatatypeManager();
        }
        return result;
    }

    private static Map getDefaultContainerOptions() {
        HashMap<String, XMLMapImpl> options = new HashMap<String, XMLMapImpl>();
        Configuration configuration = registry.lookup(CONFIGURATION_KEY, Configuration.class);
        if (ModelerCore.getPlugin() != null && configuration != null) {
            XMLMapImpl xmlMap = new XMLMapImpl();
            for (ExtensionDescriptor descriptor : configuration.getResourceLoadOptions()) {
                ResourceLoadOptionContributor optionContributor = (ResourceLoadOptionContributor)descriptor.getExtensionClassInstance();
                if (optionContributor == null) continue;
                optionContributor.addMappings((XMLResource.XMLMap)xmlMap);
            }
            options.put("XML_MAP", xmlMap);
        }
        return options;
    }

    public static IEclipsePreferences getDefaultPreferences(String pluginId) {
        CoreArgCheck.isNotNull((Object)pluginId, (String)"pluginId");
        return new DefaultScope().getNode(pluginId);
    }

    public static synchronized Container getExternalResourceContainer() throws CoreException {
        Container externalResourceContainer = registry.lookup(EXTERNAL_RESOURCE_CONTAINER_KEY, Container.class);
        if (externalResourceContainer == null) {
            externalResourceContainer = ModelerCore.createEmptyContainer(EXTERNAL_RESOURCE_CONTAINER_KEY);
            registry.register(EXTERNAL_RESOURCE_CONTAINER_KEY, externalResourceContainer);
            ModelerCore.loadExternalResources(externalResourceContainer);
        }
        return externalResourceContainer;
    }

    public static synchronized List<ResourceSet> getExternalResourceSets() {
        List externalResourceSets = registry.lookup(EXTERNAL_RESOURCE_SETS_KEY, List.class);
        if (externalResourceSets == null) {
            externalResourceSets = registry.register(EXTERNAL_RESOURCE_SETS_KEY, new ArrayList());
            try {
                Container rsrcSet = ModelerCore.getExternalResourceContainer();
                if (rsrcSet != null) {
                    externalResourceSets.add(rsrcSet);
                }
            }
            catch (CoreException e) {
                Util.log(4, (Throwable)e, e.getMessage());
            }
            List desc = ModelerCore.getConfiguration().getExternalResourceSetDescriptors();
            for (ExtensionDescriptor descriptor : desc) {
                ResourceSet rsrcSet;
                ExternalResourceSet extRsrcSet = (ExternalResourceSet)descriptor.getExtensionClassInstance();
                if (extRsrcSet == null || (rsrcSet = extRsrcSet.getResourceSet()) == null) continue;
                externalResourceSets.add(rsrcSet);
            }
        }
        return externalResourceSets;
    }

    public static boolean isResourceInExternalResourceSet(Resource resource) {
        if (resource == null) {
            return false;
        }
        List<ResourceSet> sets = ModelerCore.getExternalResourceSets();
        if (sets == null || sets.isEmpty()) {
            return false;
        }
        for (ResourceSet set : sets) {
            if (resource.getResourceSet() != set) continue;
            return true;
        }
        return false;
    }

    public static List<InvocationFactoryHelper> getInvocationFactoryHelpers() {
        List invocationFactoryHelpers = registry.lookup(INVOCATION_FACTORY_HELPERS_KEY, List.class);
        if (invocationFactoryHelpers == null) {
            invocationFactoryHelpers = registry.register(INVOCATION_FACTORY_HELPERS_KEY, new ArrayList());
            List desc = ModelerCore.getConfiguration().getInvocationFactoryHelpers();
            for (ExtensionDescriptor descriptor : desc) {
                InvocationFactoryHelper helper = (InvocationFactoryHelper)descriptor.getExtensionClassInstance();
                if (helper == null) continue;
                invocationFactoryHelpers.add(helper);
            }
        }
        return invocationFactoryHelpers;
    }

    public static List getMappingAdapterDescriptors() {
        return ModelerCore.getConfiguration().getMappingAdapterDescriptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetamodelRegistry getMetamodelRegistry() {
        MetamodelRegistry metamodelRegistry = registry.lookup(METAMODEL_REGISTRY_KEY, MetamodelRegistry.class);
        if (metamodelRegistry != null) {
            return metamodelRegistry;
        }
        Object object = METAMODEL_REGISTRY_LOCK;
        synchronized (object) {
            StartupLogger.log(" ModelerCore - getMetamodelRegistry() Create Registry STARTED");
            Stopwatch watch = new Stopwatch();
            watch.start(true);
            metamodelRegistry = registry.lookup(METAMODEL_REGISTRY_KEY, MetamodelRegistry.class);
            if (metamodelRegistry != null) {
                return metamodelRegistry;
            }
            metamodelRegistry = registry.register(METAMODEL_REGISTRY_KEY, new MetamodelRegistryImpl());
            if (DEBUG_METAMODEL) {
                Util.log(1, Util.getString("ModelerCore.Registering_metamodel_descriptor(s)_in_the_MetamodelRegistry_1", (Object)ModelerCore.getConfiguration().getMetamodelDescriptors().size()));
            }
            for (MetamodelDescriptor descriptor : ModelerCore.getConfiguration().getMetamodelDescriptors()) {
                if (DEBUG_METAMODEL) {
                    Util.log(1, Util.getString("ModelerCore.Registering_metamodel", (Object)descriptor));
                }
                metamodelRegistry.register(descriptor);
            }
            watch.stop();
            StartupLogger.log(" ModelerCore - getMetamodelRegistry() Create Registry Finished", watch.getTotalDuration());
        }
        return metamodelRegistry;
    }

    public static Container getModelContainer() throws CoreException {
        Container defaultModelContainer = registry.lookup(DEFAULT_CONTAINER_KEY, Container.class);
        if (defaultModelContainer == null) {
            defaultModelContainer = ModelerCore.loadModelContainer();
            defaultModelContainer.start();
        }
        return defaultModelContainer;
    }

    public static ModelEditor getModelEditor() {
        ModelEditor modelEditor = registry.lookup(MODEL_EDITOR_KEY, ModelEditor.class);
        if (modelEditor == null) {
            modelEditor = registry.register(MODEL_EDITOR_KEY, new ModelEditorImpl());
        }
        return modelEditor;
    }

    public static ModelWorkspace getModelWorkspace() {
        return ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace();
    }

    public static ObjectID getObjectId(EObject object) {
        return ModelerCore.getModelEditor().getObjectID(object);
    }

    public static String getObjectIdString(EObject object) {
        return ModelerCore.getModelEditor().getObjectIdString(object);
    }

    public static Plugin getPlugin() {
        return MODELER_CORE_PLUGIN;
    }

    public static IEclipsePreferences getPreferences(String pluginId) {
        CoreArgCheck.isNotNull((Object)pluginId, (String)"pluginId");
        return new InstanceScope().getNode(pluginId);
    }

    static String getProducerName() {
        if (Platform.isRunning()) {
            Bundle bundle = Platform.getBundle((String)FEATURE_ID);
            Object name = bundle.getHeaders().get("Bundle-Name");
            return name.toString();
        }
        return "Teiid Designer";
    }

    public static synchronized Registry getRegistry() {
        return registry;
    }

    public static synchronized Resource[] getSystemVdbResources() {
        ArrayList<Resource> tmp = new ArrayList<Resource>();
        try {
            Container rsrcSet = ModelerCore.getExternalResourceContainer();
            if (rsrcSet != null) {
                for (Object element : rsrcSet.getResources()) {
                    Resource rsrc = (Resource)element;
                    if (rsrc == null || rsrc.getURI().lastSegment().indexOf("SYS") == -1) continue;
                    tmp.add(rsrc);
                }
            }
        }
        catch (CoreException e) {
            Util.log(4, (Throwable)e, e.getMessage());
        }
        Resource[] systemResources = new Resource[tmp.size()];
        tmp.toArray(systemResources);
        return systemResources;
    }

    public static TransformationPreferences getTransformationPreferences() {
        TransformationPreferences transformationPreferences = registry.lookup(TRANSFORMATION_PREFERENCES_KEY, TransformationPreferences.class);
        if (transformationPreferences == null) {
            transformationPreferences = registry.register(TRANSFORMATION_PREFERENCES_KEY, new TransformationPreferencesImpl());
        }
        return transformationPreferences;
    }

    public static ValidationPreferences getValidationPreferences() {
        ValidationPreferences validationPreferences = registry.lookup(VALIDATION_PREFERENCES_KEY, ValidationPreferences.class);
        if (validationPreferences == null) {
            validationPreferences = registry.register(VALIDATION_PREFERENCES_KEY, new ValidationPreferencesImpl());
        }
        return validationPreferences;
    }

    public static synchronized ValidationRuleManager getValidationRuleManager() {
        ValidationRuleManager validationRuleMgr = registry.lookup(VALIDATION_RULE_MANAGER_KEY, ValidationRuleManager.class);
        if (validationRuleMgr == null) {
            validationRuleMgr = registry.register(VALIDATION_RULE_MANAGER_KEY, new ValidationRuleManager());
        }
        return validationRuleMgr;
    }

    static String getVersion() {
        if (Platform.isRunning()) {
            Bundle bundle = Platform.getBundle((String)FEATURE_ID);
            Object version = bundle.getHeaders().get("Bundle-Version");
            String versionStr = version.toString();
            if (versionStr.endsWith(".qualifier")) {
                versionStr = versionStr.substring(0, versionStr.length() - 10);
            }
            return versionStr;
        }
        return "7.7.0";
    }

    public static IWorkspace getWorkspace() {
        IWorkspace workspace = registry.lookup(WORKSPACE_KEY, IWorkspace.class);
        if (workspace == null) {
            workspace = registry.register(WORKSPACE_KEY, ResourcesPlugin.getWorkspace());
        }
        return workspace;
    }

    public static DatatypeManager getWorkspaceDatatypeManager() {
        DatatypeManager datatypeManager = null;
        try {
            Container modelContainer = ModelerCore.getModelContainer();
            if (modelContainer != null) {
                datatypeManager = modelContainer.getDatatypeManager();
            }
        }
        catch (CoreException e) {
            throw new ModelerCoreRuntimeException((Throwable)e, Util.getString("ModelerCore.Error_creating_the_DatatypeManager_instance_1", new Object[0]));
        }
        return datatypeManager;
    }

    public static boolean hasModelNature(IProject project) {
        return DotProjectUtils.isModelerProject(project);
    }

    public static boolean ignoreValidationPreferencesOnBuild() {
        return IGNORE_VALIDATION_PREFERNCES_ON_BUILD;
    }

    private static void initializeXsdGlobalResourceSet() {
        StartupLogger.log(" ModelerCore - initializeXsdGlobalResourceSet() STARTED");
        Stopwatch watch = new Stopwatch();
        watch.start(true);
        XSDSchemaImpl.getMagicSchemaForSchema((String)XML_SCHEMA_GENERAL_URI);
        watch.stop();
        StartupLogger.log(" ModelerCore - initializeXsdGlobalResourceSet() calling XSDSchemaImpl.getMagicSchemaForSchema()", watch.getTotalDuration());
        watch.start(true);
        XSDSchemaImpl.getSchemaForSchema((String)XML_SCHEMA_GENERAL_URI);
        watch.stop();
        StartupLogger.log(" ModelerCore - initializeXsdGlobalResourceSet() calling XSDSchemaImpl.getSchemaForSchema()", watch.getTotalDuration());
        watch.start(true);
        XSDSchemaImpl.getSchemaInstance((String)XML_SCHEMA_INSTANCE_GENERAL_URI);
        watch.stop();
        StartupLogger.log(" ModelerCore - initializeXsdGlobalResourceSet() calling XSDSchemaImpl.getSchemaInstance()", watch.getTotalDuration());
        StartupLogger.log(" ModelerCore - initializeXsdGlobalResourceSet() FINISHED");
    }

    public static boolean isModelContainer(Container container) {
        return container == registry.lookup(DEFAULT_CONTAINER_KEY, Container.class);
    }

    public static boolean isReservedProjectName(String proposedName) {
        if (CoreStringUtil.isEmpty((String)proposedName)) {
            return false;
        }
        String[] stringArray = RESERVED_PROJECT_NAMES;
        int n = RESERVED_PROJECT_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String reservedProjectName = stringArray[n2];
            if (reservedProjectName.equalsIgnoreCase(proposedName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void loadExternalResources(Container container) {
        ExternalResourceLoader loader = new ExternalResourceLoader();
        List desc = ModelerCore.getConfiguration().getExternalResourceDescriptors();
        for (ExternalResourceDescriptor descriptor : desc) {
            try {
                loader.load(descriptor, container);
            }
            catch (ModelerCoreException e) {
                Util.log(4, (Throwable)e, Util.getString("ModelerCore.Error_loading_external_resource_1", new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Container loadModelContainer() throws CoreException {
        Container defaultContainer = registry.lookup(DEFAULT_CONTAINER_KEY, Container.class);
        if (defaultContainer != null) {
            return defaultContainer;
        }
        Object object = CONTAINER_LOCK;
        synchronized (object) {
            defaultContainer = registry.lookup(DEFAULT_CONTAINER_KEY, Container.class);
            if (defaultContainer == null) {
                defaultContainer = ModelerCore.createContainer(DEFAULT_CONTAINER_KEY, RegistryOption.REGISTER);
            }
            return defaultContainer;
        }
    }

    public static boolean makeHidden(IProject project) {
        boolean success = true;
        try {
            if (!project.hasNature(HIDDEN_PROJECT_NATURE_ID)) {
                IProjectDescription description = project.getDescription();
                String[] natures = description.getNatureIds();
                String[] newNatures = new String[natures.length + 1];
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = HIDDEN_PROJECT_NATURE_ID;
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
            }
        }
        catch (CoreException e) {
            Util.log((Throwable)e);
            success = false;
        }
        return success;
    }

    public static void rollbackTxn() {
        try {
            UnitOfWork uow = ModelerCore.getCurrentUoW();
            if (uow != null) {
                uow.rollback();
            }
        }
        catch (ModelerCoreException e) {
            Util.log(4, (Throwable)e, e.getMessage());
        }
    }

    public static void savePreferences(String pluginId) throws BackingStoreException {
        CoreArgCheck.isNotNull((Object)pluginId, (String)"pluginId");
        new DefaultScope().getNode(pluginId).flush();
        new InstanceScope().getNode(pluginId).flush();
    }

    public static void setIgnoreValidationPreferencesOnBuild(boolean ignorePrefs) {
        IGNORE_VALIDATION_PREFERNCES_ON_BUILD = ignorePrefs;
    }

    public static void setObjectId(EObject object, ObjectID objectId) {
        ModelerCore.getModelEditor().setObjectID(object, objectId);
    }

    public static void setObjectId(EObject object, String objectId) {
        ModelerCore.getModelEditor().setObjectID(object, objectId);
    }

    public static boolean startTxn(boolean isSignificant, boolean isUndoable, String description, Object source) {
        try {
            UnitOfWork uow = ModelerCore.getCurrentUoW();
            if (uow != null && uow.requiresStart()) {
                uow.begin();
                uow.setSignificant(isSignificant);
                uow.setDescription(description);
                uow.setSource(source);
                uow.setUndoable(isUndoable);
                return true;
            }
        }
        catch (ModelerCoreException modelerCoreException) {
            return false;
        }
        return false;
    }

    @Deprecated
    public static boolean startTxn(boolean isSignificant, String description) {
        return ModelerCore.startTxn(isSignificant, description, null);
    }

    public static boolean startTxn(boolean isSignificant, String description, Object source) {
        return ModelerCore.startTxn(isSignificant, true, description, source);
    }

    public static boolean startTxn(String description, Object source) {
        return ModelerCore.startTxn(true, true, description, source);
    }

    public static void testLoadModelContainer() throws CoreException {
        ModelerCore.loadModelContainer();
    }

    public static UUID workspaceUuid() {
        return registry.lookup(UUID_KEY, UUID.class);
    }

    public ModelerCore() {
        MODELER_CORE_PLUGIN = this;
        this.refactorListeners = new CopyOnWriteArrayList();
    }

    public boolean addRefactorResourceListener(IRefactorResourceListener listener) {
        CoreArgCheck.isNotNull((Object)listener, (String)"listener");
        return this.refactorListeners.addIfAbsent(listener);
    }

    public void notifyRefactored(RefactorResourceEvent event) {
        for (IRefactorResourceListener listener : this.refactorListeners) {
            try {
                listener.notifyRefactored(event);
            }
            catch (Exception e) {
                Util.log((Throwable)e);
            }
        }
    }

    public boolean removeRefactorResourceListener(IRefactorResourceListener listener) {
        CoreArgCheck.isNotNull((Object)listener, (String)"listener");
        return this.refactorListeners.remove(listener);
    }

    public void start() throws Exception {
        Stopwatch watch = new Stopwatch();
        watch.start();
        StartupLogger.log(" ModelerCore.startup() STARTED");
        CoreModelerPlugin.setTransactionManager((DeclarativeTransactionManager)this);
        try {
            ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
        }
        catch (Throwable t) {
            Util.log(4, Util.getString("ModelerCore.Error_encountered_initializing_the_platform_logger_1", (Object)t.getMessage()));
        }
        Util.checkJre(MINIMUM_JAVA_VERSION);
        try {
            EclipseConfigurationBuilder.build(ModelerCore.getConfiguration());
        }
        catch (Throwable t) {
            Util.log(4, Util.getString("ModelerCore.Error_encountered_building_the_Eclipse_configuration_2", (Object)t.getMessage()));
        }
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            this.saveParticipant = new ModelWorkspaceManagerSaveParticipant();
            workspace.addSaveParticipant((Plugin)this, this.saveParticipant);
        }
        catch (Throwable throwable) {
            Util.log(4, Util.getString("ModelerCore.Error_encountered_starting_ModelWorkspaceManager", new Object[0]));
        }
        ModelerCore.initializeXsdGlobalResourceSet();
        ModelerCore.loadModelContainer();
        ModelerCore.getValidationPreferences();
        File file = this.getStateLocation().append(WORKSPACE_UUID_FILE).toFile();
        WorkspaceUUIDService.getInstance().setRestoreLocation(file);
        registry.register(UUID_KEY, WorkspaceUUIDService.getInstance().getUUID());
        watch.stop();
        StartupLogger.log(" ModelerCore.startup() FINISHED", watch.getTotalDuration());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.start();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        registry.unregister(DEFAULT_CONTAINER_KEY);
        MetamodelRegistry metamodelRegistry = registry.lookup(METAMODEL_REGISTRY_KEY, MetamodelRegistry.class);
        if (metamodelRegistry != null) {
            metamodelRegistry.dispose();
            registry.unregister(METAMODEL_REGISTRY_KEY);
        }
        IWorkspace workspace = ModelerCore.getWorkspace();
        workspace.removeSaveParticipant((Plugin)this);
        IStatus wsMgrProblem = null;
        try {
            ModelWorkspaceManager.shutdown();
        }
        catch (CoreException e) {
            wsMgrProblem = e.getStatus();
        }
        if (wsMgrProblem != null) {
            String msg = Util.getString("ModelerCore.One_or_more_errors_shutting_down_ModelerCore_1", new Object[0]);
            ModelStatusImpl multiStat = new ModelStatusImpl(1, msg);
            multiStat.add(wsMgrProblem);
            throw new ModelWorkspaceException(multiStat);
        }
    }

    public static boolean hasDefaultTeiidServer() {
        return ModelerCore.getTeiidServerManager().getDefaultServer() != null;
    }

    public static String getDefaultServerName() {
        ITeiidServer defaultTeiidServer = ModelerCore.getTeiidServerManager().getDefaultServer();
        if (defaultTeiidServer == null) {
            return Util.getString(String.valueOf(I18N_PREFIX) + "noDefaultServer", new Object[0]);
        }
        return defaultTeiidServer.getParentName();
    }

    public static boolean isDefaultTeiidConnected() {
        ITeiidServer defaultTeiidServer = ModelerCore.getTeiidServerManager().getDefaultServer();
        if (defaultTeiidServer == null) {
            return false;
        }
        return defaultTeiidServer.isConnected();
    }

    public static boolean isDefaultParentConnected() {
        ITeiidServer defaultTeiidServer = ModelerCore.getTeiidServerManager().getDefaultServer();
        if (defaultTeiidServer == null) {
            return false;
        }
        return defaultTeiidServer.isParentConnected();
    }

    public static EventManager getDefaultServerEventManager() {
        return ModelerCore.getTeiidServerManager();
    }

    public static Event createDefaultTeiidServerEvent() {
        Event event = new Event();
        event.data = ModelerCore.getTeiidServerManager().getDefaultServer();
        return event;
    }

    public static ITeiidServerVersion getTeiidServerVersion() {
        return ModelerCore.getTeiidServerManager().getDefaultServerVersion();
    }

    public static String getTeiidRuntimePath() throws Exception {
        ITeiidServerVersion version = ModelerCore.getTeiidServerVersion();
        IExecutionAdminFactory adminFactory = TeiidRuntimeRegistry.getInstance().getExecutionAdminFactory(version);
        if (adminFactory == null) {
            throw new Exception(Util.getString("ModelerCore.cannotFindTeiidClientRuntimePath", new Object[0]));
        }
        return adminFactory.getRuntimePluginPath();
    }

    public static void addTeiidServerVersionListener(ITeiidServerVersionListener listener) {
        if (ModelerCore.getTeiidServerManager() == null) {
            throw new IllegalStateException();
        }
        ModelerCore.getTeiidServerManager().addTeiidServerVersionListener(listener);
    }

    public static void removeTeiidServerVersionListener(ITeiidServerVersionListener listener) {
        if (ModelerCore.getTeiidServerManager() == null) {
            throw new IllegalStateException();
        }
        ModelerCore.getTeiidServerManager().removeTeiidServerVersionListener(listener);
    }

    public static IDataTypeManagerService getTeiidDataTypeManagerService() {
        try {
            return TeiidRuntimeRegistry.getInstance().getDataTypeManagerService(ModelerCore.getTeiidServerManager().getDefaultServerVersion());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static IQueryService getTeiidQueryService() {
        try {
            return TeiidRuntimeRegistry.getInstance().getQueryService(ModelerCore.getTeiidServerManager().getDefaultServerVersion());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static IExecutionAdminFactory.SupportLevel getTeiidSupportLevel(ITeiidServerVersion teiidVersion) {
        try {
            IExecutionAdminFactory factory = TeiidRuntimeRegistry.getInstance().getExecutionAdminFactory(teiidVersion);
            return factory.supports(teiidVersion);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ModelResource createModelResource(IPath location, String modelName) {
        IResource resource = ModelerCore.getWorkspace().getRoot().findMember(location);
        IProject project = location.segmentCount() == 1 ? (IProject)resource : resource.getProject();
        IPath relativeModelPath = resource.getFullPath().removeFirstSegments(1).append(modelName);
        IFile modelFile = project.getFile(relativeModelPath);
        ModelResource resrc = ModelerCore.create(modelFile);
        return resrc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITeiidServerManager getTeiidServerManager() {
        Object object = mutexObject;
        synchronized (object) {
            if (teiidServerManager == null) {
                IExtensionRegistryCallback<ITeiidServerManager> callback = new IExtensionRegistryCallback<ITeiidServerManager>(){

                    public String getExtensionPointId() {
                        return "org.teiid.designer.spi.teiidServerManager";
                    }

                    public String getElementId() {
                        return "serverManager";
                    }

                    public String getAttributeId() {
                        return "class";
                    }

                    public boolean isSingle() {
                        return true;
                    }

                    public void process(ITeiidServerManager instance, IConfigurationElement element) {
                        CoreArgCheck.isNotNull((Object)instance);
                        if (teiidServerManager != null) {
                            throw new IllegalStateException();
                        }
                        teiidServerManager = instance;
                        instance.restoreState();
                    }
                };
                try {
                    ExtensionRegistryUtils.createExtensionInstances((IExtensionRegistryCallback)callback);
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        return teiidServerManager;
    }

    public static void setTeiidServerManager(ITeiidServerManager teiidServerManager) {
        ModelerCore.teiidServerManager = teiidServerManager;
    }

    public static class EXTENSION {
        public static final String METAMODEL_SERVICE_ID = "org.teiid.designer.core.metamodelService";
        public static final String XMI_STREAM_READER_ID = "org.teiid.designer.core.xmiStreamReader";
        public static final String XMI_STREAM_WRITER_ID = "org.teiid.designer.core.xmiStreamWriter";
        public static final String XMI_RESOURCE_FACTORY_ID = "org.teiid.designer.core.xmiResourceFactory";
        public static final String BUILDER_ID = "org.teiid.designer.core.modelBuilder";
        public static final String NATURE_ID = "org.teiid.designer.core.modelNature";
    }

    public static class EXTENSION_POINT {

        public static class ASSOCIATION_PROVIDER {
            public static final String ID = "associationProvider";
            public static final String UNIQUE_ID = "org.teiid.designer.core.associationProvider";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String PROVIDER_CLASS = "providerClass";
            }
        }

        public static class DATATYPE_MANAGER {
            public static final String ID = "datatypeManager";
            public static final String UNIQUE_ID = "org.teiid.designer.core.datatypeManager";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
            }
        }

        public static class DEPENDENCY_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "dependencyAspect";
            public static final String UNIQUE_ID = "org.teiid.designer.core.dependencyAspect";
        }

        public static class EOBJECT_MATCHER_FACTORY {
            public static final String ID = "eobjectMatcherFactory";
            public static final String UNIQUE_ID = "org.teiid.designer.core.eobjectMatcherFactory";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
            }
        }

        public static class EXTERNAL_RESOURCE {
            public static final String ID = "externalResource";
            public static final String UNIQUE_ID = "org.teiid.designer.core.externalResource";

            public static class ATTRIBUTES {
                public static final String LOAD_IMMEDIATELY = "loadImmediately";
            }

            public static class ELEMENTS {
                public static final String RESOURCE_NAME = "resourceName";
                public static final String RESOURCE_URL = "resourceUrl";
                public static final String INTERNAL_URI = "internalUri";
                public static final String PRIORITY = "priority";
                public static final String PROPERTIES = "properties";
            }
        }

        public static class EXTERNAL_RESOURCE_SET {
            public static final String ID = "externalResourceSet";
            public static final String UNIQUE_ID = "org.teiid.designer.core.externalResourceSet";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
                public static final String PROPERTIES = "properties";
            }
        }

        public static class FEATURE_CONSTRAINT_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "featureConstraintAspect";
            public static final String UNIQUE_ID = "org.teiid.designer.core.featureConstraintAspect";
        }

        public static class IMPORT_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "importAspect";
            public static final String UNIQUE_ID = "org.teiid.designer.core.importAspect";
        }

        public static class INVOCATION_FACTORY_HELPER {
            public static final String ID = "invocationFactoryHelper";
            public static final String UNIQUE_ID = "org.teiid.designer.core.invocationFactoryHelper";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
            }
        }

        public static class ITEM_PROVIDER_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "itemProviderAspect";
            public static final String UNIQUE_ID = "org.teiid.designer.core.itemProviderAspect";
        }

        public static class METAMODEL {
            public static final String ID = "metamodel";
            public static final String UNIQUE_ID = "org.teiid.designer.core.metamodel";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
                public static final String DESCRIPTION = "description";
                public static final String CLASS = "class";
                public static final String CREATE_AS_PHYSICAL = "createAsPhysical";
                public static final String CREATE_AS_VIRTUAL = "createAsVirtual";
                public static final String CREATE_AS_NEW_MODEL = "createAsNewModel";
                public static final String PARTICIPATORY_ONLY = "participatoryOnly";
                public static final String REQUIRES_PROXIES = "requiresProxies";
                public static final String ROOT_ENTITY_MAX_OCCURS = "maxOccurs";
                public static final String SUPPORTS_EXTENSION = "supportsExtension";
                public static final String SUPPORTS_DIAGRAMS = "supportsDiagrams";
            }

            public static class ELEMENTS {
                public static final String URI = "uri";
                public static final String DISPLAY_NAME = "displayName";
                public static final String ALTERNATE_URI = "alternateUri";
                public static final String PACKAGE_CLASS = "packageClass";
                public static final String ADAPTER_CLASS = "adapterClass";
                public static final String ROOT_ENTITY_CLASS = "rootEntityClass";
                public static final String ALLOWABLE_MODEL_TYPE = "allowableModelType";
                public static final String PROPERTIES = "properties";
                public static final String INITIALIZERS = "initializers";
                public static final String INITIALIZER = "initializer";
                public static final String FILE_EXTENSION = "fileExtension";
            }
        }

        public static class METAMODEL_ASPECT {
            protected static final String UML_DIAGRAM_ID = "umlDiagramAspect";
            protected static final String ITEM_PROVIDER_ID = "itemProviderAspect";
            protected static final String DEPENDENCY_ID = "dependencyAspect";
            protected static final String VALIDATION_ID = "validationAspect";
            protected static final String SQL_ID = "sqlAspect";
            protected static final String RELATIONSHIP_ID = "relationshipAspect";
            protected static final String FEATURE_CONSTRAINT_ID = "featureConstraintAspect";
            protected static final String IMPORT_ID = "importAspect";
            public static String[] ASPECT_IDS = new String[]{"umlDiagramAspect", "itemProviderAspect", "dependencyAspect", "validationAspect", "sqlAspect", "relationshipAspect", "featureConstraintAspect", "importAspect"};

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String METAMODEL_REF_ID = "metamodelExtensionID";
                public static final String FACTORY_CLASS = "factoryClass";
            }
        }

        public static class REFERENCE_UPDATOR {
            public static final String ID = "referenceUpdator";
            public static final String UNIQUE_ID = "org.teiid.designer.core.referenceUpdator";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
                public static final String PROPERTIES = "properties";
            }
        }

        public static class RELATIONSHIP_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "relationshipAspect";
            public static final String UNIQUE_ID = "org.teiid.designer.core.relationshipAspect";
        }

        public static class RESOURCE_FACTORY {
            public static final String ID = "resourceFactory";
            public static final String UNIQUE_ID = "org.teiid.designer.core.resourceFactory";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
                public static final String FILE_EXTENSION = "fileExtension";
                public static final String PROTOCOL = "protocol";
            }
        }

        public static class RESOURCE_INDEXER {
            public static final String ID = "resourceIndexer";
            public static final String UNIQUE_ID = "org.teiid.designer.core.resourceIndexer";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
                public static final String PROPERTIES = "properties";
            }
        }

        public static class RESOURCE_LOAD_OPTIONS {
            public static final String ID = "resourceLoadOptions";
            public static final String UNIQUE_ID = "org.teiid.designer.core.resourceLoadOptions";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
            }
        }

        public static class RESOURCE_VALIDATOR {
            public static final String ID = "resourceValidator";
            public static final String UNIQUE_ID = "org.teiid.designer.core.resourceValidator";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
                public static final String PROPERTIES = "properties";
            }
        }

        public static class SQL_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "sqlAspect";
            public static final String UNIQUE_ID = "org.teiid.designer.core.sqlAspect";
        }

        public static class STREAM_READER {
            public static final String ID = "streamReader";
            public static final String UNIQUE_ID = "org.teiid.designer.core.streamReader";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
            }
        }

        public static class STREAM_WRITER {
            public static final String ID = "streamWriter";
            public static final String UNIQUE_ID = "org.teiid.designer.core.streamWriter";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
            }
        }

        public static class UML_DIAGRAM_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "umlDiagramAspect";
            public static final String UNIQUE_ID = "org.teiid.designer.core.umlDiagramAspect";
        }

        public static class VALIDATION {
            public static final String ID = "modelValidation";
            public static final String UNIQUE_ID = "org.teiid.designer.core.modelValidation";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
                public static final String LABEL = "label";
                public static final String TOOL_TIP = "toolTip";
                public static final String CATEGORY = "category";
                public static final String DEFAULT = "default";
            }

            public static class ELEMENTS {
                public static final String PREFERENCE = "preference";
            }
        }

        public static class VALIDATION_ASPECT
        extends METAMODEL_ASPECT {
            public static final String ID = "validationAspect";
            public static final String UNIQUE_ID = "org.teiid.designer.core.validationAspect";
        }
    }

    public static interface ILicense {
        public static final String PRODUCER_NAME = ModelerCore.getProducerName();
        public static final String VERSION = ModelerCore.getVersion();
    }

    public static enum RegistryOption {
        REGISTER,
        NO_REGISTER;

    }
}

