/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.core.ExternalResourceDescriptor;
import org.teiid.designer.core.ExternalResourceDescriptorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ContainerImpl;
import org.teiid.designer.core.workspace.ModelFileUtil;

public class ExternalResourceLoader {
    private static final String BUNDLE_RESOURCE_URL = "bundleresource://";
    protected static final String EXTENSION_CHAR = ".";
    protected static final String SUFFIX_JAR = ".JAR";
    protected static final String SUFFIX_ZIP = ".ZIP";
    protected static final String SUFFIX_VDB = ".VDB";

    public Resource load(ExternalResourceDescriptor descriptor, Container container) throws ModelerCoreException {
        if (descriptor == null) {
            CoreArgCheck.isNotNull((Object)descriptor, (String)ModelerCore.Util.getString("ExternalResourceLoader.The_ExternalResourceDescriptor_reference_may_not_be_null_1", new Object[0]));
        }
        if (container == null) {
            CoreArgCheck.isNotNull((Object)container, (String)ModelerCore.Util.getString("ExternalResourceLoader.The_Container_reference_may_not_be_null_2", new Object[0]));
        }
        this.validateDescriptor(descriptor);
        String resourceUrl = descriptor.getResourceUrl();
        String resourceName = descriptor.getResourceName();
        String internalUri = descriptor.getInternalUri();
        String tempDirPath = this.getTempDirectoryPath(descriptor);
        File resourceFile = this.retrieveResourceFile(resourceUrl, resourceName, tempDirPath);
        if (resourceFile == null) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.An_existing_resource_with_the_name_cannot_retrieved_from_{1}._7", new Object[]{resourceName, resourceUrl}));
        }
        if (!ModelFileUtil.isModelFile((File)resourceFile)) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.The_external_resource_with_the_name_is_not_a_model_resource._8", (Object)resourceName));
        }
        return this.loadResource(container, resourceFile, internalUri);
    }

    public void validateDescriptor(ExternalResourceDescriptor descriptor) throws ModelerCoreException {
        if (descriptor == null) {
            CoreArgCheck.isNotNull((Object)descriptor, (String)ModelerCore.Util.getString("ExternalResourceLoader.The_ExternalResourceDescriptor_reference_may_not_be_null_1", new Object[0]));
        }
        if (descriptor.getResourceUrl() == null || descriptor.getResourceUrl().length() == 0) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.The_ExternalResourceDescriptor_may_not_have_a_null_or_empty_resource_URL_string_3", new Object[0]));
        }
        if (descriptor.getResourceName() == null || descriptor.getResourceName().length() == 0) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.The_ExternalResourceDescriptor_may_not_have_a_null_or_empty_resource_name_string_4", new Object[0]));
        }
        String resourceUrl = descriptor.getResourceUrl();
        String resourceName = descriptor.getResourceName();
        if (!resourceUrl.startsWith(BUNDLE_RESOURCE_URL)) {
            File f = new File(resourceUrl);
            if (!f.exists()) {
                URL url = ClassLoader.getSystemResource(resourceUrl);
                if (url == null) {
                    throw new IllegalArgumentException(ModelerCore.Util.getString("ExternalResourceLoader.The_resource_with_name_and_location_cannot_be_found_on_the_file_system._2", new Object[]{resourceName, resourceUrl}));
                }
                String loc = url.getPath();
                ((ExternalResourceDescriptorImpl)descriptor).setResourceUrl(loc);
                f = new File(loc);
            }
            if (!(this.isArchiveFileName(resourceUrl) || f.isDirectory() || f.isFile() && f.getName().equalsIgnoreCase(resourceName))) {
                throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.The_resource_with_name_and_location_cannot_be_processed_by_the_loader._6", new Object[]{resourceName, resourceUrl}));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private File retrieveResourceFile(String resourceUrl, String resourceName, String tempDirectoryPath) throws ModelerCoreException {
        resourceFile = null;
        if (resourceUrl.startsWith("bundleresource://")) {
            fileName = CoreStringUtil.getLastToken((String)resourceUrl, (String)"/");
            resourceFile = new File(tempDirectoryPath, fileName);
            if (!resourceFile.exists()) {
                try {
                    FileUtils.write((InputStream)new URL(resourceUrl).openStream(), (File)resourceFile);
                }
                catch (IOException v0) {
                    throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.An_existing_resource_with_the_name_cannot_retrieved_from_{1}._7", new Object[]{resourceName, resourceUrl}));
                }
            } else {
                try {
                    if (ExternalResourceLoader.contentEquals(new FileInputStream(resourceFile), new URL(resourceUrl).openStream())) ** GOTO lbl21
                    FileUtils.write((InputStream)new URL(resourceUrl).openStream(), (File)resourceFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.An_existing_resource_with_the_name_cannot_retrieved_from_{1}._7", new Object[]{resourceName, resourceUrl}));
                }
            }
        } else {
            resourceFile = new File(resourceUrl);
            if (resourceFile.isDirectory()) {
                return this.retrieveResourceFromFolder(resourceFile, resourceName);
            }
        }
lbl21:
        // 5 sources

        if (this.isArchiveFileName(resourceFile.getAbsolutePath())) {
            return this.retrieveResourceFromZip(resourceFile, resourceName, tempDirectoryPath);
        }
        return resourceFile;
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    protected Resource loadResource(Container container, File resourceFile, String internalUri) throws ModelerCoreException {
        if (resourceFile == null) {
            CoreArgCheck.isNotNull((Object)resourceFile, (String)ModelerCore.Util.getString("ExternalResourceLoader.The_java.io.File_reference_may_not_be_null_11", new Object[0]));
        }
        if (!resourceFile.exists()) {
            CoreArgCheck.isTrue((boolean)resourceFile.exists(), (String)ModelerCore.Util.getString("ExternalResourceLoader.The_java.io.File_reference_must_exist_12", new Object[0]));
        }
        try {
            ResourceSet resourceSet;
            Resource.Factory resourceFactory;
            URI physicalURI = URI.createFileURI((String)resourceFile.getAbsolutePath());
            URI logicalURI = null;
            if (internalUri != null && internalUri.length() > 0) {
                logicalURI = URI.createURI((String)internalUri);
            }
            Resource externalResource = null;
            if (logicalURI != null && container instanceof ContainerImpl && (resourceFactory = (resourceSet = ((ContainerImpl)container).getResourceSet()).getResourceFactoryRegistry().getFactory(physicalURI)) != null) {
                externalResource = resourceFactory.createResource(logicalURI);
                resourceSet.getResources().add((Object)externalResource);
                FileInputStream fis = null;
                InputStream bis = null;
                try {
                    fis = new FileInputStream(resourceFile);
                    bis = new BufferedInputStream(fis);
                    Map options = externalResource.getResourceSet() != null ? externalResource.getResourceSet().getLoadOptions() : Collections.EMPTY_MAP;
                    externalResource.load(bis, options);
                }
                finally {
                    if (bis != null) {
                        bis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
            if (externalResource == null) {
                externalResource = container.getResource(physicalURI, true);
                if (logicalURI != null) {
                    container.getURIConverter().getURIMap().put(logicalURI, physicalURI);
                }
            }
            return externalResource;
        }
        catch (Throwable e) {
            throw new ModelerCoreException(e, ModelerCore.Util.getString("ExternalResourceLoader.Error_loading_the_external_resource_into_the_container._13", (Object)resourceFile));
        }
    }

    protected File retrieveResourceFromFolder(File folder, String fileName) throws ModelerCoreException {
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (f.isFile() && f.exists() && f.getName().equalsIgnoreCase(fileName)) {
                return f;
            }
            ++i;
        }
        throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.An_existing_file_with_the_name_cannot_be_found_under_the_directory._14", new Object[]{fileName, folder}));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File retrieveResourceFromZip(File zip, String zipEntryName, String tempDirectoryLocation) throws ModelerCoreException {
        zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            entries = zipFile.entries();
            ** GOTO lbl-1000
        }
        catch (Throwable e) {
            throw new ModelerCoreException(e, ModelerCore.Util.getString("ExternalResourceLoader.An_existing_entry_with_the_name_cannot_be_found_in_the_archive._16", new Object[]{zipEntryName, zip}));
        }
        catch (Throwable var14_18) {
            try {
                if (zipFile == null) throw var14_18;
                zipFile.close();
                throw var14_18;
            }
            catch (IOException v0) {}
            throw var14_18;
        }
lbl15:
        // 1 sources

        while (true) {
            try {
                if (zipFile == null) return var15_17;
                zipFile.close();
                return var15_17;
            }
            catch (IOException v1) {}
            return var15_17;
        }
lbl-1000:
        // 2 sources

        {
            while (entries.hasMoreElements() && (entry = entries.nextElement()) != null) {
                if (!entry.getName().equalsIgnoreCase(zipEntryName)) continue;
                inputStream = zipFile.getInputStream(entry);
                length = (int)entry.getSize();
                if (length >= 0) {
                    buffer = new byte[length];
                    offset = 0;
                    do {
                        n = inputStream.read(buffer, offset, length);
                        offset += n;
                    } while ((length -= n) > 0);
                } else {
                    buffer = new byte[1024];
                    while ((n = inputStream.read(buffer, 0, 1024)) >= 0) {
                    }
                }
                extractDirectory = new File(tempDirectoryLocation);
                if (!extractDirectory.exists()) {
                    extractDirectory.mkdir();
                }
                entryName = new Path(entry.getName()).lastSegment();
                entryFile = new File(extractDirectory + File.separator + entryName);
                entryFile.createNewFile();
                entryFile.deleteOnExit();
                outputStream = new FileOutputStream(entryFile);
                outputStream.write(buffer);
                outputStream.flush();
                outputStream.close();
                var15_17 = entryFile;
                ** continue;
lbl52:
                // 1 sources

                ** GOTO lbl15
            }
            throw new ModelerCoreException(ModelerCore.Util.getString("ExternalResourceLoader.An_existing_entry_with_the_name_cannot_be_found_in_the_archive._15", new Object[]{zipEntryName, zip}));
        }
    }

    protected String getTempDirectoryPath(ExternalResourceDescriptor descriptor) {
        if (descriptor == null) {
            CoreArgCheck.isNotNull((Object)descriptor, (String)ModelerCore.Util.getString("ExternalResourceLoader.The_ExternalResourceDescriptor_reference_may_not_be_null_1", new Object[0]));
        }
        CoreArgCheck.isInstanceOf(ExternalResourceDescriptorImpl.class, (Object)descriptor, (String)ModelerCore.Util.getString("ExternalResourceLoader.The_ExternalResourceDescriptor_must_be_an_instanceof_ExternalResourceDescriptorImpl_1", new Object[0]));
        ExternalResourceDescriptorImpl descriptorImpl = (ExternalResourceDescriptorImpl)descriptor;
        String tempDirPath = descriptorImpl.getTempDirectoryPath();
        if (tempDirPath == null || tempDirPath.length() == 0) {
            try {
                tempDirPath = File.createTempFile("temp", null).getParent();
            }
            catch (IOException iOException) {
                tempDirPath = System.getProperty("user.dir");
            }
        }
        return tempDirPath;
    }

    protected boolean isArchiveFileName(String name) {
        if (CoreStringUtil.isEmpty((String)name)) {
            return false;
        }
        String upperCaseName = name.toUpperCase();
        return upperCaseName.endsWith(SUFFIX_JAR) || upperCaseName.endsWith(SUFFIX_ZIP) || upperCaseName.endsWith(SUFFIX_VDB);
    }
}

