/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.jboss.tools.modeshape.jcr.MultiValidationStatus;
import org.jboss.tools.modeshape.jcr.ValidationStatus;
import org.jboss.tools.modeshape.jcr.cnd.CndImporter;
import org.jboss.tools.modeshape.jcr.cnd.CndValidator;
import org.jboss.tools.modeshape.jcr.cnd.CompactNodeTypeDefinition;
import org.jboss.tools.modeshape.jcr.ui.Activator;
import org.jboss.tools.modeshape.jcr.ui.JcrUiConstants;
import org.jboss.tools.modeshape.jcr.ui.JcrUiUtils;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndMessages;

public final class CndProjectBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible()) {
            return null;
        }
        CndVisitor visitor = new CndVisitor();
        if (6 == kind || this.getDelta(project) == null) {
            this.getProject().accept((IResourceVisitor)visitor);
        } else {
            IResourceDelta delta = this.getDelta(project);
            delta.accept((IResourceDeltaVisitor)visitor);
        }
        Collection<IFile> cndFilesToBuild = visitor.getCndFiles();
        monitor.beginTask(CndMessages.cndBuildTaskName, cndFilesToBuild.size());
        if (!cndFilesToBuild.isEmpty()) {
            MultiStatus status = new MultiStatus(JcrUiConstants.PLUGIN_ID, 0, null, null);
            for (IFile cndFile : cndFilesToBuild) {
                monitor.subTask(NLS.bind((String)CndMessages.cndBuildSubTaskName, (Object)cndFile.getName()));
                try {
                    try {
                        cndFile.deleteMarkers(null, true, 2);
                        ArrayList<Throwable> errors = new ArrayList<Throwable>();
                        CompactNodeTypeDefinition cnd = new CndImporter().importFrom(cndFile.getContents(), errors, cndFile.getName());
                        if (errors.isEmpty()) {
                            this.createMarkers(cndFile, CndValidator.validateCnd((CompactNodeTypeDefinition)cnd));
                        } else {
                            this.createMarkers(cndFile, errors);
                        }
                    }
                    catch (Exception e) {
                        Status cndStatus = new Status(4, JcrUiConstants.PLUGIN_ID, NLS.bind((String)CndMessages.cndFileParseError, (Object)cndFile.getName()), (Throwable)e);
                        status.add((IStatus)cndStatus);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        monitor.worked(1);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.worked(1);
                    throw throwable;
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.worked(1);
            }
            if (!status.isOK()) {
                Activator.getSharedInstance().getLog().log((IStatus)status);
            }
        }
        return null;
    }

    private void createMarker(IFile cndFile, int severity, String message) {
        assert (cndFile != null) : "file is null";
        assert (message != null && !message.isEmpty()) : "message is empty";
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("severity", severity);
        attributes.put("message", message);
        try {
            MarkerUtilities.createMarker((IResource)cndFile, attributes, (String)JcrUiConstants.WorkspaceIds.CND_PROBLEM_MARKER);
        }
        catch (CoreException e) {
            Activator.getSharedInstance().getLog().log((IStatus)new Status(4, JcrUiConstants.PLUGIN_ID, null, (Throwable)e));
        }
    }

    private void createMarkers(IFile cndFile, List<Throwable> errors) {
        assert (cndFile != null) : "file is null";
        if (errors == null || errors.isEmpty()) {
            return;
        }
        for (Throwable t : errors) {
            this.createMarker(cndFile, 2, t.getLocalizedMessage());
        }
    }

    private void createMarkers(IFile cndFile, MultiValidationStatus status) {
        if (status == null || status.isOk()) {
            return;
        }
        for (ValidationStatus validationStatus : status.getAll()) {
            if (validationStatus.isOk()) continue;
            if (validationStatus instanceof MultiValidationStatus) {
                this.createMarkers(cndFile, (MultiValidationStatus)validationStatus);
                continue;
            }
            this.createMarker(cndFile, JcrUiUtils.getMarkerSeverity(validationStatus), validationStatus.getMessage());
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        CndVisitor visitor = new CndVisitor();
        this.getProject().accept((IResourceVisitor)visitor);
        try {
            Collection<IFile> cndFilesToClean = visitor.getCndFiles();
            monitor.beginTask(CndMessages.cndCleanTaskName, cndFilesToClean.size());
            for (IFile cndFile : cndFilesToClean) {
                try {
                    monitor.subTask(NLS.bind((String)CndMessages.cndCleanSubTaskName, (Object)cndFile.getName()));
                    cndFile.deleteMarkers(null, true, 2);
                }
                finally {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.worked(1);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    class CndVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        private final Collection<IFile> cndFiles = new ArrayList<IFile>();

        CndVisitor() {
        }

        public Collection<IFile> getCndFiles() {
            return this.cndFiles;
        }

        public boolean visit(IResource resource) {
            if (JcrUiUtils.isCndFile(resource)) {
                this.cndFiles.add((IFile)resource);
            }
            return true;
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (JcrUiUtils.isCndFile(resource)) {
                this.cndFiles.add((IFile)resource);
            }
            return true;
        }
    }
}

