/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryParser;
import org.teiid.designer.query.IQueryResolver;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.sql.ICommandCollectorVisitor;
import org.teiid.designer.query.sql.IElementCollectorVisitor;
import org.teiid.designer.query.sql.IFunctionCollectorVisitor;
import org.teiid.designer.query.sql.IGroupCollectorVisitor;
import org.teiid.designer.query.sql.IGroupsUsedByElementsVisitor;
import org.teiid.designer.query.sql.IPredicateCollectorVisitor;
import org.teiid.designer.query.sql.IReferenceCollectorVisitor;
import org.teiid.designer.query.sql.IResolverVisitor;
import org.teiid.designer.query.sql.ISQLStringVisitor;
import org.teiid.designer.query.sql.ISQLStringVisitorCallback;
import org.teiid.designer.query.sql.IValueIteratorProviderCollectorVisitor;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.designer.query.sql.symbol.ISymbol;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.udf.FunctionMethodDescriptor;
import org.teiid.designer.udf.FunctionParameterDescriptor;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.designer.validator.IUpdateValidator;
import org.teiid.designer.validator.IValidator;
import org.teiid.designer.xml.IMappingDocumentFactory;
import org.teiid.language.SQLConstants;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.function.UDFSource;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.ProcedureReservedWords;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.CallbackSQLStringVisitor;
import org.teiid.query.sql.visitor.CommandCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.FunctionCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.SQLStringVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.validator.PredicateCollectorVisitor;
import org.teiid.query.validator.ReferenceCollectorVisitor;
import org.teiid.query.validator.UpdateValidator;
import org.teiid.query.validator.Validator;
import org.teiid.runtime.client.proc.ProcedureService;
import org.teiid.runtime.client.query.SyntaxFactory;
import org.teiid.runtime.client.xml.MappingDocumentFactory;

public class QueryService
implements IQueryService {
    private final ITeiidServerVersion teiidVersion;
    private QueryParser queryParser;
    private final SystemFunctionManager systemFunctionManager;
    private SyntaxFactory factory;

    public QueryService(ITeiidServerVersion teiidVersion) {
        this.teiidVersion = teiidVersion;
        this.systemFunctionManager = new SystemFunctionManager(teiidVersion, this.getClass().getClassLoader());
    }

    public IQueryParser getQueryParser() {
        if (this.queryParser == null) {
            this.queryParser = new QueryParser(this.teiidVersion);
        }
        return this.queryParser;
    }

    public boolean isReservedWord(String word) {
        return SQLConstants.isReservedWord(this.teiidVersion, word);
    }

    public boolean isProcedureReservedWord(String word) {
        return ProcedureReservedWords.isProcedureReservedWord(this.teiidVersion, word);
    }

    public Set<String> getReservedWords() {
        return SQLConstants.getReservedWords(this.teiidVersion);
    }

    public Set<String> getNonReservedWords() {
        return SQLConstants.getNonReservedWords(this.teiidVersion);
    }

    public String getJDBCSQLTypeName(int jdbcType) {
        return JDBCSQLTypeInfo.getTypeName(jdbcType);
    }

    public IFunctionLibrary createFunctionLibrary() {
        return new FunctionLibrary(this.teiidVersion, this.systemFunctionManager.getSystemFunctions(), new FunctionTree[0]);
    }

    public IFunctionLibrary createFunctionLibrary(List<FunctionMethodDescriptor> functionMethodDescriptors) {
        HashMap<String, FunctionTree> functionTrees = new HashMap<String, FunctionTree>();
        for (FunctionMethodDescriptor descriptor : functionMethodDescriptors) {
            ArrayList<FunctionParameter> inputParameters = new ArrayList<FunctionParameter>();
            FunctionParameterDescriptor[] functionParameterDescriptorArray = descriptor.getInputParameters();
            int n = functionParameterDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionParameterDescriptor paramDescriptor = functionParameterDescriptorArray[n2];
                inputParameters.add(new FunctionParameter(paramDescriptor.getName(), paramDescriptor.getType()));
                ++n2;
            }
            FunctionParameter outputParameter = new FunctionParameter(descriptor.getOutputParameter().getName(), descriptor.getOutputParameter().getType());
            FunctionMethod fMethod = new FunctionMethod(descriptor.getName(), descriptor.getDescription(), descriptor.getCategory(), descriptor.getInvocationClass(), descriptor.getInvocationMethod(), inputParameters.toArray(new FunctionParameter[0]), outputParameter);
            fMethod.setPushDown(descriptor.getPushDownLiteral());
            fMethod.setVarArgs(descriptor.isVariableArgs());
            if (descriptor.isDeterministic()) {
                fMethod.setDeterminism(FunctionMethod.Determinism.DETERMINISTIC);
            } else {
                fMethod.setDeterminism(FunctionMethod.Determinism.NONDETERMINISTIC);
            }
            FunctionTree tree = (FunctionTree)functionTrees.get(descriptor.getSchema());
            if (tree == null) {
                tree = new FunctionTree(this.teiidVersion, descriptor.getSchema(), new UDFSource(Collections.EMPTY_LIST, this.getClass().getClassLoader()), false);
                functionTrees.put(descriptor.getSchema(), tree);
            }
            FunctionDescriptor fd = tree.addFunction(descriptor.getSchema(), null, fMethod, false);
            fd.setMetadataID(descriptor.getMetadataID());
        }
        return new FunctionLibrary(this.teiidVersion, this.systemFunctionManager.getSystemFunctions(), functionTrees.values().toArray(new FunctionTree[0]));
    }

    public IQueryFactory createQueryFactory() {
        if (this.factory == null) {
            this.factory = new SyntaxFactory(((QueryParser)this.getQueryParser()).getTeiidParser());
        }
        return this.factory;
    }

    public IMappingDocumentFactory getMappingDocumentFactory() {
        this.getQueryParser();
        return new MappingDocumentFactory(this.queryParser.getTeiidParser());
    }

    public String getSymbolName(IExpression expression) {
        if (expression instanceof ISymbol) {
            return ((ISymbol)expression).getName();
        }
        return "expr";
    }

    public String getSymbolShortName(String name) {
        int index = name.lastIndexOf(".");
        if (index >= 0) {
            return name.substring(index + 1);
        }
        return name;
    }

    public String getSymbolShortName(IExpression expression) {
        if (expression instanceof ISymbol) {
            return ((ISymbol)expression).getShortName();
        }
        return "expr";
    }

    public SQLStringVisitor getSQLStringVisitor() {
        return new SQLStringVisitor(this.teiidVersion);
    }

    public ISQLStringVisitor getCallbackSQLStringVisitor(ISQLStringVisitorCallback visitorCallback) {
        return new CallbackSQLStringVisitor(this.teiidVersion, visitorCallback);
    }

    public IGroupCollectorVisitor getGroupCollectorVisitor(boolean removeDuplicates) {
        return new GroupCollectorVisitor(this.teiidVersion, removeDuplicates);
    }

    public IGroupsUsedByElementsVisitor getGroupsUsedByElementsVisitor() {
        return new GroupsUsedByElementsVisitor();
    }

    public IElementCollectorVisitor getElementCollectorVisitor(boolean removeDuplicates) {
        return new ElementCollectorVisitor(this.teiidVersion, removeDuplicates);
    }

    public ICommandCollectorVisitor getCommandCollectorVisitor() {
        return new CommandCollectorVisitor(this.teiidVersion);
    }

    public IFunctionCollectorVisitor getFunctionCollectorVisitor(boolean removeDuplicates) {
        return new FunctionCollectorVisitor(this.teiidVersion, removeDuplicates);
    }

    public IPredicateCollectorVisitor getPredicateCollectorVisitor() {
        return new PredicateCollectorVisitor(this.teiidVersion);
    }

    public IReferenceCollectorVisitor getReferenceCollectorVisitor() {
        return new ReferenceCollectorVisitor(this.teiidVersion);
    }

    public IValueIteratorProviderCollectorVisitor getValueIteratorProviderCollectorVisitor() {
        return new ValueIteratorProviderCollectorVisitor(this.teiidVersion);
    }

    public IResolverVisitor getResolverVisitor() {
        return new ResolverVisitor(this.teiidVersion);
    }

    public IValidator getValidator() {
        return new Validator();
    }

    public IUpdateValidator getUpdateValidator(IQueryMetadataInterface metadata, IUpdateValidator.TransformUpdateType tInsertType, IUpdateValidator.TransformUpdateType tUpdateType, IUpdateValidator.TransformUpdateType tDeleteType) {
        UpdateValidator.UpdateType insertType = UpdateValidator.UpdateType.valueOf(tInsertType.name());
        UpdateValidator.UpdateType updateType = UpdateValidator.UpdateType.valueOf(tUpdateType.name());
        UpdateValidator.UpdateType deleteType = UpdateValidator.UpdateType.valueOf(tDeleteType.name());
        return new UpdateValidator(metadata, insertType, updateType, deleteType);
    }

    public void resolveGroup(IGroupSymbol groupSymbol, IQueryMetadataInterface metadata) throws Exception {
        ResolverUtil.resolveGroup((GroupSymbol)groupSymbol, metadata);
    }

    public void fullyQualifyElements(ICommand command) {
        ResolverUtil.fullyQualifyElements((Command)command);
    }

    public IQueryResolver getQueryResolver() {
        this.getQueryParser();
        return new QueryResolver((QueryParser)this.getQueryParser());
    }

    public ProcedureService getProcedureService() {
        return new ProcedureService(this.teiidVersion);
    }
}

