/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.util.ArgCheck;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidVdb;
import org.teiid.runtime.client.admin.VdbManifestGenerator;

public class TeiidVdb
implements ITeiidVdb,
Comparable<TeiidVdb> {
    private static final String PREVIEW = "preview";
    private final VDB vdb;
    private final ITeiidServer teiidServer;
    private final boolean isPreview;
    private final boolean isDdlFileVdb;
    private final boolean isDynamic;

    public TeiidVdb(VDB vdb, ITeiidServer teiidServer) {
        ArgCheck.isNotNull(vdb, "vdb");
        ArgCheck.isNotNull(teiidServer, "teiidServer");
        this.vdb = vdb;
        this.teiidServer = teiidServer;
        this.isPreview = Boolean.parseBoolean(vdb.getProperties().getProperty(PREVIEW));
        this.isDynamic = ((VDBMetaData)vdb).isXmlDeployment();
        boolean ddlFileResult = false;
        if (!this.isDynamic) {
            for (Model mod : this.vdb.getModels()) {
                String schemaText = mod.getSchemaText();
                if (schemaText == null) continue;
                ddlFileResult = true;
                break;
            }
        }
        this.isDdlFileVdb = ddlFileResult;
    }

    @Override
    public int compareTo(TeiidVdb vdb) {
        ArgCheck.isNotNull(vdb, "vdb");
        return this.getName().compareTo(vdb.getName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ITeiidVdb other = (ITeiidVdb)obj;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public String getName() {
        return this.vdb.getName();
    }

    public String getDeployedName() {
        return this.getName();
    }

    public int getVersion() {
        return this.vdb.getVersion();
    }

    public boolean isPreviewVdb() {
        return this.isPreview;
    }

    public boolean isDynamicVdb() {
        return this.isDynamic;
    }

    public boolean isDdlFileVdb() {
        return this.isDdlFileVdb;
    }

    public boolean isActive() {
        return this.vdb.getStatus().equals((Object)VDB.Status.ACTIVE);
    }

    public boolean isLoading() {
        return this.vdb.getStatus().equals((Object)VDB.Status.LOADING);
    }

    public boolean hasFailed() {
        return this.vdb.getStatus().equals((Object)VDB.Status.FAILED);
    }

    public boolean wasRemoved() {
        return this.vdb.getStatus().equals((Object)VDB.Status.REMOVED);
    }

    public List<String> getValidityErrors() {
        List<String> errors = this.vdb.getValidityErrors();
        if (errors != null) {
            return Collections.unmodifiableList(errors);
        }
        return Collections.emptyList();
    }

    public boolean hasModels() {
        return !this.vdb.getModels().isEmpty();
    }

    public String getManifest() {
        VdbManifestGenerator generator = new VdbManifestGenerator(this.teiidServer, (VDBMetaData)this.vdb);
        return generator.getManifest();
    }

    public Collection<String> getModelNames() {
        if (!this.hasModels()) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Model model : this.vdb.getModels()) {
            names.add(model.getName());
        }
        return names;
    }

    public String getPropertyValue(String key) {
        return this.vdb.getPropertyValue(key);
    }
}

