/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client.admin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TeiidOptionsUtil {
    private static final String PREFIX = "OPTIONS (";
    public static final String UUID = "UUID";
    private static final char S_QUOTE = '\'';
    private static final char D_QUOTE = '\"';
    private static final List<Character> INVALID_ID_CHARS = Arrays.asList(Character.valueOf('/'), Character.valueOf(':'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('|'), Character.valueOf('*'));

    private static boolean isValidIdentifierCharacter(char c) {
        return !INVALID_ID_CHARS.contains(Character.valueOf(c));
    }

    public static String filterUuidsFromOptions(String ddl) throws Exception {
        StringBuilder sb = new StringBuilder();
        int indexOfOptions = ddl.indexOf(PREFIX);
        String remainingDdl = ddl;
        while (indexOfOptions > -1) {
            sb.append(remainingDdl.substring(0, indexOfOptions));
            remainingDdl = remainingDdl.substring(indexOfOptions);
            HashMap<String, String> options = new HashMap<String, String>();
            remainingDdl = TeiidOptionsUtil.parse(remainingDdl, options, true);
            String filteredOptions = TeiidOptionsUtil.getOptionsClause(options, true);
            if (filteredOptions != null) {
                sb.append(filteredOptions);
            }
            indexOfOptions = remainingDdl.indexOf(PREFIX);
        }
        sb.append(remainingDdl);
        return sb.toString();
    }

    private static String getOptionsClause(Map<String, String> options, boolean removeUuid) {
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIX);
        int nValues = options.size();
        int count = 0;
        boolean hasOptions = false;
        for (String key : options.keySet()) {
            if (key.equalsIgnoreCase(UUID)) continue;
            sb.append(key).append(" ").append(options.get(key));
            hasOptions = true;
            if (++count >= nValues - 1) continue;
            sb.append(", ");
        }
        if (hasOptions) {
            return sb.toString();
        }
        return null;
    }

    protected static String parse(String inputString, Map<String, String> options) throws Exception {
        return TeiidOptionsUtil.parse(inputString, options, false);
    }

    private static String parse(String inputString, Map<String, String> options, boolean keepQuotes) throws Exception {
        if (inputString == null || !inputString.startsWith(PREFIX)) {
            throw new Exception("OPTIONS clause must start with OPTIONS (");
        }
        if (options == null || !options.isEmpty()) {
            throw new Exception("Options map is null or not empty");
        }
        String text = inputString.trim();
        text = inputString.substring(PREFIX.length());
        if (text.isEmpty()) {
            throw new Exception("OPTIONS clause did not have closing paren");
        }
        String[] optionResult = null;
        String[] valueResult = null;
        boolean keepGoing = true;
        int i = -1;
        do {
            i = -1;
            optionResult = TeiidOptionsUtil.parseIdentifier(text, keepQuotes);
            valueResult = TeiidOptionsUtil.parseValue(optionResult[1], keepQuotes);
            options.put(optionResult[0], valueResult[0]);
            text = valueResult[1];
            char[] cArray = text.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                ++i;
                if (c == ')') {
                    keepGoing = false;
                    break;
                }
                if (c == ',') break;
                if (!Character.isWhitespace(c)) {
                    throw new Exception("OPTIONS clause need commas separating options");
                }
                ++n2;
            }
            if (i == text.length() - 1) {
                keepGoing = false;
                continue;
            }
            text = text.substring(i + 1);
        } while (keepGoing);
        if (text.charAt(i) != ')') {
            throw new Exception("OPTIONS clause does not have ending right paren");
        }
        return text.substring(++i);
    }

    protected static String[] parseIdentifier(String inputString) throws Exception {
        return TeiidOptionsUtil.parseIdentifier(inputString, false);
    }

    private static String[] parseIdentifier(String inputString, boolean keepQuotes) throws Exception {
        if (inputString == null || inputString.trim().isEmpty()) {
            throw new Exception("Cannot parse identifier when input string is empty");
        }
        String remainder = inputString.trim();
        String id = "";
        boolean foundBeginningSingleQuote = false;
        boolean foundEndingSingleQuote = false;
        boolean foundBeginningDoubleQuote = false;
        boolean foundEndingDoubleQuote = false;
        int i = 0;
        char[] cArray = remainder.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        block4: while (n2 < n) {
            char c = cArray[n2];
            if (Character.isWhitespace(c)) {
                if (!id.isEmpty()) {
                    ++i;
                    break;
                }
            } else if (!TeiidOptionsUtil.isValidIdentifierCharacter(c)) {
                throw new Exception("Option identifier has invalid character: " + c);
            }
            switch (c) {
                case '\'': {
                    if (foundBeginningSingleQuote) {
                        foundEndingSingleQuote = true;
                        id = String.valueOf(id) + c;
                        ++i;
                        break block4;
                    }
                    if (id.isEmpty() && !foundBeginningSingleQuote) {
                        foundBeginningSingleQuote = true;
                        id = String.valueOf(id) + c;
                        break;
                    }
                    throw new Exception("Found single quote embedded in identifier");
                }
                case '\"': {
                    if (foundBeginningDoubleQuote) {
                        foundEndingDoubleQuote = true;
                        id = String.valueOf(id) + c;
                        ++i;
                        break block4;
                    }
                    if (id.isEmpty() && !foundBeginningDoubleQuote) {
                        foundBeginningDoubleQuote = true;
                        id = String.valueOf(id) + c;
                        break;
                    }
                    throw new Exception("Found double quote embedded in identifier");
                }
                default: {
                    id = String.valueOf(id) + c;
                }
            }
            ++i;
            ++n2;
        }
        if (id.isEmpty()) {
            throw new Exception("No identifier found");
        }
        if (foundBeginningSingleQuote && !foundEndingSingleQuote) {
            throw new Exception("Identifier does not have an ending single quote");
        }
        if (foundBeginningDoubleQuote && !foundEndingDoubleQuote) {
            throw new Exception("Identifier does not have an ending double quote");
        }
        if (keepQuotes) {
            if (foundBeginningSingleQuote && foundEndingSingleQuote) {
                return new String[]{String.valueOf('\'') + id + '\'', remainder.substring(i)};
            }
            if (foundBeginningDoubleQuote && foundEndingDoubleQuote) {
                return new String[]{String.valueOf('\"') + id + '\"', remainder.substring(i)};
            }
        }
        return new String[]{id, remainder.substring(i)};
    }

    private static String[] parseValue(String inputString) throws Exception {
        return TeiidOptionsUtil.parseValue(inputString, false);
    }

    private static String[] parseValue(String inputString, boolean keepQuotes) throws Exception {
        if (inputString == null || inputString.isEmpty()) {
            throw new Exception("Options value is null or empty");
        }
        boolean foundSingleFirst = false;
        boolean foundDoubleFirst = false;
        int startIndex = 0;
        char[] cArray = inputString.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isWhitespace(c)) break;
            ++startIndex;
            ++n2;
        }
        if (inputString.charAt(startIndex) == '\'') {
            String value = inputString.substring(startIndex);
            boolean foundDelimiter = false;
            int numSingle = 0;
            int numDouble = 0;
            int i = 0;
            char[] cArray2 = value.toCharArray();
            int n3 = cArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                char c = cArray2[n4];
                if (c == '\'') {
                    ++numSingle;
                    if (!foundDoubleFirst && !foundSingleFirst) {
                        foundSingleFirst = true;
                    }
                    if (value.length() - 1 == i && i != 0) {
                        ++i;
                        break;
                    }
                    char nextChar = value.charAt(i + 1);
                    if ((Character.isWhitespace(nextChar) || nextChar == ',' || nextChar == ')') && numSingle % 2 == 0 && numDouble % 2 == 0) {
                        ++i;
                        foundDelimiter = true;
                        break;
                    }
                } else if (c == '\"') {
                    ++numDouble;
                    if (!foundDoubleFirst && !foundSingleFirst) {
                        foundDoubleFirst = true;
                    }
                }
                ++i;
                ++n4;
            }
            int endIndex = i + startIndex;
            String leftOver = null;
            leftOver = foundDelimiter ? inputString.substring(endIndex) : "";
            return new String[]{inputString.substring(startIndex, endIndex), leftOver};
        }
        boolean foundDelimiter = false;
        int endIndex = 0;
        int i = startIndex;
        while (i < inputString.length()) {
            char c = inputString.charAt(i);
            if (Character.isWhitespace(c) || c == ',' || c == ')') {
                endIndex = i;
                foundDelimiter = true;
                break;
            }
            if (c == '\'' || c == '\"') {
                throw new Exception("Unquoted values cannot have quotes");
            }
            endIndex = i++;
        }
        String leftOver = null;
        if (foundDelimiter) {
            leftOver = inputString.substring(endIndex);
        } else {
            leftOver = "";
            ++endIndex;
        }
        if (keepQuotes) {
            if (foundSingleFirst) {
                return new String[]{String.valueOf('\'') + inputString.substring(startIndex, endIndex) + '\'', leftOver};
            }
            if (foundDoubleFirst) {
                return new String[]{String.valueOf('\"') + inputString.substring(startIndex, endIndex) + '\"', leftOver};
            }
        }
        return new String[]{inputString.substring(startIndex, endIndex), leftOver};
    }
}

