/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client.admin;

import java.util.Properties;
import org.teiid.core.util.ArgCheck;
import org.teiid.designer.runtime.spi.ITeiidDataSource;

public class TeiidDataSource
implements Comparable<TeiidDataSource>,
ITeiidDataSource {
    private final String displayName;
    private final String dataSourceName;
    private final String dataSourceType;
    private String connectionProfileName;
    private final Properties properties;
    private boolean isPreview = false;

    public TeiidDataSource(String displayName, String dataSourceName, String dataSourceType) {
        this(displayName, dataSourceName, dataSourceType, new Properties());
    }

    public TeiidDataSource(String displayName, String dataSourceName, String dataSourceType, Properties properties) {
        ArgCheck.isNotEmpty(dataSourceName, "dataSourceName");
        ArgCheck.isNotEmpty(dataSourceType, "dataSourceType");
        this.displayName = displayName;
        this.dataSourceName = dataSourceName;
        this.dataSourceType = dataSourceType;
        this.properties = properties;
    }

    @Override
    public int compareTo(TeiidDataSource dataSource) {
        ArgCheck.isNotNull(dataSource, "dataSource");
        return this.getName().compareTo(dataSource.getName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ITeiidDataSource other = (ITeiidDataSource)obj;
        return this.getName().equals(other.getName());
    }

    public String getDisplayName() {
        if (this.connectionProfileName != null) {
            return String.valueOf(this.displayName) + ":" + this.connectionProfileName;
        }
        return this.displayName;
    }

    public String getName() {
        return this.dataSourceName;
    }

    public String getType() {
        return this.dataSourceType;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPropertyValue(String name) {
        return this.properties.getProperty(name);
    }

    public void setProfileName(String name) {
        this.connectionProfileName = name;
    }

    public String getProfileName() {
        return this.connectionProfileName;
    }

    public boolean isPreview() {
        return this.isPreview;
    }

    public void setPreview(boolean isPreview) {
        this.isPreview = isPreview;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Data Source:\t" + this.getName());
        if (!this.getType().equalsIgnoreCase("<unknown>")) {
            sb.append("\nType: \t\t" + this.getType());
        }
        return sb.toString();
    }
}

