/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client.admin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IServer;
import org.jboss.dmr.ModelNode;
import org.jboss.ide.eclipse.as.core.server.v7.management.AS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerUtil;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.PropertyDefinition;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.core.util.ArgCheck;
import org.teiid.designer.annotation.AnnotationUtils;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.runtime.spi.EventManager;
import org.teiid.designer.runtime.spi.ExecutionConfigurationEvent;
import org.teiid.designer.runtime.spi.IExecutionAdmin;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidJdbcInfo;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.spi.ITeiidVdb;
import org.teiid.designer.runtime.spi.TeiidExecutionException;
import org.teiid.designer.runtime.spi.TeiidPropertyDefinition;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidRuntimePlugin;
import org.teiid.runtime.client.admin.AdminSpec;
import org.teiid.runtime.client.admin.ModelConnectionMatcher;
import org.teiid.runtime.client.admin.TeiidTranslator;
import org.teiid.runtime.client.admin.TeiidVdb;

public class ExecutionAdmin
implements IExecutionAdmin {
    private static String PLUGIN_ID = "org.teiid.runtime.client";
    private static String DYNAMIC_VDB_SUFFIX = "-vdb.xml";
    private static int VDB_LOADING_TIMEOUT_SEC = 300;
    private final Admin admin;
    protected Map<String, ITeiidTranslator> translatorByNameMap;
    protected Collection<String> dataSourceNames;
    protected Map<String, ITeiidDataSource> dataSourceByNameMap;
    protected Set<String> dataSourceTypeNames;
    private final EventManager eventManager;
    private final ITeiidServer teiidServer;
    private final AdminSpec adminSpec;
    private Map<String, ITeiidVdb> teiidVdbs;
    private final ModelConnectionMatcher connectionMatcher;
    private boolean loaded = false;

    ExecutionAdmin(Admin admin, ITeiidServer teiidServer) throws Exception {
        ArgCheck.isNotNull(admin, "admin");
        ArgCheck.isNotNull(teiidServer, "server");
        this.admin = admin;
        this.teiidServer = teiidServer;
        this.adminSpec = AdminSpec.getInstance(teiidServer.getServerVersion());
        this.eventManager = teiidServer.getEventManager();
        this.connectionMatcher = new ModelConnectionMatcher();
        this.init();
    }

    public ExecutionAdmin(ITeiidServer teiidServer) throws Exception {
        ArgCheck.isNotNull(teiidServer, "server");
        this.adminSpec = AdminSpec.getInstance(teiidServer.getServerVersion());
        this.admin = this.adminSpec.createAdmin(teiidServer);
        ArgCheck.isNotNull(this.admin, "admin");
        this.teiidServer = teiidServer;
        this.eventManager = teiidServer.getEventManager();
        this.connectionMatcher = new ModelConnectionMatcher();
        this.init();
    }

    private boolean isLessThanTeiidEight() {
        ITeiidServerVersion minVersion = this.teiidServer.getServerVersion().getMinimumVersion();
        return minVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_0.get());
    }

    private boolean isLessThanTeiidEightSeven() {
        ITeiidServerVersion minVersion = this.teiidServer.getServerVersion().getMinimumVersion();
        return minVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_7.get());
    }

    public boolean dataSourceExists(String name) {
        return this.dataSourceNames.contains(name);
    }

    public void deleteDataSource(String dsName) throws Exception {
        if (this.dataSourceNames.contains(dsName)) {
            this.admin.deleteDataSource(dsName);
            ITeiidDataSource tds = this.dataSourceByNameMap.get(dsName);
            this.refreshDataSources();
            if (tds != null) {
                this.eventManager.notifyListeners(ExecutionConfigurationEvent.createRemoveDataSourceEvent((ITeiidDataSource)tds));
            }
        }
    }

    public void deployVdb(IFile vdbFile) throws Exception {
        ArgCheck.isNotNull(vdbFile, "vdbFile");
        String vdbDeploymentName = vdbFile.getFullPath().lastSegment();
        String vdbName = vdbFile.getFullPath().removeFileExtension().lastSegment();
        if (this.isLessThanTeiidEightSeven()) {
            this.undeployVdb(vdbName);
        }
        this.doDeployVdb(vdbDeploymentName, this.getVdbName(vdbName), 1, vdbFile.getContents());
    }

    public void deployVdb(IFile vdbFile, int version) throws Exception {
        ArgCheck.isNotNull(vdbFile, "vdbFile");
        String vdbDeploymentName = vdbFile.getFullPath().lastSegment();
        String vdbName = vdbFile.getFullPath().removeFileExtension().lastSegment();
        if (this.isLessThanTeiidEightSeven()) {
            this.undeployVdb(vdbName);
        }
        int vdbVersion = 1;
        if (version > 1) {
            vdbVersion = version;
        }
        this.doDeployVdb(vdbDeploymentName, this.getVdbName(vdbName), vdbVersion, vdbFile.getContents());
    }

    public void deployDynamicVdb(String deploymentName, InputStream inStream) throws Exception {
        ArgCheck.isNotNull(deploymentName, "deploymentName");
        ArgCheck.isNotNull(inStream, "inStream");
        if (!deploymentName.endsWith(DYNAMIC_VDB_SUFFIX)) {
            throw new Exception(Messages.getString(Messages.ExecutionAdmin.dynamicVdbInvalidName, deploymentName));
        }
        String vdbName = deploymentName.substring(0, deploymentName.indexOf(DYNAMIC_VDB_SUFFIX));
        if (this.isLessThanTeiidEightSeven()) {
            this.undeployDynamicVdb(vdbName);
        }
        this.doDeployVdb(deploymentName, vdbName, 1, inStream);
    }

    private void doDeployVdb(String deploymentName, String vdbName, int vdbVersion, InputStream inStream) throws Exception {
        this.adminSpec.deploy(this.admin, deploymentName, inStream);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        this.refreshVDBs();
        VDB vdb = this.admin.getVDB(vdbName, vdbVersion);
        if (vdb.getStatus().equals((Object)this.adminSpec.getLoadingVDBStatus()) && vdb.getValidityErrors().isEmpty()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            this.refreshVDBs();
            vdb = this.admin.getVDB(vdbName, vdbVersion);
            if (vdb.getStatus().equals((Object)this.adminSpec.getLoadingVDBStatus()) && vdb.getValidityErrors().isEmpty()) {
                RefreshVDBsJob refreshVDBsJob = new RefreshVDBsJob(vdbName);
                refreshVDBsJob.schedule();
            }
        }
        this.eventManager.notifyListeners(ExecutionConfigurationEvent.createDeployVDBEvent((String)vdb.getName()));
    }

    private String getVdbName(String originalVdbName) throws Exception {
        String vdbName = originalVdbName;
        int firstIndex = vdbName.indexOf(46);
        int lastIndex = vdbName.lastIndexOf(46);
        if (firstIndex != -1) {
            if (firstIndex != lastIndex) {
                throw new Exception(Messages.getString(Messages.ExecutionAdmin.invalidVdbName, originalVdbName));
            }
            vdbName = vdbName.substring(0, firstIndex);
        }
        return vdbName;
    }

    public String getSchema(String vdbName, int vdbVersion, String modelName) throws Exception {
        if (this.isLessThanTeiidEight()) {
            return "";
        }
        return this.admin.getSchema(vdbName, vdbVersion, modelName, null, null);
    }

    public void disconnect() {
        this.admin.close();
        this.translatorByNameMap = new HashMap<String, ITeiidTranslator>();
        this.dataSourceNames = new ArrayList<String>();
        this.dataSourceByNameMap = new HashMap<String, ITeiidDataSource>();
        this.dataSourceTypeNames = new HashSet<String>();
        this.teiidVdbs = new HashMap<String, ITeiidVdb>();
    }

    public ITeiidDataSource getDataSource(String name) {
        return this.dataSourceByNameMap.get(name);
    }

    public Collection<ITeiidDataSource> getDataSources() {
        return this.dataSourceByNameMap.values();
    }

    public Set<String> getDataSourceTypeNames() {
        return this.dataSourceTypeNames;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public ITeiidDataSource getOrCreateDataSource(String displayName, String dsName, String typeName, Properties properties) throws Exception {
        ITeiidDataSource tds;
        ArgCheck.isNotEmpty(displayName, "displayName");
        ArgCheck.isNotEmpty(dsName, "dsName");
        ArgCheck.isNotEmpty(typeName, "typeName");
        ArgCheck.isNotEmpty(properties, "properties");
        if (this.dataSourceExists(dsName) && (tds = this.dataSourceByNameMap.get(dsName)) != null) {
            return tds;
        }
        String connProfileDriverClass = properties.getProperty("driver-class");
        if ("connector-jdbc".equals(typeName)) {
            String jarList = properties.getProperty("jarList");
            String dsNameMatch = this.getDSMatchForDriverClass(connProfileDriverClass);
            if (dsNameMatch != null) {
                typeName = dsNameMatch;
            } else if (jarList != null && jarList.trim().length() > 0) {
                this.deployJars(this.admin, jarList);
                this.refresh();
                dsNameMatch = this.getDSMatchForDriverClass(connProfileDriverClass);
                if (dsNameMatch != null) {
                    typeName = dsNameMatch;
                }
            }
        }
        if (!this.dataSourceTypeNames.contains(typeName)) {
            if ("connector-jdbc".equals(typeName)) {
                throw new TeiidExecutionException(101, Messages.getString(Messages.ExecutionAdmin.jdbcSourceForClassNameNotFound, connProfileDriverClass, this.getServer()));
            }
            throw new TeiidExecutionException(102, Messages.getString(Messages.ExecutionAdmin.dataSourceTypeDoesNotExist, typeName, this.getServer()));
        }
        this.admin.createDataSource(dsName, typeName, properties);
        this.admin.refresh();
        this.refreshDataSources();
        ITeiidDataSource tds2 = this.dataSourceByNameMap.get(dsName);
        if (tds2 != null) {
            this.eventManager.notifyListeners(ExecutionConfigurationEvent.createAddDataSourceEvent((ITeiidDataSource)tds2));
            return tds2;
        }
        throw new TeiidExecutionException(103, Messages.getString(Messages.ExecutionAdmin.errorCreatingDataSource, dsName, typeName));
    }

    private String getDSMatchForDriverClass(String requestDriverClass) throws Exception {
        if (requestDriverClass == null) {
            return null;
        }
        if (!this.getServer().isParentConnected()) {
            return null;
        }
        ModelNode request = new ModelNode();
        request.get("operation").set("installed-drivers-list");
        ModelNode address = new ModelNode();
        address.add("subsystem", "datasources");
        request.get("address").set(address);
        try {
            String requestString = request.toJSONString(true);
            IServer parentServer = this.getServer().getParent();
            int timeout = this.teiidServer.getParentRequestTimeout();
            HashMap<String, Integer> props = new HashMap<String, Integer>();
            props.put("PROPERTY_TIMEOUT", timeout);
            AS7ManagementDetails as7ManagementDetails = new AS7ManagementDetails(parentServer, props);
            String resultString = JBoss7ManagerUtil.getService((IServer)parentServer).execute((IAS7ManagementDetails)as7ManagementDetails, requestString);
            ModelNode operationResult = ModelNode.fromJSONString((String)resultString);
            List driverList = operationResult.asList();
            for (ModelNode driver : driverList) {
                String driverClassName = driver.get("driver-class-name").asString();
                String driverName = driver.get("driver-name").asString();
                if (!requestDriverClass.equalsIgnoreCase(driverClassName)) continue;
                return driverName;
            }
        }
        catch (Exception ex) {
            TeiidRuntimePlugin.logError(this.getClass().getSimpleName(), ex, Messages.getString(Messages.ExecutionAdmin.failedToGetDriverMappings, requestDriverClass));
        }
        return null;
    }

    private void deployJars(Admin admin, String jarList) {
        String[] jarPathStrs;
        String splitter = "[" + File.pathSeparatorChar + "]";
        String[] stringArray = jarPathStrs = jarList.split(splitter);
        int n = jarPathStrs.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                String jarPathStr = stringArray[n2];
                File theFile = new File(jarPathStr);
                if (theFile.exists()) {
                    if (theFile.canRead()) {
                        String fileName = theFile.getName();
                        FileInputStream iStream = null;
                        try {
                            iStream = new FileInputStream(theFile);
                        }
                        catch (FileNotFoundException ex) {
                            TeiidRuntimePlugin.logError(this.getClass().getSimpleName(), ex, Messages.getString(Messages.ExecutionAdmin.jarDeploymentJarNotFound, theFile.getPath()));
                            break block9;
                        }
                        try {
                            this.adminSpec.deploy(admin, fileName, iStream);
                            this.admin.refresh();
                        }
                        catch (Exception ex) {
                            TeiidRuntimePlugin.logError(this.getClass().getSimpleName(), ex, Messages.getString(Messages.ExecutionAdmin.jarDeploymentFailed, theFile.getPath()));
                        }
                    } else {
                        TeiidRuntimePlugin.logError(this.getClass().getSimpleName(), Messages.getString(Messages.ExecutionAdmin.jarDeploymentJarNotReadable, theFile.getPath()));
                    }
                } else {
                    TeiidRuntimePlugin.logError(this.getClass().getSimpleName(), Messages.getString(Messages.ExecutionAdmin.jarDeploymentJarNotFound, theFile.getPath()));
                }
            }
            ++n2;
        }
    }

    public void deployDriver(File jarOrRarFile) throws Exception {
        if (jarOrRarFile.exists()) {
            if (jarOrRarFile.canRead()) {
                String fileName = jarOrRarFile.getName();
                FileInputStream iStream = null;
                try {
                    iStream = new FileInputStream(jarOrRarFile);
                }
                catch (FileNotFoundException ex) {
                    TeiidRuntimePlugin.logError(this.getClass().getSimpleName(), ex, Messages.getString(Messages.ExecutionAdmin.jarDeploymentJarNotFound, jarOrRarFile.getPath()));
                    throw ex;
                }
                try {
                    this.adminSpec.deploy(this.admin, fileName, iStream);
                    this.admin.refresh();
                    this.refreshDataSourceTypes();
                }
                catch (Exception ex) {
                    TeiidRuntimePlugin.logError(this.getClass().getSimpleName(), ex, Messages.getString(Messages.ExecutionAdmin.jarDeploymentFailed, jarOrRarFile.getPath()));
                    throw ex;
                }
            }
            TeiidRuntimePlugin.logError(this.getClass().getSimpleName(), Messages.getString(Messages.ExecutionAdmin.jarDeploymentJarNotReadable, jarOrRarFile.getPath()));
        } else {
            TeiidRuntimePlugin.logError(this.getClass().getSimpleName(), Messages.getString(Messages.ExecutionAdmin.jarDeploymentJarNotFound, jarOrRarFile.getPath()));
        }
    }

    public ITeiidServer getServer() {
        return this.teiidServer;
    }

    public ITeiidTranslator getTranslator(String name) {
        ArgCheck.isNotEmpty(name, "name");
        return this.translatorByNameMap.get(name);
    }

    public Collection<ITeiidTranslator> getTranslators() {
        return Collections.unmodifiableCollection(this.translatorByNameMap.values());
    }

    public Set<String> getDataSourceTemplateNames() throws Exception {
        return this.dataSourceTypeNames;
    }

    public Collection<TeiidPropertyDefinition> getTemplatePropertyDefns(String templateName) throws Exception {
        Collection<? extends PropertyDefinition> propDefs = this.admin.getTemplatePropertyDefinitions(templateName);
        ArrayList<TeiidPropertyDefinition> teiidPropDefns = new ArrayList<TeiidPropertyDefinition>();
        for (PropertyDefinition propertyDefinition : propDefs) {
            TeiidPropertyDefinition teiidPropertyDefn = new TeiidPropertyDefinition();
            teiidPropertyDefn.setName(propertyDefinition.getName());
            teiidPropertyDefn.setDisplayName(propertyDefinition.getDisplayName());
            teiidPropertyDefn.setDescription(propertyDefinition.getDescription());
            teiidPropertyDefn.setPropertyTypeClassName(propertyDefinition.getPropertyTypeClassName());
            teiidPropertyDefn.setDefaultValue(propertyDefinition.getDefaultValue());
            teiidPropertyDefn.setAllowedValues(propertyDefinition.getAllowedValues());
            teiidPropertyDefn.setModifiable(propertyDefinition.isModifiable());
            teiidPropertyDefn.setConstrainedToAllowedValues(propertyDefinition.isConstrainedToAllowedValues());
            teiidPropertyDefn.setAdvanced(propertyDefinition.isAdvanced());
            teiidPropertyDefn.setRequired(propertyDefinition.isRequired());
            teiidPropertyDefn.setMasked(propertyDefinition.isMasked());
            teiidPropDefns.add(teiidPropertyDefn);
        }
        return teiidPropDefns;
    }

    public Properties getDataSourceProperties(String name) throws Exception {
        if (this.isLessThanTeiidEight()) {
            return null;
        }
        return this.getDataSource(name).getProperties();
    }

    public ITeiidVdb getVdb(String name) {
        ArgCheck.isNotEmpty(name, "name");
        return this.teiidVdbs.get(name);
    }

    public boolean hasVdb(String name) throws Exception {
        return this.getVdb(name) != null;
    }

    public boolean isVdbActive(String vdbName) throws Exception {
        if (!this.hasVdb(vdbName)) {
            return false;
        }
        return this.getVdb(vdbName).isActive();
    }

    public boolean isVdbLoading(String vdbName) throws Exception {
        if (!this.hasVdb(vdbName)) {
            return false;
        }
        return this.getVdb(vdbName).isLoading();
    }

    public boolean hasVdbFailed(String vdbName) throws Exception {
        if (!this.hasVdb(vdbName)) {
            return false;
        }
        return this.getVdb(vdbName).hasFailed();
    }

    public boolean wasVdbRemoved(String vdbName) throws Exception {
        if (!this.hasVdb(vdbName)) {
            return false;
        }
        return this.getVdb(vdbName).wasRemoved();
    }

    public List<String> retrieveVdbValidityErrors(String vdbName) throws Exception {
        if (!this.hasVdb(vdbName)) {
            return Collections.emptyList();
        }
        return this.getVdb(vdbName).getValidityErrors();
    }

    public Collection<ITeiidVdb> getVdbs() {
        return Collections.unmodifiableCollection(this.teiidVdbs.values());
    }

    private void init() throws Exception {
        this.translatorByNameMap = new HashMap<String, ITeiidTranslator>();
        this.dataSourceNames = new ArrayList<String>();
        this.dataSourceByNameMap = new HashMap<String, ITeiidDataSource>();
        this.dataSourceTypeNames = new HashSet<String>();
        this.refreshVDBs();
    }

    private void internalSetPropertyValue(ITeiidTranslator translator, String propName, String value, ITeiidTranslator.TranslatorPropertyType type, boolean notify) throws Exception {
        if (translator.isValidPropertyValue(propName, value, type) == null) {
            String oldValue = translator.getPropertyValue(propName, type);
            if (oldValue == null ? value == null : oldValue.equals(value)) {
                return;
            }
        } else {
            throw new Exception(Messages.getString(Messages.ExecutionAdmin.invalidPropertyValue, value, propName));
        }
    }

    public void connect() throws Exception {
        if (!this.loaded) {
            this.refresh();
            this.loaded = true;
        }
    }

    public void refresh() throws Exception {
        this.admin.refresh();
        Exception resultException = null;
        try {
            this.refreshDataSourceTypes();
        }
        catch (Exception ex) {
            resultException = ex;
        }
        try {
            this.refreshDataSources();
        }
        catch (Exception ex) {
            resultException = ex;
        }
        try {
            this.refreshTranslators();
        }
        catch (Exception ex) {
            resultException = ex;
        }
        try {
            this.refreshVDBs();
        }
        catch (Exception ex) {
            resultException = ex;
        }
        if (resultException != null) {
            throw resultException;
        }
        this.eventManager.notifyListeners(ExecutionConfigurationEvent.createServerRefreshEvent((ITeiidServer)this.teiidServer));
    }

    protected void refreshDataSources() throws Exception {
        this.dataSourceByNameMap.clear();
        this.dataSourceNames = new ArrayList<String>(this.admin.getDataSourceNames());
        Collection<ITeiidDataSource> tdsList = this.connectionMatcher.findTeiidDataSources(this.dataSourceNames);
        for (ITeiidDataSource ds : tdsList) {
            if (!this.isLessThanTeiidEight()) {
                Properties dsProps = this.admin.getDataSource(ds.getName());
                ds.getProperties().clear();
                ds.getProperties().putAll((Map<?, ?>)dsProps);
            }
            this.dataSourceByNameMap.put(ds.getName(), ds);
        }
    }

    protected void refreshTranslators() throws Exception {
        Collection<? extends Translator> translators = this.admin.getTranslators();
        for (Translator translator : translators) {
            Collection<? extends PropertyDefinition> propDefs;
            if (translator.getName() == null) continue;
            TeiidTranslator teiidTranslator = null;
            if (this.teiidServer.getServerVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_6.get())) {
                propDefs = this.admin.getTemplatePropertyDefinitions(translator.getName());
                teiidTranslator = new TeiidTranslator(translator, propDefs, this.teiidServer);
                this.translatorByNameMap.put(translator.getName(), teiidTranslator);
                continue;
            }
            if (this.teiidServer.getServerVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_7.get())) {
                propDefs = this.admin.getTranslatorPropertyDefinitions(translator.getName());
                teiidTranslator = new TeiidTranslator(translator, propDefs, this.teiidServer);
                this.translatorByNameMap.put(translator.getName(), teiidTranslator);
                continue;
            }
            propDefs = this.admin.getTranslatorPropertyDefinitions(translator.getName(), Admin.TranlatorPropertyType.OVERRIDE);
            Collection<? extends PropertyDefinition> importPropDefs = this.admin.getTranslatorPropertyDefinitions(translator.getName(), Admin.TranlatorPropertyType.IMPORT);
            Collection<? extends PropertyDefinition> extPropDefs = this.admin.getTranslatorPropertyDefinitions(translator.getName(), Admin.TranlatorPropertyType.EXTENSION_METADATA);
            teiidTranslator = new TeiidTranslator(translator, propDefs, importPropDefs, extPropDefs, this.teiidServer);
            this.translatorByNameMap.put(translator.getName(), teiidTranslator);
        }
    }

    protected void refreshVDBs() throws Exception {
        Collection<? extends VDB> vdbs = Collections.unmodifiableCollection(this.admin.getVDBs());
        this.teiidVdbs = new HashMap<String, ITeiidVdb>();
        for (VDB vDB : vdbs) {
            this.teiidVdbs.put(vDB.getName(), new TeiidVdb(vDB, this.teiidServer));
        }
    }

    protected void refreshDataSourceTypes() throws Exception {
        this.dataSourceTypeNames = new HashSet<String>(this.admin.getDataSourceTemplateNames());
    }

    public void setProperties(ITeiidTranslator translator, Properties changedProperties, ITeiidTranslator.TranslatorPropertyType type) throws Exception {
        ArgCheck.isNotNull(translator, "translator");
        ArgCheck.isNotNull(changedProperties, "changedProperties");
        ArgCheck.isNotEmpty(changedProperties.entrySet(), "changedProperties");
        if (changedProperties.size() == 1) {
            String name = changedProperties.stringPropertyNames().iterator().next();
            this.setPropertyValue(translator, name, changedProperties.getProperty(name), type);
        } else {
            for (String name : changedProperties.stringPropertyNames()) {
                this.internalSetPropertyValue(translator, name, changedProperties.getProperty(name), type, false);
            }
        }
    }

    public void setPropertyValue(ITeiidTranslator translator, String propName, String value, ITeiidTranslator.TranslatorPropertyType type) throws Exception {
        ArgCheck.isNotNull(translator, "translator");
        ArgCheck.isNotEmpty(propName, "propName");
        ArgCheck.isNotEmpty(value, "value");
        this.internalSetPropertyValue(translator, propName, value, type, true);
    }

    public void undeployVdb(String vdbName) throws Exception {
        ITeiidVdb vdb = this.getVdb(vdbName);
        if (vdb != null) {
            String deploymentName = vdb.getPropertyValue("deployment-name");
            if (deploymentName != null) {
                this.adminSpec.undeploy(this.admin, deploymentName, vdb.getVersion());
            } else {
                throw new Exception(Messages.getString(Messages.ExecutionAdmin.cannotUndeployVdbNoDeploymentName, vdbName));
            }
        }
        vdb = this.getVdb(vdbName);
        this.refreshVDBs();
        if (vdb != null) {
            this.eventManager.notifyListeners(ExecutionConfigurationEvent.createUnDeployVDBEvent((String)vdb.getName()));
        }
    }

    public void undeployDynamicVdb(String vdbName) throws Exception {
        ITeiidVdb vdb = this.getVdb(vdbName);
        if (vdb != null) {
            this.adminSpec.undeploy(this.admin, this.appendDynamicVdbSuffix(vdbName), vdb.getVersion());
        }
        vdb = this.getVdb(vdbName);
        this.refreshVDBs();
        if (vdb != null) {
            this.eventManager.notifyListeners(ExecutionConfigurationEvent.createUnDeployVDBEvent((String)vdb.getName()));
        }
    }

    public void undeployVdb(String vdbName, int vdbVersion) throws Exception {
        this.adminSpec.undeploy(this.admin, this.appendVdbExtension(vdbName), vdbVersion);
        ITeiidVdb vdb = this.getVdb(vdbName);
        this.refreshVDBs();
        if (vdb != null) {
            this.eventManager.notifyListeners(ExecutionConfigurationEvent.createUnDeployVDBEvent((String)vdb.getName()));
        }
    }

    private String appendVdbExtension(String vdbName) {
        if (vdbName.endsWith("vdb")) {
            return vdbName;
        }
        return String.valueOf(vdbName) + ".vdb";
    }

    private String appendDynamicVdbSuffix(String vdbName) {
        if (vdbName.endsWith("-vdb.xml")) {
            return vdbName;
        }
        return String.valueOf(vdbName) + "-vdb.xml";
    }

    public IStatus ping(IExecutionAdmin.PingType pingType) {
        String msg = Messages.getString(Messages.ExecutionAdmin.cannotConnectToServer, this.teiidServer.getTeiidAdminInfo().getUsername());
        try {
            if (this.admin == null) {
                throw new Exception(msg);
            }
            switch (pingType) {
                case JDBC: {
                    return this.pingJdbc();
                }
            }
            return this.pingAdmin();
        }
        catch (Exception ex) {
            return new Status(4, PLUGIN_ID, msg, (Throwable)ex);
        }
    }

    private IStatus pingAdmin() throws Exception {
        this.admin.getSessions();
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus pingJdbc() {
        String host = this.teiidServer.getHost();
        ITeiidJdbcInfo teiidJdbcInfo = this.teiidServer.getTeiidJdbcInfo();
        String protocol = "mm://";
        if (teiidJdbcInfo.isSecure()) {
            protocol = "mms://";
        }
        Connection teiidJdbcConnection = null;
        String url = "jdbc:teiid:ping@" + protocol + host + ':' + teiidJdbcInfo.getPort();
        try {
            this.adminSpec.deploy(this.admin, "ping-vdb.xml", new ByteArrayInputStream(this.adminSpec.getTestVDB().getBytes()));
            try {
                try {
                    String urlAndCredentials = String.valueOf(url) + ";";
                    TeiidDriver teiidDriver = TeiidDriver.getInstance();
                    teiidDriver.setTeiidVersion(this.teiidServer.getServerVersion());
                    Properties props = new Properties();
                    props.put("user", teiidJdbcInfo.getUsername());
                    props.put("password", teiidJdbcInfo.getPassword());
                    teiidJdbcConnection = teiidDriver.connect(urlAndCredentials, props);
                    return Status.OK_STATUS;
                }
                catch (SQLException ex) {
                    String msg = Messages.getString(Messages.ExecutionAdmin.serverDeployUndeployProblemPingingTeiidJdbc, url);
                    Status status = new Status(4, PLUGIN_ID, msg, (Throwable)ex);
                    this.adminSpec.undeploy(this.admin, "ping-vdb.xml", 1);
                    if (teiidJdbcConnection == null) return status;
                    teiidJdbcConnection.close();
                    return status;
                }
            }
            finally {
                this.adminSpec.undeploy(this.admin, "ping-vdb.xml", 1);
                if (teiidJdbcConnection != null) {
                    teiidJdbcConnection.close();
                }
            }
        }
        catch (Exception ex) {
            String msg = Messages.getString(Messages.ExecutionAdmin.serverDeployUndeployProblemPingingTeiidJdbc, url);
            return new Status(4, PLUGIN_ID, msg, (Throwable)ex);
        }
    }

    public String getAdminDriverPath() {
        return Admin.class.getProtectionDomain().getCodeSource().getLocation().getFile();
    }

    public Driver getTeiidDriver(String driverClass) throws Exception {
        Class<?> klazz = this.getClass().getClassLoader().loadClass(driverClass);
        Object driver = klazz.newInstance();
        if (driver instanceof Driver) {
            return (Driver)driver;
        }
        throw new Exception(Messages.getString(Messages.ExecutionAdmin.cannotLoadDriverClass, driverClass));
    }

    @Deprecated
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    public void mergeVdbs(String sourceVdbName, int sourceVdbVersion, String targetVdbName, int targetVdbVersion) throws Exception {
        if (!AnnotationUtils.isApplicable((AccessibleObject)this.getClass().getMethod("mergeVdbs", String.class, Integer.TYPE, String.class, Integer.TYPE), (ITeiidServerVersion)this.getServer().getServerVersion())) {
            throw new UnsupportedOperationException(Messages.getString(Messages.ExecutionAdmin.mergeVdbUnsupported, new Object[0]));
        }
        this.admin.mergeVDBs(sourceVdbName, sourceVdbVersion, targetVdbName, targetVdbVersion);
    }

    class RefreshVDBsJob
    extends Job {
        String vdbName;

        public RefreshVDBsJob(String vdbName) {
            super("VDB Refresh");
            this.vdbName = vdbName;
            this.setSystem(false);
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("VDB Refresh", -1);
            try {
                this.waitForVDBLoad(this.vdbName);
            }
            catch (Exception exception) {}
            monitor.done();
            return Status.OK_STATUS;
        }

        private void waitForVDBLoad(String vdbName) throws Exception {
            long waitUntil = System.currentTimeMillis() + (long)(VDB_LOADING_TIMEOUT_SEC * 1000);
            boolean first = true;
            do {
                block5: {
                    if (!first) {
                        try {
                            Thread.sleep(5000L);
                            break block5;
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                    first = false;
                }
                ExecutionAdmin.this.refreshVDBs();
                ITeiidVdb vdb = ExecutionAdmin.this.getVdb(vdbName);
                if (vdb != null) {
                    boolean hasValidityErrors;
                    boolean bl = hasValidityErrors = !vdb.getValidityErrors().isEmpty();
                    if (vdb.hasModels() && !vdb.hasFailed() && vdb.isLoading() && !vdb.isActive() && !vdb.wasRemoved() && !hasValidityErrors) continue;
                    return;
                }
                return;
            } while (System.currentTimeMillis() < waitUntil);
            ExecutionAdmin.this.refreshVDBs();
        }
    }
}

