/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.script.Compilable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.QNameException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.query.metadata.IStoredProcedureInfo;
import org.teiid.designer.query.sql.ILanguageVisitor;
import org.teiid.designer.query.sql.lang.ISPParameter;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.query.sql.proc.ICreateProcedureCommand;
import org.teiid.designer.query.sql.symbol.IAggregateSymbol;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.metadata.AggregateAttributes;
import org.teiid.metadata.Table;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Alter;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.AlterView;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.CriteriaOperator;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.HasCriteria;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.Labeled;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NamespaceItem;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.ObjectColumn;
import org.teiid.query.sql.lang.ObjectTable;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.TargetedCommand;
import org.teiid.query.sql.lang.TextColumn;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.TranslateCriteria;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.lang.XMLColumn;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.BranchingStatement;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.JSONObject;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.symbol.XMLAttributes;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.FunctionCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.SQLStringVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.validator.AbstractValidationVisitor;
import org.teiid.query.validator.UpdateValidator;
import org.teiid.query.validator.Validator;
import org.teiid.query.xquery.saxon.SaxonXQueryExpression;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class ValidationVisitor
extends AbstractValidationVisitor {
    public static final Reference.Constraint LIMIT_CONSTRAINT = new PositiveIntegerConstraint(Messages.ValidationVisitor.badlimit2);
    private boolean isXML = false;
    private boolean inQuery;
    private ICreateProcedureCommand<Block, GroupSymbol, Expression, LanguageVisitor> createProc;
    private final DataTypeManagerService dataTypeManager;

    public ValidationVisitor(ITeiidServerVersion teiidVersion) {
        super(teiidVersion);
        this.dataTypeManager = DataTypeManagerService.getInstance(teiidVersion);
    }

    @Override
    public void reset() {
        super.reset();
        this.isXML = false;
        this.inQuery = false;
        if (this.getTeiidVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_0.get())) {
            this.createProc = null;
        }
    }

    @Override
    public void visit(Delete obj) {
        this.validateNoXMLUpdates(obj);
        GroupSymbol group = obj.getGroup();
        this.validateGroupSupportsUpdate(group);
        if (obj.getUpdateInfo() != null && obj.getUpdateInfo().isInherentDelete()) {
            this.validateUpdate(obj, 4, obj.getUpdateInfo());
        }
    }

    @Override
    public void visit(GroupBy obj) {
        List<Expression> groupBySymbols = obj.getSymbols();
        this.validateSortable(groupBySymbols);
        for (Expression expr : groupBySymbols) {
            if (ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(expr).isEmpty() && !(expr instanceof Constant) && !(expr instanceof Reference)) continue;
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.groupby_subquery, expr), expr);
        }
    }

    @Override
    public void visit(GroupSymbol obj) {
        try {
            if (this.getMetadata().isScalarGroup(obj.getMetadataID())) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.invalid_scalar_group_reference, obj), obj);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(Insert obj) {
        this.validateNoXMLUpdates(obj);
        this.validateGroupSupportsUpdate(obj.getGroup());
        this.validateInsert(obj);
        try {
            if (obj.isMerge()) {
                Collection keys = this.getMetadata().getUniqueKeysInGroup(obj.getGroup().getMetadataID());
                if (keys.isEmpty()) {
                    this.handleValidationError(Messages.gs(Messages.TEIID.TEIID31132, obj.getGroup()), obj);
                } else {
                    LinkedHashSet keyCols = new LinkedHashSet(this.getMetadata().getElementIDsInKey(keys.iterator().next()));
                    for (ElementSymbol es : obj.getVariables()) {
                        keyCols.remove(es.getMetadataID());
                    }
                    if (!keyCols.isEmpty()) {
                        this.handleValidationError(Messages.gs(Messages.TEIID.TEIID31133, obj.getGroup(), obj.getVariables()), obj);
                    }
                }
            }
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        if (obj.getQueryExpression() != null) {
            this.validateMultisourceInsert(obj.getGroup());
        }
        if (obj.getUpdateInfo() != null && obj.getUpdateInfo().isInherentInsert()) {
            this.validateUpdate(obj, 2, obj.getUpdateInfo());
            try {
                if (obj.getUpdateInfo().findInsertUpdateMapping(obj, false) == null) {
                    this.handleValidationError(Messages.gs(Messages.TEIID.TEIID30376, obj.getVariables()), obj);
                }
            }
            catch (Exception e) {
                this.handleValidationError(e.getMessage(), obj);
            }
        }
    }

    @Override
    public void visit(OrderByItem obj) {
        this.validateSortable(obj.getSymbol());
    }

    @Override
    public void visit(Query obj) {
        this.validateHasProjectedSymbols(obj);
        if (this.isXMLCommand(obj)) {
            if (obj.getInto() != null) {
                this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0069, new Object[0]), obj);
            }
            this.isXML = true;
            this.validateXMLQuery(obj);
        } else {
            this.inQuery = true;
            this.validateAggregates(obj);
            if (obj.getSelect() != null && obj.getFrom() == null && !ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(obj.getSelect()).isEmpty()) {
                this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0067, new Object[0]), obj);
            }
            if (obj.getInto() != null) {
                this.validateSelectInto(obj);
            }
        }
    }

    @Override
    public void visit(Select obj) {
        this.validateSelectElements(obj);
        if (obj.isDistinct()) {
            this.validateSortable(obj.getProjectedSymbols());
        }
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        this.validateSubquery(obj);
        if (ValidationVisitor.isNonComparable((Expression)obj.getExpression())) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0027, obj), obj);
        }
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
        List projSymbols = obj.getCommand().getProjectedSymbols();
        if (projSymbols.size() != 1) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0011, new Object[0]), obj);
        }
    }

    @Override
    public void visit(XMLSerialize obj) {
        if (obj.getEncoding() != null) {
            try {
                Charset.forName(obj.getEncoding());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.invalid_encoding, obj.getEncoding()), obj);
            }
            if (obj.getType() != DataTypeManagerService.DefaultDataTypes.BLOB.getTypeClass() && obj.getType() != DataTypeManagerService.DefaultDataTypes.VARBINARY.getTypeClass()) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.encoding_for_binary, new Object[0]), obj);
            }
        }
    }

    @Override
    public void visit(SetQuery obj) {
        this.validateHasProjectedSymbols(obj);
        this.validateSetQuery(obj);
    }

    @Override
    public void visit(Update obj) {
        this.validateNoXMLUpdates(obj);
        this.validateGroupSupportsUpdate(obj.getGroup());
        this.validateUpdate(obj);
    }

    @Override
    public void visit(Into obj) {
        GroupSymbol target = obj.getGroup();
        this.validateGroupSupportsUpdate(target);
        this.validateMultisourceInsert(obj.getGroup());
    }

    private void validateMultisourceInsert(GroupSymbol group) {
        try {
            if (this.getMetadata().isMultiSource(this.getMetadata().getModelID(group.getMetadataID()))) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.multisource_insert, group), group);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(Function obj) {
        block17: {
            block22: {
                block20: {
                    block21: {
                        block19: {
                            block18: {
                                if (!IFunctionLibrary.FunctionName.LOOKUP.equalsIgnoreCase(obj.getName())) break block18;
                                try {
                                    ResolverUtil.ResolvedLookup resolvedLookup = ResolverUtil.resolveLookup(obj, this.getMetadata());
                                    if (ValidationVisitor.isNonComparable(resolvedLookup.getKeyElement())) {
                                        this.handleValidationError(Messages.getString(Messages.ValidationVisitor.invalid_lookup_key, resolvedLookup.getKeyElement()), resolvedLookup.getKeyElement());
                                    }
                                    break block17;
                                }
                                catch (Exception e) {
                                    this.handleException(e, obj);
                                }
                                break block17;
                            }
                            if (!IFunctionLibrary.FunctionName.CONTEXT.equalsIgnoreCase(obj.getName())) break block19;
                            if (!this.isXML) {
                                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.The_context_function_cannot_be_used_in_a_non_XML_command, new Object[0]), obj);
                            } else {
                                if (!(obj.getArg(0) instanceof ElementSymbol)) {
                                    this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_004_0036, new Object[0]), obj);
                                }
                                for (Function function : FunctionCollectorVisitor.getFunctions((LanguageObject)obj.getArg(1), false)) {
                                    if (!IFunctionLibrary.FunctionName.CONTEXT.equalsIgnoreCase(function.getName())) continue;
                                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.Context_function_nested, new Object[0]), obj);
                                }
                            }
                            break block17;
                        }
                        if (!IFunctionLibrary.FunctionName.ROWLIMIT.equalsIgnoreCase(obj.getName()) && !IFunctionLibrary.FunctionName.ROWLIMITEXCEPTION.equalsIgnoreCase(obj.getName())) break block20;
                        if (!this.isXML) break block21;
                        if (obj.getArg(0) instanceof ElementSymbol) break block17;
                        this.handleValidationError(Messages.getString(Messages.ValidationVisitor.rowlimit2, new Object[0]), obj);
                        break block17;
                    }
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.The_rowlimit_function_cannot_be_used_in_a_non_XML_command, new Object[0]), obj);
                    break block17;
                }
                if (!obj.getName().equalsIgnoreCase("xpathvalue")) break block22;
                if (!(obj.getArgs()[1] instanceof Constant)) break block17;
                Constant xpathConst = (Constant)obj.getArgs()[1];
                try {
                    XMLSystemFunctions.validateXpath((String)xpathConst.getValue());
                }
                catch (Exception e) {
                    this.handleValidationError(Messages.getString(Messages.QueryResolver.invalid_xpath, e.getMessage()), obj);
                }
                break block17;
            }
            if (obj.getName().equalsIgnoreCase("to_bytes") || obj.getName().equalsIgnoreCase("to_chars")) {
                try {
                    FunctionMethods.getCharset((String)((Constant)obj.getArg(1)).getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.invalid_encoding, obj.getArg(1)), obj);
                }
            } else if (obj.isAggregate()) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.user_defined_aggregate_as_function, obj, obj.getName()), obj);
            } else if (IFunctionLibrary.FunctionName.JSONARRAY.equalsIgnoreCase(obj.getName())) {
                Expression[] args;
                Expression[] expressionArray = args = obj.getArgs();
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression expression = expressionArray[n2];
                    this.validateJSONValue(obj, expression);
                    ++n2;
                }
            }
        }
    }

    @Override
    public void visit(AssignmentStatement obj) {
        ElementSymbol variable = obj.getVariable();
        this.validateAssignment(obj, variable);
    }

    @Override
    public void visit(CommandStatement obj) {
        if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0.get())) {
            this.visit7(obj);
        } else {
            this.visit8(obj);
        }
    }

    private void visit7(CommandStatement obj) {
        if (obj.getCommand() instanceof StoredProcedure) {
            StoredProcedure proc = (StoredProcedure)obj.getCommand();
            for (SPParameter param : proc.getParameters()) {
                if (param.getParameterType() != SPParameter.RETURN_VALUE && param.getParameterType() != SPParameter.OUT || !(param.getExpression() instanceof ElementSymbol)) continue;
                this.validateAssignment(obj, (ElementSymbol)param.getExpression());
            }
        }
    }

    @Override
    public void visit(StoredProcedure obj) {
        for (SPParameter param : obj.getInputParameters()) {
            try {
                if (this.getMetadata().elementSupports(param.getMetadataID(), 4) || !EvaluatableVisitor.isFullyEvaluatable(param.getExpression(), true)) continue;
                try {
                    Object evaluatedValue = Evaluator.assess(param.getExpression());
                    if (evaluatedValue == null) {
                        this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0055, param.getParameterSymbol()), param.getParameterSymbol());
                        continue;
                    }
                    if (!(evaluatedValue instanceof ArrayImpl) || !this.getMetadata().isVariadic(param.getMetadataID())) continue;
                    ArrayImpl av = (ArrayImpl)evaluatedValue;
                    Object[] objectArray = av.getValues();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o == null) {
                            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0055, param.getParameterSymbol()), param.getParameterSymbol());
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void validateAssignment(LanguageObject obj, ElementSymbol variable) {
        String groupName = variable.getGroupSymbol().getCanonicalName();
        if (groupName.equals("CHANGING") || groupName.equals("INPUTS")) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0012, "INPUTS", "CHANGING"), obj);
        }
    }

    @Override
    public void visit(ScalarSubquery obj) {
        this.validateSubquery(obj);
        List projSymbols = obj.getCommand().getProjectedSymbols();
        if (projSymbols.size() != 1) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_008_0032, obj.getCommand()), obj.getCommand());
        }
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void validateContainsRowsUpdatedVariable(CreateUpdateProcedureCommand obj) {
        final ArrayList assignVars = new ArrayList();
        LanguageVisitor visitor = new LanguageVisitor(this.getTeiidVersion()){

            @Override
            public void visit(AssignmentStatement stmt) {
                assignVars.add(stmt.getVariable());
            }
        };
        PreOrderNavigator.doVisit(obj, visitor);
        boolean foundVar = false;
        for (ElementSymbol variable : assignVars) {
            if (!variable.getShortName().equalsIgnoreCase("ROWS_UPDATED")) continue;
            foundVar = true;
            break;
        }
        if (!foundVar) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0016, "ROWS_UPDATED"), obj);
        }
    }

    @Override
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    public void visit(CreateUpdateProcedureCommand obj) {
        if (!obj.isUpdateProcedure()) {
            if (GroupCollectorVisitor.getGroups((LanguageObject)obj, true).contains(obj.getVirtualGroup())) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.Procedure_has_group_self_reference, new Object[0]), obj);
            }
            return;
        }
        this.createProc = obj;
        this.validateContainsRowsUpdatedVariable(obj);
    }

    @Override
    public void visit(CreateProcedureCommand obj) {
        if (obj.getUpdateType() == 0) {
            if (GroupCollectorVisitor.getGroups((LanguageObject)obj, true).contains(obj.getVirtualGroup())) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.Procedure_has_group_self_reference, new Object[0]), obj);
            }
            if (obj.getResultSetColumns() != null) {
                this.createProc = obj;
            }
        }
    }

    private boolean isUpdateProcedure() {
        if (this.createProc == null) {
            return false;
        }
        if (!(this.createProc instanceof CreateUpdateProcedureCommand)) {
            return false;
        }
        return ((CreateUpdateProcedureCommand)this.createProc).isUpdateProcedure();
    }

    @Override
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    public void visit(HasCriteria obj) {
        if (!this.isUpdateProcedure()) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0019, new Object[0]), obj);
        }
    }

    @Override
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    public void visit(TranslateCriteria obj) {
        if (!this.isUpdateProcedure()) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0019, new Object[0]), obj);
        }
        if (obj.hasTranslations()) {
            List<ElementSymbol> selectElmnts = null;
            if (obj.getSelector().hasElements()) {
                selectElmnts = obj.getSelector().getElements();
            }
            for (CompareCriteria transCrit : obj.getTranslations()) {
                Collection<ElementSymbol> leftElmnts = ElementCollectorVisitor.getElements((LanguageObject)transCrit.getLeftExpression(), true);
                ElementSymbol leftExpr = leftElmnts.iterator().next();
                if (selectElmnts == null || selectElmnts.contains(leftExpr)) continue;
                this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0021, new Object[0]), leftExpr);
            }
        }
        this.validateTranslateCriteria(obj);
    }

    @Override
    public void visit(CompoundCriteria obj) {
        if (this.isXML) {
            ArrayList<Function> rowLimitFunctions = new ArrayList<Function>();
            FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(this.getTeiidVersion(), rowLimitFunctions, IFunctionLibrary.FunctionName.ROWLIMIT.text());
            PreOrderNavigator.doVisit(obj, visitor);
            visitor = new FunctionCollectorVisitor(this.getTeiidVersion(), rowLimitFunctions, IFunctionLibrary.FunctionName.ROWLIMITEXCEPTION.text());
            PreOrderNavigator.doVisit(obj, visitor);
            int functionCount = rowLimitFunctions.size();
            if (functionCount > 0) {
                Iterator<Criteria> conjunctIter = Criteria.separateCriteriaByAnd(obj).iterator();
                int i = 0;
                while (conjunctIter.hasNext() && i < functionCount) {
                    CompareCriteria crit;
                    Criteria conjunct = conjunctIter.next();
                    if (!(conjunct instanceof CompareCriteria) || (!rowLimitFunctions.contains((crit = (CompareCriteria)conjunct).getLeftExpression()) || rowLimitFunctions.contains(crit.getRightExpression())) && (!rowLimitFunctions.contains(crit.getRightExpression()) || rowLimitFunctions.contains(crit.getLeftExpression()))) continue;
                    ++i;
                }
                if (i < functionCount) {
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.rowlimit3, new Object[0]), obj);
                }
            }
        }
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    protected void validateTranslateCriteria(TranslateCriteria obj) {
        if (this.currentCommand == null) {
            return;
        }
        if (!this.isUpdateProcedure()) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0019, new Object[0]), obj);
        }
        CreateUpdateProcedureCommand updateProc = (CreateUpdateProcedureCommand)this.createProc;
        Map<ElementSymbol, Expression> symbolMap = updateProc.getSymbolMap();
        Command userCommand = updateProc.getUserCommand();
        if (userCommand == null) {
            return;
        }
        Criteria userCrit = null;
        int userCmdType = userCommand.getType();
        switch (userCmdType) {
            case 4: {
                userCrit = ((Delete)userCommand).getCriteria();
                break;
            }
            case 3: {
                userCrit = ((Update)userCommand).getCriteria();
                break;
            }
        }
        if (userCrit == null) {
            return;
        }
        Collection<ElementSymbol> transleElmnts = ElementCollectorVisitor.getElements((LanguageObject)obj, true);
        Collection<GroupSymbol> groups = GroupCollectorVisitor.getGroups((LanguageObject)this.currentCommand, true);
        CriteriaOperator.Operator selectType = obj.getSelector().getSelectorType();
        for (Criteria predCrit : Criteria.separateCriteriaByAnd(userCrit)) {
            if (selectType != CriteriaOperator.Operator.NO_TYPE) {
                if (predCrit instanceof CompareCriteria) {
                    CompareCriteria ccCrit = (CompareCriteria)predCrit;
                    if (selectType.getIndex() != ccCrit.getOperator()) {
                        continue;
                    }
                } else if (predCrit instanceof MatchCriteria ? selectType != CriteriaOperator.Operator.LIKE : (predCrit instanceof IsNullCriteria ? selectType != CriteriaOperator.Operator.IS_NULL : (predCrit instanceof SetCriteria ? selectType != CriteriaOperator.Operator.IN : predCrit instanceof BetweenCriteria && selectType != CriteriaOperator.Operator.BETWEEN))) continue;
            }
            for (ElementSymbol criteriaElement : ElementCollectorVisitor.getElements((LanguageObject)predCrit, true)) {
                if (!transleElmnts.contains(criteriaElement)) continue;
                Expression mappedExpr = symbolMap.get(criteriaElement);
                if (mappedExpr instanceof AggregateSymbol) {
                    this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0022, criteriaElement), criteriaElement);
                }
                if (groups.containsAll(GroupsUsedByElementsVisitor.getGroups(mappedExpr))) continue;
                this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0023, criteriaElement), criteriaElement);
            }
        }
    }

    protected void validateSelectElements(Select obj) {
        if (this.isXML) {
            return;
        }
        Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements((LanguageObject)obj, true);
        Collection<ElementSymbol> cantSelect = this.validateElementsSupport(elements, 0);
        if (cantSelect != null) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0024, cantSelect), cantSelect);
        }
    }

    protected void validateHasProjectedSymbols(Command obj) {
        if (obj.getProjectedSymbols().size() == 0) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0025, new Object[0]), obj);
        }
    }

    protected void validateSortable(List<? extends Expression> symbols) {
        for (Expression expression : symbols) {
            this.validateSortable(expression);
        }
    }

    private void validateSortable(Expression symbol) {
        if (ValidationVisitor.isNonComparable(symbol)) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0026, symbol), symbol);
        }
    }

    public static boolean isNonComparable(Expression symbol) {
        DataTypeManagerService dataTypeManager = DataTypeManagerService.getInstance(symbol.getTeiidVersion());
        return dataTypeManager.isNonComparable(dataTypeManager.getDataTypeName(symbol.getType()));
    }

    protected void validateNoXMLUpdates(Command obj) {
        if (this.isXMLCommand(obj)) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0029, new Object[0]), obj);
        }
    }

    protected void validateNoXMLProcedures(Command obj) {
        if (this.isXMLCommand(obj)) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0030, new Object[0]), obj);
        }
    }

    private void validateXMLQuery(Query obj) {
        if (obj.getGroupBy() != null) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0031, new Object[0]), obj);
        }
        if (obj.getHaving() != null) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0032, new Object[0]), obj);
        }
        if (obj.getLimit() != null) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.limit_not_valid_for_xml, new Object[0]), obj);
        }
        if (obj.getOrderBy() != null) {
            OrderBy orderBy = obj.getOrderBy();
            for (OrderByItem item : orderBy.getOrderByItems()) {
                if (item.getSymbol() instanceof ElementSymbol) continue;
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.orderby_expression_xml, new Object[0]), obj);
            }
        }
    }

    protected void validateGroupSupportsUpdate(GroupSymbol groupSymbol) {
        try {
            if (!this.getMetadata().groupSupports(groupSymbol.getMetadataID(), 0)) {
                this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0033, SQLStringVisitor.getSQLString(groupSymbol)), groupSymbol);
            }
        }
        catch (Exception e) {
            this.handleException(e, groupSymbol);
        }
    }

    protected void validateSetQuery(SetQuery query) {
        for (QueryCommand subQuery : query.getQueryCommands()) {
            if (this.isXMLCommand(subQuery)) {
                this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0034, new Object[0]), query);
            }
            if (!(subQuery instanceof Query) || ((Query)subQuery).getInto() == null) continue;
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.union_insert, new Object[0]), query);
        }
        if (!query.isAll() || query.getOperation() == ISetQuery.Operation.EXCEPT || query.getOperation() == ISetQuery.Operation.INTERSECT) {
            this.validateSortable(query.getProjectedSymbols());
        }
        if (query.isAll() && (query.getOperation() == ISetQuery.Operation.EXCEPT || query.getOperation() == ISetQuery.Operation.INTERSECT)) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.excpet_intersect_all, new Object[0]), query);
        }
    }

    private void validateAggregates(Query query) {
        Select select = query.getSelect();
        GroupBy groupBy = query.getGroupBy();
        Criteria having = query.getHaving();
        this.validateNoAggsInClause(groupBy);
        List<GroupSymbol> correlationGroups = null;
        this.validateNoAggsInClause(query.getCriteria());
        if (query.getFrom() == null) {
            this.validateNoAggsInClause(select);
            this.validateNoAggsInClause(query.getOrderBy());
        } else {
            this.validateNoAggsInClause(query.getFrom());
            correlationGroups = query.getFrom().getGroups();
        }
        HashSet<Expression> groupSymbols = null;
        boolean hasAgg = false;
        if (groupBy != null) {
            groupSymbols = new HashSet<Expression>(groupBy.getSymbols());
            hasAgg = true;
        }
        LinkedHashSet<Expression> invalid = new LinkedHashSet<Expression>();
        LinkedHashSet invalidWindowFunctions = new LinkedHashSet();
        LinkedList aggs = new LinkedList();
        if (having != null) {
            this.validateCorrelatedReferences(query, correlationGroups, groupSymbols, having, invalid);
            AggregateSymbolCollectorVisitor.getAggregates(having, aggs, invalid, null, invalidWindowFunctions, groupSymbols);
            hasAgg = true;
        }
        for (Expression symbol : select.getProjectedSymbols()) {
            if (hasAgg || !aggs.isEmpty()) {
                this.validateCorrelatedReferences(query, correlationGroups, groupSymbols, symbol, invalid);
            }
            AggregateSymbolCollectorVisitor.getAggregates(symbol, aggs, invalid, null, null, groupSymbols);
        }
        if (!(aggs.isEmpty() && !hasAgg || invalid.isEmpty())) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0037, invalid), invalid);
        }
        if (!invalidWindowFunctions.isEmpty()) {
            this.handleValidationError(Messages.getString(Messages.TeiidParser.window_only_top_level, invalidWindowFunctions), invalidWindowFunctions);
        }
    }

    private void validateCorrelatedReferences(Query query, final List<GroupSymbol> correlationGroups, final Set<Expression> groupingSymbols, LanguageObject object, LinkedHashSet<Expression> invalid) {
        if (query.getFrom() == null) {
            return;
        }
        ElementCollectorVisitor ecv = new ElementCollectorVisitor(this.getTeiidVersion(), invalid){

            @Override
            public void visit(ElementSymbol obj) {
                if (obj.isExternalReference() && correlationGroups.contains(obj.getGroupSymbol()) && (groupingSymbols == null || !groupingSymbols.contains(obj))) {
                    super.visit(obj);
                }
            }
        };
        AggregateSymbolCollectorVisitor.AggregateStopNavigator asn = new AggregateSymbolCollectorVisitor.AggregateStopNavigator(ecv);
        object.acceptVisitor((ILanguageVisitor)asn);
    }

    private void validateNoAggsInClause(LanguageObject clause) {
        if (clause == null) {
            return;
        }
        LinkedHashSet aggs = new LinkedHashSet();
        AggregateSymbolCollectorVisitor.getAggregates(clause, aggs, null, null, aggs, null);
        if (!aggs.isEmpty()) {
            this.handleValidationError(Messages.getString(Messages.TeiidParser.Aggregate_only_top_level, aggs), aggs);
        }
    }

    protected void validateInsert(Insert obj) {
        List<ElementSymbol> vars = obj.getVariables();
        Iterator varIter = vars.iterator();
        List<Expression> values = obj.getValues();
        Iterator valIter = values.iterator();
        GroupSymbol insertGroup = obj.getGroup();
        try {
            boolean multiSource = this.getMetadata().isMultiSource(this.getMetadata().getModelID(insertGroup.getMetadataID()));
            for (ElementSymbol insertElem : vars) {
                if (!this.getMetadata().elementSupports(insertElem.getMetadataID(), 5)) {
                    this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0052, insertElem), insertElem);
                }
                if (!multiSource || !this.getMetadata().isMultiSourceElement(insertElem.getMetadataID())) continue;
                multiSource = false;
            }
            if (multiSource) {
                this.validateMultisourceInsert(insertGroup);
            }
            LinkedList<ElementSymbol> insertElmnts = new LinkedList<ElementSymbol>(ResolverUtil.resolveElementsInGroup(insertGroup, this.getMetadata()));
            insertElmnts.removeAll(vars);
            for (ElementSymbol nextElmnt : insertElmnts) {
                if (this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 7) || this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 4) || this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 8)) continue;
                this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0053, insertGroup, nextElmnt), nextElmnt);
            }
            while (valIter.hasNext() && varIter.hasNext()) {
                Expression nextValue = (Expression)valIter.next();
                ElementSymbol nextVar = (ElementSymbol)varIter.next();
                if (!EvaluatableVisitor.isFullyEvaluatable(nextValue, true)) continue;
                try {
                    Object evaluatedValue = Evaluator.assess(nextValue);
                    if (evaluatedValue != null || this.getMetadata().elementSupports(nextVar.getMetadataID(), 4)) continue;
                    this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0055, nextVar), nextVar);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            this.handleException(e, obj);
        }
    }

    protected void validateSetClauseList(SetClauseList list) {
        HashSet<ElementSymbol> dups = new HashSet<ElementSymbol>();
        HashSet<ElementSymbol> changeVars = new HashSet<ElementSymbol>();
        for (SetClause clause : list.getClauses()) {
            ElementSymbol elementID = clause.getSymbol();
            if (changeVars.add(elementID)) continue;
            dups.add(elementID);
        }
        if (!dups.isEmpty()) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0062, dups), dups);
        }
    }

    protected void validateUpdate(Update update) {
        try {
            UpdateValidator.UpdateInfo info = update.getUpdateInfo();
            for (SetClause entry : update.getChangeList().getClauses()) {
                Expression value;
                ElementSymbol elementID = entry.getSymbol();
                if (!this.getMetadata().elementSupports(elementID.getMetadataID(), 5)) {
                    this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0059, elementID), elementID);
                }
                Object metadataID = elementID.getMetadataID();
                if (this.getMetadata().isMultiSourceElement(metadataID)) {
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.multi_source_update_not_allowed, elementID), elementID);
                }
                if (EvaluatableVisitor.isFullyEvaluatable(value = entry.getValue(), true)) {
                    try {
                        Constant c = (Constant)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.CONSTANT);
                        c.setValue(Evaluator.assess(value));
                        value = c;
                    }
                    catch (Exception exception) {}
                }
                if (!(value instanceof Constant) || ((Constant)value).getValue() != null || this.getMetadata().elementSupports(elementID.getMetadataID(), 4)) continue;
                this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0060, SQLStringVisitor.getSQLString(elementID)), elementID);
            }
            if (info != null && info.isInherentUpdate()) {
                this.validateUpdate(update, 3, info);
                Set<ElementSymbol> updateCols = update.getChangeList().getClauseMap().keySet();
                if (!info.hasValidUpdateMapping(updateCols)) {
                    this.handleValidationError(Messages.gs(Messages.TEIID.TEIID30376, updateCols), update);
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, update);
        }
        this.validateSetClauseList(update.getChangeList());
    }

    private void validateUpdate(TargetedCommand update, int type, UpdateValidator.UpdateInfo info) {
        String error = ProcedureContainerResolver.validateUpdateInfo(update.getGroup(), type, info);
        if (error != null) {
            this.handleValidationError(error, update.getGroup());
        }
    }

    protected void validateSelectInto(Query query) {
        List<Expression> symbols = query.getSelect().getProjectedSymbols();
        GroupSymbol intoGroup = query.getInto().getGroup();
        this.validateInto(query, symbols, intoGroup);
    }

    private void validateInto(LanguageObject query, List<Expression> symbols, GroupSymbol intoGroup) {
        try {
            List elementIDs = this.getMetadata().getElementIDsInGroupID(intoGroup.getMetadataID());
            if (symbols.size() != elementIDs.size()) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.select_into_wrong_elements, new Integer(elementIDs.size()), new Integer(symbols.size())), query);
                return;
            }
            int symbolNum = 0;
            while (symbolNum < symbols.size()) {
                String targetTypeName;
                Class<?> symbolType;
                String symbolTypeName;
                Expression symbol = symbols.get(symbolNum);
                Object elementID = elementIDs.get(symbolNum);
                if (!this.getMetadata().elementSupports(elementID, 5)) {
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.element_updates_not_allowed, this.getMetadata().getFullName(elementID)), intoGroup);
                }
                if (!(symbolTypeName = this.dataTypeManager.getDataTypeName(symbolType = symbol.getType())).equals(targetTypeName = this.getMetadata().getElementType(elementID)) && !this.dataTypeManager.isImplicitConversion(symbolTypeName, targetTypeName)) {
                    Object[] params = new Object[]{symbolTypeName, targetTypeName, new Integer(symbolNum + 1), query};
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.select_into_no_implicit_conversion, params), query);
                }
                ++symbolNum;
            }
        }
        catch (Exception e) {
            this.handleException(e, query);
        }
    }

    private void validateRowLimitFunctionNotInInvalidCriteria(Criteria obj) {
        ArrayList<Function> rowLimitFunctions = new ArrayList<Function>();
        FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(this.getTeiidVersion(), rowLimitFunctions, IFunctionLibrary.FunctionName.ROWLIMIT.text());
        PreOrderNavigator.doVisit(obj, visitor);
        visitor = new FunctionCollectorVisitor(this.getTeiidVersion(), rowLimitFunctions, IFunctionLibrary.FunctionName.ROWLIMITEXCEPTION.text());
        PreOrderNavigator.doVisit(obj, visitor);
        if (rowLimitFunctions.size() > 0) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.rowlimit3, new Object[0]), obj);
        }
    }

    @Override
    public void visit(BetweenCriteria obj) {
        if (ValidationVisitor.isNonComparable(obj.getExpression())) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0027, obj), obj);
        }
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(IsNullCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(MatchCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(NotCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(SetCriteria obj) {
        if (ValidationVisitor.isNonComparable((Expression)obj.getExpression())) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0027, obj), obj);
        }
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        this.validateSubquery(obj);
        if (ValidationVisitor.isNonComparable(obj.getLeftExpression())) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0027, obj), obj);
        }
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(Option obj) {
        Collection dep = obj.getDependentGroups();
        Collection notDep = obj.getNotDependentGroups();
        if (dep != null && !dep.isEmpty() && notDep != null && !notDep.isEmpty()) {
            String groupName2 = null;
            String notDepGroup2 = null;
            for (String groupName2 : dep) {
                for (String notDepGroup2 : notDep) {
                    if (!notDepGroup2.equalsIgnoreCase(groupName2)) continue;
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.group_in_both_dep, groupName2), obj);
                    return;
                }
            }
        }
    }

    @Override
    public void visit(DynamicCommand obj) {
        if (obj.getIntoGroup() != null) {
            this.validateInto(obj, obj.getAsColumns(), obj.getIntoGroup());
        }
        if (obj.getUsing() != null) {
            this.validateSetClauseList(obj.getUsing());
        }
    }

    @Override
    public void visit(Create obj) {
        Table t;
        if (!obj.getPrimaryKey().isEmpty()) {
            this.validateSortable(obj.getPrimaryKey());
        }
        if (obj.getTableMetadata() != null && !(t = obj.getTableMetadata()).getForeignKeys().isEmpty()) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.temp_fk, obj.getTable()), obj);
        }
    }

    @Override
    public void visit(Drop drop) {
        if (!drop.getTable().isTempTable()) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.drop_of_nontemptable, drop.getTable()), drop);
        }
        try {
            if (this.getMetadata().isVirtualGroup(drop.getTable().getMetadataID())) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.drop_of_globaltemptable, drop.getTable()), drop);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(CompareCriteria obj) {
        if (ValidationVisitor.isNonComparable((Expression)obj.getLeftExpression())) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0027, obj), obj);
        }
        ArrayList<Function> rowLimitFunctions = new ArrayList<Function>();
        FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(this.getTeiidVersion(), rowLimitFunctions, IFunctionLibrary.FunctionName.ROWLIMIT.text());
        PreOrderNavigator.doVisit(obj, visitor);
        visitor = new FunctionCollectorVisitor(this.getTeiidVersion(), rowLimitFunctions, IFunctionLibrary.FunctionName.ROWLIMITEXCEPTION.text());
        PreOrderNavigator.doVisit(obj, visitor);
        int functionCount = rowLimitFunctions.size();
        if (functionCount > 0) {
            Function rightExpr;
            Function leftExpr;
            Function function = null;
            Expression expr = null;
            if (obj.getLeftExpression() instanceof Function && (IFunctionLibrary.FunctionName.ROWLIMIT.equalsIgnoreCase((leftExpr = (Function)obj.getLeftExpression()).getName()) || IFunctionLibrary.FunctionName.ROWLIMITEXCEPTION.equalsIgnoreCase(leftExpr.getName()))) {
                function = leftExpr;
                expr = obj.getRightExpression();
            }
            if (function == null && obj.getRightExpression() instanceof Function && (IFunctionLibrary.FunctionName.ROWLIMIT.equalsIgnoreCase((rightExpr = (Function)obj.getRightExpression()).getName()) || IFunctionLibrary.FunctionName.ROWLIMITEXCEPTION.equalsIgnoreCase(rightExpr.getName()))) {
                function = rightExpr;
                expr = obj.getLeftExpression();
            }
            if (function == null) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.rowlimit0, new Object[0]), obj);
            } else if (expr instanceof Constant) {
                Constant constant = (Constant)expr;
                if (constant.getValue() instanceof Integer) {
                    Integer integer = (Integer)constant.getValue();
                    if (integer < 0) {
                        this.handleValidationError(Messages.getString(Messages.ValidationVisitor.rowlimit1, new Object[0]), obj);
                    }
                } else {
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.rowlimit1, new Object[0]), obj);
                }
            } else if (expr instanceof Reference) {
                ((Reference)expr).setConstraint(new PositiveIntegerConstraint(Messages.ValidationVisitor.rowlimit1));
            } else {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.rowlimit1, new Object[0]), obj);
            }
        }
    }

    @Override
    public void visit(Limit obj) {
        this.validateLimitExpression(obj, obj.getOffset());
        this.validateLimitExpression(obj, obj.getRowLimit());
    }

    private void validateLimitExpression(Limit obj, Expression limitExpr) {
        if (limitExpr != null) {
            if (limitExpr instanceof Constant) {
                Integer limit = (Integer)((Constant)limitExpr).getValue();
                if (limit < 0) {
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.badlimit2, new Object[0]), obj);
                }
            } else if (limitExpr instanceof Reference) {
                ((Reference)limitExpr).setConstraint(LIMIT_CONSTRAINT);
            } else if (!EvaluatableVisitor.willBecomeConstant(limitExpr)) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.badlimit1, new Object[0]), obj);
            }
        }
    }

    @Override
    public void visit(XMLForest obj) {
        this.validateDerivedColumnNames(obj, obj.getArgs());
        for (DerivedColumn dc : obj.getArgs()) {
            if (dc.getAlias() == null) continue;
            this.validateQName(obj, dc.getAlias());
            this.validateXMLContentTypes(dc.getExpression(), obj);
        }
    }

    @Override
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    public void visit(JSONObject obj) {
        for (DerivedColumn dc : obj.getArgs()) {
            this.validateJSONValue(obj, dc.getExpression());
        }
    }

    @Override
    public void visit(WindowFunction windowFunction) {
        IAggregateSymbol.Type type = windowFunction.getFunction().getAggregateFunction();
        switch (type) {
            case RANK: 
            case DENSE_RANK: 
            case ROW_NUMBER: {
                if (windowFunction.getWindowSpecification().getOrderBy() != null) break;
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.ranking_requires_order_by, windowFunction), windowFunction);
                break;
            }
            case XMLAGG: 
            case TEXTAGG: 
            case ARRAY_AGG: 
            case JSONARRAY_AGG: 
            case STRING_AGG: {
                if (windowFunction.getWindowSpecification().getOrderBy() == null) break;
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.window_order_by, windowFunction), windowFunction);
                break;
            }
        }
        this.validateNoSubqueriesOrOuterReferences(windowFunction);
        if (windowFunction.getFunction().getOrderBy() != null || windowFunction.getFunction().isDistinct() && windowFunction.getWindowSpecification().getOrderBy() != null) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0042, windowFunction.getFunction(), windowFunction), windowFunction);
        }
        if (windowFunction.getWindowSpecification().getPartition() != null) {
            this.validateSortable(windowFunction.getWindowSpecification().getPartition());
        }
    }

    @Override
    public void visit(AggregateSymbol obj) {
        if (!this.inQuery) {
            this.handleValidationError(Messages.getString(Messages.TeiidParser.Aggregate_only_top_level, obj), obj);
            return;
        }
        if (obj.getAggregateFunction() == IAggregateSymbol.Type.USER_DEFINED) {
            AggregateAttributes aa = obj.getFunctionDescriptor().getMethod().getAggregateAttributes();
            if (!aa.allowsDistinct() && obj.isDistinct()) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.uda_not_allowed, "DISTINCT", obj), obj);
            }
            if (!aa.allowsOrderBy() && obj.getOrderBy() != null) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.uda_not_allowed, "ORDER BY", obj), obj);
            }
            if (aa.isAnalytic() && !obj.isWindowed()) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.uda_analytic, obj), obj);
            }
        }
        if (obj.getCondition() != null) {
            Expression condition = obj.getCondition();
            this.validateNoSubqueriesOrOuterReferences(condition);
        }
        Expression aggExp = null;
        if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0.get())) {
            aggExp = obj.getExpression();
            this.validateNoNestedAggs(aggExp);
        } else {
            Expression[] aggExps;
            Expression[] expressionArray = aggExps = obj.getArgs();
            int n = aggExps.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                this.validateNoNestedAggs(expression);
                ++n2;
            }
            if (aggExps.length > 0) {
                aggExp = aggExps[0];
            }
        }
        this.validateNoNestedAggs(obj.getOrderBy());
        this.validateNoNestedAggs(obj.getCondition());
        IAggregateSymbol.Type aggregateFunction = obj.getAggregateFunction();
        if ((aggregateFunction == IAggregateSymbol.Type.SUM || aggregateFunction == IAggregateSymbol.Type.AVG) && obj.getType() == null) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0041, aggregateFunction, obj), obj);
        } else if (obj.getType() != DataTypeManagerService.DefaultDataTypes.NULL.getTypeClass()) {
            if (aggregateFunction == IAggregateSymbol.Type.XMLAGG && aggExp.getType() != DataTypeManagerService.DefaultDataTypes.XML.getTypeClass()) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.non_xml, aggregateFunction, obj), obj);
            } else if (obj.isBoolean() && aggExp.getType() != DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass()) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.non_boolean, aggregateFunction, obj), obj);
            } else if (aggregateFunction == IAggregateSymbol.Type.JSONARRAY_AGG) {
                this.validateJSONValue(obj, aggExp);
            }
        }
        if ((obj.isDistinct() || aggregateFunction == IAggregateSymbol.Type.MIN || aggregateFunction == IAggregateSymbol.Type.MAX) && this.dataTypeManager.isNonComparable(this.dataTypeManager.getDataTypeName(aggExp.getType()))) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.non_comparable, aggregateFunction, obj), obj);
        }
        if (obj.isEnhancedNumeric()) {
            if (!Number.class.isAssignableFrom(aggExp.getType())) {
                this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0041, aggregateFunction, obj), obj);
            }
            if (obj.isDistinct()) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.invalid_distinct, aggregateFunction, obj), obj);
            }
        }
        if (obj.getAggregateFunction() != IAggregateSymbol.Type.TEXTAGG) {
            return;
        }
        TextLine tl = (TextLine)aggExp;
        if (tl.isIncludeHeader()) {
            this.validateDerivedColumnNames(obj, tl.getExpressions());
        }
        for (DerivedColumn dc : tl.getExpressions()) {
            this.validateXMLContentTypes(dc.getExpression(), obj);
        }
        this.validateTextOptions(obj, tl.getDelimiter(), tl.getQuote());
        if (tl.getEncoding() != null) {
            try {
                Charset.forName(tl.getEncoding());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.invalid_encoding, tl.getEncoding()), obj);
            }
        }
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private void validateJSONValue(LanguageObject obj, Expression expr) {
        if (expr.getType() != DataTypeManagerService.DefaultDataTypes.STRING.getTypeClass() && !this.dataTypeManager.isTransformable(expr.getType(), DataTypeManagerService.DefaultDataTypes.STRING.getTypeClass())) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.invalid_json_value, expr, obj), obj);
        }
    }

    private void validateNoSubqueriesOrOuterReferences(Expression expr) {
        if (!ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(expr).isEmpty()) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.filter_subquery, expr), expr);
        }
        for (ElementSymbol es : ElementCollectorVisitor.getElements((LanguageObject)expr, false)) {
            if (!es.isExternalReference()) continue;
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.filter_subquery, es), es);
        }
    }

    private void validateNoNestedAggs(LanguageObject aggExp) {
        if (aggExp != null) {
            LinkedHashSet nestedAggs = new LinkedHashSet();
            AggregateSymbolCollectorVisitor.getAggregates(aggExp, nestedAggs, null, null, nestedAggs, null);
            if (!nestedAggs.isEmpty()) {
                this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0039, nestedAggs), nestedAggs);
            }
        }
    }

    private String[] validateQName(LanguageObject obj, String name) {
        try {
            return Name11Checker.getInstance().getQNameParts((CharSequence)name);
        }
        catch (QNameException qNameException) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.xml_invalid_qname, name), obj);
            return null;
        }
    }

    private void validateDerivedColumnNames(LanguageObject obj, List<DerivedColumn> cols) {
        for (DerivedColumn dc : cols) {
            if (dc.getAlias() != null || dc.getExpression() instanceof ElementSymbol) continue;
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.expression_requires_name, new Object[0]), obj);
        }
    }

    @Override
    public void visit(XMLAttributes obj) {
        this.validateDerivedColumnNames(obj, obj.getArgs());
        for (DerivedColumn dc : obj.getArgs()) {
            String[] parts;
            if (dc.getAlias() == null) continue;
            if ("xmlns".equals(dc.getAlias())) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.xml_attributes_reserved, new Object[0]), obj);
            }
            if ((parts = this.validateQName(obj, dc.getAlias())) == null || !"xmlns".equals(parts[0])) continue;
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.xml_attributes_reserved, dc.getAlias()), obj);
        }
    }

    @Override
    public void visit(XMLElement obj) {
        for (Expression expression : obj.getContent()) {
            this.validateXMLContentTypes(expression, obj);
        }
        this.validateQName(obj, obj.getName());
    }

    public void validateXMLContentTypes(Expression expression, LanguageObject parent) {
        if (expression.getType() == DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeClass() || expression.getType() == DataTypeManagerService.DefaultDataTypes.BLOB.getTypeClass()) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.xml_content_type, expression), parent);
        }
    }

    @Override
    public void visit(QueryString obj) {
        this.validateDerivedColumnNames(obj, obj.getArgs());
    }

    @Override
    public void visit(XMLTable obj) {
        List<DerivedColumn> passing = obj.getPassing();
        this.validatePassing(obj, obj.getXQueryExpression(), passing);
        boolean hasOrdinal = false;
        for (XMLColumn xc : obj.getColumns()) {
            if (!xc.isOrdinal()) {
                if (xc.getDefaultExpression() == null || EvaluatableVisitor.isFullyEvaluatable(xc.getDefaultExpression(), false)) continue;
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.invalid_default, xc.getDefaultExpression()), obj);
                continue;
            }
            if (hasOrdinal) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.one_ordinal, new Object[0]), obj);
                break;
            }
            hasOrdinal = true;
        }
    }

    @Override
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    public void visit(ObjectTable obj) {
        List<DerivedColumn> passing = obj.getPassing();
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (DerivedColumn dc : passing) {
            if (dc.getAlias() == null) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.context_item_not_allowed, new Object[0]), obj);
                continue;
            }
            if (names.add(dc.getAlias())) continue;
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.duplicate_passing, dc.getAlias()), obj);
        }
        Compilable scriptCompiler = null;
        try {
            ScriptEngine engine = this.getMetadata().getScriptEngine(obj.getScriptingLanguage());
            obj.setScriptEngine(engine);
            if (engine instanceof Compilable) {
                scriptCompiler = (Compilable)((Object)engine);
                engine.put("javax.script.filename", "OBJECTTABLE");
                obj.setCompiledScript(scriptCompiler.compile(obj.getRowScript()));
            }
        }
        catch (Exception e) {
            this.handleValidationError(e.getMessage(), obj);
        }
        for (ObjectColumn xc : obj.getColumns()) {
            if (scriptCompiler != null) {
                try {
                    xc.setCompiledScript(scriptCompiler.compile(xc.getPath()));
                }
                catch (ScriptException e) {
                    this.handleValidationError(Messages.gs(Messages.TEIID.TEIID31110, xc.getPath(), e.getMessage()), obj);
                }
            }
            if (xc.getDefaultExpression() == null || EvaluatableVisitor.isFullyEvaluatable(xc.getDefaultExpression(), false)) continue;
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.invalid_default, xc.getDefaultExpression()), obj);
        }
    }

    @Override
    public void visit(XMLQuery obj) {
        this.validatePassing(obj, obj.getXQueryExpression(), obj.getPassing());
    }

    private void validatePassing(LanguageObject obj, SaxonXQueryExpression xqe, List<DerivedColumn> passing) {
        boolean context = false;
        boolean hadError = false;
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (DerivedColumn dc : passing) {
            if (dc.getAlias() == null) {
                Class<?> type = dc.getExpression().getType();
                if (type != DataTypeManagerService.DefaultDataTypes.XML.getTypeClass()) {
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.context_item_type, new Object[0]), obj);
                }
                if (context && !hadError) {
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.passing_requires_name, new Object[0]), obj);
                    hadError = true;
                }
                context = true;
                continue;
            }
            this.validateXMLContentTypes(dc.getExpression(), obj);
            if (names.add(dc.getAlias())) continue;
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.duplicate_passing, dc.getAlias()), obj);
        }
        if (xqe.usesContextItem() && !context) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.context_required, new Object[0]), obj);
        }
    }

    @Override
    public void visit(XMLNamespaces obj) {
        boolean hasDefault = false;
        for (NamespaceItem item : obj.getNamespaceItems()) {
            if (item.getPrefix() != null) {
                if (item.getPrefix().equals("xml") || item.getPrefix().equals("xmlns")) {
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.xml_namespaces_reserved, new Object[0]), obj);
                } else if (!Name11Checker.getInstance().isValidNCName((CharSequence)item.getPrefix())) {
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.xml_namespaces_invalid, item.getPrefix()), obj);
                }
                if (item.getUri().length() != 0) continue;
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.xml_namespaces_null_uri, new Object[0]), obj);
                continue;
            }
            if (hasDefault) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.xml_namespaces, new Object[0]), obj);
                break;
            }
            hasDefault = true;
        }
    }

    @Override
    public void visit(TextTable obj) {
        boolean widthSet = false;
        Character delimiter = null;
        Character quote = null;
        boolean usingSelector = false;
        for (TextColumn column : obj.getColumns()) {
            if (column.isOrdinal()) continue;
            if (column.getWidth() != null) {
                widthSet = true;
                if (column.getWidth() < 0) {
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.text_table_negative, new Object[0]), obj);
                }
            } else if (widthSet) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.text_table_invalid_width, new Object[0]), obj);
            }
            if (column.getSelector() != null) {
                usingSelector = true;
                if (obj.getSelector() != null && obj.getSelector().equals(column.getSelector())) {
                    this.handleValidationError(Messages.getString(Messages.ValidationVisitor.text_table_selector_required, new Object[0]), obj);
                }
            }
            if (column.getPosition() == null || column.getPosition() >= 0) continue;
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.text_table_negative, new Object[0]), obj);
        }
        if (widthSet) {
            if (obj.getDelimiter() != null || obj.getHeader() != null || obj.getQuote() != null || usingSelector) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.text_table_width, new Object[0]), obj);
            }
        } else {
            if (obj.getHeader() != null && obj.getHeader() < 0) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.text_table_negative, new Object[0]), obj);
            }
            if (!obj.isUsingRowDelimiter()) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.fixed_option, new Object[0]), obj);
            }
            delimiter = obj.getDelimiter();
            quote = obj.getQuote();
            this.validateTextOptions(obj, delimiter, quote);
        }
        if (obj.getSkip() != null && obj.getSkip() < 0) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.text_table_negative, new Object[0]), obj);
        }
        if (usingSelector && obj.getSelector() == null) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.text_table_selector_required, new Object[0]), obj);
        }
    }

    private void validateTextOptions(LanguageObject obj, Character delimiter, Character quote) {
        if (quote == null) {
            quote = Character.valueOf('\"');
        }
        if (delimiter == null) {
            delimiter = Character.valueOf(',');
        }
        if (quote.equals(delimiter)) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.text_table_delimiter, new Object[0]), obj);
        }
        if (quote.equals(Character.valueOf('\n')) || delimiter.equals(Character.valueOf('\n'))) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.text_table_newline, new Object[0]), obj);
        }
    }

    @Override
    public void visit(XMLParse obj) {
        if (obj.getExpression().getType() != DataTypeManagerService.DefaultDataTypes.STRING.getTypeClass() && obj.getExpression().getType() != DataTypeManagerService.DefaultDataTypes.CLOB.getTypeClass() && obj.getExpression().getType() != DataTypeManagerService.DefaultDataTypes.BLOB.getTypeClass()) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.xmlparse_type, new Object[0]), obj);
        }
    }

    @Override
    public void visit(ExistsCriteria obj) {
        this.validateSubquery(obj);
    }

    @Override
    public void visit(SubqueryFromClause obj) {
        this.validateSubquery(obj);
    }

    @Override
    public void visit(LoopStatement obj) {
        this.validateSubquery(obj);
    }

    @Override
    public void visit(WithQueryCommand obj) {
        this.validateSubquery(obj);
    }

    @Override
    public void visit(AlterView obj) {
        try {
            QueryResolver queryResolver = new QueryResolver(this.getTeiidVersion());
            queryResolver.validateProjectedSymbols(obj.getTarget(), this.getMetadata(), (Command)obj.getDefinition());
            Validator.validate(obj.getDefinition(), this.getMetadata(), this);
            this.validateAlterTarget(obj);
        }
        catch (QueryValidatorException e) {
            this.handleValidationError(e.getMessage(), (LanguageObject)obj.getDefinition());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void validateAlterTarget(Alter<?> obj) {
        if (this.getMetadata().getImportedModels().contains(obj.getTarget().getSchema())) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.invalid_alter, obj.getTarget()), obj.getTarget());
        }
    }

    @Override
    public void visit(AlterProcedure obj) {
        GroupSymbol gs = obj.getTarget();
        this.validateAlterTarget(obj);
        try {
            if (!gs.isProcedure() || !this.getMetadata().isVirtualModel(this.getMetadata().getModelID(gs.getMetadataID()))) {
                this.handleValidationError(Messages.getString(Messages.ValidationVisitor.not_a_procedure, gs), gs);
                return;
            }
            Validator.validate(obj.getDefinition(), this.getMetadata(), this);
            QueryResolver queryResolver = new QueryResolver(this.getTeiidVersion());
            IStoredProcedureInfo info = this.getMetadata().getStoredProcedureInfoForProcedure(gs.getName());
            for (ISPParameter param : info.getParameters()) {
                if (param.getParameterType() != SPParameter.RESULT_SET) continue;
                queryResolver.validateProjectedSymbols(gs, param.getResultSetColumns(), obj.getDefinition().getProjectedSymbols());
                break;
            }
        }
        catch (QueryValidatorException e) {
            Object command = obj.getDefinition();
            if (command instanceof CreateUpdateProcedureCommand) {
                this.handleValidationError(e.getMessage(), ((CreateUpdateProcedureCommand)command).getBlock());
            } else if (command instanceof CreateProcedureCommand) {
                this.handleValidationError(e.getMessage(), ((CreateProcedureCommand)command).getBlock());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(Block obj) {
        if (obj.getLabel() == null) {
            return;
        }
        for (LanguageObject lo : this.stack) {
            if (!(lo instanceof Labeled)) continue;
            Labeled labeled = (Labeled)((Object)lo);
            if (!obj.getLabel().equalsIgnoreCase(labeled.getLabel())) continue;
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.duplicate_block_label, obj.getLabel()), obj);
        }
    }

    private void visit8(CommandStatement obj) {
        if (this.createProc == null || this.createProc.getResultSetColumns().isEmpty() || !obj.isReturnable() || !obj.getCommand().returnsResultSet()) {
            return;
        }
        List<? extends Expression> symbols = obj.getCommand().getResultSetColumns();
        if (symbols == null && obj.getCommand() instanceof DynamicCommand) {
            DynamicCommand cmd = (DynamicCommand)obj.getCommand();
            cmd.setAsColumns(this.createProc.getResultSetColumns());
            return;
        }
        try {
            QueryResolver queryResolver = new QueryResolver(this.getTeiidVersion());
            queryResolver.validateProjectedSymbols((GroupSymbol)this.createProc.getVirtualGroup(), this.createProc.getResultSetColumns(), symbols);
        }
        catch (Exception e) {
            this.handleValidationError(Messages.gs(Messages.TEIID.TEIID31121, this.createProc.getVirtualGroup(), obj, e.getMessage()), obj);
        }
    }

    @Override
    public void visit(BranchingStatement obj) {
        boolean matchedLabel = false;
        boolean inLoop = false;
        for (LanguageObject lo : this.stack) {
            if (lo instanceof LoopStatement || lo instanceof WhileStatement) {
                inLoop = true;
                if (obj.getLabel() == null) break;
                matchedLabel |= obj.getLabel().equalsIgnoreCase(((Labeled)((Object)lo)).getLabel());
                continue;
            }
            if (obj.getLabel() == null || !(lo instanceof Block) || !obj.getLabel().equalsIgnoreCase(((Block)lo).getLabel())) continue;
            matchedLabel = true;
            if (obj.getMode() == BranchingStatement.BranchingMode.LEAVE) continue;
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.invalid_label, obj.getLabel()), obj);
        }
        if (obj.getMode() != BranchingStatement.BranchingMode.LEAVE && !inLoop) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.no_loop, new Object[0]), obj);
        }
        if (obj.getLabel() != null && !matchedLabel) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.unknown_block_label, obj.getLabel()), obj);
        }
    }

    @Override
    public void visit(AlterTrigger obj) {
        this.validateAlterTarget(obj);
        this.validateGroupSupportsUpdate(obj.getTarget());
        try {
            if (obj.getDefinition() != null) {
                Validator.validate(obj.getDefinition(), this.getMetadata(), this);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void validateSubquery(SubqueryContainer<?> subQuery) {
        if (subQuery.getCommand() instanceof Query && ((Query)subQuery.getCommand()).getInto() != null) {
            this.handleValidationError(Messages.getString(Messages.ValidationVisitor.subquery_insert, new Object[0]), (LanguageObject)subQuery.getCommand());
        }
    }

    private static final class PositiveIntegerConstraint
    implements Reference.Constraint {
        private Messages.ValidationVisitor msgKey;

        public PositiveIntegerConstraint(Messages.ValidationVisitor enumKey) {
            this.msgKey = enumKey;
        }

        @Override
        public void validate(Object value) throws Exception {
            if (value == null || (Integer)value < 0) {
                throw new TeiidClientException(Messages.getString(this.msgKey, new Object[0]));
            }
        }
    }
}

