/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.util;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Random;
import java.util.TimeZone;
import javax.security.auth.Subject;
import org.teiid.core.util.LRUCache;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.metadata.FunctionMethod;

public class CommandContext
implements Cloneable,
org.teiid.CommandContext {
    private GlobalState globalState = new GlobalState();
    private FunctionMethod.Determinism[] determinismLevel = new FunctionMethod.Determinism[]{FunctionMethod.Determinism.DETERMINISTIC};
    private final ITeiidServerVersion teiidVersion;

    public CommandContext(ITeiidServerVersion teiidVersion) {
        this.teiidVersion = teiidVersion;
    }

    public ITeiidServerVersion getTeiidVersion() {
        return this.teiidVersion;
    }

    public FunctionMethod.Determinism getDeterminismLevel() {
        return this.determinismLevel[0];
    }

    public void setDeterminismLevel(FunctionMethod.Determinism level) {
        if (this.determinismLevel[0] == null || level.compareTo(this.determinismLevel[0]) < 0) {
            this.determinismLevel[0] = level;
        }
    }

    @Override
    public double getNextRand() {
        if (this.globalState.random == null) {
            this.globalState.random = new Random();
        }
        return this.globalState.random.nextDouble();
    }

    @Override
    public double getNextRand(long seed) {
        if (this.globalState.random == null) {
            this.globalState.random = new Random();
        }
        this.globalState.random.setSeed(seed);
        return this.globalState.random.nextDouble();
    }

    public static DecimalFormat getDecimalFormat(CommandContext context, String format) {
        DecimalFormat result = null;
        if (context != null) {
            if (context.globalState.decimalFormatCache == null) {
                context.globalState.decimalFormatCache = new LRUCache(32);
            } else {
                result = (DecimalFormat)context.globalState.decimalFormatCache.get(format);
            }
        }
        if (result == null) {
            result = new DecimalFormat(format);
            result.setParseBigDecimal(true);
            if (context != null) {
                context.globalState.decimalFormatCache.put(format, result);
            }
        }
        return result;
    }

    public static SimpleDateFormat getDateFormat(CommandContext context, String format) {
        SimpleDateFormat result = null;
        if (context != null) {
            if (context.globalState.dateFormatCache == null) {
                context.globalState.dateFormatCache = new LRUCache(32);
            } else {
                result = (SimpleDateFormat)context.globalState.dateFormatCache.get(format);
            }
        }
        if (result == null) {
            result = new SimpleDateFormat(format);
            if (context != null) {
                context.globalState.dateFormatCache.put(format, result);
            }
        }
        return result;
    }

    @Override
    public String getUserName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVdbName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getVdbVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getConnectionId() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public String getConnectionID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getProcessorBatchSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TimeZone getServerTimeZone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Subject getSubject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Serializable getCommandPayload() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRequestId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getReuseCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassLoader getVDBClassLoader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addWarning(Exception ex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isContinuous() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReturnAutoGeneratedKeys() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object setSessionVariable(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getSessionVariable(String key) {
        throw new UnsupportedOperationException();
    }

    private static class GlobalState
    implements Cloneable {
        private Random random = null;
        private LRUCache<String, DecimalFormat> decimalFormatCache;
        private LRUCache<String, SimpleDateFormat> dateFormatCache;

        private GlobalState() {
        }
    }
}

