/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.util.StringUtil;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.query.sql.ILanguageVisitor;
import org.teiid.designer.query.sql.ISQLStringVisitor;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.symbol.IAggregateSymbol;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.language.SQLConstants;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.DDLConstants;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.AlterView;
import org.teiid.query.sql.lang.ArrayTable;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.CriteriaSelector;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.HasCriteria;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Labeled;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.lang.LeadingComment;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NamespaceItem;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.ObjectColumn;
import org.teiid.query.sql.lang.ObjectTable;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.lang.ProjectedColumn;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubqueryHint;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.TextColumn;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.TrailingComment;
import org.teiid.query.sql.lang.TranslateCriteria;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.lang.XMLColumn;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.BranchingStatement;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.ExceptionExpression;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.RaiseErrorStatement;
import org.teiid.query.sql.proc.RaiseStatement;
import org.teiid.query.sql.proc.ReturnStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.JSONObject;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.symbol.WindowSpecification;
import org.teiid.query.sql.symbol.XMLAttributes;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;

public class SQLStringVisitor
extends LanguageVisitor
implements SQLConstants.Reserved,
SQLConstants.NonReserved,
SQLConstants.Tokens,
DDLConstants,
ISQLStringVisitor<LanguageObject> {
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private static final Map<String, String> BUILTIN_PREFIXES = new HashMap<String, String>();
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private static final HashSet<String> LENGTH_DATATYPES;
    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private static final HashSet<String> PRECISION_DATATYPES;
    public static final String UNDEFINED = "<undefined>";
    private static final String BEGIN_HINT = "/*+";
    private static final String END_HINT = "*/";
    private static final char ID_ESCAPE_CHAR = '\"';
    protected StringBuilder parts = new StringBuilder();
    private boolean shortNameOnly = false;

    static {
        for (Map.Entry<String, String> entry : MetadataFactory.BUILTIN_NAMESPACES.entrySet()) {
            BUILTIN_PREFIXES.put(entry.getValue(), entry.getKey());
        }
        LENGTH_DATATYPES = new HashSet<String>(Arrays.asList(DataTypeManagerService.DefaultDataTypes.CHAR.getId(), DataTypeManagerService.DefaultDataTypes.CLOB.getId(), DataTypeManagerService.DefaultDataTypes.BLOB.getId(), DataTypeManagerService.DefaultDataTypes.OBJECT.getId(), DataTypeManagerService.DefaultDataTypes.XML.getId(), DataTypeManagerService.DefaultDataTypes.STRING.getId(), DataTypeManagerService.DefaultDataTypes.VARBINARY.getId(), DataTypeManagerService.DefaultDataTypes.BIG_INTEGER.getId()));
        PRECISION_DATATYPES = new HashSet<String>(Arrays.asList(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL.getId()));
    }

    public SQLStringVisitor(ITeiidServerVersion teiidVersion) {
        super(teiidVersion);
    }

    public static final String getSQLString(LanguageObject obj) {
        if (obj == null) {
            return UNDEFINED;
        }
        SQLStringVisitor visitor = new SQLStringVisitor(obj.getTeiidVersion());
        return visitor.returnSQLString(obj);
    }

    public String returnSQLString(LanguageObject languageObject) {
        if (languageObject == null) {
            return UNDEFINED;
        }
        this.isApplicable(languageObject);
        languageObject.acceptVisitor((ILanguageVisitor)this);
        return this.getSQLString();
    }

    public String getSQLString() {
        return this.parts.toString();
    }

    public boolean isShortNameOnly() {
        if (!this.isTeiid8OrGreater()) {
            return false;
        }
        return this.shortNameOnly;
    }

    private void setShortNameOnly(boolean shortNameOnly) {
        if (!this.isTeiid8OrGreater()) {
            return;
        }
        this.shortNameOnly = shortNameOnly;
    }

    protected void visitNode(LanguageObject obj) {
        if (obj == null) {
            this.append(UNDEFINED);
            return;
        }
        this.isApplicable(obj);
        obj.acceptVisitor((ILanguageVisitor)this);
    }

    protected void append(Object value) {
        this.parts.append(value);
    }

    protected void beginClause(int level) {
        this.append(" ");
    }

    private Constant newConstant(Object value) {
        Constant constant = (Constant)this.createNode(TeiidNodeFactory.ASTNodes.CONSTANT);
        constant.setValue(value);
        return constant;
    }

    @Override
    public void visit(BetweenCriteria obj) {
        this.visitNode(obj.getExpression());
        this.append(" ");
        if (obj.isNegated()) {
            this.append("NOT");
            this.append(" ");
        }
        this.append("BETWEEN");
        this.append(" ");
        this.visitNode(obj.getLowerExpression());
        this.append(" ");
        this.append("AND");
        this.append(" ");
        this.visitNode(obj.getUpperExpression());
    }

    @Override
    public void visit(CaseExpression obj) {
        this.append("CASE");
        this.append(" ");
        this.visitNode(obj.getExpression());
        this.append(" ");
        int i = 0;
        while (i < obj.getWhenCount()) {
            this.append("WHEN");
            this.append(" ");
            this.visitNode(obj.getWhenExpression(i));
            this.append(" ");
            this.append("THEN");
            this.append(" ");
            this.visitNode(obj.getThenExpression(i));
            this.append(" ");
            ++i;
        }
        if (obj.getElseExpression() != null) {
            this.append("ELSE");
            this.append(" ");
            this.visitNode(obj.getElseExpression());
            this.append(" ");
        }
        this.append("END");
    }

    @Override
    public void visit(CompareCriteria obj) {
        IExpression leftExpression = obj.getLeftExpression();
        this.visitNode((LanguageObject)leftExpression);
        this.append(" ");
        this.append(obj.getOperatorAsString());
        this.append(" ");
        Expression rightExpression = obj.getRightExpression();
        this.visitNode(rightExpression);
    }

    @Override
    public void visit(CompoundCriteria obj) {
        int operator = obj.getOperator();
        String operatorStr = "";
        if (operator == CompoundCriteria.AND) {
            operatorStr = "AND";
        } else if (operator == CompoundCriteria.OR) {
            operatorStr = "OR";
        }
        List<Criteria> subCriteria = obj.getCriteria();
        if (subCriteria.size() == 1) {
            Criteria firstChild = subCriteria.get(0);
            this.visitNode(firstChild);
        } else {
            Iterator<Criteria> iter = subCriteria.iterator();
            while (iter.hasNext()) {
                Criteria crit = iter.next();
                this.append("(");
                this.visitNode(crit);
                this.append(")");
                if (!iter.hasNext()) continue;
                this.append(" ");
                this.append(operatorStr);
                this.append(" ");
            }
        }
    }

    @Override
    public void visit(Delete obj) {
        this.append("DELETE");
        this.addSourceHint(obj.getSourceHint());
        this.append(" ");
        this.append("FROM");
        this.append(" ");
        this.visitNode(obj.getGroup());
        if (obj.getCriteria() != null) {
            this.beginClause(0);
            this.visitCriteria("WHERE", obj.getCriteria());
        }
        if (obj.getOption() != null) {
            this.beginClause(0);
            this.visitNode(obj.getOption());
        }
    }

    @Override
    public void visit(From obj) {
        this.append("FROM");
        this.beginClause(1);
        this.registerNodes(obj.getClauses(), 0);
    }

    @Override
    public void visit(GroupBy obj) {
        this.append("GROUP");
        this.append(" ");
        this.append("BY");
        this.append(" ");
        if (this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_5) && obj.isRollup()) {
            this.append("ROLLUP");
            this.append("(");
        }
        this.registerNodes(obj.getSymbols(), 0);
        if (this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_5) && obj.isRollup()) {
            this.append(")");
        }
    }

    @Override
    public void visit(Insert obj) {
        if (this.isTeiid8OrGreater() && obj.isMerge()) {
            this.append("MERGE");
        } else {
            this.append("INSERT");
        }
        this.addSourceHint(obj.getSourceHint());
        this.append(" ");
        this.append("INTO");
        this.append(" ");
        this.visitNode(obj.getGroup());
        if (!obj.getVariables().isEmpty()) {
            this.beginClause(2);
            List<ElementSymbol> vars = obj.getVariables();
            if (vars != null) {
                this.append("(");
                this.setShortNameOnly(true);
                this.registerNodes(vars, 0);
                this.setShortNameOnly(false);
                this.append(")");
            }
        }
        this.beginClause(1);
        if (obj.getQueryExpression() != null) {
            this.visitNode(obj.getQueryExpression());
        } else if (obj.getValues() != null) {
            this.append("VALUES");
            this.beginClause(2);
            this.append("(");
            this.registerNodes(obj.getValues(), 0);
            this.append(")");
        }
        if (obj.getOption() != null) {
            this.beginClause(1);
            this.visitNode(obj.getOption());
        }
    }

    private void visit7(Create obj) {
        this.append("CREATE");
        this.append(" ");
        this.append("LOCAL");
        this.append(" ");
        this.append("TEMPORARY");
        this.append(" ");
        this.append("TABLE");
        this.append(" ");
        this.visitNode(obj.getTable());
        this.append(" ");
        List<Column> columns = obj.getColumns();
        this.append("(");
        Iterator<Column> iter = columns.iterator();
        while (iter.hasNext()) {
            Column element = iter.next();
            this.outputDisplayName(element.getName());
            this.append(" ");
            if (element.isAutoIncremented()) {
                this.append("SERIAL");
            } else {
                this.append(element.getRuntimeType());
                if (element.getNullType() == BaseColumn.NullType.No_Nulls) {
                    this.append("NOT");
                    this.append(" ");
                    this.append("NULL");
                }
            }
            if (!iter.hasNext()) continue;
            this.append(", ");
        }
        if (!obj.getPrimaryKey().isEmpty()) {
            this.append(", ");
            this.append("PRIMARY");
            this.append(" ");
            this.append("KEY");
            this.append("(");
            Iterator<ElementSymbol> pkiter = obj.getPrimaryKey().iterator();
            while (pkiter.hasNext()) {
                this.outputShortName(pkiter.next());
                if (!pkiter.hasNext()) continue;
                this.append(", ");
            }
            this.append(")");
        }
        this.append(")");
    }

    private String buildTableOptions(Table table) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, table);
        if (table.isMaterialized()) {
            this.addOption(options, "MATERIALIZED", table.isMaterialized());
            if (table.getMaterializedTable() != null) {
                this.addOption(options, "MATERIALIZED_TABLE", table.getMaterializedTable().getName());
            }
        }
        if (table.supportsUpdate()) {
            this.addOption(options, "UPDATABLE", table.supportsUpdate());
        }
        if (table.getCardinality() != -1) {
            this.addOption(options, "CARDINALITY", table.getCardinality());
        }
        if (!table.getProperties().isEmpty()) {
            for (String key : table.getProperties().keySet()) {
                this.addOption(options, key, table.getProperty(key, false));
            }
        }
        return options.toString();
    }

    private void addCommonOptions(StringBuilder sb, AbstractMetadataRecord record) {
        if (record.getUUID() != null && !record.getUUID().startsWith("tid:")) {
            this.addOption(sb, "UUID", record.getUUID());
        }
        if (record.getAnnotation() != null) {
            this.addOption(sb, "ANNOTATION", record.getAnnotation());
        }
        if (record.getNameInSource() != null && !record.getNameInSource().equals(record.getName())) {
            this.addOption(sb, "NAMEINSOURCE", record.getNameInSource());
        }
    }

    private void buildContraints(Table table) {
        this.addConstraints(table.getAccessPatterns(), "AP", "ACCESSPATTERN");
        KeyRecord pk = table.getPrimaryKey();
        if (pk != null) {
            this.addConstraint("PK", "PRIMARY KEY", pk, true);
        }
        this.addConstraints(table.getUniqueKeys(), "UNIQUE", "UNIQUE");
        this.addConstraints(table.getIndexes(), "INDEX", "INDEX");
        this.addConstraints(table.getFunctionBasedIndexes(), "INDEX", "INDEX");
        int i = 0;
        while (i < table.getForeignKeys().size()) {
            ForeignKey key = table.getForeignKeys().get(i);
            this.addConstraint("FK" + i, "FOREIGN KEY", key, false);
            this.append(" ");
            this.append("REFERENCES");
            if (key.getReferenceTableName() != null) {
                this.append(" ");
                GroupSymbol gs = (GroupSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
                gs.setName(key.getReferenceTableName());
                this.append(gs.getName());
            }
            this.append(" ");
            this.addNames(key.getReferenceColumns());
            this.appendOptions(key);
            ++i;
        }
    }

    private void addConstraints(List<KeyRecord> constraints, String defaultName, String type) {
        int i = 0;
        while (i < constraints.size()) {
            KeyRecord constraint = constraints.get(i);
            this.addConstraint(String.valueOf(defaultName) + i, type, constraint, true);
            ++i;
        }
    }

    private void addConstraint(String defaultName, String type, KeyRecord constraint, boolean addOptions) {
        this.append(",");
        this.append("\n");
        this.append("\t");
        boolean nameMatches = defaultName.equals(constraint.getName());
        if (!nameMatches) {
            this.append("CONSTRAINT");
            this.append(" ");
            this.append(this.escapeSinglePart(constraint.getName()));
            this.append(" ");
        }
        this.append(type);
        this.addColumns(constraint.getColumns(), false);
        if (addOptions) {
            this.appendOptions(constraint);
        }
    }

    private void addColumns(List<Column> columns, boolean includeType) {
        this.append("(");
        boolean first = true;
        for (Column c : columns) {
            if (first) {
                first = false;
            } else {
                this.append(",");
                this.append(" ");
            }
            if (includeType) {
                this.appendColumn(c, true, includeType);
                this.appendColumnOptions(c);
                continue;
            }
            if (c.getParent() instanceof KeyRecord) {
                this.append(c.getNameInSource());
                continue;
            }
            this.append(this.escapeSinglePart(c.getName()));
        }
        this.append(")");
    }

    private void addNames(List<String> columns) {
        if (columns != null) {
            this.append("(");
            boolean first = true;
            for (String c : columns) {
                if (first) {
                    first = false;
                } else {
                    this.append(",");
                    this.append(" ");
                }
                this.append(this.escapeSinglePart(c));
            }
            this.append(")");
        }
    }

    private void visit(Column column) {
        this.append("\n");
        this.append("\t");
        this.appendColumn(column, true, true);
        if (column.isAutoIncremented()) {
            this.append(" ");
            this.append("AUTO_INCREMENT");
        }
        this.appendDefault(column);
        this.appendColumnOptions(column);
    }

    private void appendDefault(BaseColumn column) {
        if (column.getDefaultValue() != null) {
            this.append(" ");
            this.append("DEFAULT");
            this.append(" ");
            this.append("'");
            this.append(StringUtil.replaceAll(column.getDefaultValue(), "'", "''"));
            this.append("'");
        }
    }

    private void appendColumn(BaseColumn column, boolean includeName, boolean includeType) {
        if (includeName) {
            this.append(this.escapeSinglePart(column.getName()));
        }
        if (includeType) {
            String runtimeTypeName = column.getDatatype().getRuntimeTypeName();
            if (includeName) {
                this.append(" ");
            }
            this.append(runtimeTypeName);
            if (LENGTH_DATATYPES.contains(runtimeTypeName)) {
                if (column.getLength() != 0 && column.getLength() != column.getDatatype().getLength()) {
                    this.append("(");
                    this.append(column.getLength());
                    this.append(")");
                }
            } else if (PRECISION_DATATYPES.contains(runtimeTypeName) && (column.getPrecision() != column.getDatatype().getPrecision() || column.getScale() != column.getDatatype().getScale())) {
                this.append("(");
                this.append(column.getPrecision());
                if (column.getScale() != 0) {
                    this.append(",");
                    this.append(column.getScale());
                }
                this.append(")");
            }
            if (column.getNullType() == BaseColumn.NullType.No_Nulls) {
                this.append(" ");
                this.append("NOT NULL");
            }
        }
    }

    private void appendColumnOptions(BaseColumn column) {
        StringBuilder options = new StringBuilder();
        this.addCommonOptions(options, column);
        if (!column.getDatatype().isBuiltin()) {
            this.addOption(options, "UDT", String.valueOf(column.getDatatype().getName()) + "(" + column.getLength() + ", " + column.getPrecision() + ", " + column.getScale() + ")");
        }
        if (column.getDatatype().getRadix() != 0 && column.getRadix() != column.getDatatype().getRadix()) {
            this.addOption(options, "RADIX", column.getRadix());
        }
        if (column instanceof Column) {
            this.buildColumnOptions((Column)column, options);
        }
        if (options.length() != 0) {
            this.append(" ");
            this.append("OPTIONS");
            this.append(" ");
            this.append("(");
            this.append(options);
            this.append(")");
        }
    }

    private void buildColumnOptions(Column column, StringBuilder options) {
        if (!column.isSelectable()) {
            this.addOption(options, "SELECTABLE", column.isSelectable());
        }
        if (!column.isUpdatable() && column.getParent() instanceof Table && ((Table)column.getParent()).supportsUpdate()) {
            this.addOption(options, "UPDATABLE", column.isUpdatable());
        }
        if (column.isCurrency()) {
            this.addOption(options, "CURRENCY", column.isCurrency());
        }
        if (!column.isCaseSensitive() && column.getDatatype().isCaseSensitive()) {
            this.addOption(options, "CASE_SENSITIVE", column.isCaseSensitive());
        }
        if (!column.isSigned() && column.getDatatype().isSigned()) {
            this.addOption(options, "SIGNED", column.isSigned());
        }
        if (column.isFixedLength()) {
            this.addOption(options, "FIXED_LENGTH", column.isFixedLength());
        }
        if (column.getCharOctetLength() != 0 && column.getLength() != column.getCharOctetLength()) {
            this.addOption(options, "CHAR_OCTET_LENGTH", column.getCharOctetLength());
        }
        if (column.getSearchType() != null && (!column.getSearchType().equals((Object)column.getDatatype().getSearchType()) || column.isSearchTypeSet())) {
            this.addOption(options, "SEARCHABLE", column.getSearchType().name());
        }
        if (column.getMinimumValue() != null) {
            this.addOption(options, "MIN_VALUE", column.getMinimumValue());
        }
        if (column.getMaximumValue() != null) {
            this.addOption(options, "MAX_VALUE", column.getMaximumValue());
        }
        if (column.getNativeType() != null) {
            this.addOption(options, "NATIVE_TYPE", column.getNativeType());
        }
        if (column.getNullValues() != -1) {
            this.addOption(options, "NULL_VALUE_COUNT", column.getNullValues());
        }
        if (column.getDistinctValues() != -1) {
            this.addOption(options, "DISTINCT_VALUES", column.getDistinctValues());
        }
        this.buildOptions(column, options);
    }

    private void appendOptions(AbstractMetadataRecord record) {
        StringBuilder options = new StringBuilder();
        this.buildOptions(record, options);
        if (options.length() != 0) {
            this.append(" ");
            this.append("OPTIONS");
            this.append(" ");
            this.append("(");
            this.append(options);
            this.append(")");
        }
    }

    private void buildOptions(AbstractMetadataRecord record, StringBuilder options) {
        if (!record.getProperties().isEmpty()) {
            for (Map.Entry<String, String> entry : record.getProperties().entrySet()) {
                this.addOption(options, entry.getKey(), entry.getValue());
            }
        }
    }

    private void addOption(StringBuilder sb, String key, Object value) {
        if (sb.length() != 0) {
            sb.append(",").append(" ");
        }
        Constant c = (Constant)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.CONSTANT);
        c.setValue(value);
        value = c;
        if (key != null && key.length() > 2 && key.charAt(0) == '{') {
            String origKey = key;
            int index = key.indexOf(125);
            if (index > 1) {
                String uri = key.substring(1, index);
                key = key.substring(index + 1, key.length());
                String prefix = BUILTIN_PREFIXES.get(uri);
                key = prefix != null ? String.valueOf(prefix) + ":" + key : origKey;
            }
        }
        sb.append(this.escapeSinglePart(key));
        this.append(" ");
        this.append(value);
    }

    private String addTableBody(Table table) {
        String options;
        String name = this.escapeSinglePart(table.getName());
        this.append(name);
        if (table.getColumns() != null) {
            this.append(" ");
            this.append("(");
            boolean first = true;
            for (Column c : table.getColumns()) {
                if (first) {
                    first = false;
                } else {
                    this.append(",");
                }
                this.visit(c);
            }
            this.buildContraints(table);
            this.append("\n");
            this.append(")");
        }
        if (!(options = this.buildTableOptions(table)).isEmpty()) {
            this.append(" ");
            this.append("OPTIONS");
            this.append(" ");
            this.append("(");
            this.append(options);
            this.append(")");
        }
        return name;
    }

    private void visit8(Create obj) {
        this.append("CREATE");
        this.append(" ");
        if (obj.getTableMetadata() != null) {
            this.append("FOREIGN");
            this.append(" ");
            this.append("TEMPORARY");
            this.append(" ");
            this.append("TABLE");
            this.append(" ");
            this.addTableBody(obj.getTableMetadata());
            this.append(" ");
            this.append("ON");
            this.append(" ");
            this.outputLiteral(String.class, false, obj.getOn());
            return;
        }
        this.append("LOCAL");
        this.append(" ");
        this.append("TEMPORARY");
        this.append(" ");
        this.append("TABLE");
        this.append(" ");
        this.visitNode(obj.getTable());
        this.append(" ");
        List<Column> columns = obj.getColumns();
        this.append("(");
        Iterator<Column> iter = columns.iterator();
        while (iter.hasNext()) {
            Column element = iter.next();
            this.outputDisplayName(element.getName());
            this.append(" ");
            if (element.isAutoIncremented()) {
                this.append("SERIAL");
            } else {
                this.append(element.getRuntimeType());
                if (element.getNullType() == BaseColumn.NullType.No_Nulls) {
                    this.append(" ");
                    this.append("NOT");
                    this.append(" ");
                    this.append("NULL");
                }
            }
            if (!iter.hasNext()) continue;
            this.append(", ");
        }
        if (!obj.getPrimaryKey().isEmpty()) {
            this.append(", ");
            this.append("PRIMARY");
            this.append(" ");
            this.append("KEY");
            this.append("(");
            Iterator<ElementSymbol> pkiter = obj.getPrimaryKey().iterator();
            while (pkiter.hasNext()) {
                this.outputShortName(pkiter.next());
                if (!pkiter.hasNext()) continue;
                this.append(", ");
            }
            this.append(")");
        }
        this.append(")");
    }

    @Override
    public void visit(Create obj) {
        if (this.isTeiid8OrGreater()) {
            this.visit8(obj);
        } else {
            this.visit7(obj);
        }
    }

    @Override
    public void visit(Drop obj) {
        this.append("DROP");
        this.append(" ");
        this.append("TABLE");
        this.append(" ");
        this.visitNode(obj.getTable());
    }

    @Override
    public void visit(IsNullCriteria obj) {
        Expression expr = obj.getExpression();
        if (this.isTeiid8OrGreater()) {
            this.appendNested(expr);
        } else {
            this.visitNode(expr);
        }
        this.append(" ");
        this.append("IS");
        this.append(" ");
        if (obj.isNegated()) {
            this.append("NOT");
            this.append(" ");
        }
        this.append("NULL");
    }

    @Override
    public void visit(JoinPredicate obj) {
        FromClause leftClause;
        this.addHintComment(obj);
        if (obj.hasHint()) {
            this.append("(");
        }
        if ((leftClause = obj.getLeftClause()) instanceof JoinPredicate && !((JoinPredicate)leftClause).hasHint()) {
            this.append("(");
            this.visitNode(leftClause);
            this.append(")");
        } else {
            this.visitNode(leftClause);
        }
        this.append(" ");
        this.visitNode(obj.getJoinType());
        this.append(" ");
        FromClause rightClause = obj.getRightClause();
        if (rightClause instanceof JoinPredicate && !((JoinPredicate)rightClause).hasHint()) {
            this.append("(");
            this.visitNode(rightClause);
            this.append(")");
        } else {
            this.visitNode(rightClause);
        }
        List joinCriteria = obj.getJoinCriteria();
        if (joinCriteria != null && joinCriteria.size() > 0) {
            this.append(" ");
            this.append("ON");
            this.append(" ");
            Iterator critIter = joinCriteria.iterator();
            while (critIter.hasNext()) {
                Criteria crit = (Criteria)critIter.next();
                if (crit instanceof PredicateCriteria || crit instanceof NotCriteria) {
                    this.visitNode(crit);
                } else {
                    this.append("(");
                    this.visitNode(crit);
                    this.append(")");
                }
                if (!critIter.hasNext()) continue;
                this.append(" ");
                this.append("AND");
                this.append(" ");
            }
        }
        if (obj.hasHint()) {
            this.append(")");
        }
        this.addMakeDep(obj);
    }

    private void addHintComment(FromClause obj) {
        if (obj.hasHint()) {
            this.append(BEGIN_HINT);
            this.append(" ");
            if (obj.isOptional()) {
                this.append("optional");
                this.append(" ");
            }
            if (obj.getMakeDep() != null && obj.getMakeDep().isSimple()) {
                this.append("MAKEDEP");
                this.append(" ");
            }
            if (obj.isMakeNotDep()) {
                this.append("MAKENOTDEP");
                this.append(" ");
            }
            if (obj.isMakeInd()) {
                this.append("MAKEIND");
                this.append(" ");
            }
            if (obj.isNoUnnest()) {
                this.append(SubqueryHint.NOUNNEST);
                this.append(" ");
            }
            if (this.isTeiid8OrGreater() && obj.isPreserve()) {
                this.append("PRESERVE");
                this.append(" ");
            }
            this.append(END_HINT);
            this.append(" ");
        }
    }

    @Override
    public void visit(JoinType obj) {
        String[] output = null;
        switch (obj.getKind()) {
            case JOIN_ANTI_SEMI: {
                output = new String[]{"ANTI SEMI", " ", "JOIN"};
                break;
            }
            case JOIN_CROSS: {
                output = new String[]{"CROSS", " ", "JOIN"};
                break;
            }
            case JOIN_FULL_OUTER: {
                output = new String[]{"FULL", " ", "OUTER", " ", "JOIN"};
                break;
            }
            case JOIN_INNER: {
                output = new String[]{"INNER", " ", "JOIN"};
                break;
            }
            case JOIN_LEFT_OUTER: {
                output = new String[]{"LEFT", " ", "OUTER", " ", "JOIN"};
                break;
            }
            case JOIN_RIGHT_OUTER: {
                output = new String[]{"RIGHT", " ", "OUTER", " ", "JOIN"};
                break;
            }
            case JOIN_SEMI: {
                output = new String[]{"SEMI", " ", "JOIN"};
                break;
            }
            case JOIN_UNION: {
                output = new String[]{"UNION", " ", "JOIN"};
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        String[] stringArray = output;
        int n = output.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            this.append(part);
            ++n2;
        }
    }

    @Override
    public void visit(MatchCriteria obj) {
        this.visitNode(obj.getLeftExpression());
        this.append(" ");
        if (obj.isNegated()) {
            this.append("NOT");
            this.append(" ");
        }
        switch (obj.getMode()) {
            case SIMILAR: {
                this.append("SIMILAR");
                this.append(" ");
                this.append("TO");
                break;
            }
            case LIKE: {
                this.append("LIKE");
                break;
            }
            case REGEX: {
                this.append("LIKE_REGEX");
            }
        }
        this.append(" ");
        this.visitNode(obj.getRightExpression());
        if (obj.getEscapeChar() != '\u0000') {
            this.append(" ");
            this.append("ESCAPE");
            if (this.isTeiid8OrGreater()) {
                this.append(" ");
                this.outputLiteral(String.class, false, Character.valueOf(obj.getEscapeChar()));
            } else {
                this.append(" '");
                this.append(String.valueOf(obj.getEscapeChar()));
                this.append("'");
            }
        }
    }

    @Override
    public void visit(NotCriteria obj) {
        this.append("NOT");
        this.append(" (");
        this.visitNode(obj.getCriteria());
        this.append(")");
    }

    @Override
    public void visit(Option obj) {
        Iterator iter;
        this.append("OPTION");
        Collection groups = obj.getDependentGroups();
        if (groups != null && groups.size() > 0) {
            this.append(" ");
            this.append("MAKEDEP");
            this.append(" ");
            iter = groups.iterator();
            Iterator<Option.MakeDep> iter1 = obj.getMakeDepOptions().iterator();
            while (iter.hasNext()) {
                this.outputDisplayName((String)iter.next());
                this.appendMakeDepOptions(iter1.next());
                if (!iter.hasNext()) continue;
                this.append(", ");
            }
        }
        if ((groups = obj.getNotDependentGroups()) != null && groups.size() > 0) {
            this.append(" ");
            this.append("MAKENOTDEP");
            this.append(" ");
            iter = groups.iterator();
            while (iter.hasNext()) {
                this.outputDisplayName((String)iter.next());
                if (!iter.hasNext()) continue;
                this.append(", ");
            }
        }
        if ((groups = obj.getNoCacheGroups()) != null && groups.size() > 0) {
            this.append(" ");
            this.append("NOCACHE");
            this.append(" ");
            iter = groups.iterator();
            while (iter.hasNext()) {
                this.outputDisplayName((String)iter.next());
                if (!iter.hasNext()) continue;
                this.append(", ");
            }
        } else if (obj.isNoCache()) {
            this.append(" ");
            this.append("NOCACHE");
        }
    }

    public SQLStringVisitor appendMakeDepOptions(Option.MakeDep makedep) {
        if (this.isLessThanTeiidVersion(TeiidServerVersion.Version.TEIID_8_5)) {
            return this;
        }
        boolean parens = false;
        if (makedep.getMax() != null || makedep.isJoin()) {
            this.append("(");
            parens = true;
        }
        boolean space = false;
        if (makedep.getMax() != null) {
            if (space) {
                this.append(" ");
            } else {
                space = true;
            }
            this.append("MAX");
            this.append(":");
            this.append(makedep.getMax());
        }
        if (makedep.isJoin()) {
            if (space) {
                this.append(" ");
            } else {
                space = true;
            }
            this.append("JOIN");
        }
        if (parens) {
            this.append(")");
        }
        return this;
    }

    @Override
    public void visit(OrderBy obj) {
        this.append("ORDER");
        this.append(" ");
        this.append("BY");
        this.append(" ");
        this.registerNodes(obj.getOrderByItems(), 0);
    }

    @Override
    public void visit(OrderByItem obj) {
        Expression ses = obj.getSymbol();
        if (ses instanceof AliasSymbol) {
            AliasSymbol as = (AliasSymbol)ses;
            this.outputDisplayName(as.getOutputName());
        } else {
            this.visitNode(ses);
        }
        if (!obj.isAscending()) {
            this.append(" ");
            this.append("DESC");
        }
        if (obj.getNullOrdering() != null) {
            this.append(" ");
            this.append("NULLS");
            this.append(" ");
            this.append(obj.getNullOrdering().name());
        }
    }

    @Override
    public void visit(DynamicCommand obj) {
        this.append("EXECUTE");
        this.append(" ");
        this.append("IMMEDIATE");
        this.append(" ");
        this.visitNode(obj.getSql());
        if (obj.isAsClauseSet()) {
            this.beginClause(1);
            this.append("AS");
            this.append(" ");
            int i = 0;
            while (i < obj.getAsColumns().size()) {
                ElementSymbol symbol = (ElementSymbol)obj.getAsColumns().get(i);
                this.outputShortName(symbol);
                this.append(" ");
                this.append(this.getDataTypeManager().getDataTypeName(symbol.getType()));
                if (i < obj.getAsColumns().size() - 1) {
                    this.append(", ");
                }
                ++i;
            }
        }
        if (obj.getIntoGroup() != null) {
            this.beginClause(1);
            this.append("INTO");
            this.append(" ");
            this.visitNode(obj.getIntoGroup());
        }
        if (obj.getUsing() != null && !obj.getUsing().isEmpty()) {
            this.beginClause(1);
            this.append("USING");
            this.append(" ");
            this.visitNode(obj.getUsing());
        }
        if (obj.getUpdatingModelCount() > 0) {
            this.beginClause(1);
            this.append("UPDATE");
            this.append(" ");
            if (obj.getUpdatingModelCount() > 1) {
                this.append("*");
            } else {
                this.append("1");
            }
        }
    }

    @Override
    public void visit(SetClauseList obj) {
        Iterator<SetClause> iterator = obj.getClauses().iterator();
        while (iterator.hasNext()) {
            SetClause clause = iterator.next();
            this.visitNode(clause);
            if (!iterator.hasNext()) continue;
            this.append(", ");
        }
    }

    @Override
    public void visit(SetClause obj) {
        ElementSymbol symbol = obj.getSymbol();
        this.outputShortName(symbol);
        this.append(" = ");
        this.visitNode(obj.getValue());
    }

    @Override
    public void visit(WithQueryCommand obj) {
        this.visitNode(obj.getGroupSymbol());
        this.append(" ");
        if (obj.getColumns() != null && !obj.getColumns().isEmpty()) {
            this.append("(");
            this.setShortNameOnly(true);
            this.registerNodes(obj.getColumns(), 0);
            this.setShortNameOnly(false);
            this.append(")");
            this.append(" ");
        }
        this.append("AS");
        this.append(" ");
        this.append("(");
        if (this.isTeiidVersionOrGreater(TeiidServerVersion.Version.TEIID_8_5) && obj.getCommand() == null) {
            this.append("<dependent values>");
        } else {
            this.visitNode(obj.getCommand());
        }
        this.append(")");
    }

    @Override
    public void visit(Query obj) {
        this.addLeadingComment(obj.getLeadingComment());
        this.addCacheHint(obj.getCacheHint());
        this.addWithClause(obj);
        this.append("SELECT");
        SourceHint sh = obj.getSourceHint();
        this.addSourceHint(sh);
        if (obj.getSelect() != null) {
            this.visitNode(obj.getSelect());
        }
        if (obj.getInto() != null) {
            this.beginClause(1);
            this.visitNode(obj.getInto());
        }
        if (obj.getFrom() != null) {
            this.beginClause(1);
            this.visitNode(obj.getFrom());
        }
        if (obj.getCriteria() != null) {
            this.beginClause(1);
            this.visitCriteria("WHERE", obj.getCriteria());
        }
        if (obj.getGroupBy() != null) {
            this.beginClause(1);
            this.visitNode(obj.getGroupBy());
        }
        if (obj.getHaving() != null) {
            this.beginClause(1);
            this.visitCriteria("HAVING", obj.getHaving());
        }
        if (obj.getOrderBy() != null) {
            this.beginClause(1);
            this.visitNode(obj.getOrderBy());
        }
        if (obj.getLimit() != null) {
            this.beginClause(1);
            this.visitNode(obj.getLimit());
        }
        if (obj.getOption() != null) {
            this.beginClause(1);
            this.visitNode(obj.getOption());
        }
        this.addTrailingComment(obj.getTrailingComment());
    }

    private void addSourceHint(SourceHint sh) {
        if (sh != null) {
            this.append(" ");
            this.append(BEGIN_HINT);
            this.append("sh");
            if (this.isTeiid8OrGreater() && sh.isUseAliases()) {
                this.append(" ");
                this.append("KEEP ALIASES");
            }
            if (sh.getGeneralHint() != null) {
                this.appendSourceHintValue(sh.getGeneralHint());
            } else {
                this.append(" ");
            }
            if (sh.getSpecificHints() != null) {
                for (Map.Entry<String, SourceHint.SpecificHint> entry : sh.getSpecificHints().entrySet()) {
                    this.append(entry.getKey());
                    if (this.isTeiid8OrGreater() && entry.getValue().isUseAliases()) {
                        this.append(" ");
                        this.append("KEEP ALIASES");
                    }
                    this.appendSourceHintValue(entry.getValue().getHint());
                }
            }
            this.append(END_HINT);
        }
    }

    private void addWithClause(QueryCommand obj) {
        if (obj.getWith() != null) {
            this.append("WITH");
            this.append(" ");
            this.registerNodes(obj.getWith(), 0);
            this.beginClause(0);
        }
    }

    protected void visitCriteria(String keyWord, Criteria crit) {
        this.append(keyWord);
        this.append(" ");
        this.visitNode(crit);
    }

    @Override
    public void visit(SearchedCaseExpression obj) {
        this.append("CASE");
        int i = 0;
        while (i < obj.getWhenCount()) {
            this.append(" ");
            this.append("WHEN");
            this.append(" ");
            this.visitNode(obj.getWhenCriteria(i));
            this.append(" ");
            this.append("THEN");
            this.append(" ");
            this.visitNode(obj.getThenExpression(i));
            ++i;
        }
        this.append(" ");
        if (obj.getElseExpression() != null) {
            this.append("ELSE");
            this.append(" ");
            this.visitNode(obj.getElseExpression());
            this.append(" ");
        }
        this.append("END");
    }

    @Override
    public void visit(Select obj) {
        if (obj.isDistinct()) {
            this.append(" ");
            this.append("DISTINCT");
        }
        this.beginClause(2);
        Iterator<Expression> iter = obj.getSymbols().iterator();
        while (iter.hasNext()) {
            Expression symbol = iter.next();
            this.visitNode(symbol);
            if (!iter.hasNext()) continue;
            this.append(", ");
        }
    }

    private void appendSourceHintValue(String sh) {
        this.append(":");
        this.append(Character.valueOf('\''));
        this.append(SQLStringVisitor.escapeStringValue(sh, "'"));
        this.append(Character.valueOf('\''));
        this.append(" ");
    }

    @Override
    public void visit(SetCriteria obj) {
        if (this.isTeiid8OrGreater()) {
            this.appendNested((Expression)obj.getExpression());
        } else {
            this.visitNode((LanguageObject)obj.getExpression());
        }
        this.append(" ");
        if (obj.isNegated()) {
            this.append("NOT");
            this.append(" ");
        }
        this.append("IN");
        this.append(" (");
        Collection<Expression> vals = obj.getValues();
        int size = vals.size();
        if (size == 1) {
            Iterator<Expression> iter = vals.iterator();
            Expression expr = iter.next();
            this.visitNode(expr);
        } else if (size > 1) {
            Iterator<Expression> iter = vals.iterator();
            Expression expr = iter.next();
            this.visitNode(expr);
            while (iter.hasNext()) {
                expr = iter.next();
                this.append(", ");
                this.visitNode(expr);
            }
        }
        this.append(")");
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    private void appendNested(Expression ex) {
        boolean useParens = ex instanceof Criteria;
        if (useParens) {
            this.append("(");
        }
        this.visitNode(ex);
        if (useParens) {
            this.append(")");
        }
    }

    @Override
    public void visit(SetQuery obj) {
        this.addCacheHint(obj.getCacheHint());
        this.addWithClause(obj);
        QueryCommand query = obj.getLeftQuery();
        this.appendSetQuery(obj, query, false);
        this.beginClause(0);
        this.append(obj.getOperation());
        if (obj.isAll()) {
            this.append(" ");
            this.append("ALL");
        }
        this.beginClause(0);
        query = obj.getRightQuery();
        this.appendSetQuery(obj, query, true);
        if (obj.getOrderBy() != null) {
            this.beginClause(0);
            this.visitNode(obj.getOrderBy());
        }
        if (obj.getLimit() != null) {
            this.beginClause(0);
            this.visitNode(obj.getLimit());
        }
        if (obj.getOption() != null) {
            this.beginClause(0);
            this.visitNode(obj.getOption());
        }
    }

    protected void appendSetQuery(SetQuery parent, QueryCommand obj, boolean right) {
        if (obj.getLimit() != null || obj.getOrderBy() != null || right && obj instanceof SetQuery && (parent.isAll() && !((SetQuery)obj).isAll() || parent.getOperation() != ((SetQuery)obj).getOperation())) {
            this.append("(");
            this.visitNode(obj);
            this.append(")");
        } else {
            this.visitNode(obj);
        }
    }

    @Override
    public void visit(StoredProcedure obj) {
        this.addCacheHint(obj.getCacheHint());
        if (obj.isCalledWithReturn()) {
            for (SPParameter param : obj.getParameters()) {
                if (param.getParameterType() != SPParameter.RETURN_VALUE) continue;
                if (param.getExpression() == null) {
                    this.append("?");
                    continue;
                }
                this.visitNode(param.getExpression());
            }
            this.append(" ");
            this.append("=");
            this.append(" ");
        }
        this.append("EXEC");
        this.append(" ");
        this.append(obj.getProcedureName());
        this.append("(");
        boolean first = true;
        for (SPParameter param : obj.getParameters()) {
            boolean addParens;
            if (param.isUsingDefault() || param.getParameterType() == SPParameter.RETURN_VALUE || param.getParameterType() == SPParameter.RESULT_SET || param.getExpression() == null) continue;
            if (first) {
                first = false;
            } else {
                this.append(", ");
            }
            if (obj.isDisplayNamedParameters()) {
                this.append(this.escapeSinglePart(Symbol.getShortName(param.getParameterSymbol().getOutputName())));
                this.append(" => ");
            }
            boolean bl = addParens = !obj.isDisplayNamedParameters() && param.getExpression() instanceof CompareCriteria;
            if (addParens) {
                this.append("(");
            }
            this.visitNode(param.getExpression());
            if (!addParens) continue;
            this.append(")");
        }
        this.append(")");
        if (obj.getOption() != null) {
            this.beginClause(1);
            this.visitNode(obj.getOption());
        }
    }

    public void addCacheHint(CacheHint obj) {
        if (obj == null) {
            return;
        }
        this.append(BEGIN_HINT);
        this.append(" ");
        this.append("cache");
        boolean addParens = false;
        if (obj.isPrefersMemory()) {
            this.append("(");
            addParens = true;
            this.append("pref_mem");
        }
        if (obj.getTtl() != null) {
            if (!addParens) {
                this.append("(");
                addParens = true;
            } else {
                this.append(" ");
            }
            this.append("ttl:");
            this.append(obj.getTtl());
        }
        if (obj.getUpdatable() != null) {
            if (!addParens) {
                this.append("(");
                addParens = true;
            } else {
                this.append(" ");
            }
            this.append("updatable");
        }
        if (obj.getScope() != null) {
            if (!addParens) {
                this.append("(");
                addParens = true;
            } else {
                this.append(" ");
            }
            this.append("scope:");
            this.append((Object)obj.getScope());
        }
        if (addParens) {
            this.append(")");
        }
        this.append(" ");
        this.append(END_HINT);
        this.beginClause(0);
    }

    public void addLeadingComment(LeadingComment comment) {
        if (comment == null) {
            return;
        }
        this.append(comment.getComment());
        this.append(" ");
        this.append("\n");
    }

    public void addTrailingComment(TrailingComment comment) {
        if (comment == null) {
            return;
        }
        this.append("\n");
        this.append(" ");
        this.append(comment.getComment());
    }

    @Override
    public void visit(SubqueryFromClause obj) {
        this.addHintComment(obj);
        if (obj.isTable()) {
            this.append("TABLE");
        }
        this.append("(");
        this.visitNode(obj.getCommand());
        this.append(")");
        this.append(" AS ");
        GroupSymbol groupSymbol = obj.getGroupSymbol();
        if (this.isTeiid8OrGreater()) {
            this.append(this.escapeSinglePart(groupSymbol.getOutputName()));
        } else {
            this.append(groupSymbol.getOutputName());
        }
        this.addMakeDep(obj);
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        this.visitNode((LanguageObject)obj.getExpression());
        this.append(" ");
        if (obj.isNegated()) {
            this.append("NOT");
            this.append(" ");
        }
        this.append("IN");
        this.addSubqueryHint(obj.getSubqueryHint());
        this.append(" (");
        this.visitNode(obj.getCommand());
        this.append(")");
    }

    @Override
    public void visit(UnaryFromClause obj) {
        this.addHintComment(obj);
        this.visitNode(obj.getGroup());
        this.addMakeDep(obj);
    }

    @Override
    public void visit(Update obj) {
        this.append("UPDATE");
        this.addSourceHint(obj.getSourceHint());
        this.append(" ");
        this.visitNode(obj.getGroup());
        this.beginClause(1);
        this.append("SET");
        this.beginClause(2);
        this.visitNode(obj.getChangeList());
        if (obj.getCriteria() != null) {
            this.beginClause(1);
            this.visitCriteria("WHERE", obj.getCriteria());
        }
        if (obj.getOption() != null) {
            this.beginClause(1);
            this.visitNode(obj.getOption());
        }
    }

    @Override
    public void visit(Into obj) {
        this.append("INTO");
        this.append(" ");
        this.visitNode(obj.getGroup());
    }

    @Override
    public void visit(AggregateSymbol obj) {
        if (this.isTeiid8OrGreater()) {
            this.append(obj.getName());
        } else {
            this.append(obj.getAggregateFunction().name());
        }
        this.append("(");
        if (obj.isDistinct()) {
            this.append("DISTINCT");
            this.append(" ");
        } else if (this.isTeiid8OrGreater() && obj.getAggregateFunction() == IAggregateSymbol.Type.USER_DEFINED) {
            this.append("ALL");
            this.append(" ");
        }
        if (!this.isTeiid8OrGreater() && obj.getExpression() == null || this.isTeiid8OrGreater() && (obj.getArgs() == null || obj.getArgs().length == 0)) {
            if (obj.getAggregateFunction() == IAggregateSymbol.Type.COUNT) {
                this.append("*");
            }
        } else if (this.isTeiid8OrGreater()) {
            this.registerNodes(obj.getArgs(), 0);
        } else {
            this.visitNode(obj.getExpression());
        }
        if (obj.getOrderBy() != null) {
            this.append(" ");
            this.visitNode(obj.getOrderBy());
        }
        this.append(")");
        if (obj.getCondition() != null) {
            this.append(" ");
            this.append("FILTER");
            this.append("(");
            this.append("WHERE");
            this.append(" ");
            this.append(obj.getCondition());
            this.append(")");
        }
    }

    @Override
    public void visit(AliasSymbol obj) {
        this.visitNode(obj.getSymbol());
        this.append(" ");
        this.append("AS");
        this.append(" ");
        this.append(this.escapeSinglePart(obj.getOutputName()));
    }

    @Override
    public void visit(MultipleElementSymbol obj) {
        if (obj.getGroup() == null) {
            this.append("*");
        } else {
            this.visitNode(obj.getGroup());
            this.append(".");
            this.append("*");
        }
    }

    private void visit7(Constant obj) {
        Class<?> type = obj.getType();
        String[] constantParts = null;
        if (obj.isMultiValued()) {
            constantParts = new String[]{"?"};
        } else if (obj.getValue() == null) {
            constantParts = type.equals(DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass()) ? new String[]{"UNKNOWN"} : new String[]{"null"};
        } else {
            if (Number.class.isAssignableFrom(type)) {
                constantParts = new String[]{obj.getValue().toString()};
            } else if (type.equals(DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass())) {
                constantParts = new String[]{obj.getValue().equals(Boolean.TRUE) ? "TRUE" : "FALSE"};
            } else if (type.equals(DataTypeManagerService.DefaultDataTypes.TIMESTAMP.getTypeClass())) {
                constantParts = new String[]{"{ts'", obj.getValue().toString(), "'}"};
            } else if (type.equals(DataTypeManagerService.DefaultDataTypes.TIME.getTypeClass())) {
                constantParts = new String[]{"{t'", obj.getValue().toString(), "'}"};
            } else if (type.equals(DataTypeManagerService.DefaultDataTypes.DATE.getTypeClass())) {
                constantParts = new String[]{"{d'", obj.getValue().toString(), "'}"};
            }
            if (constantParts == null) {
                String strValue = obj.getValue().toString();
                strValue = SQLStringVisitor.escapeStringValue(strValue, "'");
                constantParts = new String[]{"'", strValue, "'"};
            }
        }
        String[] stringArray = constantParts;
        int n = constantParts.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.append(string);
            ++n2;
        }
    }

    private void outputLiteral(Class<?> type, boolean multiValued, Object value) throws AssertionError {
        String[] constantParts = null;
        if (multiValued) {
            constantParts = new String[]{"?"};
        } else if (value == null) {
            constantParts = type.equals(DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass()) ? new String[]{"UNKNOWN"} : new String[]{"null"};
        } else {
            if (this.isTeiid87OrGreater() && value.getClass() == ArrayImpl.class) {
                ArrayImpl av = (ArrayImpl)value;
                this.append("(");
                int i = 0;
                while (i < av.getValues().length) {
                    Object value2;
                    if (i > 0) {
                        this.append(",");
                        this.append(" ");
                    }
                    this.outputLiteral((value2 = av.getValues()[i]) != null ? value2.getClass() : av.getValues().getClass().getComponentType(), multiValued, value2);
                    ++i;
                }
                this.append(")");
                return;
            }
            if (Number.class.isAssignableFrom(type)) {
                constantParts = new String[]{value.toString()};
            } else if (type.equals(DataTypeManagerService.DefaultDataTypes.BOOLEAN.getTypeClass())) {
                constantParts = new String[]{value.equals(Boolean.TRUE) ? "TRUE" : "FALSE"};
            } else if (type.equals(DataTypeManagerService.DefaultDataTypes.TIMESTAMP.getTypeClass())) {
                constantParts = new String[]{"{ts'", value.toString(), "'}"};
            } else if (type.equals(DataTypeManagerService.DefaultDataTypes.TIME.getTypeClass())) {
                constantParts = new String[]{"{t'", value.toString(), "'}"};
            } else if (type.equals(DataTypeManagerService.DefaultDataTypes.DATE.getTypeClass())) {
                constantParts = new String[]{"{d'", value.toString(), "'}"};
            } else if (type.equals(DataTypeManagerService.DefaultDataTypes.VARBINARY.getTypeClass())) {
                constantParts = new String[]{"X'", value.toString(), "'"};
            }
            if (constantParts == null) {
                if (this.isTeiid8OrGreater() && DataTypeManagerService.DefaultDataTypes.isLOB(type)) {
                    constantParts = new String[]{"?"};
                } else {
                    String strValue = value.toString();
                    strValue = SQLStringVisitor.escapeStringValue(strValue, "'");
                    constantParts = new String[]{"'", strValue, "'"};
                }
            }
        }
        String[] stringArray = constantParts;
        int n = constantParts.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.append(string);
            ++n2;
        }
    }

    private void visit8(Constant obj) {
        Class<?> type = obj.getType();
        boolean multiValued = obj.isMultiValued();
        Object value = obj.getValue();
        this.outputLiteral(type, multiValued, value);
    }

    @Override
    public void visit(Constant obj) {
        if (this.isTeiid8OrGreater()) {
            this.visit8(obj);
        } else {
            this.visit7(obj);
        }
    }

    static String escapeStringValue(String str, String tick) {
        return StringUtil.replaceAll(str, tick, String.valueOf(tick) + tick);
    }

    @Override
    public void visit(ElementSymbol obj) {
        if (obj.getDisplayMode().equals((Object)IElementSymbol.DisplayMode.SHORT_OUTPUT_NAME) || this.isShortNameOnly()) {
            this.outputShortName(obj);
            return;
        }
        String name = obj.getOutputName();
        if (obj.getDisplayMode().equals((Object)IElementSymbol.DisplayMode.FULLY_QUALIFIED)) {
            name = obj.getName();
        }
        this.outputDisplayName(name);
    }

    private void outputShortName(ElementSymbol obj) {
        this.outputDisplayName(Symbol.getShortName(obj.getOutputName()));
    }

    private void outputDisplayName(String name) {
        String[] pathParts = name.split("\\.");
        int i = 0;
        while (i < pathParts.length) {
            if (i > 0) {
                this.append(".");
            }
            this.append(this.escapeSinglePart(pathParts[i]));
            ++i;
        }
    }

    @Override
    public void visit(ExpressionSymbol obj) {
        this.visitNode(obj.getExpression());
    }

    @Override
    public void visit(Function obj) {
        String name = obj.getName();
        LanguageObject[] args = obj.getArgs();
        if (obj.isImplicit()) {
            this.visitNode(args[0]);
        } else if (name.equalsIgnoreCase("CONVERT") || name.equalsIgnoreCase("CAST")) {
            this.append(name);
            this.append("(");
            if (args != null && args.length > 0) {
                this.visitNode(args[0]);
                if (name.equalsIgnoreCase("CONVERT")) {
                    this.append(", ");
                } else {
                    this.append(" ");
                    this.append("AS");
                    this.append(" ");
                }
                if (args.length < 2 || args[1] == null || !(args[1] instanceof Constant)) {
                    this.append(UNDEFINED);
                } else {
                    this.append(((Constant)args[1]).getValue());
                }
            }
            this.append(")");
        } else if (name.equals("+") || name.equals("-") || name.equals("*") || name.equals("/") || name.equals("||")) {
            this.append("(");
            if (args != null) {
                int i = 0;
                while (i < args.length) {
                    this.visitNode(args[i]);
                    if (i < args.length - 1) {
                        this.append(" ");
                        this.append(name);
                        this.append(" ");
                    }
                    ++i;
                }
            }
            this.append(")");
        } else if (name.equalsIgnoreCase("TIMESTAMPADD") || name.equalsIgnoreCase("TIMESTAMPDIFF")) {
            this.append(name);
            this.append("(");
            if (args != null && args.length > 0) {
                this.append(((Constant)args[0]).getValue());
                this.registerNodes(args, 1);
            }
            this.append(")");
        } else if (name.equalsIgnoreCase("xmlpi")) {
            this.append(name);
            this.append("(NAME ");
            this.outputDisplayName((String)((Constant)args[0]).getValue());
            this.registerNodes(args, 1);
            this.append(")");
        } else if (name.equalsIgnoreCase("trim")) {
            this.append(name);
            this.append("(");
            String value = (String)((Constant)args[0]).getValue();
            if (!value.equalsIgnoreCase("BOTH")) {
                this.append(((Constant)args[0]).getValue());
                this.append(" ");
            }
            this.append(args[1]);
            this.append(" ");
            this.append("FROM");
            this.append(" ");
            this.append(args[2]);
            this.append(")");
        } else {
            this.append(name);
            this.append("(");
            this.registerNodes(args, 0);
            this.append(")");
        }
    }

    private void registerNodes(LanguageObject[] objects, int begin) {
        this.registerNodes(Arrays.asList(objects), begin);
    }

    private void registerNodes(List<? extends LanguageObject> objects, int begin) {
        if (objects == null) {
            return;
        }
        int i = begin;
        while (i < objects.size()) {
            if (i > 0) {
                this.append(", ");
            }
            this.visitNode(objects.get(i));
            ++i;
        }
    }

    @Override
    public void visit(GroupSymbol obj) {
        String alias = null;
        String fullGroup = obj.getOutputName();
        if (obj.getOutputDefinition() != null) {
            alias = obj.getOutputName();
            fullGroup = obj.getOutputDefinition();
        }
        this.outputDisplayName(fullGroup);
        if (alias != null) {
            this.append(" ");
            this.append("AS");
            this.append(" ");
            this.append(this.escapeSinglePart(alias));
        }
    }

    @Override
    public void visit(Reference obj) {
        if (!obj.isPositional() && obj.getExpression() != null) {
            this.visitNode(obj.getExpression());
        } else {
            this.append("?");
        }
    }

    private void visit7(Block obj) {
        this.addLabel(obj);
        List<Statement> statements = obj.getStatements();
        this.append("BEGIN");
        if (obj.isAtomic()) {
            this.append(" ");
            this.append("ATOMIC");
        }
        this.append("\n");
        Iterator<Statement> stmtIter = statements.iterator();
        while (stmtIter.hasNext()) {
            this.addTabs(1);
            this.visitNode(stmtIter.next());
            this.append("\n");
        }
        this.addTabs(0);
        this.append("END");
    }

    private void addStatements(List<Statement> statements) {
        Iterator<Statement> stmtIter = statements.iterator();
        while (stmtIter.hasNext()) {
            this.addTabs(1);
            this.visitNode(stmtIter.next());
            this.append("\n");
        }
        this.addTabs(0);
    }

    private void visit8(Block obj) {
        this.addLabel(obj);
        List<Statement> statements = obj.getStatements();
        this.append("BEGIN");
        if (obj.isAtomic()) {
            this.append(" ");
            this.append("ATOMIC");
        }
        this.append("\n");
        this.addStatements(statements);
        if (obj.getExceptionGroup() != null) {
            this.append("EXCEPTION");
            this.append(" ");
            this.outputDisplayName(obj.getExceptionGroup());
            this.append("\n");
            if (obj.getExceptionStatements() != null) {
                this.addStatements(obj.getExceptionStatements());
            }
        }
        this.append("END");
    }

    @Override
    public void visit(Block block) {
        if (this.isTeiid8OrGreater()) {
            this.visit8(block);
        } else {
            this.visit7(block);
        }
    }

    private void addLabel(Labeled obj) {
        if (obj.getLabel() != null) {
            this.outputDisplayName(obj.getLabel());
            this.append(" ");
            this.append(":");
            this.append(" ");
        }
    }

    protected void addTabs(int level) {
    }

    @Override
    public void visit(CommandStatement obj) {
        this.visitNode(obj.getCommand());
        if (this.isTeiid8OrGreater() && !obj.isReturnable()) {
            this.append(" ");
            this.append("WITHOUT");
            this.append(" ");
            this.append("RETURN");
        }
        this.append(";");
    }

    @Override
    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    public void visit(CreateUpdateProcedureCommand obj) {
        this.addLeadingComment(obj.getLeadingComment());
        this.append("CREATE");
        this.append(" ");
        if (!obj.isUpdateProcedure()) {
            this.append("VIRTUAL");
            this.append(" ");
        }
        this.append("PROCEDURE");
        this.append("\n");
        this.addTabs(0);
        this.visitNode(obj.getBlock());
        this.addTrailingComment(obj.getTrailingComment());
    }

    @Override
    public void visit(CreateProcedureCommand obj) {
        this.addLeadingComment(obj.getLeadingComment());
        this.addCacheHint(obj.getCacheHint());
        if (this.isLessThanTeiidVersion(TeiidServerVersion.Version.TEIID_8_4)) {
            this.append("CREATE");
            this.append(" ");
            this.append("VIRTUAL");
            this.append(" ");
            this.append("PROCEDURE");
            this.append("\n");
            this.addTabs(0);
        }
        this.visitNode(obj.getBlock());
        this.addTrailingComment(obj.getTrailingComment());
    }

    @Override
    public void visit(DeclareStatement obj) {
        this.append("DECLARE");
        this.append(" ");
        this.append(obj.getVariableType());
        this.append(" ");
        this.createAssignment(obj);
    }

    private void createAssignment(AssignmentStatement obj) {
        this.visitNode(obj.getVariable());
        if (obj.getExpression() != null) {
            this.append(" = ");
            this.visitNode(obj.getExpression());
        }
        this.append(";");
    }

    @Override
    public void visit(IfStatement obj) {
        this.append("IF");
        this.append("(");
        this.visitNode(obj.getCondition());
        this.append(")\n");
        this.addTabs(0);
        this.visitNode(obj.getIfBlock());
        if (obj.hasElseBlock()) {
            this.append("\n");
            this.addTabs(0);
            this.append("ELSE");
            this.append("\n");
            this.addTabs(0);
            this.visitNode(obj.getElseBlock());
        }
    }

    @Override
    public void visit(AssignmentStatement obj) {
        this.createAssignment(obj);
    }

    @Override
    public void visit(RaiseStatement obj) {
        this.append("RAISE");
        this.append(" ");
        if (obj.isWarning()) {
            this.append("SQLWARNING");
            this.append(" ");
        }
        this.visitNode(obj.getExpression());
        this.append(";");
    }

    @Override
    public void visit(HasCriteria obj) {
        this.append("HAS");
        this.append(" ");
        this.visitNode(obj.getSelector());
    }

    @Override
    public void visit(TranslateCriteria obj) {
        this.append("TRANSLATE");
        this.append(" ");
        this.visitNode(obj.getSelector());
        if (obj.hasTranslations()) {
            this.append(" ");
            this.append("WITH");
            this.append(" ");
            this.append("(");
            Iterator<CompareCriteria> critIter = obj.getTranslations().iterator();
            while (critIter.hasNext()) {
                this.visitNode(critIter.next());
                if (critIter.hasNext()) {
                    this.append(", ");
                }
                if (critIter.hasNext()) continue;
                this.append(")");
            }
        }
    }

    @Override
    public void visit(CriteriaSelector obj) {
        switch (obj.getSelectorType()) {
            case EQ: {
                this.append("= ");
                break;
            }
            case GE: {
                this.append(">= ");
                break;
            }
            case GT: {
                this.append("> ");
                break;
            }
            case LE: {
                this.append("<= ");
                break;
            }
            case LT: {
                this.append("< ");
                break;
            }
            case NE: {
                this.append("<> ");
                break;
            }
            case IN: {
                this.append("IN");
                this.append(" ");
                break;
            }
            case IS_NULL: {
                this.append("IS");
                this.append(" ");
                this.append("NULL");
                this.append(" ");
                break;
            }
            case LIKE: {
                this.append("LIKE");
                this.append(" ");
                break;
            }
            case BETWEEN: {
                this.append("BETWEEN");
                this.append(" ");
                break;
            }
        }
        this.append("CRITERIA");
        if (obj.hasElements()) {
            this.append(" ");
            this.append("ON");
            this.append(" ");
            this.append("(");
            Iterator<ElementSymbol> elmtIter = obj.getElements().iterator();
            while (elmtIter.hasNext()) {
                this.visitNode(elmtIter.next());
                if (!elmtIter.hasNext()) continue;
                this.append(", ");
            }
            this.append(")");
        }
    }

    @Override
    public void visit(RaiseErrorStatement obj) {
        this.append("ERROR");
        this.append(" ");
        this.visitNode(obj.getExpression());
        this.append(";");
    }

    @Override
    public void visit(ExceptionExpression exceptionExpression) {
        this.append("SQLEXCEPTION");
        this.append(" ");
        this.visitNode(exceptionExpression.getMessage());
        if (exceptionExpression.getSqlState() != null) {
            this.append(" ");
            this.append("SQLSTATE");
            this.append(" ");
            this.append(exceptionExpression.getSqlState());
            if (exceptionExpression.getErrorCode() != null) {
                this.append(",");
                this.append(" ");
                this.append(exceptionExpression.getErrorCode());
            }
        }
        if (exceptionExpression.getParent() != null) {
            this.append(" ");
            this.append("CHAIN");
            this.append(" ");
            this.append(exceptionExpression.getParent());
        }
    }

    @Override
    public void visit(ReturnStatement obj) {
        this.append("RETURN");
        if (obj.getExpression() != null) {
            this.append(" ");
            this.visitNode(obj.getExpression());
        }
        this.append(";");
    }

    @Override
    public void visit(BranchingStatement obj) {
        switch (obj.getMode()) {
            case CONTINUE: {
                this.append("CONTINUE");
                break;
            }
            case BREAK: {
                this.append("BREAK");
                break;
            }
            case LEAVE: {
                this.append("LEAVE");
            }
        }
        if (obj.getLabel() != null) {
            this.append(" ");
            this.outputDisplayName(obj.getLabel());
        }
        this.append(";");
    }

    @Override
    public void visit(LoopStatement obj) {
        this.addLabel(obj);
        this.append("LOOP");
        this.append(" ");
        this.append("ON");
        this.append(" (");
        this.visitNode(obj.getCommand());
        this.append(") ");
        this.append("AS");
        this.append(" ");
        if (this.isTeiid8OrGreater()) {
            this.outputDisplayName(obj.getCursorName());
        } else {
            this.append(obj.getCursorName());
        }
        this.append("\n");
        this.addTabs(0);
        this.visitNode(obj.getBlock());
    }

    @Override
    public void visit(WhileStatement obj) {
        this.addLabel(obj);
        this.append("WHILE");
        this.append("(");
        this.visitNode(obj.getCondition());
        this.append(")\n");
        this.addTabs(0);
        this.visitNode(obj.getBlock());
    }

    @Override
    public void visit(ExistsCriteria obj) {
        if (obj.isNegated()) {
            this.append("NOT");
            this.append(" ");
        }
        this.append("EXISTS");
        this.addSubqueryHint(obj.getSubqueryHint());
        this.append(" (");
        this.visitNode(obj.getCommand());
        this.append(")");
    }

    private void addSubqueryHint(SubqueryHint hint) {
        if (hint.isNoUnnest()) {
            this.append(" ");
            this.append(BEGIN_HINT);
            this.append(" ");
            this.append(SubqueryHint.NOUNNEST);
            this.append(" ");
            this.append(END_HINT);
        } else if (hint.isDepJoin()) {
            this.append(" ");
            this.append(BEGIN_HINT);
            this.append(" ");
            this.append(SubqueryHint.DJ);
            this.append(" ");
            this.append(END_HINT);
        } else if (hint.isMergeJoin()) {
            this.append(" ");
            this.append(BEGIN_HINT);
            this.append(" ");
            this.append(SubqueryHint.MJ);
            this.append(" ");
            this.append(END_HINT);
        }
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        Expression leftExpression = obj.getLeftExpression();
        this.visitNode(leftExpression);
        String operator = obj.getOperatorAsString();
        String quantifier = obj.getPredicateQuantifierAsString();
        this.append(" ");
        this.append(operator);
        this.append(" ");
        this.append(quantifier);
        this.append("(");
        this.visitNode(obj.getCommand());
        this.append(")");
    }

    @Override
    public void visit(ScalarSubquery obj) {
        this.append("(");
        this.visitNode(obj.getCommand());
        this.append(")");
    }

    @Override
    public void visit(XMLAttributes obj) {
        this.append("XMLATTRIBUTES");
        this.append("(");
        this.registerNodes(obj.getArgs(), 0);
        this.append(")");
    }

    @Override
    public void visit(XMLElement obj) {
        this.append("XMLELEMENT");
        this.append("(NAME ");
        this.outputDisplayName(obj.getName());
        if (obj.getNamespaces() != null) {
            this.append(", ");
            this.visitNode(obj.getNamespaces());
        }
        if (obj.getAttributes() != null) {
            this.append(", ");
            this.visitNode(obj.getAttributes());
        }
        if (!obj.getContent().isEmpty()) {
            this.append(", ");
        }
        this.registerNodes(obj.getContent(), 0);
        this.append(")");
    }

    @Override
    public void visit(XMLForest obj) {
        this.append("XMLFOREST");
        this.append("(");
        if (obj.getNamespaces() != null) {
            this.visitNode(obj.getNamespaces());
            this.append(", ");
        }
        this.registerNodes(obj.getArgs(), 0);
        this.append(")");
    }

    @Override
    public void visit(JSONObject obj) {
        this.append("JSONOBJECT");
        this.append("(");
        this.registerNodes(obj.getArgs(), 0);
        this.append(")");
    }

    @Override
    public void visit(TextLine obj) {
        this.append("FOR");
        this.append(" ");
        this.registerNodes(obj.getExpressions(), 0);
        if (obj.getDelimiter() != null) {
            this.append(" ");
            this.append("DELIMITER");
            this.append(" ");
            this.visitNode(this.newConstant(obj.getDelimiter()));
        }
        if (obj.getQuote() != null) {
            this.append(" ");
            this.append("QUOTE");
            this.append(" ");
            this.visitNode(this.newConstant(obj.getQuote()));
        }
        if (obj.isIncludeHeader()) {
            this.append(" ");
            this.append("HEADER");
        }
        if (obj.getEncoding() != null) {
            this.append(" ");
            this.append("ENCODING");
            this.append(" ");
            this.outputDisplayName(obj.getEncoding());
        }
    }

    @Override
    public void visit(XMLNamespaces obj) {
        this.append("XMLNAMESPACES");
        this.append("(");
        Iterator<NamespaceItem> items = obj.getNamespaceItems().iterator();
        while (items.hasNext()) {
            NamespaceItem item = items.next();
            if (item.getPrefix() == null) {
                if (item.getUri() == null) {
                    this.append("NO DEFAULT");
                } else {
                    this.append("DEFAULT ");
                    this.visitNode(this.newConstant(item.getUri()));
                }
            } else {
                this.visitNode(this.newConstant(item.getUri()));
                this.append(" AS ");
                this.outputDisplayName(item.getPrefix());
            }
            if (!items.hasNext()) continue;
            this.append(", ");
        }
        this.append(")");
    }

    @Override
    public void visit(Limit obj) {
        if (!obj.isStrict()) {
            this.append(BEGIN_HINT);
            this.append(" ");
            this.append(Limit.NON_STRICT);
            this.append(" ");
            this.append(END_HINT);
            this.append(" ");
        }
        if (obj.getRowLimit() == null) {
            this.append("OFFSET");
            this.append(" ");
            this.visitNode(obj.getOffset());
            this.append(" ");
            this.append("ROWS");
            return;
        }
        this.append("LIMIT");
        if (obj.getOffset() != null) {
            this.append(" ");
            this.visitNode(obj.getOffset());
            this.append(",");
        }
        this.append(" ");
        this.visitNode(obj.getRowLimit());
    }

    @Override
    public void visit(TextTable obj) {
        this.addHintComment(obj);
        this.append("TEXTTABLE(");
        this.visitNode(obj.getFile());
        if (this.isTeiid8OrGreater() && obj.getSelector() != null) {
            this.append(" ");
            this.append("SELECTOR");
            this.append(" ");
            this.append(this.escapeSinglePart(obj.getSelector()));
        }
        this.append(" ");
        this.append("COLUMNS");
        Iterator<TextColumn> cols = obj.getColumns().iterator();
        while (cols.hasNext()) {
            TextColumn col = cols.next();
            this.append(" ");
            this.outputDisplayName(col.getName());
            this.append(" ");
            if (col.isOrdinal()) {
                this.append("FOR");
                this.append(" ");
                this.append("ORDINALITY");
            } else {
                this.append(col.getType());
                if (col.getWidth() != null) {
                    this.append(" ");
                    this.append("WIDTH");
                    this.append(" ");
                    this.append(col.getWidth());
                }
                if (col.isNoTrim()) {
                    this.append(" ");
                    this.append("NO");
                    this.append(" ");
                    this.append("TRIM");
                }
                if (this.isTeiid8OrGreater() && col.getSelector() != null) {
                    this.append(" ");
                    this.append("SELECTOR");
                    this.append(" ");
                    this.append(this.escapeSinglePart(col.getSelector()));
                    this.append(" ");
                    this.append(col.getPosition());
                }
            }
            if (!cols.hasNext()) continue;
            this.append(",");
        }
        if (!obj.isUsingRowDelimiter()) {
            this.append(" ");
            this.append("NO");
            this.append(" ");
            this.append("ROW");
            this.append(" ");
            this.append("DELIMITER");
        }
        if (obj.getDelimiter() != null) {
            this.append(" ");
            this.append("DELIMITER");
            this.append(" ");
            this.visitNode(this.newConstant(obj.getDelimiter()));
        }
        if (obj.getQuote() != null) {
            this.append(" ");
            if (obj.isEscape()) {
                this.append("ESCAPE");
            } else {
                this.append("QUOTE");
            }
            this.append(" ");
            this.visitNode(this.newConstant(obj.getQuote()));
        }
        if (obj.getHeader() != null) {
            this.append(" ");
            this.append("HEADER");
            if (1 != obj.getHeader()) {
                this.append(" ");
                this.append(obj.getHeader());
            }
        }
        if (obj.getSkip() != null) {
            this.append(" ");
            this.append("SKIP");
            this.append(" ");
            this.append(obj.getSkip());
        }
        this.append(")");
        this.append(" ");
        this.append("AS");
        this.append(" ");
        this.outputDisplayName(obj.getName());
        this.addMakeDep(obj);
    }

    @Override
    public void visit(XMLTable obj) {
        this.addHintComment(obj);
        this.append("XMLTABLE(");
        if (obj.getNamespaces() != null) {
            this.visitNode(obj.getNamespaces());
            this.append(",");
            this.append(" ");
        }
        this.visitNode(this.newConstant(obj.getXquery()));
        if (!obj.getPassing().isEmpty()) {
            this.append(" ");
            this.append("PASSING");
            this.append(" ");
            this.registerNodes(obj.getPassing(), 0);
        }
        if (this.isTeiid8OrGreater() && !obj.getColumns().isEmpty() && !obj.isUsingDefaultColumn() || !this.isTeiid8OrGreater() && !obj.getColumns().isEmpty()) {
            this.append(" ");
            this.append("COLUMNS");
            Iterator<XMLColumn> cols = obj.getColumns().iterator();
            while (cols.hasNext()) {
                XMLColumn col = cols.next();
                this.append(" ");
                this.outputDisplayName(col.getName());
                this.append(" ");
                if (col.isOrdinal()) {
                    this.append("FOR");
                    this.append(" ");
                    this.append("ORDINALITY");
                } else {
                    this.append(col.getType());
                    if (col.getDefaultExpression() != null) {
                        this.append(" ");
                        this.append("DEFAULT");
                        this.append(" ");
                        this.visitNode(col.getDefaultExpression());
                    }
                    if (col.getPath() != null) {
                        this.append(" ");
                        this.append("PATH");
                        this.append(" ");
                        this.visitNode(this.newConstant(col.getPath()));
                    }
                }
                if (!cols.hasNext()) continue;
                this.append(",");
            }
        }
        this.append(")");
        this.append(" ");
        this.append("AS");
        this.append(" ");
        this.outputDisplayName(obj.getName());
        this.addMakeDep(obj);
    }

    @Override
    public void visit(ObjectTable obj) {
        this.addHintComment(obj);
        this.append("OBJECTTABLE(");
        if (obj.getScriptingLanguage() != null) {
            this.append("LANGUAGE");
            this.append(" ");
            this.visitNode(this.newConstant(obj.getScriptingLanguage()));
            this.append(" ");
        }
        this.visitNode(this.newConstant(obj.getRowScript()));
        if (!obj.getPassing().isEmpty()) {
            this.append(" ");
            this.append("PASSING");
            this.append(" ");
            this.registerNodes(obj.getPassing(), 0);
        }
        this.append(" ");
        this.append("COLUMNS");
        Iterator<ObjectColumn> cols = obj.getColumns().iterator();
        while (cols.hasNext()) {
            ObjectColumn col = cols.next();
            this.append(" ");
            this.outputDisplayName(col.getName());
            this.append(" ");
            this.append(col.getType());
            this.append(" ");
            this.visitNode(this.newConstant(col.getPath()));
            if (col.getDefaultExpression() != null) {
                this.append(" ");
                this.append("DEFAULT");
                this.append(" ");
                this.visitNode(col.getDefaultExpression());
            }
            if (!cols.hasNext()) continue;
            this.append(",");
        }
        this.append(")");
        this.append(" ");
        this.append("AS");
        this.append(" ");
        this.outputDisplayName(obj.getName());
        this.addMakeDep(obj);
    }

    @Override
    public void visit(XMLQuery obj) {
        this.append("XMLQUERY(");
        if (obj.getNamespaces() != null) {
            this.visitNode(obj.getNamespaces());
            this.append(",");
            this.append(" ");
        }
        this.visitNode(this.newConstant(obj.getXquery()));
        if (!obj.getPassing().isEmpty()) {
            this.append(" ");
            this.append("PASSING");
            this.append(" ");
            this.registerNodes(obj.getPassing(), 0);
        }
        if (obj.getEmptyOnEmpty() != null) {
            this.append(" ");
            if (obj.getEmptyOnEmpty().booleanValue()) {
                this.append("EMPTY");
            } else {
                this.append("NULL");
            }
            this.append(" ");
            this.append("ON");
            this.append(" ");
            this.append("EMPTY");
        }
        this.append(")");
    }

    @Override
    public void visit(DerivedColumn obj) {
        this.visitNode(obj.getExpression());
        if (obj.getAlias() != null) {
            this.append(" ");
            this.append("AS");
            this.append(" ");
            this.outputDisplayName(obj.getAlias());
        }
    }

    @Override
    public void visit(XMLSerialize obj) {
        this.append("XMLSERIALIZE");
        this.append("(");
        if (obj.getDocument() != null) {
            if (obj.getDocument().booleanValue()) {
                this.append("DOCUMENT");
            } else {
                this.append("CONTENT");
            }
            this.append(" ");
        }
        this.visitNode(obj.getExpression());
        if (obj.getTypeString() != null) {
            this.append(" ");
            this.append("AS");
            this.append(" ");
            this.append(obj.getTypeString());
        }
        if (this.isTeiid8OrGreater()) {
            if (obj.getEncoding() != null) {
                this.append(" ");
                this.append("ENCODING");
                this.append(" ");
                this.append(this.escapeSinglePart(obj.getEncoding()));
            }
            if (obj.getVersion() != null) {
                this.append(" ");
                this.append("VERSION");
                this.append(" ");
                this.append(this.newConstant(obj.getVersion()));
            }
            if (obj.getDeclaration() != null) {
                this.append(" ");
                if (obj.getDeclaration().booleanValue()) {
                    this.append("INCLUDING");
                } else {
                    this.append("EXCLUDING");
                }
                this.append(" ");
                this.append("XMLDECLARATION");
            }
        }
        this.append(")");
    }

    @Override
    public void visit(QueryString obj) {
        this.append("QUERYSTRING");
        this.append("(");
        this.visitNode(obj.getPath());
        if (!obj.getArgs().isEmpty()) {
            this.append(",");
            this.append(" ");
            this.registerNodes(obj.getArgs(), 0);
        }
        this.append(")");
    }

    @Override
    public void visit(XMLParse obj) {
        this.append("XMLPARSE");
        this.append("(");
        if (obj.isDocument()) {
            this.append("DOCUMENT");
        } else {
            this.append("CONTENT");
        }
        this.append(" ");
        this.visitNode(obj.getExpression());
        if (obj.isWellFormed()) {
            this.append(" ");
            this.append("WELLFORMED");
        }
        this.append(")");
    }

    @Override
    public void visit(ExpressionCriteria obj) {
        this.visitNode(obj.getExpression());
    }

    @Override
    public void visit(TriggerAction obj) {
        this.addLeadingComment(obj.getLeadingComment());
        this.append("FOR");
        this.append(" ");
        this.append("EACH");
        this.append(" ");
        this.append("ROW");
        this.append("\n");
        this.addTabs(0);
        this.visitNode(obj.getBlock());
        this.addTrailingComment(obj.getTrailingComment());
    }

    @Override
    public void visit(ArrayTable obj) {
        this.addHintComment(obj);
        this.append("ARRAYTABLE(");
        this.visitNode(obj.getArrayValue());
        this.append(" ");
        this.append("COLUMNS");
        Iterator<ProjectedColumn> cols = obj.getColumns().iterator();
        while (cols.hasNext()) {
            ProjectedColumn col = cols.next();
            this.append(" ");
            this.outputDisplayName(col.getName());
            this.append(" ");
            this.append(col.getType());
            if (!cols.hasNext()) continue;
            this.append(",");
        }
        this.append(")");
        this.append(" ");
        this.append("AS");
        this.append(" ");
        this.outputDisplayName(obj.getName());
        this.addMakeDep(obj);
    }

    private void addMakeDep(FromClause obj) {
        if (this.isLessThanTeiidVersion(TeiidServerVersion.Version.TEIID_8_5)) {
            return;
        }
        Option.MakeDep makeDep = obj.getMakeDep();
        if (makeDep != null && !makeDep.isSimple()) {
            this.append(" ");
            this.append("MAKEDEP");
            this.appendMakeDepOptions(makeDep);
        }
    }

    private void visit7(AlterProcedure<CreateUpdateProcedureCommand> obj) {
        this.append("ALTER");
        this.append(" ");
        this.append("PROCEDURE");
        this.append(" ");
        this.append(obj.getTarget());
        this.beginClause(1);
        this.append("AS");
        this.append(((CreateUpdateProcedureCommand)obj.getDefinition()).getBlock());
    }

    private void visit8(AlterProcedure<CreateProcedureCommand> obj) {
        this.append("ALTER");
        this.append(" ");
        this.append("PROCEDURE");
        this.append(" ");
        this.append(obj.getTarget());
        this.beginClause(1);
        this.append("AS");
        this.append(((CreateProcedureCommand)obj.getDefinition()).getBlock());
    }

    @Override
    public void visit(AlterProcedure obj) {
        if (this.isTeiid8OrGreater()) {
            this.visit8(obj);
        } else {
            this.visit7(obj);
        }
    }

    @Override
    public void visit(AlterTrigger obj) {
        if (obj.isCreate()) {
            this.append("CREATE");
        } else {
            this.append("ALTER");
        }
        this.append(" ");
        this.append("TRIGGER");
        this.append(" ");
        this.append("ON");
        this.append(" ");
        this.append(obj.getTarget());
        this.beginClause(0);
        this.append("INSTEAD");
        this.append(" ");
        this.append("OF");
        this.append(" ");
        this.append((Object)obj.getEvent());
        if (obj.getDefinition() != null) {
            this.beginClause(0);
            this.append("AS");
            this.append("\n");
            this.addTabs(0);
            this.append(obj.getDefinition());
        } else {
            this.append(" ");
            this.append(obj.getEnabled() != false ? "ENABLED" : "DISABLED");
        }
    }

    @Override
    public void visit(AlterView obj) {
        this.append("ALTER");
        this.append(" ");
        this.append("VIEW");
        this.append(" ");
        this.append(obj.getTarget());
        this.beginClause(0);
        this.append("AS");
        this.append("\n");
        this.addTabs(0);
        this.append(obj.getDefinition());
    }

    @Override
    public void visit(WindowFunction windowFunction) {
        this.append(windowFunction.getFunction());
        this.append(" ");
        this.append("OVER");
        this.append(" ");
        this.append(windowFunction.getWindowSpecification());
    }

    @Override
    public void visit(WindowSpecification windowSpecification) {
        this.append("(");
        boolean needsSpace = false;
        if (windowSpecification.getPartition() != null) {
            this.append("PARTITION");
            this.append(" ");
            this.append("BY");
            this.append(" ");
            this.registerNodes(windowSpecification.getPartition(), 0);
            needsSpace = true;
        }
        if (windowSpecification.getOrderBy() != null) {
            if (needsSpace) {
                this.append(" ");
            }
            this.append(windowSpecification.getOrderBy());
        }
        this.append(")");
    }

    @Override
    public void visit(Array array) {
        if (!array.isImplicit()) {
            this.append("(");
        }
        this.registerNodes(array.getExpressions(), 0);
        if (!array.isImplicit()) {
            if (array.getExpressions().size() == 1) {
                this.append(",");
            }
            this.append(")");
        }
    }

    private String escapeSinglePart(String part) {
        if (this.isReservedWord(part)) {
            return String.valueOf('\"') + part + '\"';
        }
        boolean escape = true;
        char start = part.charAt(0);
        if (start == '#' || start == '@' || StringUtil.isLetter(start)) {
            escape = false;
            int i = 1;
            while (!escape && i < part.length()) {
                char c = part.charAt(i);
                escape = !StringUtil.isLetterOrDigit(c) && c != '_';
                ++i;
            }
        }
        if (escape) {
            return String.valueOf('\"') + SQLStringVisitor.escapeStringValue(part, "\"") + '\"';
        }
        return part;
    }

    private boolean isReservedWord(String string) {
        if (string == null) {
            return false;
        }
        return SQLConstants.isReservedWord(this.getTeiidVersion(), string);
    }
}

