/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.UnresolvedSymbolDescription;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.annotation.Removed;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.sql.lang.ISPParameter;
import org.teiid.designer.query.sql.proc.IBlock;
import org.teiid.designer.query.sql.proc.ICreateProcedureCommand;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.ExpressionStatement;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.ReturnStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ResolveVirtualGroupCriteriaVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.runtime.client.Messages;

public class UpdateProcedureResolver
extends CommandResolver {
    private final List<ElementSymbol> exceptionGroup;
    private DataTypeManagerService dataTypeManager;

    public UpdateProcedureResolver(QueryResolver queryResolver) {
        super(queryResolver);
        ElementSymbol es1 = (ElementSymbol)this.create(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
        es1.setName("STATE");
        es1.setType(DataTypeManagerService.DefaultDataTypes.STRING.getTypeClass());
        ElementSymbol es2 = (ElementSymbol)this.create(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
        es2.setName("ERRORCODE");
        es2.setType(DataTypeManagerService.DefaultDataTypes.INTEGER.getTypeClass());
        ElementSymbol es3 = (ElementSymbol)this.create(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
        es3.setName("TEIIDCODE");
        es3.setType(DataTypeManagerService.DefaultDataTypes.STRING.getTypeClass());
        ElementSymbol es4 = (ElementSymbol)this.create(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
        es4.setName("EXCEPTION");
        es4.setType(Exception.class);
        ElementSymbol es5 = (ElementSymbol)this.create(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
        es5.setName("CHAIN");
        es5.setType(Exception.class);
        this.exceptionGroup = Arrays.asList(es1, es2, es3, es4, es5);
    }

    @Override
    public DataTypeManagerService getDataTypeManager() {
        if (this.dataTypeManager == null) {
            this.dataTypeManager = DataTypeManagerService.getInstance(this.getTeiidVersion());
        }
        return this.dataTypeManager;
    }

    private void addRowCountToContext(Command command, TempMetadataAdapter metadata) throws Exception {
        ElementSymbol updateCount;
        String countVar;
        GroupContext externalGroups = command.getExternalGroupContexts();
        LinkedList<ElementSymbol> symbols = new LinkedList<ElementSymbol>();
        if (command instanceof CreateUpdateProcedureCommand && ((CreateUpdateProcedureCommand)command).isUpdateProcedure()) {
            this.resolveVirtualGroupElements((CreateUpdateProcedureCommand)command, metadata);
            countVar = "VARIABLES.ROWS_UPDATED";
            updateCount = (ElementSymbol)this.create(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
            updateCount.setName(countVar);
            updateCount.setType(DataTypeManagerService.DefaultDataTypes.INTEGER.getTypeClass());
            symbols.add(updateCount);
        }
        countVar = "VARIABLES.ROWCOUNT";
        updateCount = (ElementSymbol)this.create(TeiidNodeFactory.ASTNodes.ELEMENT_SYMBOL);
        updateCount.setName(countVar);
        updateCount.setType(DataTypeManagerService.DefaultDataTypes.INTEGER.getTypeClass());
        symbols.add(updateCount);
        ProcedureContainerResolver.addScalarGroup(this.getTeiidParser(), "VARIABLES", metadata.getMetadataStore(), externalGroups, symbols);
    }

    private void resolveCommand(TriggerAction ta, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws Exception {
        ICreateProcedureCommand cmd;
        if (this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0.get())) {
            cmd = (ICreateProcedureCommand)this.create(TeiidNodeFactory.ASTNodes.CREATE_UPDATE_PROCEDURE_COMMAND);
        } else {
            cmd = (ICreateProcedureCommand)this.create(TeiidNodeFactory.ASTNodes.CREATE_PROCEDURE_COMMAND);
            ((CreateProcedureCommand)cmd).setUpdateType(2);
        }
        cmd.setBlock((IBlock)ta.getBlock());
        cmd.setVirtualGroup((IGroupSymbol)ta.getView());
        this.resolveBlock((ICreateProcedureCommand<Block, GroupSymbol, Expression, LanguageVisitor>)cmd, ta.getBlock(), ta.getExternalGroupContexts(), metadata);
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    @Deprecated
    private void resolveVirtualGroupElements(CreateUpdateProcedureCommand procCommand, IQueryMetadataInterface metadata) throws Exception {
        Command transformCmd;
        GroupSymbol virtualGroup = procCommand.getVirtualGroup();
        if (!metadata.isVirtualGroup(virtualGroup.getMetadataID())) {
            return;
        }
        ResolveVirtualGroupCriteriaVisitor.resolveCriteria(procCommand, virtualGroup, metadata);
        try {
            QueryResolver queryResolver = new QueryResolver(this.getTeiidVersion());
            transformCmd = queryResolver.resolveView(virtualGroup, metadata.getVirtualPlan(virtualGroup.getMetadataID()), "SELECT", metadata).getCommand();
        }
        catch (Exception e) {
            throw new QueryResolverException(e, e.getMessage());
        }
        ArrayList<Expression> cloned = new ArrayList<Expression>();
        for (Expression item : transformCmd.getProjectedSymbols()) {
            cloned.add(item.clone());
        }
        Map<ElementSymbol, Expression> symbolMap = SymbolMap.createSymbolMap(virtualGroup, cloned, metadata).asMap();
        procCommand.setSymbolMap(symbolMap);
    }

    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws Exception {
        this.addRowCountToContext(command, metadata);
        if (command instanceof CreateProcedureCommand) {
            this.resolveBlock((CreateProcedureCommand)command, ((CreateProcedureCommand)command).getBlock(), command.getExternalGroupContexts(), metadata);
        } else if (command instanceof CreateUpdateProcedureCommand) {
            this.resolveBlock((CreateUpdateProcedureCommand)command, ((CreateUpdateProcedureCommand)command).getBlock(), command.getExternalGroupContexts(), metadata);
        } else if (command instanceof TriggerAction) {
            this.resolveCommand((TriggerAction)command, metadata, resolveNullLiterals);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void resolveBlock(ICreateProcedureCommand<Block, GroupSymbol, Expression, LanguageVisitor> command, Block block, GroupContext originalExternalGroups, TempMetadataAdapter metadata) throws Exception {
        TempMetadataStore store = metadata.getMetadataStore().clone();
        metadata = new TempMetadataAdapter(metadata.getMetadata(), store);
        GroupContext externalGroups = new GroupContext(originalExternalGroups, null);
        GroupSymbol variables = ProcedureContainerResolver.addScalarGroup(this.getTeiidParser(), "VARIABLES", store, externalGroups, new LinkedList());
        for (Statement statement : block.getStatements()) {
            this.resolveStatement(command, statement, externalGroups, variables, metadata);
        }
        if (block.getExceptionGroup() != null) {
            store = metadata.getMetadataStore().clone();
            metadata = new TempMetadataAdapter(metadata.getMetadata(), store);
            externalGroups = new GroupContext(originalExternalGroups, null);
            variables = ProcedureContainerResolver.addScalarGroup(this.getTeiidParser(), "VARIABLES", store, externalGroups, new LinkedList());
            this.isValidGroup(metadata, block.getExceptionGroup());
            if (block.getExceptionStatements() != null) {
                ProcedureContainerResolver.addScalarGroup(this.getTeiidParser(), block.getExceptionGroup(), store, externalGroups, this.exceptionGroup, false);
                for (Statement statement : block.getExceptionStatements()) {
                    this.resolveStatement(command, statement, externalGroups, variables, metadata);
                }
            }
        }
    }

    @Removed(value=TeiidServerVersion.Version.TEIID_8_0)
    @Deprecated
    private void resolveStatement(CreateUpdateProcedureCommand command, Statement statement, GroupContext externalGroups, GroupSymbol variables, TempMetadataAdapter metadata) throws Exception {
        ResolverVisitor visitor = new ResolverVisitor(this.getTeiidVersion());
        switch (statement.getType()) {
            case TYPE_IF: {
                IfStatement ifStmt = (IfStatement)statement;
                Criteria ifCrit = ifStmt.getCondition();
                for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(ifCrit)) {
                    this.resolveEmbeddedCommand(metadata, externalGroups, (Command)container.getCommand());
                }
                visitor.resolveLanguageObject(ifCrit, null, externalGroups, metadata);
                this.resolveBlock(command, ifStmt.getIfBlock(), externalGroups, metadata);
                if (!ifStmt.hasElseBlock()) break;
                this.resolveBlock(command, ifStmt.getElseBlock(), externalGroups, metadata);
                break;
            }
            case TYPE_COMMAND: {
                DynamicCommand dynamicCommand;
                DynamicCommand dynCommand;
                CommandStatement cmdStmt = (CommandStatement)statement;
                Command subCommand = cmdStmt.getCommand();
                TempMetadataStore discoveredMetadata = this.resolveEmbeddedCommand(metadata, externalGroups, subCommand);
                if (subCommand instanceof StoredProcedure) {
                    StoredProcedure sp = (StoredProcedure)subCommand;
                    block12: for (SPParameter param : sp.getParameters()) {
                        ISPParameter.ParameterInfo paramType = ISPParameter.ParameterInfo.valueOf((int)param.getParameterType());
                        switch (paramType) {
                            case OUT: 
                            case RETURN_VALUE: {
                                if (param.getExpression() != null && !this.isAssignable(metadata, param)) {
                                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30121, param.getExpression()));
                                }
                                sp.setCallableStatement(true);
                                break;
                            }
                            case INOUT: {
                                if (!this.isAssignable(metadata, param)) continue block12;
                                sp.setCallableStatement(true);
                            }
                        }
                    }
                }
                if (discoveredMetadata != null) {
                    metadata.getMetadataStore().getData().putAll(discoveredMetadata.getData());
                }
                if (subCommand instanceof DynamicCommand && (dynCommand = (DynamicCommand)subCommand).getIntoGroup() == null && !command.isUpdateProcedure() && !dynCommand.isAsClauseSet() && !command.getProjectedSymbols().isEmpty()) {
                    dynCommand.setAsColumns(command.getProjectedSymbols());
                }
                if (command.isUpdateProcedure()) break;
                if (command.getResultsCommand() != null && command.getResultsCommand().getType() == 10 && !(dynamicCommand = (DynamicCommand)command.getResultsCommand()).isAsClauseSet()) {
                    dynamicCommand.setAsColumns(Collections.EMPTY_LIST);
                }
                if (!subCommand.returnsResultSet()) break;
                command.setResultsCommand(subCommand);
                break;
            }
            case TYPE_DECLARE: 
            case TYPE_ERROR: 
            case TYPE_ASSIGNMENT: {
                ExpressionStatement exprStmt = (ExpressionStatement)((Object)statement);
                if (exprStmt.getExpression() != null) {
                    Expression expr = exprStmt.getExpression();
                    for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(expr)) {
                        this.resolveEmbeddedCommand(metadata, externalGroups, (Command)container.getCommand());
                    }
                    visitor.resolveLanguageObject(expr, null, externalGroups, metadata);
                }
                if (statement.getType() == Statement.StatementType.TYPE_DECLARE) {
                    this.collectDeclareVariable((DeclareStatement)statement, variables, metadata, externalGroups);
                } else if (statement.getType() == Statement.StatementType.TYPE_ASSIGNMENT) {
                    AssignmentStatement assStmt = (AssignmentStatement)statement;
                    visitor.resolveLanguageObject(assStmt.getVariable(), null, externalGroups, metadata);
                    if (!metadata.elementSupports(assStmt.getVariable().getMetadataID(), 5)) {
                        throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30121, assStmt.getVariable()));
                    }
                    assStmt.getVariable().setIsExternalReference(false);
                }
                if (exprStmt.getExpression() == null) break;
                Class<?> varType = exprStmt.getExpectedType();
                Class<?> exprType = exprStmt.getExpression().getType();
                if (exprType == null) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30123, new Object[0]));
                }
                String varTypeName = this.getDataTypeManager().getDataTypeName(varType);
                exprStmt.setExpression(ResolverUtil.convertExpression(exprStmt.getExpression(), varTypeName, metadata));
                break;
            }
            case TYPE_WHILE: {
                WhileStatement whileStmt = (WhileStatement)statement;
                Criteria whileCrit = whileStmt.getCondition();
                for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(whileCrit)) {
                    this.resolveEmbeddedCommand(metadata, externalGroups, (Command)container.getCommand());
                }
                visitor.resolveLanguageObject(whileCrit, null, externalGroups, metadata);
                this.resolveBlock(command, whileStmt.getBlock(), externalGroups, metadata);
                break;
            }
            case TYPE_LOOP: {
                LoopStatement loopStmt = (LoopStatement)statement;
                String groupName = loopStmt.getCursorName();
                if (metadata.getMetadataStore().getTempGroupID(groupName) != null) {
                    throw new QueryResolverException(Messages.getString(Messages.ERR.ERR_015_012_0065, new Object[0]));
                }
                if (GroupSymbol.isTempGroupName(loopStmt.getCursorName())) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30125, loopStmt.getCursorName()));
                }
                Command cmd = loopStmt.getCommand();
                this.resolveEmbeddedCommand(metadata, externalGroups, cmd);
                List symbols = cmd.getProjectedSymbols();
                TempMetadataStore store = metadata.getMetadataStore().clone();
                metadata = new TempMetadataAdapter(metadata.getMetadata(), store);
                externalGroups = new GroupContext(externalGroups, null);
                ProcedureContainerResolver.addScalarGroup(this.getTeiidParser(), groupName, store, externalGroups, (List<? extends Expression>)symbols, false);
                this.resolveBlock(command, loopStmt.getBlock(), externalGroups, metadata);
            }
        }
    }

    private void resolveStatement(CreateProcedureCommand command, Statement statement, GroupContext externalGroups, GroupSymbol variables, TempMetadataAdapter metadata) throws Exception {
        ResolverVisitor visitor = new ResolverVisitor(this.getTeiidVersion());
        switch (statement.getType()) {
            case TYPE_IF: {
                IfStatement ifStmt = (IfStatement)statement;
                Criteria ifCrit = ifStmt.getCondition();
                for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(ifCrit)) {
                    this.resolveEmbeddedCommand(metadata, externalGroups, (Command)container.getCommand());
                }
                visitor.resolveLanguageObject(ifCrit, null, externalGroups, metadata);
                this.resolveBlock(command, ifStmt.getIfBlock(), externalGroups, metadata);
                if (!ifStmt.hasElseBlock()) break;
                this.resolveBlock(command, ifStmt.getElseBlock(), externalGroups, metadata);
                break;
            }
            case TYPE_COMMAND: {
                DynamicCommand dynCommand;
                CommandStatement cmdStmt = (CommandStatement)statement;
                Command subCommand = cmdStmt.getCommand();
                TempMetadataStore discoveredMetadata = this.resolveEmbeddedCommand(metadata, externalGroups, subCommand);
                if (subCommand instanceof StoredProcedure) {
                    StoredProcedure sp = (StoredProcedure)subCommand;
                    block18: for (SPParameter param : sp.getParameters()) {
                        ISPParameter.ParameterInfo paramType = ISPParameter.ParameterInfo.valueOf((int)param.getParameterType());
                        switch (paramType) {
                            case OUT: 
                            case RETURN_VALUE: {
                                if (param.getExpression() != null && !this.isAssignable(metadata, param)) {
                                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30121, param.getExpression()));
                                }
                                sp.setCallableStatement(true);
                                break;
                            }
                            case INOUT: {
                                if (!this.isAssignable(metadata, param)) continue block18;
                                sp.setCallableStatement(true);
                            }
                        }
                    }
                }
                if (discoveredMetadata != null) {
                    metadata.getMetadataStore().getData().putAll(discoveredMetadata.getData());
                }
                if (subCommand instanceof DynamicCommand && (dynCommand = (DynamicCommand)subCommand).getIntoGroup() == null && !dynCommand.isAsClauseSet()) {
                    if (command.getResultSetColumns() != null && command.getResultSetColumns().isEmpty() || !cmdStmt.isReturnable() || command.getResultSetColumns() == null) {
                        dynCommand.setAsColumns(Collections.EMPTY_LIST);
                    } else {
                        dynCommand.setAsColumns(command.getResultSetColumns());
                    }
                }
                if (command.getResultSetColumns() != null || !cmdStmt.isReturnable() || !subCommand.returnsResultSet() || subCommand.getResultSetColumns() == null || subCommand.getResultSetColumns().isEmpty()) break;
                command.setResultSetColumns(subCommand.getResultSetColumns());
                if (!command.getProjectedSymbols().isEmpty()) break;
                command.setProjectedSymbols(subCommand.getResultSetColumns());
                break;
            }
            case TYPE_DECLARE: 
            case TYPE_ERROR: 
            case TYPE_ASSIGNMENT: 
            case TYPE_RETURN: {
                ExpressionStatement exprStmt = (ExpressionStatement)((Object)statement);
                if (exprStmt.getExpression() != null) {
                    Expression expr = exprStmt.getExpression();
                    for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(expr)) {
                        this.resolveEmbeddedCommand(metadata, externalGroups, (Command)container.getCommand());
                    }
                    visitor.resolveLanguageObject(expr, null, externalGroups, metadata);
                }
                switch (statement.getType()) {
                    case TYPE_DECLARE: {
                        this.collectDeclareVariable((DeclareStatement)statement, variables, metadata, externalGroups);
                        break;
                    }
                    case TYPE_ASSIGNMENT: {
                        AssignmentStatement assStmt = (AssignmentStatement)statement;
                        visitor.resolveLanguageObject(assStmt.getVariable(), null, externalGroups, metadata);
                        if (!metadata.elementSupports(assStmt.getVariable().getMetadataID(), 5)) {
                            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30121, assStmt.getVariable()));
                        }
                        assStmt.getVariable().setIsExternalReference(false);
                        break;
                    }
                    case TYPE_RETURN: {
                        ReturnStatement rs = (ReturnStatement)statement;
                        if (rs.getExpression() == null) break;
                        if (command.getReturnVariable() == null) {
                            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID31125, rs));
                        }
                        rs.setVariable(command.getReturnVariable().clone());
                    }
                }
                if (exprStmt.getExpression() == null) break;
                Class<?> varType = exprStmt.getExpectedType();
                Class<?> exprType = exprStmt.getExpression().getType();
                if (exprType == null) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30123, new Object[0]));
                }
                String varTypeName = this.getDataTypeManager().getDataTypeName(varType);
                exprStmt.setExpression(ResolverUtil.convertExpression(exprStmt.getExpression(), varTypeName, metadata));
                if (statement.getType() != Statement.StatementType.TYPE_ERROR) break;
                ResolverVisitor.checkException(exprStmt.getExpression());
                break;
            }
            case TYPE_WHILE: {
                WhileStatement whileStmt = (WhileStatement)statement;
                Criteria whileCrit = whileStmt.getCondition();
                for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(whileCrit)) {
                    this.resolveEmbeddedCommand(metadata, externalGroups, (Command)container.getCommand());
                }
                visitor.resolveLanguageObject(whileCrit, null, externalGroups, metadata);
                this.resolveBlock(command, whileStmt.getBlock(), externalGroups, metadata);
                break;
            }
            case TYPE_LOOP: {
                LoopStatement loopStmt = (LoopStatement)statement;
                String groupName = loopStmt.getCursorName();
                this.isValidGroup(metadata, groupName);
                Command cmd = loopStmt.getCommand();
                this.resolveEmbeddedCommand(metadata, externalGroups, cmd);
                List symbols = cmd.getProjectedSymbols();
                TempMetadataStore store = metadata.getMetadataStore().clone();
                metadata = new TempMetadataAdapter(metadata.getMetadata(), store);
                externalGroups = new GroupContext(externalGroups, null);
                ProcedureContainerResolver.addScalarGroup(this.getTeiidParser(), groupName, store, externalGroups, (List<? extends Expression>)symbols, false);
                this.resolveBlock(command, loopStmt.getBlock(), externalGroups, metadata);
                break;
            }
            case TYPE_COMPOUND: {
                this.resolveBlock(command, (Block)statement, externalGroups, metadata);
            }
        }
    }

    private void resolveStatement(ICreateProcedureCommand command, Statement statement, GroupContext externalGroups, GroupSymbol variables, TempMetadataAdapter metadata) throws Exception {
        if (command instanceof CreateProcedureCommand) {
            this.resolveStatement((CreateProcedureCommand)command, statement, externalGroups, variables, metadata);
        } else if (command instanceof CreateUpdateProcedureCommand) {
            this.resolveStatement((CreateUpdateProcedureCommand)command, statement, externalGroups, variables, metadata);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void isValidGroup(TempMetadataAdapter metadata, String groupName) throws Exception {
        if (metadata.getMetadataStore().getTempGroupID(groupName) != null) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30124, groupName));
        }
        if (GroupSymbol.isTempGroupName(groupName)) {
            throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30125, groupName));
        }
    }

    private boolean isAssignable(TempMetadataAdapter metadata, SPParameter param) throws Exception {
        if (!(param.getExpression() instanceof ElementSymbol)) {
            return false;
        }
        ElementSymbol symbol = (ElementSymbol)param.getExpression();
        return metadata.elementSupports(symbol.getMetadataID(), 5);
    }

    private TempMetadataStore resolveEmbeddedCommand(TempMetadataAdapter metadata, GroupContext groupContext, Command cmd) throws Exception {
        this.getQueryResolver().setChildMetadata(cmd, metadata.getMetadataStore(), groupContext);
        return this.getQueryResolver().resolveCommand(cmd, metadata.getMetadata());
    }

    private void collectDeclareVariable(DeclareStatement obj, GroupSymbol variables, TempMetadataAdapter metadata, GroupContext externalGroups) throws Exception {
        ElementSymbol variable = obj.getVariable();
        String typeName = obj.getVariableType();
        GroupSymbol gs = variable.getGroupSymbol();
        if (gs == null) {
            String outputName = variable.getShortName();
            gs = (GroupSymbol)this.create(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
            gs.setName("VARIABLES");
            variable.setGroupSymbol(gs);
            variable.setOutputName(outputName);
        } else if (gs.getSchema() != null || !gs.getShortName().equalsIgnoreCase("VARIABLES")) {
            this.handleUnresolvableDeclaration(variable, Messages.getString(Messages.ERR.ERR_015_010_0031, "VARIABLES", variable));
        }
        boolean exists = false;
        try {
            ResolverVisitor visitor = new ResolverVisitor(variable.getTeiidVersion());
            visitor.resolveLanguageObject(variable, null, externalGroups, metadata);
            exists = true;
        }
        catch (Exception exception) {}
        if (exists) {
            this.handleUnresolvableDeclaration(variable, Messages.getString(Messages.ERR.ERR_015_010_0032, variable.getOutputName()));
        }
        variable.setType(this.getDataTypeManager().getDataTypeClass(typeName));
        variable.setGroupSymbol(variables);
        TempMetadataID id = new TempMetadataID(variable.getName(), typeName.equalsIgnoreCase("EXCEPTION") ? Exception.class : variable.getType());
        id.setUpdatable(true);
        variable.setMetadataID(id);
        metadata.getMetadataStore().addElementToTempGroup("VARIABLES", variable.clone());
    }

    private void handleUnresolvableDeclaration(ElementSymbol variable, String description) throws QueryResolverException {
        UnresolvedSymbolDescription symbol = new UnresolvedSymbolDescription(variable.toString(), description);
        QueryResolverException e = new QueryResolverException(symbol.getDescription());
        e.setUnresolvedSymbols(Arrays.asList(symbol));
        throw e;
    }
}

