/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.UnresolvedSymbolDescription;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.query.metadata.IStoredProcedureInfo;
import org.teiid.designer.query.sql.lang.IJoinType;
import org.teiid.designer.query.sql.lang.ISPParameter;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.ArrayTable;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.ObjectColumn;
import org.teiid.query.sql.lang.ObjectTable;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.lang.TextColumn;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.lang.XMLColumn;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.navigator.PostOrderNavigator;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.runtime.client.Messages;

public class SimpleQueryResolver
extends CommandResolver {
    public SimpleQueryResolver(QueryResolver queryResolver) {
        super(queryResolver);
    }

    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws Exception {
        Query query = (Query)command;
        this.resolveWith(metadata, query);
        try {
            QueryResolverVisitor qrv = new QueryResolverVisitor(query, metadata);
            qrv.visit(query);
            ResolverVisitor visitor = (ResolverVisitor)qrv.getVisitor();
            visitor.throwException(true);
            if (visitor.hasUserDefinedAggregate() && this.getTeiidVersion().isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_6.get())) {
                ExpressionMappingVisitor emv = new ExpressionMappingVisitor(this.getTeiidVersion(), null){

                    @Override
                    public Expression replaceExpression(Expression element) {
                        if (element instanceof Function && !(element instanceof AggregateSymbol) && ((Function)element).isAggregate()) {
                            Function f = (Function)element;
                            AggregateSymbol as = (AggregateSymbol)SimpleQueryResolver.this.create(TeiidNodeFactory.ASTNodes.AGGREGATE_SYMBOL);
                            as.setName(f.getName());
                            as.setDistinct(false);
                            as.setArgs(f.getArgs());
                            as.setType(f.getType());
                            as.setFunctionDescriptor(f.getFunctionDescriptor());
                            return as;
                        }
                        return element;
                    }
                };
                PreOrPostOrderNavigator.doVisit(query, emv, false);
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        if (query.getLimit() != null) {
            ResolverUtil.resolveLimit(query.getLimit());
        }
        if (query.getOrderBy() != null) {
            ResolverUtil.resolveOrderBy(query.getOrderBy(), query, metadata);
        }
        List<Expression> symbols = query.getSelect().getProjectedSymbols();
        if (query.getInto() != null) {
            GroupSymbol symbol = query.getInto().getGroup();
            ResolverUtil.resolveImplicitTempGroup(metadata, symbol, symbols);
        } else if (resolveNullLiterals) {
            ResolverUtil.resolveNullLiterals(symbols);
        }
    }

    public void resolveWith(TempMetadataAdapter metadata, QueryCommand query) throws Exception {
        if (query.getWith() == null) {
            return;
        }
        LinkedHashSet<GroupSymbol> discoveredGroups = new LinkedHashSet<GroupSymbol>();
        for (WithQueryCommand obj : query.getWith()) {
            QueryCommand queryExpression = obj.getCommand();
            this.getQueryResolver().setChildMetadata(queryExpression, query);
            this.getQueryResolver().resolveCommand(queryExpression, metadata.getMetadata(), false);
            if (!discoveredGroups.add(obj.getGroupSymbol())) {
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30101, obj.getGroupSymbol()));
            }
            List<ElementSymbol> projectedSymbols = obj.getCommand().getProjectedSymbols();
            if (obj.getColumns() != null && !obj.getColumns().isEmpty()) {
                if (obj.getColumns().size() != projectedSymbols.size()) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30102, obj.getGroupSymbol()));
                }
                Iterator<ElementSymbol> iter = obj.getColumns().iterator();
                for (Expression expression : projectedSymbols) {
                    ElementSymbol elementSymbol = iter.next();
                    elementSymbol.setType(expression.getType());
                }
                projectedSymbols = obj.getColumns();
            }
            TempMetadataID id = ResolverUtil.addTempGroup(metadata, obj.getGroupSymbol(), (List<? extends Expression>)projectedSymbols, true);
            obj.getGroupSymbol().setMetadataID(metadata.getMetadataStore().getTempGroupID(obj.getGroupSymbol().getName()));
            obj.getGroupSymbol().setIsTempTable(true);
            List<GroupSymbol> list = Collections.singletonList(obj.getGroupSymbol());
            ResolverVisitor visitor = new ResolverVisitor(obj.getTeiidVersion());
            if (obj.getColumns() != null && !obj.getColumns().isEmpty()) {
                for (Expression expression : projectedSymbols) {
                    visitor.resolveLanguageObject(expression, list, (IQueryMetadataInterface)metadata);
                }
            }
            if (obj.getColumns() == null || obj.getColumns().isEmpty()) continue;
            Iterator<ElementSymbol> iterator = obj.getColumns().iterator();
            for (TempMetadataID colid : id.getElements()) {
                ElementSymbol es = iterator.next();
                es.setMetadataID(colid);
                es.setGroupSymbol(obj.getGroupSymbol());
            }
        }
    }

    private GroupSymbol resolveAllInGroup(MultipleElementSymbol allInGroupSymbol, Set<GroupSymbol> groups, IQueryMetadataInterface metadata) throws Exception {
        String groupAlias = allInGroupSymbol.getGroup().getName();
        List<GroupSymbol> groupSymbols = ResolverUtil.findMatchingGroups(groupAlias, groups, metadata);
        if (groupSymbols.isEmpty() || groupSymbols.size() > 1) {
            String msg = Messages.getString(groupSymbols.isEmpty() ? Messages.ERR.ERR_015_008_0047 : Messages.QueryResolver.ambiguous_all_in_group, allInGroupSymbol);
            QueryResolverException qre = new QueryResolverException(msg);
            qre.addUnresolvedSymbol(new UnresolvedSymbolDescription(allInGroupSymbol.toString(), msg));
            throw qre;
        }
        allInGroupSymbol.getGroup();
        allInGroupSymbol.setGroup(groupSymbols.get(0).clone());
        return groupSymbols.get(0);
    }

    public class QueryResolverVisitor
    extends PostOrderNavigator {
        private LinkedHashSet<GroupSymbol> currentGroups;
        private LinkedList<GroupSymbol> discoveredGroups;
        private List<GroupSymbol> implicitGroups;
        private TempMetadataAdapter metadata;
        private Query query;
        private boolean allowImplicit;

        public QueryResolverVisitor(Query query, TempMetadataAdapter metadata) {
            super(new ResolverVisitor(query.getTeiidVersion(), metadata, null, query.getExternalGroupContexts()));
            this.currentGroups = new LinkedHashSet();
            this.discoveredGroups = new LinkedList();
            this.implicitGroups = new LinkedList<GroupSymbol>();
            this.allowImplicit = true;
            ResolverVisitor visitor = (ResolverVisitor)this.getVisitor();
            visitor.setGroups(this.currentGroups);
            this.query = query;
            this.metadata = metadata;
        }

        @Override
        protected void postVisitVisitor(LanguageObject obj) {
            super.postVisitVisitor(obj);
            ResolverVisitor visitor = (ResolverVisitor)this.getVisitor();
            try {
                visitor.throwException(false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(Query obj) {
            this.visitNode(obj.getInto());
            this.visitNode(obj.getFrom());
            this.visitNode(obj.getCriteria());
            this.visitNode(obj.getGroupBy());
            this.visitNode(obj.getHaving());
            this.visitNode(obj.getSelect());
            this.visitNode(obj.getLimit());
        }

        @Override
        public void visit(GroupSymbol obj) {
            try {
                ResolverUtil.resolveGroup(obj, this.metadata);
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        }

        private void resolveSubQuery(SubqueryContainer<?> obj, Collection<GroupSymbol> externalGroups) {
            Object command = obj.getCommand();
            SimpleQueryResolver.this.getQueryResolver().setChildMetadata((Command)command, this.query);
            ((Command)command).pushNewResolvingContext(externalGroups);
            try {
                SimpleQueryResolver.this.getQueryResolver().resolveCommand((Command)command, this.metadata.getMetadata(), false);
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        }

        @Override
        public void visit(MultipleElementSymbol obj) {
            try {
                ArrayList<ElementSymbol> elementSymbols = new ArrayList<ElementSymbol>();
                SequencedCollection<GroupSymbol> groups = this.currentGroups;
                if (obj.getGroup() != null) {
                    groups = Arrays.asList(SimpleQueryResolver.this.resolveAllInGroup(obj, this.currentGroups, this.metadata));
                }
                for (GroupSymbol group : groups) {
                    elementSymbols.addAll(this.resolveSelectableElements(group));
                }
                obj.setElementSymbols(elementSymbols);
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        }

        private List<ElementSymbol> resolveSelectableElements(GroupSymbol group) throws Exception {
            List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(group, this.metadata);
            ArrayList<ElementSymbol> result = new ArrayList<ElementSymbol>(elements.size());
            for (ElementSymbol element : elements) {
                if (!this.metadata.elementSupports(element.getMetadataID(), 0) || this.metadata.isPseudo(element.getMetadataID())) continue;
                element = element.clone();
                element.setGroupSymbol(group);
                result.add(element);
            }
            return result;
        }

        @Override
        public void visit(ScalarSubquery obj) {
            this.resolveSubQuery(obj, this.currentGroups);
        }

        @Override
        public void visit(ExistsCriteria obj) {
            this.resolveSubQuery(obj, this.currentGroups);
        }

        @Override
        public void visit(SubqueryCompareCriteria obj) {
            this.visitNode(obj.getLeftExpression());
            this.resolveSubQuery(obj, this.currentGroups);
            this.postVisitVisitor(obj);
        }

        @Override
        public void visit(SubquerySetCriteria obj) {
            this.visitNode((LanguageObject)obj.getExpression());
            this.resolveSubQuery(obj, this.currentGroups);
            this.postVisitVisitor(obj);
        }

        @Override
        public void visit(TextTable obj) {
            LinkedHashSet<GroupSymbol> saved = this.preTableFunctionReference(obj);
            this.visitNode(obj.getFile());
            try {
                obj.setFile(ResolverUtil.convertExpression(obj.getFile(), DataTypeManagerService.DefaultDataTypes.CLOB.getId(), this.metadata));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.postTableFunctionReference(obj, saved);
            for (TextColumn col : obj.getColumns()) {
                if (col.getWidth() == null) continue;
                obj.setFixedWidth(true);
                break;
            }
        }

        @Override
        public void visit(ArrayTable obj) {
            LinkedHashSet<GroupSymbol> saved = this.preTableFunctionReference(obj);
            this.visitNode(obj.getArrayValue());
            this.postTableFunctionReference(obj, saved);
        }

        @Override
        public void visit(XMLTable obj) {
            LinkedHashSet<GroupSymbol> saved = this.preTableFunctionReference(obj);
            this.visitNodes(obj.getPassing());
            this.postTableFunctionReference(obj, saved);
            try {
                ResolverUtil.setDesiredType(obj.getPassing(), obj);
                obj.compileXqueryExpression();
                for (XMLColumn column : obj.getColumns()) {
                    if (column.getDefaultExpression() == null) continue;
                    this.visitNode(column.getDefaultExpression());
                    Expression ex = ResolverUtil.convertExpression(column.getDefaultExpression(), this.getDataTypeManager().getDataTypeName(column.getSymbol().getType()), this.metadata);
                    column.setDefaultExpression(ex);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(ObjectTable obj) {
            LinkedHashSet<GroupSymbol> saved = this.preTableFunctionReference(obj);
            this.visitNodes(obj.getPassing());
            this.postTableFunctionReference(obj, saved);
            try {
                ResolverUtil.setDesiredType(obj.getPassing(), obj, DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeClass());
                for (ObjectColumn column : obj.getColumns()) {
                    if (column.getDefaultExpression() == null) continue;
                    this.visitNode(column.getDefaultExpression());
                    Expression ex = ResolverUtil.convertExpression(column.getDefaultExpression(), this.getDataTypeManager().getDataTypeName(column.getSymbol().getType()), this.metadata);
                    column.setDefaultExpression(ex);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public LinkedHashSet<GroupSymbol> preTableFunctionReference(TableFunctionReference tfr) {
            LinkedHashSet<GroupSymbol> saved = new LinkedHashSet<GroupSymbol>(this.currentGroups);
            if (this.allowImplicit) {
                this.currentGroups.addAll(this.implicitGroups);
            }
            return saved;
        }

        public void postTableFunctionReference(TableFunctionReference obj, LinkedHashSet<GroupSymbol> saved) {
            for (ElementSymbol symbol : ElementCollectorVisitor.getElements((LanguageObject)obj, false)) {
                if (symbol.isExternalReference() || !this.implicitGroups.contains(symbol.getGroupSymbol())) continue;
                symbol.setIsExternalReference(true);
            }
            if (this.allowImplicit) {
                this.currentGroups.clear();
                this.currentGroups.addAll(saved);
            }
            this.discoveredGroup(obj.getGroupSymbol());
            try {
                ResolverUtil.addTempGroup(this.metadata, obj.getGroupSymbol(), obj.getProjectedSymbols(), false);
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
            obj.getGroupSymbol().setMetadataID(this.metadata.getMetadataStore().getTempGroupID(obj.getGroupSymbol().getName()));
            HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
            groups.add(obj.getGroupSymbol());
            ResolverVisitor visitor = new ResolverVisitor(obj.getTeiidVersion());
            for (ElementSymbol symbol : obj.getProjectedSymbols()) {
                try {
                    visitor.resolveLanguageObject(symbol, groups, null, this.metadata);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void visit(SubqueryFromClause obj) {
            AbstractCollection externalGroups = this.currentGroups;
            if (obj.isTable() && this.allowImplicit) {
                externalGroups = new ArrayList<GroupSymbol>(externalGroups);
                externalGroups.addAll(this.implicitGroups);
            }
            this.resolveSubQuery(obj, externalGroups);
            this.discoveredGroup(obj.getGroupSymbol());
            try {
                ResolverUtil.addTempGroup(this.metadata, obj.getGroupSymbol(), obj.getCommand().getProjectedSymbols(), false);
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
            obj.getGroupSymbol().setMetadataID(this.metadata.getMetadataStore().getTempGroupID(obj.getGroupSymbol().getName()));
        }

        @Override
        public void visit(UnaryFromClause obj) {
            GroupSymbol group = obj.getGroup();
            this.visitNode(group);
            try {
                if (!group.isProcedure() && this.metadata.isXMLGroup(group.getMetadataID())) {
                    throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30112, new Object[0]));
                }
                this.discoveredGroup(group);
                if (group.isProcedure()) {
                    this.createProcRelational(obj);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void discoveredGroup(GroupSymbol group) {
            this.discoveredGroups.add(group);
            if (this.allowImplicit) {
                this.implicitGroups.add(group);
            }
        }

        private void createProcRelational(UnaryFromClause obj) throws Exception {
            GroupSymbol group = obj.getGroup();
            String fullName = this.metadata.getFullName(group.getMetadataID());
            String queryName = group.getName();
            IStoredProcedureInfo storedProcedureInfo = this.metadata.getStoredProcedureInfoForProcedure(fullName);
            StoredProcedure storedProcedureCommand = (StoredProcedure)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.STORED_PROCEDURE);
            storedProcedureCommand.setProcedureRelational(true);
            storedProcedureCommand.setProcedureName(fullName);
            List metadataParams = storedProcedureInfo.getParameters();
            Query procQuery = (Query)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.QUERY);
            From from = (From)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.FROM);
            SubqueryFromClause subqueryFromClause = (SubqueryFromClause)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.SUBQUERY_FROM_CLAUSE);
            subqueryFromClause.setName("X");
            subqueryFromClause.setCommand(storedProcedureCommand);
            from.addClause(subqueryFromClause);
            procQuery.setFrom(from);
            Select select = (Select)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.SELECT);
            MultipleElementSymbol mes = (MultipleElementSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.MULTIPLE_ELEMENT_SYMBOL);
            mes.setName("X");
            select.addSymbol(mes);
            procQuery.setSelect(select);
            LinkedList<String> accessPatternElementNames = new LinkedList<String>();
            int paramIndex = 1;
            for (SPParameter metadataParameter : metadataParams) {
                SPParameter clonedParam = metadataParameter.clone();
                if (clonedParam.getParameterType() != ISPParameter.ParameterInfo.IN.index() && metadataParameter.getParameterType() != ISPParameter.ParameterInfo.INOUT.index()) continue;
                ElementSymbol paramSymbol = clonedParam.getParameterSymbol();
                Reference ref = (Reference)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.REFERENCE);
                ref.setExpression(paramSymbol);
                clonedParam.setExpression(ref);
                clonedParam.setIndex(paramIndex++);
                storedProcedureCommand.setParameter(clonedParam);
                String aliasName = paramSymbol.getShortName();
                if (metadataParameter.getParameterType() == ISPParameter.ParameterInfo.INOUT.index()) {
                    aliasName = String.valueOf(aliasName) + "_IN";
                }
                ExpressionSymbol es = (ExpressionSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.EXPRESSION_SYMBOL);
                es.setName(paramSymbol.getShortName());
                es.setExpression(ref);
                AliasSymbol newSymbol = (AliasSymbol)this.getTeiidParser().createASTNode(TeiidNodeFactory.ASTNodes.ALIAS_SYMBOL);
                newSymbol.setName(aliasName);
                newSymbol.setSymbol(es);
                select.addSymbol(newSymbol);
                accessPatternElementNames.add(String.valueOf(queryName) + "." + aliasName);
            }
            SimpleQueryResolver.this.getQueryResolver().resolveCommand(procQuery, this.metadata.getMetadata());
            List<Expression> projectedSymbols = procQuery.getProjectedSymbols();
            TreeSet<String> foundNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (Expression ses : projectedSymbols) {
                if (foundNames.add(Symbol.getShortName(ses))) continue;
                throw new QueryResolverException(Messages.gs(Messages.TEIID.TEIID30114, fullName));
            }
            TempMetadataID id = this.metadata.getMetadataStore().getTempGroupID(queryName);
            if (id == null) {
                this.metadata.getMetadataStore().addTempGroup(queryName, projectedSymbols, true);
                id = this.metadata.getMetadataStore().getTempGroupID(queryName);
                id.setOriginalMetadataID(storedProcedureCommand.getProcedureID());
                if (!accessPatternElementNames.isEmpty()) {
                    LinkedList<TempMetadataID> accessPatternIds = new LinkedList<TempMetadataID>();
                    for (String name : accessPatternElementNames) {
                        accessPatternIds.add(this.metadata.getMetadataStore().getTempElementID(name));
                    }
                    id.setAccessPatterns(Arrays.asList(new TempMetadataID("procedure access pattern", accessPatternIds)));
                }
            }
            group.setMetadataID(id);
            obj.setExpandedCommand(procQuery);
        }

        @Override
        public void visit(Into obj) {
            if (!obj.getGroup().isImplicitTempGroupSymbol()) {
                super.visit(obj);
            }
        }

        @Override
        public void visit(JoinPredicate obj) {
            assert (this.currentGroups.isEmpty());
            ArrayList<GroupSymbol> tempImplicitGroups = new ArrayList<GroupSymbol>(this.discoveredGroups);
            this.discoveredGroups.clear();
            this.visitNode(obj.getLeftClause());
            ArrayList<GroupSymbol> leftGroups = new ArrayList<GroupSymbol>(this.discoveredGroups);
            this.discoveredGroups.clear();
            this.visitNode(obj.getRightClause());
            this.discoveredGroups.addAll(leftGroups);
            this.addDiscoveredGroups();
            this.visitNodes(obj.getJoinCriteria());
            this.discoveredGroups.addAll(this.currentGroups);
            this.currentGroups.clear();
            this.discoveredGroups.addAll(tempImplicitGroups);
        }

        private void addDiscoveredGroups() {
            for (GroupSymbol group : this.discoveredGroups) {
                if (this.currentGroups.add(group)) continue;
                String msg = Messages.getString(Messages.ERR.ERR_015_008_0046, group.getName());
                QueryResolverException qre = new QueryResolverException(msg);
                qre.addUnresolvedSymbol(new UnresolvedSymbolDescription(group.toString(), msg));
                throw new RuntimeException(qre);
            }
            this.discoveredGroups.clear();
        }

        @Override
        public void visit(From obj) {
            assert (this.currentGroups.isEmpty());
            for (FromClause clause : obj.getClauses()) {
                this.checkImplicit(clause);
            }
            super.visit(obj);
            this.addDiscoveredGroups();
        }

        private void checkImplicit(FromClause clause) {
            if (clause instanceof JoinPredicate) {
                JoinPredicate jp = (JoinPredicate)clause;
                if (IJoinType.Types.JOIN_FULL_OUTER.equals((Object)jp.getJoinType().getKind()) || IJoinType.Types.JOIN_RIGHT_OUTER.equals((Object)jp.getJoinType().getKind())) {
                    this.allowImplicit = false;
                    return;
                }
                this.checkImplicit(jp.getLeftClause());
                if (this.allowImplicit) {
                    this.checkImplicit(jp.getRightClause());
                }
            }
        }

        @Override
        public void visit(Limit obj) {
            super.visit(obj);
            if (obj.getOffset() != null) {
                ResolverUtil.setTypeIfNull(obj.getOffset(), DataTypeManagerService.DefaultDataTypes.INTEGER.getTypeClass());
                try {
                    obj.setOffset(ResolverUtil.convertExpression(obj.getOffset(), DataTypeManagerService.DefaultDataTypes.INTEGER.getId(), this.metadata));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (obj.getRowLimit() != null) {
                ResolverUtil.setTypeIfNull(obj.getRowLimit(), DataTypeManagerService.DefaultDataTypes.INTEGER.getTypeClass());
                try {
                    obj.setRowLimit(ResolverUtil.convertExpression(obj.getRowLimit(), DataTypeManagerService.DefaultDataTypes.INTEGER.getId(), this.metadata));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

