/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.teiid.core.util.StringUtil;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.parser.v7.Teiid7Parser;
import org.teiid.query.parser.v8.Teiid8Parser;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.AlterView;
import org.teiid.query.sql.lang.ArrayTable;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.CriteriaSelector;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.HasCriteria;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.LanguageObject;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.ObjectColumn;
import org.teiid.query.sql.lang.ObjectTable;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.ProjectedColumn;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.Teiid7ParserTreeConstants;
import org.teiid.query.sql.lang.Teiid8ParserTreeConstants;
import org.teiid.query.sql.lang.TextColumn;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.TranslateCriteria;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.lang.XMLColumn;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.lang.v7.Alter7Procedure;
import org.teiid.query.sql.lang.v8.Alter8Procedure;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.BranchingStatement;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.ExceptionExpression;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.RaiseErrorStatement;
import org.teiid.query.sql.proc.RaiseStatement;
import org.teiid.query.sql.proc.ReturnStatement;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.JSONObject;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.symbol.WindowSpecification;
import org.teiid.query.sql.symbol.XMLAttributes;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.sql.symbol.v7.Aggregate7Symbol;
import org.teiid.query.sql.symbol.v7.Window7Function;
import org.teiid.query.sql.symbol.v8.Aggregate8Symbol;
import org.teiid.query.sql.symbol.v8.Window8Function;
import org.teiid.runtime.client.Messages;

public class TeiidNodeFactory {
    private static TeiidNodeFactory instance;
    private static final String DOT;
    private static final String UNDERSCORE = "_";
    private static final String OPEN_BRACKET = "(";
    private static final String CLOSE_BRACKET = ")";
    private static final String SPEECH_MARK = "\"";
    private static final String SEMI_COLON = ";";
    private static final String COMMA = ",";
    private static final String PREFIX = "JJT";
    private static final String NEWLINE = "\n";
    private static final String TAB = "\t";
    private static final String SPACE = " ";
    private static final String NON_NLS = "//$NON-NLS-1$";
    private static final String PACKAGE_NAME = "org.teiid.query.sql.lang";
    private static final String CONSTANT_CLASS_PREFIX = "Teiid";
    private static final String CONSTANT_CLASS_POSTFIX = "ParserTreeConstants";
    private static final String NODENAME_FIELD = "jjtNodeName";
    private static final String VOID = "VOID";
    private static final String[] COMPONENT_METHOD_EXCLUSIONS;
    private static final Map<String, String> AST_NODE_ANNOTATIONS;

    static {
        DOT = StringUtil.Constants.DOT;
        COMPONENT_METHOD_EXCLUSIONS = new String[]{"AggregateSymbol", "WindowFunction", "AlterProcedure"};
        AST_NODE_ANNOTATIONS = new HashMap<String, String>();
        AST_NODE_ANNOTATIONS.put("CreateUpdateProcedureCommand", "@Removed(\"8.0.0\")");
        AST_NODE_ANNOTATIONS.put("CriteriaSelector", "@Removed(\"8.0.0\")");
        AST_NODE_ANNOTATIONS.put("RaiseErrorStatement", "@Removed(\"8.0.0\")");
        AST_NODE_ANNOTATIONS.put("TranslateCriteria", "@Removed(\"8.0.0\")");
        AST_NODE_ANNOTATIONS.put("HasCriteria", "@Removed(\"8.0.0\")");
        AST_NODE_ANNOTATIONS.put("CreateProcedureCommand", "@Since(\"8.0.0\")");
        AST_NODE_ANNOTATIONS.put("ObjectTable", "@Since(\"8.0.0\")");
        AST_NODE_ANNOTATIONS.put("ReturnStatement", "@Since(\"8.0.0\")");
        AST_NODE_ANNOTATIONS.put("RaiseStatement", "@Since(\"8.0.0\")");
        AST_NODE_ANNOTATIONS.put("Array", "@Since(\"8.0.0\")");
        AST_NODE_ANNOTATIONS.put("ExceptionExpression", "@Since(\"8.0.0\")");
        AST_NODE_ANNOTATIONS.put("JSONObject", "@Since(\"8.0.0\")");
    }

    public static TeiidNodeFactory getInstance() {
        if (instance == null) {
            instance = new TeiidNodeFactory();
        }
        return instance;
    }

    private static boolean isTeiid7Parser(TeiidParser teiidParser) {
        return teiidParser instanceof Teiid7Parser;
    }

    private static boolean isTeiid8Parser(TeiidParser teiidParser) {
        return teiidParser instanceof Teiid8Parser;
    }

    public <T extends LanguageObject> T create(TeiidParser teiidParser, ASTNodes nodeType) {
        block5: {
            block4: {
                if (!TeiidNodeFactory.isTeiid8Parser(teiidParser)) break block4;
                int i = 0;
                while (i < Teiid8ParserTreeConstants.jjtNodeName.length) {
                    String constantName = Teiid8ParserTreeConstants.jjtNodeName[i];
                    if (constantName.equalsIgnoreCase(nodeType.getName())) {
                        return this.create(teiidParser, i);
                    }
                    ++i;
                }
                break block5;
            }
            if (!TeiidNodeFactory.isTeiid7Parser(teiidParser)) break block5;
            int i = 0;
            while (i < Teiid7ParserTreeConstants.jjtNodeName.length) {
                String constantName = Teiid7ParserTreeConstants.jjtNodeName[i];
                if (constantName.equalsIgnoreCase(nodeType.getName())) {
                    return this.create(teiidParser, i);
                }
                ++i;
            }
        }
        throw new IllegalArgumentException(Messages.getString(Messages.TeiidParser.invalidNodeType, nodeType.getName(), teiidParser.getVersion()));
    }

    public <T extends LanguageObject> T create(TeiidParser teiidParser, int nodeType) {
        if (TeiidNodeFactory.isTeiid8Parser(teiidParser)) {
            return this.create((Teiid8Parser)teiidParser, nodeType);
        }
        if (TeiidNodeFactory.isTeiid7Parser(teiidParser)) {
            return this.create((Teiid7Parser)teiidParser, nodeType);
        }
        throw new IllegalArgumentException(Messages.getString(Messages.TeiidParser.invalidNodeType, nodeType, teiidParser.getVersion()));
    }

    private Map<String, String> indexNodeNames(Class<?> constantClass) throws NoSuchFieldException, IllegalAccessException {
        Field nodeNameField = constantClass.getField(NODENAME_FIELD);
        Object nodeNameObj = nodeNameField.get(null);
        String[] nodeNameFields = (String[])nodeNameObj;
        HashMap<String, String> nodeNameMap = new HashMap<String, String>();
        String[] stringArray = nodeNameFields;
        int n = nodeNameFields.length;
        int n2 = 0;
        while (n2 < n) {
            String nodeName = stringArray[n2];
            nodeNameMap.put(nodeName.toLowerCase(), nodeName);
            ++n2;
        }
        return nodeNameMap;
    }

    private String createASTNodesEnumDeclaration() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("/**\n");
        buffer.append(" * Names of AST nodes to allow creation outside of the parsers\n");
        buffer.append(" *\n");
        buffer.append(" * @generated\n");
        buffer.append(" */\n");
        buffer.append("public enum ASTNodes {\n");
        return buffer.toString();
    }

    private String createASTNodeEnumValue(String typeName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t/**\n");
        buffer.append("\t * " + typeName + NEWLINE);
        buffer.append("\t * @generated\n");
        buffer.append("\t */\n");
        String annotation = AST_NODE_ANNOTATIONS.get(typeName);
        if (annotation != null) {
            buffer.append(TAB + annotation + NEWLINE);
        }
        buffer.append(TAB);
        int i = 0;
        while (i < typeName.length()) {
            Character c = Character.valueOf(typeName.charAt(i));
            Character c1 = null;
            if (i + 1 < typeName.length()) {
                c1 = Character.valueOf(typeName.charAt(i + 1));
            }
            if (i > 0 && Character.isUpperCase(c.charValue()) && (c1 == null || !Character.isUpperCase(c1.charValue()))) {
                buffer.append(UNDERSCORE);
            }
            buffer.append(Character.toUpperCase(c.charValue()));
            ++i;
        }
        buffer.append("(\"");
        buffer.append(typeName);
        buffer.append("\")");
        buffer.append(", //$NON-NLS-1$\n");
        return buffer.toString();
    }

    private String createASTNodesEnumMethods() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\tprivate String name;\n");
        buffer.append(NEWLINE);
        buffer.append("\tASTNodes(String name) {\n");
        buffer.append("\t\tthis.name = name;\n");
        buffer.append("\t}\n");
        buffer.append(NEWLINE);
        buffer.append("\t/**\n");
        buffer.append("\t * @return Name of this common node\n");
        buffer.append("\t */\n");
        buffer.append("\tpublic String getName() {\n");
        buffer.append("\t\treturn name;\n");
        buffer.append("\t}\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    private String createMethodDeclaration(int serverVersion) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("/**\n");
        buffer.append(" * Create a version " + serverVersion + " teiid parser node for the given node type." + NEWLINE);
        buffer.append(" *\n");
        buffer.append(" * @generated\n");
        buffer.append(" *\n");
        buffer.append(" * @param teiidParser\n");
        buffer.append(" * @param nodeType\n");
        buffer.append(" * @return version " + serverVersion + " teiid parser node" + NEWLINE);
        buffer.append(" */\n");
        buffer.append("private <T extends LanguageObject> T create(Teiid" + serverVersion + "Parser teiidParser, int nodeType) {" + NEWLINE);
        return buffer.toString();
    }

    private String createSwitchCase(String astIdentifier, String typeName, String constantClassName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t\tcase " + constantClassName + DOT + astIdentifier + ":" + NEWLINE);
        buffer.append("\t\t\treturn (T) create" + typeName + "(teiidParser, nodeType)" + SEMI_COLON + NEWLINE);
        return buffer.toString();
    }

    private String createComponentMethod(String typeName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("/**\n");
        buffer.append(" *\n");
        buffer.append(" * @generated\n");
        buffer.append(" *\n");
        buffer.append(" * @param teiidParser\n");
        buffer.append(" * @param nodeType\n");
        buffer.append(" * @return\n");
        buffer.append(" */\n");
        buffer.append("private " + typeName + " create" + typeName + "(TeiidParser teiidParser, int nodeType) {" + NEWLINE);
        buffer.append("\treturn new " + typeName + "(teiidParser, nodeType)" + SEMI_COLON + NEWLINE);
        buffer.append("}\n");
        return buffer.toString();
    }

    private void generate(int ... serverVersions) throws Exception {
        LinkedHashSet<String> componentMethods = new LinkedHashSet<String>();
        LinkedHashSet<String> astNodesEnum = new LinkedHashSet<String>();
        StringBuffer createMethodBuffer = new StringBuffer();
        List<String> componentMethodExclusions = Arrays.asList(COMPONENT_METHOD_EXCLUSIONS);
        astNodesEnum.add(this.createASTNodesEnumDeclaration());
        Object object = serverVersions;
        int n = serverVersions.length;
        int n2 = 0;
        while (n2 < n) {
            int serverVersion = object[n2];
            String constantClassName = CONSTANT_CLASS_PREFIX + serverVersion + CONSTANT_CLASS_POSTFIX;
            Class<?> constantClass = Class.forName(PACKAGE_NAME + DOT + constantClassName);
            Map<String, String> nodeNameIndex = this.indexNodeNames(constantClass);
            createMethodBuffer.append(this.createMethodDeclaration(serverVersion));
            createMethodBuffer.append("\tswitch (nodeType) {\n");
            Field[] fieldArray = constantClass.getFields();
            int n3 = fieldArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Field field = fieldArray[n4];
                String fieldName = field.getName();
                if (fieldName.startsWith(PREFIX) && !fieldName.equalsIgnoreCase("JJTVOID")) {
                    String astName = fieldName.substring(PREFIX.length());
                    String typeName = nodeNameIndex.get(astName.toLowerCase());
                    createMethodBuffer.append(this.createSwitchCase(fieldName, typeName, constantClassName));
                    if (!componentMethodExclusions.contains(typeName)) {
                        componentMethods.add(this.createComponentMethod(typeName));
                    }
                    astNodesEnum.add(this.createASTNodeEnumValue(typeName));
                }
                ++n4;
            }
            createMethodBuffer.append("\t\tdefault:\n");
            createMethodBuffer.append("\t\t\t");
            createMethodBuffer.append("throw new IllegalArgumentException(Messages.getString(Messages.TeiidParser.invalidNodeType, nodeType, teiidParser.getVersion()))");
            createMethodBuffer.append(";\n");
            createMethodBuffer.append("\t}\n");
            createMethodBuffer.append("}\n\n");
            ++n2;
        }
        Iterator iter = astNodesEnum.iterator();
        String lastValue = null;
        while (iter.hasNext()) {
            lastValue = (String)iter.next();
        }
        astNodesEnum.remove(lastValue);
        lastValue = lastValue.replace(COMMA, SEMI_COLON);
        astNodesEnum.add(lastValue);
        astNodesEnum.add(this.createASTNodesEnumMethods());
        object = astNodesEnum.iterator();
        while (object.hasNext()) {
            String value = (String)object.next();
            System.out.println(value);
        }
        for (String method : componentMethods) {
            System.out.println(method);
        }
        System.out.println(createMethodBuffer.toString());
    }

    public static void main(String[] args) throws Exception {
        TeiidNodeFactory factory = new TeiidNodeFactory();
        factory.generate(7, 8);
    }

    public static LanguageObject jjtCreate(TeiidParser teiidParser, int nodeType) {
        return TeiidNodeFactory.getInstance().create(teiidParser, nodeType);
    }

    private WindowFunction createWindowFunction(TeiidParser teiidParser, int nodeType) {
        if (TeiidNodeFactory.isTeiid8Parser(teiidParser)) {
            return new Window8Function((Teiid8Parser)teiidParser, nodeType);
        }
        if (TeiidNodeFactory.isTeiid7Parser(teiidParser)) {
            return new Window7Function((Teiid7Parser)teiidParser, nodeType);
        }
        throw new IllegalArgumentException(Messages.getString(Messages.TeiidParser.invalidNodeType, nodeType, teiidParser.getVersion()));
    }

    private AggregateSymbol createAggregateSymbol(TeiidParser teiidParser, int nodeType) {
        if (TeiidNodeFactory.isTeiid8Parser(teiidParser)) {
            return new Aggregate8Symbol((Teiid8Parser)teiidParser, nodeType);
        }
        if (TeiidNodeFactory.isTeiid7Parser(teiidParser)) {
            return new Aggregate7Symbol((Teiid7Parser)teiidParser, nodeType);
        }
        throw new IllegalArgumentException(Messages.getString(Messages.TeiidParser.invalidNodeType, nodeType, teiidParser.getVersion()));
    }

    private AlterProcedure createAlterProcedure(TeiidParser teiidParser, int nodeType) {
        if (TeiidNodeFactory.isTeiid8Parser(teiidParser)) {
            return new Alter8Procedure((Teiid8Parser)teiidParser, nodeType);
        }
        if (TeiidNodeFactory.isTeiid7Parser(teiidParser)) {
            return new Alter7Procedure((Teiid7Parser)teiidParser, nodeType);
        }
        throw new IllegalArgumentException(Messages.getString(Messages.TeiidParser.invalidNodeType, nodeType, teiidParser.getVersion()));
    }

    private TriggerAction createTriggerAction(TeiidParser teiidParser, int nodeType) {
        return new TriggerAction(teiidParser, nodeType);
    }

    private Drop createDrop(TeiidParser teiidParser, int nodeType) {
        return new Drop(teiidParser, nodeType);
    }

    private Create createCreate(TeiidParser teiidParser, int nodeType) {
        return new Create(teiidParser, nodeType);
    }

    private RaiseErrorStatement createRaiseErrorStatement(TeiidParser teiidParser, int nodeType) {
        return new RaiseErrorStatement(teiidParser, nodeType);
    }

    private BranchingStatement createBranchingStatement(TeiidParser teiidParser, int nodeType) {
        return new BranchingStatement(teiidParser, nodeType);
    }

    private WhileStatement createWhileStatement(TeiidParser teiidParser, int nodeType) {
        return new WhileStatement(teiidParser, nodeType);
    }

    private LoopStatement createLoopStatement(TeiidParser teiidParser, int nodeType) {
        return new LoopStatement(teiidParser, nodeType);
    }

    private IfStatement createIfStatement(TeiidParser teiidParser, int nodeType) {
        return new IfStatement(teiidParser, nodeType);
    }

    private CriteriaSelector createCriteriaSelector(TeiidParser teiidParser, int nodeType) {
        return new CriteriaSelector(teiidParser, nodeType);
    }

    private HasCriteria createHasCriteria(TeiidParser teiidParser, int nodeType) {
        return new HasCriteria(teiidParser, nodeType);
    }

    private DeclareStatement createDeclareStatement(TeiidParser teiidParser, int nodeType) {
        return new DeclareStatement(teiidParser, nodeType);
    }

    private CommandStatement createCommandStatement(TeiidParser teiidParser, int nodeType) {
        return new CommandStatement(teiidParser, nodeType);
    }

    private TranslateCriteria createTranslateCriteria(TeiidParser teiidParser, int nodeType) {
        return new TranslateCriteria(teiidParser, nodeType);
    }

    private CreateUpdateProcedureCommand createCreateUpdateProcedureCommand(TeiidParser teiidParser, int nodeType) {
        return new CreateUpdateProcedureCommand(teiidParser, nodeType);
    }

    private DynamicCommand createDynamicCommand(TeiidParser teiidParser, int nodeType) {
        return new DynamicCommand(teiidParser, nodeType);
    }

    private SetClauseList createSetClauseList(TeiidParser teiidParser, int nodeType) {
        return new SetClauseList(teiidParser, nodeType);
    }

    private SetClause createSetClause(TeiidParser teiidParser, int nodeType) {
        return new SetClause(teiidParser, nodeType);
    }

    private ProjectedColumn createProjectedColumn(TeiidParser teiidParser, int nodeType) {
        return new ProjectedColumn(teiidParser, nodeType);
    }

    private StoredProcedure createStoredProcedure(TeiidParser teiidParser, int nodeType) {
        return new StoredProcedure(teiidParser, nodeType);
    }

    private Insert createInsert(TeiidParser teiidParser, int nodeType) {
        return new Insert(teiidParser, nodeType);
    }

    private Update createUpdate(TeiidParser teiidParser, int nodeType) {
        return new Update(teiidParser, nodeType);
    }

    private Delete createDelete(TeiidParser teiidParser, int nodeType) {
        return new Delete(teiidParser, nodeType);
    }

    private WithQueryCommand createWithQueryCommand(TeiidParser teiidParser, int nodeType) {
        return new WithQueryCommand(teiidParser, nodeType);
    }

    private SetQuery createSetQuery(TeiidParser teiidParser, int nodeType) {
        return new SetQuery(teiidParser, nodeType);
    }

    private Query createQuery(TeiidParser teiidParser, int nodeType) {
        return new Query(teiidParser, nodeType);
    }

    private Into createInto(TeiidParser teiidParser, int nodeType) {
        return new Into(teiidParser, nodeType);
    }

    private Select createSelect(TeiidParser teiidParser, int nodeType) {
        return new Select(teiidParser, nodeType);
    }

    private DerivedColumn createDerivedColumn(TeiidParser teiidParser, int nodeType) {
        return new DerivedColumn(teiidParser, nodeType);
    }

    private MultipleElementSymbol createMultipleElementSymbol(TeiidParser teiidParser, int nodeType) {
        return new MultipleElementSymbol(teiidParser, nodeType);
    }

    private From createFrom(TeiidParser teiidParser, int nodeType) {
        return new From(teiidParser, nodeType);
    }

    private JoinPredicate createJoinPredicate(TeiidParser teiidParser, int nodeType) {
        return new JoinPredicate(teiidParser, nodeType);
    }

    private JoinType createJoinType(TeiidParser teiidParser, int nodeType) {
        return new JoinType(teiidParser, nodeType);
    }

    private XMLSerialize createXMLSerialize(TeiidParser teiidParser, int nodeType) {
        return new XMLSerialize(teiidParser, nodeType);
    }

    private ArrayTable createArrayTable(TeiidParser teiidParser, int nodeType) {
        return new ArrayTable(teiidParser, nodeType);
    }

    private TextTable createTextTable(TeiidParser teiidParser, int nodeType) {
        return new TextTable(teiidParser, nodeType);
    }

    private TextColumn createTextColumn(TeiidParser teiidParser, int nodeType) {
        return new TextColumn(teiidParser, nodeType);
    }

    private XMLQuery createXMLQuery(TeiidParser teiidParser, int nodeType) {
        return new XMLQuery(teiidParser, nodeType);
    }

    private XMLTable createXMLTable(TeiidParser teiidParser, int nodeType) {
        return new XMLTable(teiidParser, nodeType);
    }

    private XMLColumn createXMLColumn(TeiidParser teiidParser, int nodeType) {
        return new XMLColumn(teiidParser, nodeType);
    }

    private SubqueryFromClause createSubqueryFromClause(TeiidParser teiidParser, int nodeType) {
        return new SubqueryFromClause(teiidParser, nodeType);
    }

    private UnaryFromClause createUnaryFromClause(TeiidParser teiidParser, int nodeType) {
        return new UnaryFromClause(teiidParser, nodeType);
    }

    private Criteria createCriteria(TeiidParser teiidParser, int nodeType) {
        return new Criteria(teiidParser, nodeType);
    }

    private CompoundCriteria createCompoundCriteria(TeiidParser teiidParser, int nodeType) {
        return new CompoundCriteria(teiidParser, nodeType);
    }

    private NotCriteria createNotCriteria(TeiidParser teiidParser, int nodeType) {
        return new NotCriteria(teiidParser, nodeType);
    }

    private CompareCriteria createCompareCriteria(TeiidParser teiidParser, int nodeType) {
        return new CompareCriteria(teiidParser, nodeType);
    }

    private SubqueryCompareCriteria createSubqueryCompareCriteria(TeiidParser teiidParser, int nodeType) {
        return new SubqueryCompareCriteria(teiidParser, nodeType);
    }

    private MatchCriteria createMatchCriteria(TeiidParser teiidParser, int nodeType) {
        return new MatchCriteria(teiidParser, nodeType);
    }

    private BetweenCriteria createBetweenCriteria(TeiidParser teiidParser, int nodeType) {
        return new BetweenCriteria(teiidParser, nodeType);
    }

    private IsNullCriteria createIsNullCriteria(TeiidParser teiidParser, int nodeType) {
        return new IsNullCriteria(teiidParser, nodeType);
    }

    private SubquerySetCriteria createSubquerySetCriteria(TeiidParser teiidParser, int nodeType) {
        return new SubquerySetCriteria(teiidParser, nodeType);
    }

    private SetCriteria createSetCriteria(TeiidParser teiidParser, int nodeType) {
        return new SetCriteria(teiidParser, nodeType);
    }

    private ExistsCriteria createExistsCriteria(TeiidParser teiidParser, int nodeType) {
        return new ExistsCriteria(teiidParser, nodeType);
    }

    private GroupBy createGroupBy(TeiidParser teiidParser, int nodeType) {
        return new GroupBy(teiidParser, nodeType);
    }

    private OrderBy createOrderBy(TeiidParser teiidParser, int nodeType) {
        return new OrderBy(teiidParser, nodeType);
    }

    private OrderByItem createOrderByItem(TeiidParser teiidParser, int nodeType) {
        return new OrderByItem(teiidParser, nodeType);
    }

    private ExpressionSymbol createExpressionSymbol(TeiidParser teiidParser, int nodeType) {
        return new ExpressionSymbol(teiidParser, nodeType);
    }

    private Limit createLimit(TeiidParser teiidParser, int nodeType) {
        return new Limit(teiidParser, nodeType);
    }

    private Option createOption(TeiidParser teiidParser, int nodeType) {
        return new Option(teiidParser, nodeType);
    }

    private Reference createReference(TeiidParser teiidParser, int nodeType) {
        return new Reference(teiidParser, nodeType);
    }

    private CaseExpression createCaseExpression(TeiidParser teiidParser, int nodeType) {
        return new CaseExpression(teiidParser, nodeType);
    }

    private SearchedCaseExpression createSearchedCaseExpression(TeiidParser teiidParser, int nodeType) {
        return new SearchedCaseExpression(teiidParser, nodeType);
    }

    private Function createFunction(TeiidParser teiidParser, int nodeType) {
        return new Function(teiidParser, nodeType);
    }

    private XMLParse createXMLParse(TeiidParser teiidParser, int nodeType) {
        return new XMLParse(teiidParser, nodeType);
    }

    private QueryString createQueryString(TeiidParser teiidParser, int nodeType) {
        return new QueryString(teiidParser, nodeType);
    }

    private XMLElement createXMLElement(TeiidParser teiidParser, int nodeType) {
        return new XMLElement(teiidParser, nodeType);
    }

    private XMLAttributes createXMLAttributes(TeiidParser teiidParser, int nodeType) {
        return new XMLAttributes(teiidParser, nodeType);
    }

    private XMLForest createXMLForest(TeiidParser teiidParser, int nodeType) {
        return new XMLForest(teiidParser, nodeType);
    }

    private XMLNamespaces createXMLNamespaces(TeiidParser teiidParser, int nodeType) {
        return new XMLNamespaces(teiidParser, nodeType);
    }

    private AssignmentStatement createAssignmentStatement(TeiidParser teiidParser, int nodeType) {
        return new AssignmentStatement(teiidParser, nodeType);
    }

    private ScalarSubquery createScalarSubquery(TeiidParser teiidParser, int nodeType) {
        return new ScalarSubquery(teiidParser, nodeType);
    }

    private GroupSymbol createGroupSymbol(TeiidParser teiidParser, int nodeType) {
        return new GroupSymbol(teiidParser, nodeType);
    }

    private Constant createConstant(TeiidParser teiidParser, int nodeType) {
        return new Constant(teiidParser, nodeType);
    }

    private ElementSymbol createElementSymbol(TeiidParser teiidParser, int nodeType) {
        return new ElementSymbol(teiidParser, nodeType);
    }

    private Block createBlock(TeiidParser teiidParser, int nodeType) {
        return new Block(teiidParser, nodeType);
    }

    private ExpressionCriteria createExpressionCriteria(TeiidParser teiidParser, int nodeType) {
        return new ExpressionCriteria(teiidParser, nodeType);
    }

    private AliasSymbol createAliasSymbol(TeiidParser teiidParser, int nodeType) {
        return new AliasSymbol(teiidParser, nodeType);
    }

    private WindowSpecification createWindowSpecification(TeiidParser teiidParser, int nodeType) {
        return new WindowSpecification(teiidParser, nodeType);
    }

    private TextLine createTextLine(TeiidParser teiidParser, int nodeType) {
        return new TextLine(teiidParser, nodeType);
    }

    private AlterTrigger createAlterTrigger(TeiidParser teiidParser, int nodeType) {
        return new AlterTrigger(teiidParser, nodeType);
    }

    private AlterView createAlterView(TeiidParser teiidParser, int nodeType) {
        return new AlterView(teiidParser, nodeType);
    }

    private RaiseStatement createRaiseStatement(TeiidParser teiidParser, int nodeType) {
        return new RaiseStatement(teiidParser, nodeType);
    }

    private ExceptionExpression createExceptionExpression(TeiidParser teiidParser, int nodeType) {
        return new ExceptionExpression(teiidParser, nodeType);
    }

    private ReturnStatement createReturnStatement(TeiidParser teiidParser, int nodeType) {
        return new ReturnStatement(teiidParser, nodeType);
    }

    private CreateProcedureCommand createCreateProcedureCommand(TeiidParser teiidParser, int nodeType) {
        return new CreateProcedureCommand(teiidParser, nodeType);
    }

    private ObjectTable createObjectTable(TeiidParser teiidParser, int nodeType) {
        return new ObjectTable(teiidParser, nodeType);
    }

    private ObjectColumn createObjectColumn(TeiidParser teiidParser, int nodeType) {
        return new ObjectColumn(teiidParser, nodeType);
    }

    private JSONObject createJSONObject(TeiidParser teiidParser, int nodeType) {
        return new JSONObject(teiidParser, nodeType);
    }

    private Array createArray(TeiidParser teiidParser, int nodeType) {
        return new Array(teiidParser, nodeType);
    }

    private <T extends LanguageObject> T create(Teiid7Parser teiidParser, int nodeType) {
        switch (nodeType) {
            case 1: {
                return (T)this.createTriggerAction(teiidParser, nodeType);
            }
            case 2: {
                return (T)this.createDrop(teiidParser, nodeType);
            }
            case 3: {
                return (T)this.createCreate(teiidParser, nodeType);
            }
            case 4: {
                return (T)this.createRaiseErrorStatement(teiidParser, nodeType);
            }
            case 5: {
                return (T)this.createBranchingStatement(teiidParser, nodeType);
            }
            case 6: {
                return (T)this.createWhileStatement(teiidParser, nodeType);
            }
            case 7: {
                return (T)this.createLoopStatement(teiidParser, nodeType);
            }
            case 8: {
                return (T)this.createIfStatement(teiidParser, nodeType);
            }
            case 9: {
                return (T)this.createCriteriaSelector(teiidParser, nodeType);
            }
            case 10: {
                return (T)this.createHasCriteria(teiidParser, nodeType);
            }
            case 11: {
                return (T)this.createDeclareStatement(teiidParser, nodeType);
            }
            case 12: {
                return (T)this.createCommandStatement(teiidParser, nodeType);
            }
            case 13: {
                return (T)this.createTranslateCriteria(teiidParser, nodeType);
            }
            case 14: {
                return (T)this.createCreateUpdateProcedureCommand(teiidParser, nodeType);
            }
            case 15: {
                return (T)this.createDynamicCommand(teiidParser, nodeType);
            }
            case 16: {
                return (T)this.createSetClauseList(teiidParser, nodeType);
            }
            case 17: {
                return (T)this.createSetClause(teiidParser, nodeType);
            }
            case 18: {
                return (T)this.createProjectedColumn(teiidParser, nodeType);
            }
            case 19: {
                return (T)this.createStoredProcedure(teiidParser, nodeType);
            }
            case 20: {
                return (T)this.createInsert(teiidParser, nodeType);
            }
            case 21: {
                return (T)this.createUpdate(teiidParser, nodeType);
            }
            case 22: {
                return (T)this.createDelete(teiidParser, nodeType);
            }
            case 23: {
                return (T)this.createWithQueryCommand(teiidParser, nodeType);
            }
            case 24: {
                return (T)this.createSetQuery(teiidParser, nodeType);
            }
            case 25: {
                return (T)this.createQuery(teiidParser, nodeType);
            }
            case 26: {
                return (T)this.createInto(teiidParser, nodeType);
            }
            case 27: {
                return (T)this.createSelect(teiidParser, nodeType);
            }
            case 28: {
                return (T)this.createDerivedColumn(teiidParser, nodeType);
            }
            case 29: {
                return (T)this.createMultipleElementSymbol(teiidParser, nodeType);
            }
            case 30: {
                return (T)this.createFrom(teiidParser, nodeType);
            }
            case 31: {
                return (T)this.createJoinPredicate(teiidParser, nodeType);
            }
            case 32: {
                return (T)this.createJoinType(teiidParser, nodeType);
            }
            case 33: {
                return (T)this.createXMLSerialize(teiidParser, nodeType);
            }
            case 34: {
                return (T)this.createArrayTable(teiidParser, nodeType);
            }
            case 35: {
                return (T)this.createTextTable(teiidParser, nodeType);
            }
            case 36: {
                return (T)this.createTextColumn(teiidParser, nodeType);
            }
            case 37: {
                return (T)this.createXMLQuery(teiidParser, nodeType);
            }
            case 38: {
                return (T)this.createXMLTable(teiidParser, nodeType);
            }
            case 39: {
                return (T)this.createXMLColumn(teiidParser, nodeType);
            }
            case 40: {
                return (T)this.createSubqueryFromClause(teiidParser, nodeType);
            }
            case 41: {
                return (T)this.createUnaryFromClause(teiidParser, nodeType);
            }
            case 42: {
                return (T)this.createCriteria(teiidParser, nodeType);
            }
            case 43: {
                return (T)this.createCompoundCriteria(teiidParser, nodeType);
            }
            case 44: {
                return (T)this.createNotCriteria(teiidParser, nodeType);
            }
            case 45: {
                return (T)this.createCompareCriteria(teiidParser, nodeType);
            }
            case 46: {
                return (T)this.createSubqueryCompareCriteria(teiidParser, nodeType);
            }
            case 47: {
                return (T)this.createMatchCriteria(teiidParser, nodeType);
            }
            case 48: {
                return (T)this.createBetweenCriteria(teiidParser, nodeType);
            }
            case 49: {
                return (T)this.createIsNullCriteria(teiidParser, nodeType);
            }
            case 50: {
                return (T)this.createSubquerySetCriteria(teiidParser, nodeType);
            }
            case 51: {
                return (T)this.createSetCriteria(teiidParser, nodeType);
            }
            case 52: {
                return (T)this.createExistsCriteria(teiidParser, nodeType);
            }
            case 53: {
                return (T)this.createGroupBy(teiidParser, nodeType);
            }
            case 54: {
                return (T)this.createOrderBy(teiidParser, nodeType);
            }
            case 55: {
                return (T)this.createOrderByItem(teiidParser, nodeType);
            }
            case 56: {
                return (T)this.createExpressionSymbol(teiidParser, nodeType);
            }
            case 57: {
                return (T)this.createLimit(teiidParser, nodeType);
            }
            case 58: {
                return (T)this.createOption(teiidParser, nodeType);
            }
            case 59: {
                return (T)this.createReference(teiidParser, nodeType);
            }
            case 60: {
                return (T)this.createCaseExpression(teiidParser, nodeType);
            }
            case 61: {
                return (T)this.createSearchedCaseExpression(teiidParser, nodeType);
            }
            case 62: {
                return (T)this.createFunction(teiidParser, nodeType);
            }
            case 63: {
                return (T)this.createXMLParse(teiidParser, nodeType);
            }
            case 64: {
                return (T)this.createQueryString(teiidParser, nodeType);
            }
            case 65: {
                return (T)this.createXMLElement(teiidParser, nodeType);
            }
            case 66: {
                return (T)this.createXMLAttributes(teiidParser, nodeType);
            }
            case 67: {
                return (T)this.createXMLForest(teiidParser, nodeType);
            }
            case 68: {
                return (T)this.createXMLNamespaces(teiidParser, nodeType);
            }
            case 69: {
                return (T)this.createAssignmentStatement(teiidParser, nodeType);
            }
            case 70: {
                return (T)this.createScalarSubquery(teiidParser, nodeType);
            }
            case 71: {
                return (T)this.createGroupSymbol(teiidParser, nodeType);
            }
            case 72: {
                return (T)this.createConstant(teiidParser, nodeType);
            }
            case 73: {
                return (T)this.createElementSymbol(teiidParser, nodeType);
            }
            case 74: {
                return (T)this.createBlock(teiidParser, nodeType);
            }
            case 75: {
                return (T)this.createExpressionCriteria(teiidParser, nodeType);
            }
            case 76: {
                return (T)this.createAliasSymbol(teiidParser, nodeType);
            }
            case 77: {
                return (T)this.createAggregateSymbol(teiidParser, nodeType);
            }
            case 78: {
                return (T)this.createWindowFunction(teiidParser, nodeType);
            }
            case 79: {
                return (T)this.createWindowSpecification(teiidParser, nodeType);
            }
            case 80: {
                return (T)this.createTextLine(teiidParser, nodeType);
            }
            case 81: {
                return (T)this.createAlterTrigger(teiidParser, nodeType);
            }
            case 82: {
                return (T)this.createAlterProcedure(teiidParser, nodeType);
            }
            case 83: {
                return (T)this.createAlterView(teiidParser, nodeType);
            }
        }
        throw new IllegalArgumentException(Messages.getString(Messages.TeiidParser.invalidNodeType, nodeType, teiidParser.getVersion()));
    }

    private <T extends LanguageObject> T create(Teiid8Parser teiidParser, int nodeType) {
        switch (nodeType) {
            case 1: {
                return (T)this.createTriggerAction(teiidParser, nodeType);
            }
            case 2: {
                return (T)this.createDrop(teiidParser, nodeType);
            }
            case 3: {
                return (T)this.createCreate(teiidParser, nodeType);
            }
            case 4: {
                return (T)this.createRaiseStatement(teiidParser, nodeType);
            }
            case 5: {
                return (T)this.createExceptionExpression(teiidParser, nodeType);
            }
            case 6: {
                return (T)this.createBranchingStatement(teiidParser, nodeType);
            }
            case 7: {
                return (T)this.createReturnStatement(teiidParser, nodeType);
            }
            case 8: {
                return (T)this.createWhileStatement(teiidParser, nodeType);
            }
            case 9: {
                return (T)this.createLoopStatement(teiidParser, nodeType);
            }
            case 10: {
                return (T)this.createIfStatement(teiidParser, nodeType);
            }
            case 11: {
                return (T)this.createDeclareStatement(teiidParser, nodeType);
            }
            case 12: {
                return (T)this.createCommandStatement(teiidParser, nodeType);
            }
            case 13: {
                return (T)this.createCreateProcedureCommand(teiidParser, nodeType);
            }
            case 14: {
                return (T)this.createDynamicCommand(teiidParser, nodeType);
            }
            case 15: {
                return (T)this.createSetClauseList(teiidParser, nodeType);
            }
            case 16: {
                return (T)this.createSetClause(teiidParser, nodeType);
            }
            case 17: {
                return (T)this.createProjectedColumn(teiidParser, nodeType);
            }
            case 18: {
                return (T)this.createStoredProcedure(teiidParser, nodeType);
            }
            case 19: {
                return (T)this.createInsert(teiidParser, nodeType);
            }
            case 20: {
                return (T)this.createUpdate(teiidParser, nodeType);
            }
            case 21: {
                return (T)this.createDelete(teiidParser, nodeType);
            }
            case 22: {
                return (T)this.createWithQueryCommand(teiidParser, nodeType);
            }
            case 23: {
                return (T)this.createSetQuery(teiidParser, nodeType);
            }
            case 24: {
                return (T)this.createQuery(teiidParser, nodeType);
            }
            case 25: {
                return (T)this.createInto(teiidParser, nodeType);
            }
            case 26: {
                return (T)this.createSelect(teiidParser, nodeType);
            }
            case 27: {
                return (T)this.createExpressionSymbol(teiidParser, nodeType);
            }
            case 28: {
                return (T)this.createDerivedColumn(teiidParser, nodeType);
            }
            case 29: {
                return (T)this.createMultipleElementSymbol(teiidParser, nodeType);
            }
            case 30: {
                return (T)this.createFrom(teiidParser, nodeType);
            }
            case 31: {
                return (T)this.createJoinPredicate(teiidParser, nodeType);
            }
            case 32: {
                return (T)this.createJoinType(teiidParser, nodeType);
            }
            case 33: {
                return (T)this.createXMLSerialize(teiidParser, nodeType);
            }
            case 34: {
                return (T)this.createArrayTable(teiidParser, nodeType);
            }
            case 35: {
                return (T)this.createTextTable(teiidParser, nodeType);
            }
            case 36: {
                return (T)this.createTextColumn(teiidParser, nodeType);
            }
            case 37: {
                return (T)this.createXMLQuery(teiidParser, nodeType);
            }
            case 38: {
                return (T)this.createObjectTable(teiidParser, nodeType);
            }
            case 39: {
                return (T)this.createObjectColumn(teiidParser, nodeType);
            }
            case 40: {
                return (T)this.createXMLTable(teiidParser, nodeType);
            }
            case 41: {
                return (T)this.createXMLColumn(teiidParser, nodeType);
            }
            case 42: {
                return (T)this.createSubqueryFromClause(teiidParser, nodeType);
            }
            case 43: {
                return (T)this.createUnaryFromClause(teiidParser, nodeType);
            }
            case 44: {
                return (T)this.createCriteria(teiidParser, nodeType);
            }
            case 45: {
                return (T)this.createCompoundCriteria(teiidParser, nodeType);
            }
            case 46: {
                return (T)this.createNotCriteria(teiidParser, nodeType);
            }
            case 47: {
                return (T)this.createCompareCriteria(teiidParser, nodeType);
            }
            case 48: {
                return (T)this.createSubqueryCompareCriteria(teiidParser, nodeType);
            }
            case 49: {
                return (T)this.createMatchCriteria(teiidParser, nodeType);
            }
            case 50: {
                return (T)this.createBetweenCriteria(teiidParser, nodeType);
            }
            case 51: {
                return (T)this.createIsNullCriteria(teiidParser, nodeType);
            }
            case 52: {
                return (T)this.createSubquerySetCriteria(teiidParser, nodeType);
            }
            case 53: {
                return (T)this.createSetCriteria(teiidParser, nodeType);
            }
            case 54: {
                return (T)this.createExistsCriteria(teiidParser, nodeType);
            }
            case 55: {
                return (T)this.createGroupBy(teiidParser, nodeType);
            }
            case 56: {
                return (T)this.createOrderBy(teiidParser, nodeType);
            }
            case 57: {
                return (T)this.createOrderByItem(teiidParser, nodeType);
            }
            case 58: {
                return (T)this.createLimit(teiidParser, nodeType);
            }
            case 59: {
                return (T)this.createOption(teiidParser, nodeType);
            }
            case 60: {
                return (T)this.createReference(teiidParser, nodeType);
            }
            case 61: {
                return (T)this.createCaseExpression(teiidParser, nodeType);
            }
            case 62: {
                return (T)this.createSearchedCaseExpression(teiidParser, nodeType);
            }
            case 63: {
                return (T)this.createFunction(teiidParser, nodeType);
            }
            case 64: {
                return (T)this.createXMLParse(teiidParser, nodeType);
            }
            case 65: {
                return (T)this.createQueryString(teiidParser, nodeType);
            }
            case 66: {
                return (T)this.createXMLElement(teiidParser, nodeType);
            }
            case 67: {
                return (T)this.createXMLAttributes(teiidParser, nodeType);
            }
            case 68: {
                return (T)this.createJSONObject(teiidParser, nodeType);
            }
            case 69: {
                return (T)this.createXMLForest(teiidParser, nodeType);
            }
            case 70: {
                return (T)this.createXMLNamespaces(teiidParser, nodeType);
            }
            case 71: {
                return (T)this.createAssignmentStatement(teiidParser, nodeType);
            }
            case 72: {
                return (T)this.createScalarSubquery(teiidParser, nodeType);
            }
            case 73: {
                return (T)this.createGroupSymbol(teiidParser, nodeType);
            }
            case 74: {
                return (T)this.createConstant(teiidParser, nodeType);
            }
            case 75: {
                return (T)this.createElementSymbol(teiidParser, nodeType);
            }
            case 76: {
                return (T)this.createBlock(teiidParser, nodeType);
            }
            case 77: {
                return (T)this.createExpressionCriteria(teiidParser, nodeType);
            }
            case 78: {
                return (T)this.createAliasSymbol(teiidParser, nodeType);
            }
            case 79: {
                return (T)this.createAggregateSymbol(teiidParser, nodeType);
            }
            case 80: {
                return (T)this.createWindowFunction(teiidParser, nodeType);
            }
            case 81: {
                return (T)this.createWindowSpecification(teiidParser, nodeType);
            }
            case 82: {
                return (T)this.createTextLine(teiidParser, nodeType);
            }
            case 83: {
                return (T)this.createAlterTrigger(teiidParser, nodeType);
            }
            case 84: {
                return (T)this.createAlterProcedure(teiidParser, nodeType);
            }
            case 85: {
                return (T)this.createAlterView(teiidParser, nodeType);
            }
            case 86: {
                return (T)this.createArray(teiidParser, nodeType);
            }
        }
        throw new IllegalArgumentException(Messages.getString(Messages.TeiidParser.invalidNodeType, nodeType, teiidParser.getVersion()));
    }

    public static enum ASTNodes {
        TRIGGER_ACTION("TriggerAction"),
        DROP("Drop"),
        CREATE("Create"),
        RAISE_ERROR_STATEMENT("RaiseErrorStatement"),
        BRANCHING_STATEMENT("BranchingStatement"),
        WHILE_STATEMENT("WhileStatement"),
        LOOP_STATEMENT("LoopStatement"),
        IF_STATEMENT("IfStatement"),
        CRITERIA_SELECTOR("CriteriaSelector"),
        HAS_CRITERIA("HasCriteria"),
        DECLARE_STATEMENT("DeclareStatement"),
        COMMAND_STATEMENT("CommandStatement"),
        TRANSLATE_CRITERIA("TranslateCriteria"),
        CREATE_UPDATE_PROCEDURE_COMMAND("CreateUpdateProcedureCommand"),
        DYNAMIC_COMMAND("DynamicCommand"),
        SET_CLAUSE_LIST("SetClauseList"),
        SET_CLAUSE("SetClause"),
        PROJECTED_COLUMN("ProjectedColumn"),
        STORED_PROCEDURE("StoredProcedure"),
        INSERT("Insert"),
        UPDATE("Update"),
        DELETE("Delete"),
        WITH_QUERY_COMMAND("WithQueryCommand"),
        SET_QUERY("SetQuery"),
        QUERY("Query"),
        INTO("Into"),
        SELECT("Select"),
        DERIVED_COLUMN("DerivedColumn"),
        MULTIPLE_ELEMENT_SYMBOL("MultipleElementSymbol"),
        FROM("From"),
        JOIN_PREDICATE("JoinPredicate"),
        JOIN_TYPE("JoinType"),
        XML_SERIALIZE("XMLSerialize"),
        ARRAY_TABLE("ArrayTable"),
        TEXT_TABLE("TextTable"),
        TEXT_COLUMN("TextColumn"),
        XML_QUERY("XMLQuery"),
        XML_TABLE("XMLTable"),
        XML_COLUMN("XMLColumn"),
        SUBQUERY_FROM_CLAUSE("SubqueryFromClause"),
        UNARY_FROM_CLAUSE("UnaryFromClause"),
        CRITERIA("Criteria"),
        COMPOUND_CRITERIA("CompoundCriteria"),
        NOT_CRITERIA("NotCriteria"),
        COMPARE_CRITERIA("CompareCriteria"),
        SUBQUERY_COMPARE_CRITERIA("SubqueryCompareCriteria"),
        MATCH_CRITERIA("MatchCriteria"),
        BETWEEN_CRITERIA("BetweenCriteria"),
        IS_NULL_CRITERIA("IsNullCriteria"),
        SUBQUERY_SET_CRITERIA("SubquerySetCriteria"),
        SET_CRITERIA("SetCriteria"),
        EXISTS_CRITERIA("ExistsCriteria"),
        GROUP_BY("GroupBy"),
        ORDER_BY("OrderBy"),
        ORDER_BY_ITEM("OrderByItem"),
        EXPRESSION_SYMBOL("ExpressionSymbol"),
        LIMIT("Limit"),
        OPTION("Option"),
        REFERENCE("Reference"),
        CASE_EXPRESSION("CaseExpression"),
        SEARCHED_CASE_EXPRESSION("SearchedCaseExpression"),
        FUNCTION("Function"),
        XML_PARSE("XMLParse"),
        QUERY_STRING("QueryString"),
        XML_ELEMENT("XMLElement"),
        XML_ATTRIBUTES("XMLAttributes"),
        XML_FOREST("XMLForest"),
        XML_NAMESPACES("XMLNamespaces"),
        ASSIGNMENT_STATEMENT("AssignmentStatement"),
        SCALAR_SUBQUERY("ScalarSubquery"),
        GROUP_SYMBOL("GroupSymbol"),
        CONSTANT("Constant"),
        ELEMENT_SYMBOL("ElementSymbol"),
        BLOCK("Block"),
        EXPRESSION_CRITERIA("ExpressionCriteria"),
        ALIAS_SYMBOL("AliasSymbol"),
        AGGREGATE_SYMBOL("AggregateSymbol"),
        WINDOW_FUNCTION("WindowFunction"),
        WINDOW_SPECIFICATION("WindowSpecification"),
        TEXT_LINE("TextLine"),
        ALTER_TRIGGER("AlterTrigger"),
        ALTER_PROCEDURE("AlterProcedure"),
        ALTER_VIEW("AlterView"),
        RAISE_STATEMENT("RaiseStatement"),
        EXCEPTION_EXPRESSION("ExceptionExpression"),
        RETURN_STATEMENT("ReturnStatement"),
        CREATE_PROCEDURE_COMMAND("CreateProcedureCommand"),
        OBJECT_TABLE("ObjectTable"),
        OBJECT_COLUMN("ObjectColumn"),
        JSON_OBJECT("JSONObject"),
        ARRAY("Array");

        private String name;

        private ASTNodes(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

