/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.teiid.CommandContext;
import org.teiid.UserDefinedAggregate;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class FunctionTree {
    private final ITeiidServerVersion teiidVersion;
    private static final Integer DESCRIPTOR_KEY = -1;
    private Map<String, Set<FunctionMethod>> categories = new TreeMap<String, Set<FunctionMethod>>();
    private Map<String, List<FunctionMethod>> functionsByName = new TreeMap<String, List<FunctionMethod>>(String.CASE_INSENSITIVE_ORDER);
    private Set<FunctionMethod> allFunctions = new HashSet<FunctionMethod>();
    private Map<String, Map<Object, Object>> treeRoot = new TreeMap<String, Map<Object, Object>>(String.CASE_INSENSITIVE_ORDER);
    private boolean validateClass;
    private DataTypeManagerService dataTypeManager;

    public FunctionTree(ITeiidServerVersion teiidVersion, String name, FunctionMetadataSource source) {
        this(teiidVersion, name, source, false);
    }

    public FunctionTree(ITeiidServerVersion teiidVersion, String name, FunctionMetadataSource source, boolean validateClass) {
        this.teiidVersion = teiidVersion;
        this.validateClass = validateClass;
        boolean system = "SYS".equalsIgnoreCase(name) || "SYSADMIN".equalsIgnoreCase(name);
        Collection<FunctionMethod> functions = source.getFunctionMethods();
        for (FunctionMethod method : functions) {
            if (!this.containsIndistinguishableFunction(method)) {
                this.addFunction(name, source, method, system);
                continue;
            }
            "SYS".equalsIgnoreCase(name);
        }
    }

    public DataTypeManagerService getDataTypeManager() {
        if (this.dataTypeManager == null) {
            this.dataTypeManager = DataTypeManagerService.getInstance(this.teiidVersion);
        }
        return this.dataTypeManager;
    }

    private boolean containsIndistinguishableFunction(FunctionMethod method) {
        return this.allFunctions.contains(method);
    }

    Collection<String> getCategories() {
        return this.categories.keySet();
    }

    Set<FunctionMethod> getFunctionsInCategory(String name) {
        Set<FunctionMethod> names = this.categories.get(name);
        if (names == null) {
            return Collections.emptySet();
        }
        return names;
    }

    List<FunctionMethod> findFunctionMethods(String name, int args) {
        ArrayList<FunctionMethod> allMatches = new ArrayList<FunctionMethod>();
        List<FunctionMethod> methods = this.functionsByName.get(name);
        if (methods == null || methods.size() == 0) {
            return allMatches;
        }
        for (FunctionMethod functionMethod : methods) {
            if (functionMethod.getInputParameterCount() != args && (!functionMethod.isVarArgs() || args < functionMethod.getInputParameterCount() - 1)) continue;
            allMatches.add(functionMethod);
        }
        return allMatches;
    }

    public FunctionDescriptor addFunction(String schema, FunctionMetadataSource source, FunctionMethod method, boolean system) {
        Set<FunctionMethod> functions;
        String categoryKey = method.getCategory();
        if (categoryKey == null) {
            method.setCategory("Miscellaneous");
            categoryKey = "Miscellaneous";
        }
        if ((functions = this.categories.get(categoryKey)) == null) {
            functions = new HashSet<FunctionMethod>();
            this.categories.put(categoryKey, functions);
        }
        String methodName = String.valueOf(schema) + '.' + method.getName();
        List<FunctionParameter> inputParams = method.getInputParameters();
        Class[] types = null;
        if (inputParams != null) {
            types = new Class[inputParams.size()];
            int i = 0;
            while (i < inputParams.size()) {
                Class<?> clazz;
                String typeName = inputParams.get(i).getType();
                types[i] = clazz = this.getDataTypeManager().getDataTypeClass(typeName);
                ++i;
            }
        } else {
            types = new Class[]{};
        }
        FunctionDescriptor descriptor = this.createFunctionDescriptor(source, method, types, system);
        descriptor.setSchema(schema);
        functions.add(method);
        while (true) {
            List<FunctionMethod> knownMethods;
            if ((knownMethods = this.functionsByName.get(methodName)) == null) {
                knownMethods = new ArrayList<FunctionMethod>();
                this.functionsByName.put(methodName, knownMethods);
            }
            knownMethods.add(method);
            Map<Object, Object> node = this.treeRoot.get(methodName);
            if (node == null) {
                node = new HashMap<Object, Object>(2);
                this.treeRoot.put(methodName, node);
            }
            int pathIndex = 0;
            while (pathIndex < types.length) {
                Class pathPart = types[pathIndex];
                HashMap<Object, Object> children = (HashMap<Object, Object>)node.get(pathPart);
                if (children == null) {
                    children = new HashMap<Object, Object>(2);
                    node.put(pathPart, children);
                }
                if (method.isVarArgs() && pathIndex == types.length - 1) {
                    node.put(DESCRIPTOR_KEY, descriptor);
                    HashMap<Integer, FunctionDescriptor> alternate = new HashMap<Integer, FunctionDescriptor>(2);
                    alternate.put(DESCRIPTOR_KEY, descriptor);
                    DataTypeManagerService.DefaultDataTypes dataType = this.getDataTypeManager().getDataType(pathPart);
                    node.put(dataType.getTypeArrayClass(), alternate);
                }
                node = children;
                ++pathIndex;
            }
            if (method.isVarArgs()) {
                node.put(types[types.length - 1], node);
            }
            node.put(DESCRIPTOR_KEY, descriptor);
            int index = methodName.indexOf(46);
            if (index == -1) break;
            methodName = methodName.substring(index + 1);
        }
        this.allFunctions.add(method);
        return descriptor;
    }

    private FunctionDescriptor createFunctionDescriptor(FunctionMetadataSource source, FunctionMethod method, Class<?>[] types, boolean system) {
        try {
            FunctionParameter outputParam = method.getOutputParameter();
            Class<?> outputType = null;
            if (outputParam != null) {
                outputType = this.getDataTypeManager().getDataTypeClass(outputParam.getType());
            }
            ArrayList inputTypes = new ArrayList(Arrays.asList(types));
            boolean hasWrappedArg = false;
            if (!system) {
                int i = 0;
                while (i < types.length) {
                    if (types[i] == DataTypeManagerService.DefaultDataTypes.VARBINARY.getTypeClass()) {
                        hasWrappedArg = true;
                        inputTypes.set(i, byte[].class);
                    }
                    ++i;
                }
            }
            if (method.isVarArgs()) {
                Class klazz = (Class)inputTypes.get(inputTypes.size() - 1);
                DataTypeManagerService.DefaultDataTypes dataType = this.getDataTypeManager().getDataType(klazz);
                inputTypes.set(inputTypes.size() - 1, dataType.getTypeArrayClass());
            }
            Method invocationMethod = method.getMethod();
            boolean requiresContext = false;
            if (this.validateClass && (method.getPushdown() == FunctionMethod.PushDown.CAN_PUSHDOWN || method.getPushdown() == FunctionMethod.PushDown.CANNOT_PUSHDOWN)) {
                if (invocationMethod == null) {
                    if (method.getInvocationClass() == null || method.getInvocationMethod() == null) {
                        throw new Exception(Messages.gs(Messages.TEIID.TEIID31123, method.getName()));
                    }
                    try {
                        Class methodClass = source.getInvocationClass(method.getInvocationClass());
                        ReflectionHelper helper = new ReflectionHelper(methodClass);
                        try {
                            invocationMethod = helper.findBestMethodWithSignature(method.getInvocationMethod(), inputTypes);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            inputTypes.add(0, org.teiid.query.util.CommandContext.class);
                            invocationMethod = helper.findBestMethodWithSignature(method.getInvocationMethod(), inputTypes);
                            requiresContext = true;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID30387, method.getName(), method.getInvocationClass()));
                    }
                    catch (NoSuchMethodException e) {
                        throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID30388, method, method.getInvocationClass(), method.getInvocationMethod()));
                    }
                    catch (Exception e) {
                        throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID30389, method, method.getInvocationClass(), method.getInvocationMethod()));
                    }
                } else {
                    boolean bl = requiresContext = invocationMethod.getParameterTypes().length > 0 && CommandContext.class.isAssignableFrom(invocationMethod.getParameterTypes()[0]);
                }
                if (invocationMethod != null) {
                    Class<?> methodReturn = invocationMethod.getReturnType();
                    if (method.getAggregateAttributes() == null && methodReturn.equals(Void.TYPE)) {
                        throw new Exception(Messages.gs(Messages.TEIID.TEIID30390, method.getName(), invocationMethod));
                    }
                    int modifiers = invocationMethod.getModifiers();
                    if (!Modifier.isPublic(modifiers)) {
                        throw new Exception(Messages.gs(Messages.TEIID.TEIID30391, method.getName(), invocationMethod));
                    }
                    if (!Modifier.isStatic(modifiers)) {
                        if (method.getAggregateAttributes() == null) {
                            throw new Exception(Messages.gs(Messages.TEIID.TEIID30392, method.getName(), invocationMethod));
                        }
                    } else if (method.getAggregateAttributes() != null) {
                        throw new Exception(Messages.gs(Messages.TEIID.TEIID30600, method.getName(), invocationMethod));
                    }
                    if (method.getAggregateAttributes() != null && !UserDefinedAggregate.class.isAssignableFrom(invocationMethod.getDeclaringClass())) {
                        throw new Exception(Messages.gs(Messages.TEIID.TEIID30601, method.getName(), method.getInvocationClass(), UserDefinedAggregate.class.getName()));
                    }
                    method.setMethod(invocationMethod);
                }
            }
            FunctionDescriptor result = new FunctionDescriptor(this.teiidVersion, method, types, outputType, invocationMethod, requiresContext);
            if (method.getAggregateAttributes() != null && (method.getPushdown() == FunctionMethod.PushDown.CAN_PUSHDOWN || method.getPushdown() == FunctionMethod.PushDown.CANNOT_PUSHDOWN)) {
                result.newInstance();
            }
            result.setHasWrappedArgs(hasWrappedArg);
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    FunctionDescriptor getFunction(String name, Class<?>[] argTypes) {
        Map node = this.treeRoot.get(name);
        if (node == null) {
            return null;
        }
        int i = 0;
        while (i < argTypes.length) {
            Map nextNode = (Map)node.get(argTypes[i]);
            if (nextNode == null) {
                if (argTypes[i].isArray()) {
                    nextNode = (Map)node.get(DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeClass());
                }
                if (nextNode == null) {
                    return null;
                }
            }
            node = nextNode;
            ++i;
        }
        if (node.containsKey(DESCRIPTOR_KEY)) {
            return (FunctionDescriptor)node.get(DESCRIPTOR_KEY);
        }
        return null;
    }
}

