/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.Xid;
import org.teiid.client.DQP;
import org.teiid.client.plan.Annotation;
import org.teiid.client.plan.PlanNode;
import org.teiid.client.util.ResultsFuture;
import org.teiid.client.xa.XATransactionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.core.types.ArrayImpl;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.jdbc.CallableStatementImpl;
import org.teiid.jdbc.DatabaseMetaDataImpl;
import org.teiid.jdbc.JDBCURL;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.StatementImpl;
import org.teiid.jdbc.TeiidConnection;
import org.teiid.jdbc.WrapperImpl;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.ServerConnection;
import org.teiid.net.socket.SocketServerConnection;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidRuntimePlugin;

public class ConnectionImpl
extends WrapperImpl
implements TeiidConnection {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    public static final int DEFAULT_ISOLATION = 2;
    protected static final String DEFAULT_PARTIAL_RESULTS_MODE = "FALSE";
    protected static final String DEFAULT_RESULT_SET_CACHE_MODE = "FALSE";
    private static final String SERVER_NAME = "Teiid Server";
    private static final String EMBEDDED_NAME = "Teiid Embedded";
    private long requestIDGenerator;
    private String url;
    protected Properties propInfo;
    private boolean closed = false;
    private boolean autoCommitFlag = true;
    private boolean inLocalTxn;
    private Collection<StatementImpl> statements = Collections.newSetFromMap(new ConcurrentHashMap());
    private DatabaseMetaDataImpl dbmm;
    private XidImpl transactionXid;
    private boolean readOnly = false;
    private DQP dqp;
    protected ServerConnection serverConn;
    private int transactionIsolation = 2;
    private PlanNode currentPlanDescription;
    private String debugLog;
    private Collection<Annotation> annotations;
    private Properties connectionProps;
    private Properties payload;

    public ConnectionImpl(ServerConnection serverConn, Properties info, String url) {
        this.connectionProps = info;
        this.serverConn = serverConn;
        this.url = url;
        this.dqp = serverConn.getService(DQP.class);
        logger.fine(Messages.getString(Messages.JDBC.MMConnection_Session_success, new Object[0]));
        this.logConnectionProperties(url, info);
        this.setExecutionProperties(info);
    }

    boolean isInLocalTxn() {
        return this.inLocalTxn;
    }

    private void setExecutionProperties(Properties info) {
        this.propInfo = new Properties();
        String defaultFetchSize = info.getProperty("fetchSize");
        if (defaultFetchSize != null) {
            this.propInfo.put("fetchSize", defaultFetchSize);
        } else {
            this.propInfo.put("fetchSize", String.valueOf(2048));
        }
        String partialResultsMode = info.getProperty("partialResultsMode");
        if (partialResultsMode != null) {
            this.propInfo.put("partialResultsMode", partialResultsMode);
        } else {
            this.propInfo.put("partialResultsMode", "FALSE");
        }
        String resultSetCacheMode = info.getProperty("resultSetCacheMode");
        if (resultSetCacheMode != null) {
            this.propInfo.put("resultSetCacheMode", resultSetCacheMode);
        } else {
            this.propInfo.put("resultSetCacheMode", "FALSE");
        }
        String ansiQuotes = info.getProperty("ansiQuotedIdentifiers");
        if (ansiQuotes != null) {
            this.propInfo.put("ansiQuotedIdentifiers", ansiQuotes);
        } else {
            this.propInfo.put("ansiQuotedIdentifiers", Boolean.TRUE.toString());
        }
        for (String key : info.stringPropertyNames()) {
            String actualKey = JDBCURL.EXECUTION_PROPERTIES.get(key);
            if (actualKey == null) continue;
            this.propInfo.setProperty(actualKey, info.getProperty(key));
        }
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Collection<Annotation> annotations) {
        this.annotations = annotations;
    }

    public String getDebugLog() {
        return this.debugLog;
    }

    public void setDebugLog(String debugLog) {
        this.debugLog = debugLog;
    }

    public PlanNode getCurrentPlanDescription() {
        return this.currentPlanDescription;
    }

    public void setCurrentPlanDescription(PlanNode currentPlanDescription) {
        this.currentPlanDescription = currentPlanDescription;
    }

    protected Properties getExecutionProperties() {
        return this.propInfo;
    }

    public void setExecutionProperty(String key, String value) {
        JDBCURL.addNormalizedProperty(key, value, this.getExecutionProperties());
    }

    public String getExecutionProperty(String key) {
        return this.getExecutionProperties().getProperty(JDBCURL.getValidKey(key));
    }

    DQP getDQP() {
        return this.dqp;
    }

    private void logConnectionProperties(String connUrl, Properties info) {
        StringBuffer modifiedUrl = new StringBuffer();
        if (connUrl != null) {
            int startIndex = connUrl.indexOf("password=");
            if (startIndex != -1) {
                modifiedUrl.append(connUrl.substring(0, startIndex));
                modifiedUrl.append("password=***");
                int endIndex = connUrl.indexOf(";", startIndex + 9);
                if (endIndex != -1) {
                    modifiedUrl.append(";").append(connUrl.substring(endIndex));
                }
            }
            logger.fine("Connection Url=" + modifiedUrl);
        }
        if (info != null) {
            Enumeration<Object> enumeration = info.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Object anObj = info.get(key);
                if ("password".equalsIgnoreCase(key)) continue;
                logger.fine(String.valueOf(key) + "=" + anObj);
            }
        }
    }

    String getUrl() {
        return this.url;
    }

    public String getConnectionId() {
        return this.serverConn.getLogonResult().getSessionID();
    }

    protected synchronized long nextRequestID() {
        return this.requestIDGenerator++;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        SQLException firstException = null;
        if (this.closed) {
            return;
        }
        try {
            try {
                try {
                    try {
                        this.closeStatements();
                    }
                    catch (SQLException se) {
                        firstException = se;
                        this.serverConn.close();
                        if (firstException != null) {
                            throw firstException;
                        }
                    }
                }
                finally {
                    this.serverConn.close();
                    if (firstException != null) {
                        throw firstException;
                    }
                }
            }
            catch (SQLException se) {
                throw new SQLException(Messages.getString(Messages.JDBC.MMConnection_Err_connection_close, se.getMessage()), se);
            }
        }
        finally {
            logger.fine(Messages.getString(Messages.JDBC.MMConnection_Connection_close_success, new Object[0]));
            this.closed = true;
        }
    }

    void closeStatements() throws SQLException {
        ArrayList<StatementImpl> statementsSafe = new ArrayList<StatementImpl>(this.statements);
        SQLException ex = null;
        for (StatementImpl statement : statementsSafe) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw new SQLException(Messages.getString(Messages.JDBC.MMConnection_Err_closing_stmts, new Object[0]), ex);
        }
    }

    void closeStatement(Statement statement) {
        this.statements.remove(statement);
    }

    @Override
    public void commit() throws SQLException {
        this.checkConnection();
        if (!this.autoCommitFlag) {
            try {
                this.directCommit();
            }
            finally {
                this.inLocalTxn = false;
            }
        }
    }

    private void directCommit() throws SQLException {
        if (this.inLocalTxn) {
            try {
                ResultsFuture<?> future = this.dqp.commit();
                future.get();
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            logger.fine(Messages.getString(Messages.JDBC.MMConnection_Commit_success, new Object[0]));
        }
    }

    void beginLocalTxnIfNeeded() throws SQLException {
        if (this.transactionXid != null || this.inLocalTxn || this.autoCommitFlag || this.isDisableLocalTxn()) {
            return;
        }
        try {
            try {
                this.dqp.begin();
            }
            catch (XATransactionException e) {
                throw new SQLException(e);
            }
            this.inLocalTxn = true;
        }
        finally {
            if (!this.inLocalTxn) {
                this.autoCommitFlag = true;
            }
        }
    }

    private boolean isDisableLocalTxn() {
        String prop = this.propInfo.getProperty("disableLocalTxn");
        return prop != null && Boolean.valueOf(prop) != false;
    }

    @Override
    public StatementImpl createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public StatementImpl createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    private void validateResultSetType(int resultSetType) throws SQLException {
        if (resultSetType == 1005) {
            String msg = Messages.getString(Messages.JDBC.MMConnection_Scrollable_type_not_supported, "ResultSet.TYPE_SCROLL_SENSITIVE");
            throw new SQLException(msg);
        }
    }

    private void validateResultSetConcurrency(int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency == 1008) {
            String msg = Messages.getString(Messages.JDBC.MMConnection_Concurrency_type_not_supported, "ResultSet.CONCUR_UPDATABLE");
            throw new SQLException(msg);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkConnection();
        return this.autoCommitFlag;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkConnection();
        return this.serverConn.getLogonResult().getVdbName();
    }

    public ServerConnection getServerConnection() throws SQLException {
        this.checkConnection();
        return this.serverConn;
    }

    String getVDBName() throws SQLException {
        this.checkConnection();
        return this.serverConn.getLogonResult().getVdbName();
    }

    public int getVDBVersion() throws SQLException {
        this.checkConnection();
        return this.serverConn.getLogonResult().getVdbVersion();
    }

    String getUserName() throws SQLException {
        this.checkConnection();
        return this.serverConn.getLogonResult().getUserName();
    }

    @Override
    public DatabaseMetaDataImpl getMetaData() throws SQLException {
        this.checkConnection();
        if (this.dbmm == null) {
            this.dbmm = new DatabaseMetaDataImpl(this);
        }
        return this.dbmm;
    }

    public String getDatabaseName() {
        if (this.serverConn instanceof SocketServerConnection) {
            return SERVER_NAME;
        }
        return EMBEDDED_NAME;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.transactionIsolation;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return Collections.emptyMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection();
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public CallableStatementImpl prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1004, 1007);
    }

    @Override
    public CallableStatementImpl prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, 1);
    }

    private void validateSQL(String sql) throws SQLException {
        if (sql == null) {
            String msg = Messages.getString(Messages.JDBC.MMConnection_SQL_cannot_be_null, new Object[0]);
            throw new SQLException(msg);
        }
    }

    @Override
    public PreparedStatementImpl prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public PreparedStatementImpl prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    public PreparedStatementImpl prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        this.validateSQL(sql);
        PreparedStatementImpl newStatement = new PreparedStatementImpl(this, sql, resultSetType, resultSetConcurrency);
        newStatement.setAutoGeneratedKeys(autoGeneratedKeys == 1);
        this.statements.add(newStatement);
        return newStatement;
    }

    @Override
    public PreparedStatementImpl prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, 2);
    }

    @Override
    public void rollback() throws SQLException {
        this.rollback(true);
    }

    public void rollback(boolean startTxn) throws SQLException {
        block8: {
            this.checkConnection();
            if (!this.autoCommitFlag) {
                try {
                    if (!this.inLocalTxn) break block8;
                    this.inLocalTxn = false;
                    try {
                        ResultsFuture<?> future = this.dqp.rollback();
                        future.get();
                    }
                    catch (Exception e) {
                        throw new SQLException(e);
                    }
                    logger.fine(Messages.getString(Messages.JDBC.MMConnection_Rollback_success, new Object[0]));
                }
                finally {
                    if (startTxn) {
                        this.inLocalTxn = false;
                    } else {
                        this.autoCommitFlag = true;
                    }
                }
            }
        }
    }

    public ResultsFuture<?> submitSetAutoCommitTrue(boolean commit) throws SQLException {
        this.checkConnection();
        if (this.autoCommitFlag) {
            return ResultsFuture.NULL_FUTURE;
        }
        this.autoCommitFlag = true;
        try {
            if (commit) {
                return this.dqp.commit();
            }
            return this.dqp.rollback();
        }
        catch (XATransactionException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkConnection();
        if (autoCommit == this.autoCommitFlag) {
            return;
        }
        this.autoCommitFlag = autoCommit;
        if (autoCommit) {
            this.directCommit();
        } else {
            this.inLocalTxn = false;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.readOnly == readOnly) {
            return;
        }
        if (!this.autoCommitFlag || this.transactionXid != null) {
            throw new SQLException(Messages.getString(Messages.JDBC.MMStatement_Invalid_During_Transaction, "setReadOnly(" + readOnly + ")"));
        }
        this.readOnly = readOnly;
    }

    void checkConnection() throws SQLException {
        if (this.closed) {
            throw new SQLException(Messages.getString(Messages.JDBC.MMConnection_Cant_use_closed_connection, new Object[0]));
        }
    }

    protected void commitTransaction(XidImpl arg0, boolean arg1) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        this.autoCommitFlag = true;
        try {
            ResultsFuture<?> future = this.dqp.commit(arg0, arg1);
            future.get();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    protected void endTransaction(XidImpl arg0, int arg1) throws SQLException {
        this.checkConnection();
        this.autoCommitFlag = true;
        try {
            ResultsFuture<?> future = this.dqp.end(arg0, arg1);
            future.get();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    protected void forgetTransaction(XidImpl arg0) throws SQLException {
        this.checkConnection();
        try {
            ResultsFuture<?> future = this.dqp.forget(arg0);
            future.get();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    protected int prepareTransaction(XidImpl arg0) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        try {
            ResultsFuture<Integer> future = this.dqp.prepare(arg0);
            return future.get();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    protected Xid[] recoverTransaction(int arg0) throws SQLException {
        this.checkConnection();
        try {
            ResultsFuture<Xid[]> future = this.dqp.recover(arg0);
            return future.get();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    protected void rollbackTransaction(XidImpl arg0) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        this.autoCommitFlag = true;
        try {
            ResultsFuture<?> future = this.dqp.rollback(arg0);
            future.get();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    protected void startTransaction(XidImpl arg0, int arg1, int timeout) throws SQLException {
        this.checkConnection();
        try {
            ResultsFuture<?> future = this.dqp.start(arg0, arg1, timeout);
            future.get();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        this.transactionXid = arg0;
        this.autoCommitFlag = false;
    }

    protected XidImpl getTransactionXid() {
        return this.transactionXid;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.getServerConnection().isOpen(timeout * 1000);
    }

    public void recycleConnection() {
        this.payload = null;
        try {
            this.closeStatements();
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, Messages.getString(Messages.JDBC.MMXAConnection_rolling_back_error, new Object[0]), e);
        }
        try {
            if (!this.getAutoCommit()) {
                logger.warning(Messages.getString(Messages.JDBC.MMXAConnection_rolling_back, new Object[0]));
                if (this.getTransactionXid() == null) {
                    this.rollback(false);
                } else {
                    this.rollbackTransaction(this.getTransactionXid());
                }
            }
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, Messages.getString(Messages.JDBC.MMXAConnection_rolling_back_error, new Object[0]), e);
        }
        this.serverConn.cleanUp();
    }

    public boolean isSameProcess(ConnectionImpl conn) throws CommunicationException {
        return this.serverConn.isSameInstance(conn.serverConn);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkSupportedVersion(TeiidServerVersion.Version.TEIID_8_5);
        return new ArrayImpl(this.getTeiidVersion(), elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public StatementImpl createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        StatementImpl newStatement = new StatementImpl(this, resultSetType, resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatementImpl prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        this.validateSQL(sql);
        CallableStatementImpl newStatement = new CallableStatementImpl(this, sql, resultSetType, resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkSupportedVersion(TeiidServerVersion.Version.TEIID_7_7);
        return this.prepareStatement(sql, 1003, 1007, 1, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkSupportedVersion(TeiidServerVersion.Version.TEIID_7_7);
        return this.prepareStatement(sql, 1003, 1007, 1, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkSupportedVersion(TeiidServerVersion.Version.TEIID_7_7);
        return this.prepareStatement(sql, 1003, 1007, 1, 1);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.transactionIsolation = level;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    Object setPassword(Object newPassword) {
        if (newPassword != null) {
            return this.connectionProps.put("password", newPassword);
        }
        return this.connectionProps.remove("password");
    }

    String getPassword() {
        Object result = this.connectionProps.get("password");
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    @Override
    public void changeUser(String userName, String newPassword) throws SQLException {
        Object oldName = null;
        Object oldPassword = null;
        oldName = userName != null ? this.connectionProps.put("user", userName) : this.connectionProps.remove("user");
        oldPassword = this.setPassword(newPassword);
        boolean success = false;
        try {
            try {
                this.serverConn.authenticate();
                success = true;
            }
            catch (ConnectionException e) {
                throw new SQLException(e);
            }
            catch (CommunicationException e) {
                throw new SQLException(e);
            }
        }
        finally {
            if (!success) {
                if (oldName != null) {
                    this.connectionProps.put("user", oldName);
                } else {
                    this.connectionProps.remove("user");
                }
                this.setPassword(oldPassword);
            }
        }
    }

    public ITeiidServerVersion getTeiidVersion() {
        String teiidVersionString = this.connectionProps.getProperty("org.teiid.version");
        Object teiidVersion = null;
        teiidVersion = teiidVersionString == null ? TeiidServerVersion.Version.TEIID_DEFAULT.get() : new TeiidServerVersion(teiidVersionString);
        return teiidVersion;
    }

    protected boolean isLessThanTeiidEight() {
        return this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0.get());
    }

    protected void checkSupportedVersion(TeiidServerVersion.Version teiidVersion) {
        ITeiidServerVersion minVersion = this.getTeiidVersion().getMinimumVersion();
        if (minVersion.isLessThan(teiidVersion.get())) {
            TeiidRuntimePlugin.logError("StatementImpl.checkSupportedVersion", "Method being executed that is not supported in teiid version " + this.getTeiidVersion());
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.closed) {
            return;
        }
        this.close();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    public Properties getPayload() {
        return this.payload;
    }

    public void setPayload(Properties payload) {
        this.payload = payload;
    }

    public Properties getConnectionProps() {
        return this.connectionProps;
    }
}

