/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public final class StringUtil {
    public static String replace(String source, String search, String replace) {
        int start;
        if (source != null && search != null && search.length() > 0 && replace != null && (start = source.indexOf(search)) > -1) {
            return new StringBuffer(source).replace(start, start + search.length(), replace).toString();
        }
        return source;
    }

    public static String replaceAll(String source, String search, String replace) {
        if (source == null || search == null || search.length() == 0 || replace == null) {
            return source;
        }
        int start = source.indexOf(search);
        if (start > -1) {
            StringBuffer newString = new StringBuffer(source);
            while (start > -1) {
                int end = start + search.length();
                newString.replace(start, end, replace);
                start = newString.indexOf(search, start + replace.length());
            }
            return newString.toString();
        }
        return source;
    }

    public static String join(Collection<String> strings, String delimiter) {
        if (strings == null || delimiter == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        Iterator<String> iter = strings.iterator();
        while (iter.hasNext()) {
            str.append(iter.next());
            if (!iter.hasNext()) continue;
            str.append(delimiter);
        }
        return str.toString();
    }

    public static String toString(Object[] array, String delim) {
        return StringUtil.toString(array, delim, true);
    }

    public static String toString(Object[] array, String delim, boolean includeBrackets) {
        if (array == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (includeBrackets) {
            sb.append('[');
        }
        int i = 0;
        while (i < array.length) {
            if (i != 0) {
                sb.append(delim);
            }
            sb.append(array[i]);
            ++i;
        }
        if (includeBrackets) {
            sb.append(']');
        }
        return sb.toString();
    }

    public static String toString(Object[] array) {
        return StringUtil.toString(array, ",", true);
    }

    public static List<String> split(String str, String splitter) {
        StringTokenizer tokens = new StringTokenizer(str, splitter);
        ArrayList<String> l = new ArrayList<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            l.add(tokens.nextToken());
        }
        return l;
    }

    public static String getLastToken(String str, String delimiter) {
        if (str == null) {
            return "";
        }
        int beginIndex = 0;
        if (str.lastIndexOf(delimiter) > 0) {
            beginIndex = str.lastIndexOf(delimiter) + 1;
        }
        return str.substring(beginIndex, str.length());
    }

    public static String getFirstToken(String str, String delimiter) {
        if (str == null) {
            return "";
        }
        int endIndex = str.indexOf(delimiter);
        if (endIndex < 0) {
            endIndex = str.length();
        }
        return str.substring(0, endIndex);
    }

    public static boolean startsWithIgnoreCase(String text, String prefix) {
        if (text == null || prefix == null) {
            return false;
        }
        return text.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String text, String suffix) {
        if (text == null || suffix == null) {
            return false;
        }
        return text.regionMatches(true, text.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean isLetter(char c) {
        return StringUtil.isBasicLatinLetter(c) || Character.isLetter(c);
    }

    public static boolean isDigit(char c) {
        return StringUtil.isBasicLatinDigit(c) || Character.isDigit(c);
    }

    public static boolean isLetterOrDigit(char c) {
        return StringUtil.isBasicLatinLetter(c) || StringUtil.isBasicLatinDigit(c) || Character.isLetterOrDigit(c);
    }

    public static boolean isValid(String str) {
        return str != null && str.trim().length() != 0;
    }

    private static boolean isBasicLatinLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isBasicLatinDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static int parseNumericValue(CharSequence string, StringBuilder sb, int i, int value, int possibleDigits, int radixExp) {
        int j = 0;
        while (j < possibleDigits) {
            char digit;
            int val;
            if (i + 1 == string.length() || (val = Character.digit(digit = string.charAt(i + 1), 1 << radixExp)) == -1) break;
            ++i;
            value = (value << radixExp) + val;
            ++j;
        }
        sb.append((char)value);
        return i;
    }

    public static <T> T valueOf(String value, Class type) {
        if (value == null) {
            return null;
        }
        if (type == String.class) {
            return (T)value;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.decode(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.decode(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.decode(value);
        }
        if (type.isAssignableFrom(List.class)) {
            return (T)new ArrayList<String>(Arrays.asList(value.split(",")));
        }
        if (type.isAssignableFrom(Set.class)) {
            return (T)new HashSet<String>(Arrays.asList(value.split(",")));
        }
        if (type.isArray()) {
            String[] values = value.split(",");
            Object array = Array.newInstance(type.getComponentType(), values.length);
            int i = 0;
            while (i < values.length) {
                Array.set(array, i, StringUtil.valueOf(values[i], type.getComponentType()));
                ++i;
            }
            return (T)array;
        }
        if (type == Void.class) {
            return null;
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, value);
        }
        if (type == URL.class) {
            try {
                return (T)new URL(value);
            }
            catch (MalformedURLException malformedURLException) {
            }
        } else if (type.isAssignableFrom(Map.class)) {
            List<String> l = Arrays.asList(value.split(","));
            HashMap<String, String> m = new HashMap<String, String>();
            for (String key : l) {
                int index = key.indexOf(61);
                if (index == -1) continue;
                m.put(key.substring(0, index), key.substring(index + 1));
            }
            return (T)m;
        }
        throw new IllegalArgumentException("Conversion from String to " + type.getName() + " is not supported");
    }

    /*
     * Unable to fully structure code
     */
    public static <T extends Enum<T>> T caseInsensitiveValueOf(Class<T> enumType, String name) {
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException e) {
            var7_4 = vals = (Enum[])enumType.getEnumConstants();
            var6_5 = vals.length;
            var5_6 = 0;
            ** while (var5_6 < var6_5)
        }
lbl-1000:
        // 1 sources

        {
            t = var7_4[var5_6];
            if (name.equalsIgnoreCase(t.name())) {
                return (T)t;
            }
            ++var5_6;
            continue;
        }
lbl13:
        // 1 sources

        throw e;
    }

    public static List<String> tokenize(String str, char delim) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == delim) {
                if (escaped) {
                    current.append(c);
                    escaped = false;
                } else {
                    escaped = true;
                }
            } else {
                if (escaped && current.length() > 0) {
                    result.add(current.toString());
                    current.setLength(0);
                    escaped = false;
                }
                current.append(c);
            }
            ++i;
        }
        if (current.length() > 0) {
            result.add(current.toString());
        }
        return result;
    }

    public static String unescape(CharSequence string, int quoteChar, boolean useAsciiEscapes, StringBuilder sb) {
        boolean escaped = false;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (escaped) {
                switch (c) {
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'u': {
                        i = StringUtil.parseNumericValue(string, sb, i, 0, 4, 4);
                        break;
                    }
                    default: {
                        if (c == quoteChar) {
                            sb.append(quoteChar);
                            break;
                        }
                        if (!useAsciiEscapes) break;
                        int value = Character.digit(c, 8);
                        if (value == -1) {
                            sb.append(c);
                            break;
                        }
                        int possibleDigits = value < 3 ? 2 : 1;
                        int radixExp = 3;
                        i = StringUtil.parseNumericValue(string, sb, i, value, possibleDigits, radixExp);
                    }
                }
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else {
                if (c == quoteChar) break;
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static interface Constants {
        public static final char CARRIAGE_RETURN_CHAR = '\r';
        public static final char LINE_FEED_CHAR = '\n';
        public static final char NEW_LINE_CHAR = '\n';
        public static final char SPACE_CHAR = ' ';
        public static final char DOT_CHAR = '.';
        public static final char TAB_CHAR = '\t';
        public static final String CARRIAGE_RETURN = String.valueOf('\r');
        public static final String EMPTY_STRING = "";
        public static final String DBL_SPACE = "  ";
        public static final String LINE_FEED = String.valueOf('\n');
        public static final String NEW_LINE = String.valueOf('\n');
        public static final String SPACE = String.valueOf(' ');
        public static final String DOT = String.valueOf('.');
        public static final String TAB = String.valueOf('\t');
        public static final String[] EMPTY_STRING_ARRAY = new String[0];
    }
}

