/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.teiid.core.util.StringUtil;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class PropertiesUtils {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Properties clone(Properties props) {
        return PropertiesUtils.clone(props, null, false);
    }

    public static Properties clone(Properties props, Properties defaults, boolean deepClone) {
        Properties result = null;
        if (defaults != null) {
            if (deepClone) {
                defaults = PropertiesUtils.clone(defaults);
            }
            result = new Properties(defaults);
        } else {
            result = new Properties();
        }
        PropertiesUtils.putAll(result, props);
        return result;
    }

    public static void putAll(Properties addToThis, Properties withThese) {
        if (withThese != null && addToThis != null) {
            Enumeration<?> enumeration = withThese.propertyNames();
            while (enumeration.hasMoreElements()) {
                String propName = (String)enumeration.nextElement();
                Object propValue = withThese.get(propName);
                if (propValue == null) {
                    propValue = withThese.getProperty(propName);
                }
                if (propValue == null) continue;
                addToThis.put(propName, propValue);
            }
        }
    }

    public static boolean getBooleanProperty(Properties props, String propName, boolean defaultValue) {
        String stringVal = props.getProperty(propName);
        if (stringVal == null) {
            return defaultValue;
        }
        if ((stringVal = stringVal.trim()).length() == 0) {
            return defaultValue;
        }
        try {
            return Boolean.valueOf(stringVal);
        }
        catch (NumberFormatException e) {
            String msg = Messages.getString(Messages.InvalidPropertyException.message, propName, stringVal, Float.class.getSimpleName());
            throw new RuntimeException(new TeiidClientException(e, msg));
        }
    }

    public static int getIntProperty(Properties props, String propName, int defaultValue) {
        String stringVal = props.getProperty(propName);
        if (stringVal == null) {
            return defaultValue;
        }
        if ((stringVal = stringVal.trim()).length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(stringVal);
        }
        catch (NumberFormatException e) {
            String msg = Messages.getString(Messages.InvalidPropertyException.message, propName, stringVal, Integer.class.getSimpleName());
            throw new RuntimeException(new TeiidClientException(e, msg));
        }
    }

    public static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(PropertiesUtils.toHex(b >>> 4));
            sb.append(PropertiesUtils.toHex(b));
            ++n2;
        }
        return sb.toString();
    }

    public static void setBeanProperties(Object bean, Properties props, String prefix) {
        PropertiesUtils.setBeanProperties(bean, props, prefix, false);
    }

    public static void setBeanProperties(Object bean, Properties props, String prefix, boolean caseSensitive) {
        Map<Object, Object> map = props;
        if (!caseSensitive) {
            map = PropertiesUtils.caseInsensitiveProps(props);
        }
        Method[] methods = bean.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            String methodName = method.getName();
            if (methodName.startsWith("set") && method.getParameterTypes().length == 1) {
                Object propertyValue;
                String propertyName = methodName.substring(3);
                if (prefix != null) {
                    propertyName = caseSensitive ? String.valueOf(prefix) + "." + Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1, propertyName.length()) : String.valueOf(prefix) + "." + propertyName;
                }
                if ((propertyValue = map.get(propertyName)) != null || map.containsKey(propertyName)) {
                    PropertiesUtils.setProperty(bean, propertyValue, method, propertyName);
                }
            }
            ++i;
        }
    }

    public static void setBeanProperty(Object bean, String name, Object value) {
        Method[] methods = bean.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            String methodName = method.getName();
            if (methodName.startsWith("set") && method.getParameterTypes().length == 1 && StringUtil.endsWithIgnoreCase(methodName, name)) {
                String propertyName = methodName.substring(3);
                PropertiesUtils.setProperty(bean, value, method, propertyName);
            }
            ++i;
        }
    }

    private static Class<?> setProperty(Object bean, Object value, Method method, String propertyName) {
        Class<?> argType = method.getParameterTypes()[0];
        try {
            Object[] params = new Object[]{value};
            if (value != null && !argType.isAssignableFrom(value.getClass())) {
                params = new Object[]{StringUtil.valueOf(value.toString(), argType)};
            }
            method.invoke(bean, params);
        }
        catch (Throwable e) {
            String msg = Messages.getString(Messages.InvalidPropertyException.message, propertyName, value, argType);
            throw new RuntimeException(new TeiidClientException(e, msg));
        }
        return argType;
    }

    private static TreeMap<String, String> caseInsensitiveProps(Properties connectionProps) {
        TreeMap<String, String> caseInsensitive = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Enumeration<?> itr = connectionProps.propertyNames();
        while (itr.hasMoreElements()) {
            String name = (String)itr.nextElement();
            String propValue = connectionProps.getProperty(name);
            if (propValue == null && !connectionProps.containsKey(name)) continue;
            caseInsensitive.put(name, propValue);
        }
        return caseInsensitive;
    }
}

