/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public final class HashCodeUtil {
    private static final int PRIME = 1000003;

    public static final int hashCode(int previous, boolean x) {
        return 1000003 * previous + (x ? 1 : 0);
    }

    public static final int hashCode(int previous, int x) {
        return 1000003 * previous + x;
    }

    public static final int hashCode(int previous, long x) {
        return 1000003 * previous + (int)(1000003L * (x >>> 32) + (x & 0xFFFFFFFFFFFFFFFFL));
    }

    public static final int hashCode(int previous, float x) {
        return HashCodeUtil.hashCode(previous, x == 0.0f ? 0 : Float.floatToIntBits(x));
    }

    public static final int hashCode(int previous, double x) {
        return HashCodeUtil.hashCode(previous, x == 0.0 ? 0L : Double.doubleToLongBits(x));
    }

    public static final int hashCode(int previous, Object ... x) {
        if (x == null) {
            return 1000003 * previous;
        }
        int hc = previous;
        int i = 0;
        while (i < x.length) {
            hc = x[i] == null ? 1000003 * hc : 1000003 * hc + x[i].hashCode();
            ++i;
        }
        return hc;
    }

    public static final int expHashCode(int previous, Object[] x) {
        if (x == null) {
            return 1000003 * previous;
        }
        int hc = 1000003 * previous + x.length;
        int index = 1;
        int xlen = x.length + 1;
        while (index < xlen) {
            hc = HashCodeUtil.hashCode(hc, x[index - 1]);
            index <<= 1;
        }
        return hc;
    }

    public static final int expHashCode(int previous, Collection<?> x) {
        if (x == null || x.size() == 0) {
            return 1000003 * previous;
        }
        int size = x.size();
        int hc = 1000003 * previous + size;
        if (x instanceof RandomAccess && x instanceof List) {
            List l = (List)List.class.cast(x);
            int index = 1;
            int xlen = x.size() + 1;
            while (index < xlen) {
                hc = HashCodeUtil.hashCode(hc, l.get(index - 1));
                index <<= 1;
            }
        } else {
            int skip = 0;
            int total = 0;
            Iterator<?> iter = x.iterator();
            Object obj = iter.next();
            while (total < size) {
                int i = 0;
                while (i < skip) {
                    obj = iter.next();
                    ++i;
                }
                hc = HashCodeUtil.hashCode(hc, obj);
                skip = skip == 0 ? 1 : skip << 1;
                total += skip;
            }
        }
        return hc;
    }

    public static final int expHashCode(CharSequence x) {
        return HashCodeUtil.expHashCode(x, true);
    }

    public static final int expHashCode(CharSequence x, boolean caseSensitive) {
        if (x == null) {
            return 0;
        }
        int hc = x.length();
        int index = 1;
        int xlen = x.length() + 1;
        while (index < xlen) {
            int charHash = x.charAt(index - 1);
            if (!caseSensitive) {
                charHash = Character.toUpperCase(charHash);
            }
            hc = 1000003 * hc + charHash;
            index <<= 1;
        }
        return hc;
    }
}

