/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.io.IOException;
import java.io.Reader;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.XMLType;
import org.teiid.core.types.basic.AnyToStringTransform;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class SQLXMLToStringTransform
extends AnyToStringTransform {
    public SQLXMLToStringTransform(DataTypeManagerService dataTypeManager) {
        super(dataTypeManager, DataTypeManagerService.DefaultDataTypes.XML.getTypeClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object transformDirect(Object value) throws Exception {
        String string;
        XMLType source = (XMLType)value;
        Reader reader = null;
        try {
            char[] result = new char[DataTypeManagerService.MAX_STRING_LENGTH];
            reader = source.getCharacterStream();
            int read = reader.read(result);
            string = new String(result, 0, read);
        }
        catch (Exception e) {
            try {
                throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID10080, this.getSourceType().getName(), this.getTargetType().getName()));
            }
            catch (Throwable throwable) {
                try {
                    if (reader == null) throw throwable;
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            if (reader == null) return string;
            reader.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

