/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.math.BigDecimal;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.Transform;

public class FloatingNumberToBigIntegerTransform
extends Transform {
    private Class<?> sourceType;

    public FloatingNumberToBigIntegerTransform(DataTypeManagerService dataTypeManager, Class<?> sourceType) {
        super(dataTypeManager);
        this.sourceType = sourceType;
    }

    @Override
    public Object transformDirect(Object value) throws Exception {
        return BigDecimal.valueOf(((Number)value).doubleValue()).toBigInteger();
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManagerService.DefaultDataTypes.BIG_INTEGER.getTypeClass();
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

